/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.SearchAlgorithmus;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.SPMLMealTypeDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import java.util.ArrayList;
import java.util.Iterator;

public class DeliveryInstructionSearchAlgorithm
implements SearchAlgorithmus,
NodeListener {
    private Node deliveryRoot;
    private String nextPattern;
    private boolean isSearching;
    private String pattern = "";
    private Node filterNode = new ViewNode("");

    public DeliveryInstructionSearchAlgorithm(Node m) {
        this.setNode(m);
    }

    public void setNode(Node m) {
        if (this.deliveryRoot != null) {
            this.deliveryRoot.removeNodeListener((NodeListener)this);
        }
        this.deliveryRoot = m;
        if (this.deliveryRoot != null) {
            this.deliveryRoot.addNodeListener((NodeListener)this);
            this.doSearch("");
        }
    }

    public Node getFilteredNode() {
        return this.filterNode;
    }

    @Override
    public ArrayList search(ArrayList theList, String pattern) {
        if (!this.isSearching) {
            this.doSearch(pattern);
        } else {
            this.nextPattern = pattern;
        }
        return theList;
    }

    private void doSearch(String pattern) {
        Object b = pattern;
        this.pattern = pattern;
        try {
            int no = Integer.valueOf(pattern);
            b = no;
        }
        catch (NumberFormatException e) {
            b = pattern;
        }
        if (this.deliveryRoot == null) {
            return;
        }
        Iterator it = this.deliveryRoot.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node di = ((Node)it.next()).getChildNamed(new String[]{"deliveryInstruction"});
            Node item = di.getParent();
            String checkedString = "";
            int checkedNumber = -1;
            try {
                if (item.getValue() instanceof ProductDeliverableComplete) {
                    ProductComplete p = (ProductComplete)item.getChildNamed(new String[]{"product"}).getValue();
                    checkedString = p.getCurrentVariant().getName();
                    checkedNumber = p.getNumber();
                } else if (item.getValue() instanceof ArticleDeliverableLight || item.getValue() instanceof ArticleDeliverableComplete) {
                    BasicArticleLight l = (BasicArticleLight)item.getChildNamed(new String[]{"article"}).getValue();
                    checkedString = l.getName();
                    checkedNumber = l.getNumber();
                } else if (item.getValue() instanceof ServiceDeliverableComplete) {
                    ALoadingGroupComplete group = (ALoadingGroupComplete)item.getChildNamed(new String[]{"loadingGroup"}).getValue();
                    checkedString = group.getName();
                } else if (item.getValue() instanceof SPMLMealTypeDeliverableComplete && item.getChildNamed(new String[]{"serviceSchedule"}).getValue() instanceof CateringServiceScheduleComplete) {
                    CateringServiceScheduleComplete d = (CateringServiceScheduleComplete)item.getChildNamed(new String[]{"serviceSchedule"}).getValue();
                    MealTypeComplete mealType = (MealTypeComplete)item.getChildNamed(new String[]{"mealType"}).getValue();
                    Boolean spml = (Boolean)item.getChildNamed(new String[]{"spml"}).getValue();
                    checkedString = (Boolean.TRUE.equals(spml) ? "SPML Space " : "a la Carte ") + (mealType != null ? mealType.getCode() + " " : "") + d.getType().getCode() + " " + d.getCabinClass().getCode();
                }
                if (b instanceof String) {
                    if (checkedString.toLowerCase().contains(((String)b).toLowerCase())) {
                        if (this.filterNode.contains(di)) continue;
                        this.filterNode.addChild(di, 0L);
                        continue;
                    }
                    if (!this.filterNode.contains(di)) continue;
                    this.filterNode.removeChild(di, 0L);
                    continue;
                }
                if (!(b instanceof Integer)) continue;
                if (checkedNumber != -1) {
                    String n = "" + (Integer)b;
                    String n2 = "" + checkedNumber;
                    if (n2.contains(n)) {
                        if (this.filterNode.contains(di)) continue;
                        this.filterNode.addChild(di, 0L);
                        continue;
                    }
                    if (!this.filterNode.contains(di)) continue;
                    this.filterNode.removeChild(di, 0L);
                    continue;
                }
                if (!this.filterNode.contains(di)) continue;
                this.filterNode.removeChild(di, 0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.filterNode.addChild(child, 0L);
        this.doSearch(this.pattern);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.filterNode.removeChild(child, 0L);
        this.doSearch(this.pattern);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

