/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.tab;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.table.RowContentPanelLayout;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.AnimationContainer;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.panels.AnimationPanel;
import ch.icit.pegasus.client.gui.utils.panels.DisablePanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.TabViewExpandColapseSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.util.LoadingStateComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class TabView
extends JPanelFadable
implements LafListener,
MouseListener,
AnimationContainer,
LoadingStateComponent {
    private static final long serialVersionUID = 1L;
    private TextLabel titleText;
    private Skin3Field colapsedTitleSkin;
    private Skin9Field frameSkin;
    private boolean isExpanded;
    private Resizer<TabView> resizer;
    private PegasusSubModule mainScreen;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_COLAPSED_OVER = 6;
    public static final int STATE_COLAPSED_UP = 7;
    private boolean isOver = false;
    private DisablePanel disablePanel;
    private LoadingAnimation animater;
    private AnimationPanel animaterPanel;
    private boolean isLoadingData = false;
    private Color innerBackground;
    private JPanel viewPort;

    public TabView(String name, PegasusSubModule mainScreen) {
        this.mainScreen = mainScreen;
        this.disablePanel = new DisablePanel();
        this.titleText = new TextLabel(name);
        this.resizer = new Resizer<TabView>(this);
        this.colapsedTitleSkin = SkinRegistry.getSkin(TabViewExpandColapseSkin.class);
        this.frameSkin = (Skin9Field)DefaultSkins.TableRowBorder.createDynamicSkin();
        this.innerBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("tab_view_expanded_background"));
        this.lafAttributeChanged("All attribues changed");
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.addMouseListener(this);
        this.viewPort = new JPanel();
        this.viewPort.setOpaque(false);
        this.viewPort.setLayout(new RowContentPanelLayout("tabView " + name));
        this.add(this.titleText);
        this.add(this.viewPort);
        this.disablePanel.setVisible(false);
        this.add((Component)this.disablePanel, -1);
    }

    private void createFocusCycle() {
        ArrayList<Component> b = new ArrayList<Component>();
        for (int i = 0; i < this.viewPort.getComponentCount(); ++i) {
            List<Component> a;
            Component c = this.viewPort.getComponent(i);
            if (!(c instanceof Focusable) || (a = ((Focusable)((Object)c)).getFocusComponents()) == null || a.size() <= 0) continue;
            b.addAll(a);
        }
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(b, this);
    }

    public void setLoadingData(boolean isLoadingData) {
        this.isLoadingData = isLoadingData;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (isEnabled) {
            this.disablePanel.setVisible(false);
        } else {
            this.disablePanel.setLocation(0, 0);
            this.disablePanel.setSize(this.getSize());
            this.setComponentZOrder(this.disablePanel, 0);
            this.disablePanel.setVisible(true);
        }
        for (Component p : this.viewPort.getComponents()) {
            p.setEnabled(isEnabled);
        }
        this.repaint(32L);
    }

    public void addToView(Component comp, TableLayoutConstraint constrain) {
        this.viewPort.add(comp, constrain);
    }

    public void removeFromView(Component comp) {
        this.viewPort.remove(comp);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, this.colapsedTitleSkin.getImageLeft(Button.ButtonState.STATE_COLAPSED_OVER).getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.innerBackground);
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
        if (this.isExpanded) {
            this.colapsedTitleSkin.paint(g2, 0, 0, this.getWidth(), Button.ButtonState.STATE_EXPANDED);
            this.frameSkin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        } else if (this.isOver) {
            this.colapsedTitleSkin.paint(g2, 0, 0, this.getWidth(), Button.ButtonState.STATE_COLAPSED_OVER);
        } else {
            this.colapsedTitleSkin.paint(g2, 0, 0, this.getWidth(), Button.ButtonState.STATE_COLAPSED_UP);
        }
        this.paintChildren(g2);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded, boolean invokeRelayout) {
        this.isExpanded = isExpanded;
        if (this.isExpanded) {
            this.mainScreen.newNodeSelected(null, 3, null);
            this.mainScreen.checkExpandedState(this);
        }
        if (invokeRelayout) {
            this.mainScreen.layoutPanels();
            this.validate();
        }
        if (this.isExpanded) {
            this.tryToGrabFocus();
        }
    }

    private void tryToGrabFocus() {
        for (int i = 0; i < this.viewPort.getComponentCount(); ++i) {
            List<Component> a;
            Component c = this.viewPort.getComponent(i);
            if (!(c instanceof Focusable) || (a = ((Focusable)((Object)c)).getFocusComponents()) == null || a.size() <= 0) continue;
            a.get(0).requestFocusInWindow();
            return;
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.titleText.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("gc_stowing_tab_title_font_size"), LafLoader.getLafLoader().getAttribute("gc_stowing_tab_title_font_type")));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animater != null) {
            this.animater.kill();
            this.animater = null;
        }
        if (this.animaterPanel != null) {
            this.animaterPanel.kill();
            this.animaterPanel = null;
        }
        this.resizer.deregister();
        this.resizer = null;
        this.mainScreen = null;
        this.disablePanel.kill();
        this.disablePanel = null;
        for (ArrayList c : (ArrayList)((RowContentPanelLayout)this.viewPort.getLayout()).getComponents().clone()) {
            for (Component cc : (ArrayList)c.clone()) {
                if (!(cc instanceof Killable)) continue;
                ((Killable)((Object)cc)).kill();
            }
        }
        this.remove(this.viewPort);
        this.titleText.kill();
        this.titleText = null;
    }

    @Override
    public void removeScheduled(Fadable comp) {
    }

    @Override
    public void deactivateDataLoadingAnimation() {
        if (this.isLoadingData) {
            if (this.animaterPanel.getFader() != null) {
                this.animaterPanel.fadeOut(true);
            }
            this.animater.stop();
        }
        this.createFocusCycle();
    }

    public boolean isAbleToStop() {
        return this.animater.isAbleToStop();
    }

    @Override
    public void activateDataLoadingAnimation(String t, Integer a, Integer b) {
        if (!this.isLoadingData) {
            this.isLoadingData = true;
            this.animaterPanel = new AnimationPanel();
            this.animaterPanel.setLayout(null);
            this.animaterPanel.getFader().setAnimationContainer(this);
            String t1 = t;
            if (a != null && b != null) {
                t1 = t1 + " " + a + "/" + b;
            }
            this.animater = new LoadingAnimation();
            this.animater.stateChanged(t1);
            this.animater.setMetaParent(this);
            this.animaterPanel.add((Component)this.animater, 0);
            this.animater.setProgress(1.0f);
            this.animater.start();
            this.add((Component)this.animaterPanel, 0);
            this.animaterPanel.fadeIn();
            this.validate();
        }
    }

    public LoadingAnimation getAnimation() {
        return this.animater;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isOver = true;
        this.repaint(32L);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isOver = false;
        this.repaint(32L);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled() && e.getX() > 0 && e.getX() < this.getWidth() && e.getY() > 0 && e.getY() < this.colapsedTitleSkin.getImageLeft(Button.ButtonState.STATE_COLAPSED_OVER).getHeight()) {
            this.setExpanded(!this.isExpanded, true);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int hBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")) * 2;
            TabView.this.titleText.setLocation(hBorder, (int)(((double)TabView.this.colapsedTitleSkin.getImageLeft(Button.ButtonState.STATE_COLAPSED_OVER).getHeight() - TabView.this.titleText.getPreferredSize().getHeight()) / 2.0));
            TabView.this.titleText.setSize(TabView.this.titleText.getPreferredSize());
            TabView.this.viewPort.setLocation(1, TabView.this.colapsedTitleSkin.getImageLeft(Button.ButtonState.STATE_COLAPSED_OVER).getHeight());
            TabView.this.viewPort.setSize(parent.getWidth() - 2, parent.getHeight() - (TabView.this.viewPort.getY() + 1));
            if (TabView.this.animaterPanel != null && TabView.this.isLoadingData) {
                TabView.this.animaterPanel.setLocation(2, 2);
                TabView.this.animaterPanel.setSize(TabView.this.getWidth() - 4, TabView.this.getHeight() - 4);
                TabView.this.animater.setSize(TabView.this.animater.getPreferredSize());
                TabView.this.animater.setLocation((TabView.this.getWidth() - TabView.this.animater.getWidth()) / 2, (TabView.this.getHeight() - TabView.this.animater.getHeight()) / 2);
            }
            TabView.this.disablePanel.setLocation(0, 0);
            TabView.this.disablePanel.setSize(parent.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

