/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.labelprint;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.LegListStringConverter2;
import ch.icit.pegasus.client.converter.ReportNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.ConfigurationPanel;
import ch.icit.pegasus.client.gui.ConfigurationPanelListener;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.labelprint.details.LabelPreviewDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.tool.labelprint.utils.PrintingPopup;
import ch.icit.pegasus.client.gui.submodules.tool.labelprint.utils.TableRowImpl;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiLegComboBox;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ILabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ItemLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.SpecialMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentInsertComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentReservedSpaceTrayComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.HandlingLogLight;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LabelPrintModule
extends SubModuleScreenInsert<FlightLight>
implements RemoteLoader,
ButtonListener,
ConfigurationPanelListener,
InnerPopUpListener2,
NodeListener {
    private static final long serialVersionUID = 1L;
    private LoadingAnimation loader;
    private TextButton printSelection;
    private TextButton selectAll;
    private LabelPreviewDetailsPanel labelPreview;
    private Table2 table;
    private ConfigurationPanel confPanel;
    private Node<FlightLight> flightNode;
    private FlightComplete flightC;
    private static final String NAME_FILTER = "name";
    private static final String DEPARTMENT_FILTER = "department";
    private static final String LABEL_COLOR_FILTER = "color_filter";
    private static final String SHOW_DIFF_FILTER = "difference_filter";
    private static final String SHOW_LABEL_WITH_CONTENT = "label_with_content";
    private static final String SPML_ONLY = "spml_only";
    private static final String CABIN_CLASS_FILTER = "cabin_class_filter";
    private static final String LEG = "leg";
    private static final String LABEL_LAYOUT = "labelLayout";
    private CostCenterComplete currentCostCenter;
    private ColorComplete currentColor;
    private CabinClassComplete currentCabinClass;
    private List<FlightLegComplete> currentLegs;
    private boolean showDifferenceOnly;
    private boolean labelWithContents = false;
    private ReportFileComplete currentLayout;
    private String searchName;
    private LOADINGSTATE currentSTATE;
    private int searchCount = 0;
    private boolean isInited = false;
    private boolean isAnimating = true;
    private boolean isSPMLSearch;
    private ListNode<List<FlightLegComplete>, FlightLegComplete> nt;
    private boolean firstSearch = true;
    private SearchTextField positionCode;
    private ComboBox usedDepartments;
    private ComboBox usedColors;
    private ComboBox usedLayout;
    private Node<FlightSearchConfiguration> node;

    private boolean areAllSelected() {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.isChecked()) continue;
            return false;
        }
        return true;
    }

    private void validateSelectAllState() {
        this.validateSelectAllState(this.areAllSelected());
    }

    private void validateSelectAllState(boolean check) {
        boolean allSelected = this.areAllSelected();
        this.selectAll.setText(allSelected ? Words.DESELECT_ALL : Words.SELECT_ALL);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.selectAll) {
            boolean allSelected = this.areAllSelected();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                pp.autoSelect(!allSelected);
            }
            this.validateSelectAllState(allSelected);
        } else if (source == this.printSelection) {
            boolean showPrintDialog = false;
            if (Boolean.TRUE.equals(this.flightC.getIsInvoiceClosed())) {
                InnerPopupFactory.showErrorDialog("Label print for invoiced flights is not allowed", "Labels", (Component)this);
                return;
            }
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(null, true, true, Words.PRINT_SELECTED_LABELS);
            popUp.setView(new PrintingPopup<FlightLight>(this.flightNode, this.getSelectedIds(), this.isSPMLSearch, showPrintDialog));
            popUp.showPopUpWithinScreenMiddle(300, 550, this, source);
            ((DefaultScrollablePrintPopup2)popUp.getView()).loadReportTypes();
        }
    }

    private List<ILabelComplete> getSelectedIds() {
        ArrayList<ILabelComplete> list = new ArrayList<ILabelComplete>();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isChecked()) continue;
            list.add((ILabelComplete)pp.getModel().getNode().getValue());
        }
        return list;
    }

    private void install(FlightLight dto, FakeSmartScreenTableRow<FlightLight> row) {
        this.table = new Table2(false, "", true, true, Words.EQUIPMENTS);
        this.table.setRequestFocusOnAdd(false);
        this.loader = new LoadingAnimation();
        this.loader.setPermanent(true);
        this.loader.getFader().setPermanent(true);
        this.table.setModel(new Table2Model(null, model -> new TableRowImpl(model, this.flightNode, this)));
        this.installColumnHeader(false);
        this.labelPreview = new LabelPreviewDetailsPanel(row.getNode());
        this.table.getModel().addTableSelectionListener(this.labelPreview);
        this.selectAll = new TextButton(Words.SELECT_ALL);
        this.printSelection = new TextButton(Words.PRINT_SELECTION);
        this.selectAll.setProgress(1.0f);
        this.printSelection.setProgress(1.0f);
        this.selectAll.addButtonListener(this);
        this.printSelection.addButtonListener(this);
        this.confPanel = new ConfigurationPanel();
        this.confPanel.setMinComboWidth(140);
        this.setOpaque(false);
        this.setEnabled(false);
        this.setLayout(new Layout());
        this.add(this.confPanel);
        this.add(this.table);
        this.add(this.labelPreview);
        this.add(this.selectAll);
        this.add(this.printSelection);
        this.add((Component)this.loader, 0);
        this.loader.setProgress(1.0f);
        this.loader.start();
    }

    private void installColumnHeader(boolean isSPML) {
        if (!isSPML) {
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo(Words.EQUIPMENT, null, null, null, "", 30, 30, 30));
            columns.add(new TableColumnInfo(Words.GALLEY, null, null, null, "", 30, 30, 30));
            columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 120, 120, 120));
            columns.add(new TableColumnInfo(Words.COLOR, null, null, null, "", 75, 75, 75));
            columns.add(new TableColumnInfo(Words.LABEL, null, null, null, "", 120, 120, 120));
            columns.add(new TableColumnInfo(Words.LOAD, null, null, null, "", 75, 75, 75));
            columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 60, 60, 60));
            columns.add(new TableColumnInfo(Words.CLASS, null, null, null, "", 80, 80, 80));
            columns.add(new TableColumnInfo(Words.PRINT_INFO, null, null, null, "", 60, 60, 60));
            columns.add(new TableColumnInfo(Words.PRINT, null, null, null, "", 70, 70, 70));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(8)).setxExpand(0.4);
            ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
            this.table.getModel().refreshColumns(columns);
        } else {
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo(Words.CODE, null, null, null, "", 80, 80, 80));
            columns.add(new TableColumnInfo(Words.CLASS, null, null, null, "", 80, 80, 80));
            columns.add(new TableColumnInfo(Words.COLOR, null, null, null, "", 75, 75, 75));
            columns.add(new TableColumnInfo(Words.LEG, null, null, null, "", 100, Integer.MAX_VALUE, 100));
            columns.add(new TableColumnInfo(Words.SPACE, null, null, null, "", 60, 60, 60));
            columns.add(new TableColumnInfo(Words.CABIN_CLASS, null, null, null, "", 100, 100, 100));
            columns.add(new TableColumnInfo(Words.PRINT_INFO, null, null, null, "", 60, 60, 60));
            columns.add(new TableColumnInfo(Words.PRINT, null, null, null, "", 70, 70, 70));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.4);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
            this.table.getModel().refreshColumns(columns);
        }
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    private void stopAnimation() {
        this.isAnimating = false;
        this.loader.stop();
        this.loader.fadeOut(false);
    }

    private Node<List<CabinClassComplete>> createCabinClassView(FlightLight flight) {
        ViewNode ccs = new ViewNode("");
        for (SeatConfigurationComplete sc : flight.getActiveStowingList().getSeatConfigurations()) {
            ccs.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)sc.getCabinClass(), false, true), 0L);
        }
        return ccs;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        switch (this.currentSTATE) {
            case INIT: {
                this.confPanel.addConfigurationPanelListener(this);
                this.confPanel.setMinComboWidth(150);
                this.positionCode = new SearchTextField();
                this.confPanel.addItem(this.positionCode, TitledItem.TitledItemOrientation.NORTH, NAME_FILTER, WordsToolkit.toUpperCase((String)Words.NAME));
                this.usedDepartments = new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class));
                this.usedDepartments.addItem(Words.ALL);
                this.usedDepartments.setSelectedItem(Words.ALL);
                this.confPanel.addItem(this.usedDepartments, TitledItem.TitledItemOrientation.NORTH, DEPARTMENT_FILTER, WordsToolkit.toUpperCase((String)Words.COSTCENTER));
                this.usedColors = new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class));
                this.usedColors.addItem(Words.ALL);
                this.usedColors.setSelectedItem(Words.ALL);
                this.confPanel.addItem(this.usedColors, TitledItem.TitledItemOrientation.NORTH, LABEL_COLOR_FILTER, WordsToolkit.toUpperCase((String)Words.LABEL_COLOR));
                this.usedLayout = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(ReportNameConverter.class));
                this.usedLayout.addItem(Words.ALL);
                this.usedLayout.setSelectedItem(Words.ALL);
                this.confPanel.addItem(this.usedLayout, TitledItem.TitledItemOrientation.NORTH, LABEL_LAYOUT, WordsToolkit.toUpperCase((String)Words.LABEL_LAYOUT));
                CheckBox check = new CheckBox();
                this.confPanel.addItem(check, TitledItem.TitledItemOrientation.WEST, SHOW_DIFF_FILTER, WordsToolkit.toUpperCase((String)Words.DIFF_ONLY), "Show only labels that have changed since last printing");
                CheckBox labelWithContent = new CheckBox();
                this.confPanel.addItem(labelWithContent, TitledItem.TitledItemOrientation.WEST, SHOW_LABEL_WITH_CONTENT, WordsToolkit.toUpperCase((String)Words.WITH_CONTENT), "Show only Labels with entries");
                ComboBox spmls = new ComboBox();
                spmls.addItem(Words.REGURAL);
                spmls.addItem(Words.SPML_AND_ALACARTE);
                this.confPanel.addItem(spmls, TitledItem.TitledItemOrientation.NORTH, SPML_ONLY, "LABEL TYPES");
                ComboBox cabinClass = new ComboBox((Node)new DTOProxyNode(), this.createCabinClassView((FlightLight)this.flightNode.getValue()), ConverterRegistry.getConverter(CabinClassConverter.class));
                cabinClass.addItem(Words.ALL);
                cabinClass.setSelectedItem(Words.ALL);
                this.confPanel.addItem(cabinClass, TitledItem.TitledItemOrientation.NORTH, CABIN_CLASS_FILTER, "CABIN CLASSES");
                this.nt = new ListNode();
                ArrayList a = new ArrayList();
                a.addAll(((FlightLight)this.flightNode.getValue(FlightLight.class)).getLegs());
                this.nt.setValue(a, 0L);
                this.nt.getAllChildAddEventsFor(null, new String[0]);
                MultiLegComboBox<FlightLegComplete> mls = new MultiLegComboBox<FlightLegComplete>(this.nt, ConverterRegistry.getConverter(LegListStringConverter2.class)){

                    @Override
                    public Node<?> createSelectableList() {
                        Node<?> n = super.createSelectableList();
                        return LegToolkit.getFlightLegsWithoutDSorNS(n);
                    }
                };
                this.nt.addNodeListener((NodeListener)this);
                this.confPanel.addItem(mls, TitledItem.TitledItemOrientation.NORTH, LEG, "LEGS");
                ViewNode n = new ViewNode("galleies");
                if (this.isInited) {
                    this.stopAnimation();
                    this.setEnabled(true);
                }
                this.table.getModel().setNode((Node)n);
                this.labelPreview.setFlightNode(this.flightNode);
                this.valueChanged(DEPARTMENT_FILTER, null);
                this.valueChanged(NAME_FILTER, "");
                this.isInited = true;
                break;
            }
            case SEARCH: {
                if (this.searchCount > 0) {
                    this.searchCount = 0;
                    this.doSearch();
                    break;
                }
                if (node != null && node.getValue() != null && node.getValue() instanceof List) {
                    if (this.table == null) {
                        return;
                    }
                    List l = (List)node.getValue();
                    Node currents = this.table.getModel().getNode();
                    List list = (List)node.getValue();
                    for (ILabelComplete item : list) {
                        Node nn;
                        boolean found = false;
                        Node foundNode = null;
                        Iterator it = currents.getChilds();
                        while (it.hasNext() && !found) {
                            nn = (Node)it.next();
                            if (nn.getValue(GalleyEquipmentComplete.class) == null) {
                                if (nn.getValue(GalleyEquipmentReservedSpaceTrayComplete.class) != null) {
                                    if (!((GalleyEquipmentReservedSpaceTrayComplete)nn.getValue(GalleyEquipmentReservedSpaceTrayComplete.class)).equals((Object)item)) continue;
                                    found = true;
                                    foundNode = nn;
                                    continue;
                                }
                                if (nn.getValue(GalleyEquipmentInsertComplete.class) == null || !((GalleyEquipmentInsertComplete)nn.getValue(GalleyEquipmentInsertComplete.class)).equals((Object)item)) continue;
                                found = true;
                                foundNode = nn;
                                continue;
                            }
                            if (!((GalleyEquipmentComplete)nn.getValue(GalleyEquipmentComplete.class)).equals((Object)item)) continue;
                            found = true;
                            foundNode = nn;
                        }
                        if (!found) {
                            nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)item, false, false);
                            currents.addChild(nn, 0L);
                            continue;
                        }
                        if (foundNode == null) continue;
                        foundNode.getChildNamed(new String[]{"labelConfiguration-printCount"}).removeExistingValues();
                        foundNode.getChildNamed(new String[]{"labelConfiguration-lastPrintedBy"}).removeExistingValues();
                        foundNode.getChildNamed(new String[]{"labelConfiguration-printCount"}).setValue((Object)item.getLabelConfiguration().getPrintCount(), 0L);
                        foundNode.getChildNamed(new String[]{"labelConfiguration-lastPrintedBy"}).setValue((Object)item.getLabelConfiguration().getLastPrintedBy(), 0L);
                        foundNode.removeExistingValues();
                        foundNode.setValue((Object)item, 0L);
                    }
                    Iterator it = currents.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node nn = (Node)it.next();
                        Iterator it2 = list.iterator();
                        boolean found = false;
                        while (it2.hasNext() && !found) {
                            ILabelComplete item = (ILabelComplete)it2.next();
                            if (!item.equals(nn.getValue())) continue;
                            found = true;
                        }
                        if (found) continue;
                        currents.removeChild(nn, 0L);
                    }
                }
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl i = (TableRowImpl)p;
                    i.rebuildFields(null);
                }
                this.activateSearch(true);
                this.setEnabled(true);
                this.stopAnimation();
                break;
            }
            case INKREMENT: {
                this.doSearch();
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.printSelection != null) {
            this.printSelection.setEnabled(isEnabled);
        }
        if (this.selectAll != null) {
            this.selectAll.setEnabled(isEnabled);
        }
        if (this.labelPreview != null) {
            this.labelPreview.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.nt != null) {
            this.nt.removeNodeListener((NodeListener)this);
        }
        if (this.printSelection != null) {
            this.printSelection.kill();
            this.printSelection = null;
        }
        if (this.selectAll != null) {
            this.selectAll.kill();
            this.selectAll = null;
        }
        if (this.labelPreview != null) {
            this.labelPreview.kill();
            this.labelPreview = null;
        }
        if (this.table != null) {
            this.table.kill();
            this.table = null;
        }
        if (this.confPanel != null) {
            this.confPanel.kill();
            this.confPanel = null;
        }
        if (this.loader != null) {
            this.loader.kill();
        }
        this.loader = null;
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    private void showAnimation(String text) {
        if (!this.isAnimating) {
            this.isAnimating = true;
            this.loader.fadeIn();
            this.loader.start();
            this.loader.stateChanged(text);
            this.validate();
        }
    }

    private void activateSearch(boolean isSearchActiv) {
        super.setEnabled(isSearchActiv);
        this.printSelection.setEnabled(isSearchActiv);
        this.table.setEnabled(isSearchActiv);
        this.labelPreview.setEnabled(isSearchActiv);
        this.selectAll.setEnabled(isSearchActiv);
    }

    private void doSearch() {
        this.currentSTATE = LOADINGSTATE.SEARCH;
        if (this.searchCount == 0) {
            this.showAnimation("Load");
            this.activateSearch(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ViewNode n = new ViewNode("");
                    List labels = null;
                    if (LabelPrintModule.this.isSPMLSearch) {
                        List o = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).getSpecialMealLabels((FlightReference)LabelPrintModule.this.flightNode.getValue(FlightReference.class), LabelPrintModule.this.showDifferenceOnly, LabelPrintModule.this.currentLegs, LabelPrintModule.this.currentCabinClass);
                        List o2 = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).getAlaCarteMealLabels((FlightReference)LabelPrintModule.this.flightNode.getValue(FlightReference.class), LabelPrintModule.this.showDifferenceOnly, LabelPrintModule.this.currentLegs, LabelPrintModule.this.currentCabinClass);
                        labels = new ArrayList();
                        labels.addAll(o);
                        labels.addAll(o2);
                    } else {
                        ServiceReturnWithMessage serviceReturn = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).getItemLabels(new FlightReference(((FlightReference)LabelPrintModule.this.flightNode.getValue(FlightReference.class)).getId()), LabelPrintModule.this.searchName, LabelPrintModule.this.currentCostCenter, LabelPrintModule.this.currentColor, LabelPrintModule.this.currentLayout, LabelPrintModule.this.currentCabinClass, LabelPrintModule.this.showDifferenceOnly, LabelPrintModule.this.labelWithContents);
                        List message = serviceReturn.getMessage();
                        ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
                        for (Object s : message) {
                            warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, (String)s));
                        }
                        if (warnings.size() > 0) {
                            InnerPopupFactory.showMessageDialog(warnings, "Label Validation", (Component)LabelPrintModule.this.table);
                        }
                        List o = ((ListWrapper)serviceReturn.getObject()).getList();
                        labels = o;
                        for (ItemLabelComplete label : o) {
                            Object gel;
                            GalleyEquipmentInsertComplete eq;
                            if (label.getHandlingLog().getItem() instanceof GalleyEquipmentInsertComplete) {
                                eq = (GalleyEquipmentInsertComplete)label.getHandlingLog().getItem();
                                if (eq.getContainingEquipment() != null || eq.getContainingEquipmentId() == null) continue;
                                gel = (GalleyEquipmentLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getContainingEquipment(eq.getContainingEquipmentId()).getValue();
                                eq.setContainingEquipment((GalleyEquipmentLight)gel);
                                continue;
                            }
                            if (!(label.getHandlingLog().getItem() instanceof GalleyEquipmentReservedSpaceTrayComplete) || (eq = (GalleyEquipmentReservedSpaceTrayComplete)label.getHandlingLog().getItem()).getContainingReservedSpace().getContainingEquipment() != null || eq.getContainingReservedSpace().getContainingEquipmentId() == null) continue;
                            gel = (GalleyEquipmentLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getContainingEquipment(eq.getContainingReservedSpace().getContainingEquipmentId()).getValue();
                            eq.getContainingReservedSpace().setContainingEquipment((GalleyEquipmentLight)gel);
                        }
                        if (LabelPrintModule.this.firstSearch) {
                            LabelPrintModule.this.firstSearch = false;
                            HashSet usedCostCenters = new HashSet();
                            HashSet<ColorComplete> usedColors = new HashSet<ColorComplete>();
                            HashSet<ReportFileComplete> usedLabelLayouts = new HashSet<ReportFileComplete>();
                            usedLabelLayouts.add(LabelPrintModule.this.flightC.getLabelLayout());
                            for (ItemLabelComplete l : o) {
                                HandlingLogLight hlog = l.getHandlingLog();
                                if (hlog.getItem() instanceof GalleyEquipmentComplete) {
                                    GalleyEquipmentComplete e = (GalleyEquipmentComplete)hlog.getItem();
                                    usedCostCenters.addAll(e.getCostCenter());
                                    if (!e.getLabelConfiguration().getUseDefaultLabel().booleanValue()) {
                                        usedLabelLayouts.add(e.getLabelConfiguration().getLabelLayout());
                                    }
                                } else if (hlog.getItem() instanceof GalleyEquipmentInsertComplete) {
                                    GalleyEquipmentInsertComplete i = (GalleyEquipmentInsertComplete)hlog.getItem();
                                    usedCostCenters.addAll(i.getCostCenter());
                                    if (!i.getLabelConfiguration().getUseDefaultLabel().booleanValue()) {
                                        usedLabelLayouts.add(i.getLabelConfiguration().getLabelLayout());
                                    }
                                } else if (hlog.getItem() instanceof GalleyEquipmentReservedSpaceTrayComplete) {
                                    GalleyEquipmentReservedSpaceTrayComplete t = (GalleyEquipmentReservedSpaceTrayComplete)hlog.getItem();
                                    usedCostCenters.addAll(t.getContainingReservedSpace().getCostCenter());
                                    if (!t.getContainingReservedSpace().getLabelConfiguration().getUseDefaultLabel().booleanValue()) {
                                        usedLabelLayouts.add(t.getContainingReservedSpace().getLabelConfiguration().getLabelLayout());
                                    }
                                }
                                if (l.getPreferredStyleSheet() != null) {
                                    usedLabelLayouts.add(l.getPreferredStyleSheet());
                                }
                                if (l.getLabelConfiguration().getLabelColor() != null) {
                                    usedColors.add(l.getLabelConfiguration().getLabelColor());
                                }
                                if (l.getOverrideColor() == null) continue;
                                usedColors.add(l.getOverrideColor());
                            }
                            ArrayList cc = new ArrayList();
                            cc.addAll(usedCostCenters);
                            ArrayList<ColorComplete> colors = new ArrayList<ColorComplete>();
                            colors.addAll(usedColors);
                            ArrayList<ReportFileComplete> ll = new ArrayList<ReportFileComplete>();
                            ll.addAll(usedLabelLayouts);
                            LabelPrintModule.this.updateCostCenters(cc);
                            LabelPrintModule.this.updateLabelColors(colors);
                            LabelPrintModule.this.updateLabelLayouts(ll);
                        }
                    }
                    n.setValue(labels, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return LabelPrintModule.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            ++this.searchCount;
        }
    }

    private void updateLabelLayouts(List<PegasusFileComplete> labelLayouts) {
        this.confPanel.setDisableEvents(true);
        Node usedCL = INodeCreator.getDefaultImpl().createNodes(labelLayouts, false);
        this.usedLayout.removeAllItems();
        this.usedLayout.refreshPossibleValues(usedCL);
        this.usedLayout.addItem(Words.ALL);
        this.usedLayout.setSelectedItem(Words.ALL);
        this.confPanel.setDisableEvents(false);
    }

    private void updateLabelColors(List<ColorComplete> colors) {
        this.confPanel.setDisableEvents(true);
        Node usedCL = INodeCreator.getDefaultImpl().createNodes(colors, false);
        this.usedColors.removeAllItems();
        this.usedColors.refreshPossibleValues(usedCL);
        this.usedColors.addItem(Words.ALL);
        this.usedColors.setSelectedItem(Words.ALL);
        this.confPanel.setDisableEvents(false);
    }

    private void updateCostCenters(List<CostCenterComplete> cc) {
        this.confPanel.setDisableEvents(true);
        Node usedCCs = INodeCreator.getDefaultImpl().createNodes(cc, false);
        this.usedDepartments.removeAllItems();
        this.usedDepartments.refreshPossibleValues(usedCCs);
        this.usedDepartments.addItem(Words.ALL);
        this.usedDepartments.setSelectedItem(Words.ALL);
        this.confPanel.setDisableEvents(false);
    }

    @Override
    public void startDataDownload() {
        this.currentSTATE = LOADINGSTATE.INIT;
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                LabelPrintModule.this.loader.stateChanged("Load 1/5 Modules");
                FlightLight f = (FlightLight)LabelPrintModule.this.flightNode.getValue();
                FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                LabelPrintModule.this.flightC = fc;
                ListNode ll = new ListNode();
                ll.setValue((Object)f.getLegs(), 0L);
                ll.getAllChildAddEventsFor(null, new String[0]);
                ll.setName("plegs");
                NodeToolkit.addAffix((Node)ll);
                LabelPrintModule.this.loader.stateChanged("Load 2/5 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                LabelPrintModule.this.loader.stateChanged("Load 3/5 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                LabelPrintModule.this.loader.stateChanged("Load 4/5 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                LabelPrintModule.this.loader.stateChanged("Load 5/5 Modules");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                NodeToolkit.getAffixList(ColorComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return LabelPrintModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void valueChanged(String id, Object newValue) {
        if (NAME_FILTER.equals(id)) {
            this.searchName = (String)newValue;
        } else if (DEPARTMENT_FILTER.equals(id)) {
            this.currentCostCenter = newValue instanceof Node ? (CostCenterComplete)((Node)newValue).getValue() : (newValue instanceof CostCenterComplete ? (CostCenterComplete)newValue : null);
        } else if (LABEL_LAYOUT.equals(id)) {
            this.currentLayout = newValue instanceof Node ? (ReportFileComplete)((Node)newValue).getValue() : (newValue instanceof ReportFileComplete ? (ReportFileComplete)newValue : null);
        } else if (LABEL_COLOR_FILTER.equals(id)) {
            this.currentColor = newValue instanceof Node ? (ColorComplete)((Node)newValue).getValue() : (newValue instanceof ColorComplete ? (ColorComplete)newValue : null);
        } else if (SHOW_DIFF_FILTER.equals(id)) {
            this.showDifferenceOnly = newValue instanceof Boolean ? ((Boolean)newValue).booleanValue() : false;
        } else if (SHOW_LABEL_WITH_CONTENT.equals(id)) {
            this.labelWithContents = newValue instanceof Boolean ? ((Boolean)newValue).booleanValue() : false;
        } else if (SPML_ONLY.equals(id)) {
            if (newValue instanceof String) {
                if (Words.SPML_AND_ALACARTE.equals(newValue)) {
                    this.isSPMLSearch = true;
                    this.installColumnHeader(true);
                } else if (Words.REGURAL.equals(newValue)) {
                    this.isSPMLSearch = false;
                    this.installColumnHeader(false);
                }
            }
        } else if (LEG.equals(id)) {
            if (newValue instanceof List) {
                this.currentLegs = (List)newValue;
            }
        } else if (CABIN_CLASS_FILTER.equals(id)) {
            this.currentCabinClass = newValue instanceof Node ? (CabinClassComplete)((Node)newValue).getValue() : (newValue instanceof CabinClassComplete ? (CabinClassComplete)newValue : null);
        }
        this.doSearch();
    }

    private void updateInfoText(List<ILabelComplete> labels) {
        for (Table2RowPanel p : this.table.getRows()) {
            ILabelComplete l = (ILabelComplete)p.getModel().getNode().getValue();
            HandlingLogLight log = null;
            if (l instanceof ItemLabelComplete) {
                log = ((ItemLabelComplete)l).getHandlingLog();
            } else if (l instanceof SpecialMealLabelComplete) {
                // empty if block
            }
            for (ILabelComplete i : labels) {
                TableRowImpl ip;
                HandlingLogLight log2 = null;
                if (i instanceof ItemLabelComplete) {
                    log2 = ((ItemLabelComplete)i).getHandlingLog();
                }
                if (log != null && log2 != null) {
                    if (!log.equals((Object)log2)) continue;
                    p.getModel().getNode().removeExistingValues();
                    p.getModel().getNode().setValue((Object)i, 0L);
                    p.getModel().getNode().updateNode();
                    ip = (TableRowImpl)p;
                    ip.rebuildFields(i.getLabelConfiguration());
                    continue;
                }
                if (l.getLabelConfiguration() == null || !l.getLabelConfiguration().equals((Object)i.getLabelConfiguration())) continue;
                p.getModel().getNode().removeExistingValues();
                p.getModel().getNode().setValue((Object)i, 0L);
                p.getModel().getNode().updateNode();
                ip = (TableRowImpl)p;
                ip.rebuildFields(i.getLabelConfiguration());
            }
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs != null && xargs.length != 0) {
            this.showAnimation(Words.UPDATEING_PRINT_INFO);
            this.setEnabled(false);
            this.currentSTATE = LOADINGSTATE.INKREMENT;
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    List ret = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).incrementPrintCount(new ListWrapper(LabelPrintModule.this.getSelectedIds())).getList();
                    if (!ret.isEmpty()) {
                        LabelPrintModule.this.updateInfoText(ret);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return LabelPrintModule.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    public void checkStateChanged() {
        this.validateSelectAllState();
    }

    public void valueChanged(Node<?> node) {
    }

    private List<FlightLegComplete> getLegList() {
        ArrayList<FlightLegComplete> legs = new ArrayList<FlightLegComplete>();
        Iterator it = this.nt.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            legs.add((FlightLegComplete)n.getValue());
        }
        return legs;
    }

    public void childAdded(Node<?> node, Node<?> child) {
        if (node == this.nt) {
            this.valueChanged(LEG, this.getLegList());
        }
    }

    public void childRemoved(Node<?> node, Node<?> child) {
        if (node == this.nt) {
            this.valueChanged(LEG, this.getLegList());
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public String getScreenTitle() {
        return FlightAccess.TOOL_LABEL_PUBLISHER.getDisplayName();
    }

    @Override
    public void saveAndBackDocument() {
        this.cancelDocument();
    }

    @Override
    public void saveDocument() {
        this.cancelDocument();
    }

    @Override
    public void setRowAttributes(RowTransferObject<FlightLight> o) {
        if (o == null) {
            InnerPopupFactory.showErrorDialog("Unable to load Label Publisher. Please restart Module.", (Component)this);
            return;
        }
        this.setRow(o.getFakeRow());
        this.install((FlightLight)o.getDto(), o.getFakeRow());
        FakeSmartScreenTableRow<FlightLight> m = o.getFakeRow();
        this.flightNode = m.getNode();
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return FlightAccess.getSubModuleDefinition((SubModuleAccessDefinition)FlightAccess.TOOL_LABEL_PUBLISHER);
    }

    public FlightComplete getFlight() {
        return this.flightC;
    }

    public void started() {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 1155);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (LabelPrintModule.this.loader != null) {
                LabelPrintModule.this.loader.setSize(LabelPrintModule.this.loader.getPreferredSize());
                LabelPrintModule.this.loader.setLocation((int)((double)parent.getWidth() - LabelPrintModule.this.loader.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - LabelPrintModule.this.loader.getPreferredSize().getHeight()) / 2);
            }
            int y = LabelPrintModule.this.layoutTitle(parent);
            y = LabelPrintModule.this.layoutTitleBar(y, parent.getWidth());
            LabelPrintModule.this.printSelection.setLocation((int)((double)parent.getWidth() - LabelPrintModule.this.printSelection.getPreferredSize().getWidth()), (int)((double)parent.getHeight() - LabelPrintModule.this.printSelection.getPreferredSize().getHeight()));
            LabelPrintModule.this.printSelection.setSize(LabelPrintModule.this.printSelection.getPreferredSize());
            LabelPrintModule.this.confPanel.setLocation(0, y + 10 + AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_tabletitle")));
            LabelPrintModule.this.confPanel.setSize(parent.getWidth(), 70);
            LabelPrintModule.this.table.setLocation(0, LabelPrintModule.this.confPanel.getY() + LabelPrintModule.this.confPanel.getHeight() + AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_filter_chain")));
            LabelPrintModule.this.table.setSize(parent.getWidth() * 2 / 3, (int)((double)parent.getHeight() - ((double)LabelPrintModule.this.table.getY() + LabelPrintModule.this.selectAll.getPreferredSize().getHeight() + 10.0)));
            LabelPrintModule.this.labelPreview.setLocation(LabelPrintModule.this.table.getX() + LabelPrintModule.this.table.getWidth() + 10, LabelPrintModule.this.table.getY());
            LabelPrintModule.this.labelPreview.setSize(parent.getWidth() - LabelPrintModule.this.labelPreview.getX(), (int)((double)parent.getHeight() - ((double)LabelPrintModule.this.labelPreview.getY() + LabelPrintModule.this.selectAll.getPreferredSize().getHeight() + 10.0)));
            LabelPrintModule.this.selectAll.setLocation((int)((double)(LabelPrintModule.this.table.getX() + LabelPrintModule.this.table.getWidth()) - LabelPrintModule.this.selectAll.getPreferredSize().getWidth()), parent.getHeight() - (int)LabelPrintModule.this.selectAll.getPreferredSize().getHeight());
            LabelPrintModule.this.selectAll.setSize(LabelPrintModule.this.selectAll.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private static enum LOADINGSTATE {
        INIT,
        SEARCH,
        INKREMENT;

    }
}

