/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.labelprint.utils;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterListConverter;
import ch.icit.pegasus.client.converter.EquipmentTypeConverter;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.labelprint.LabelPrintModule;
import ch.icit.pegasus.client.gui.submodules.tool.labelprint.utils.PrintInfoConverter;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.AlaCarteMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.SpecialMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentReservedSpaceTrayComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.LabelConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.TrackableItemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;

public class TableRowImpl
extends Table2RowPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TextLabel galleyName;
    private TextLabel equipmentName;
    private TextLabel departments;
    private TextLabel equipmentLoading;
    private TextLabel equipmentType;
    private TextLabel printInfo;
    private TextLabel color;
    private TextLabel cabinClass;
    private TextLabel labelLayout;
    private CheckBox print;
    private LabelPrintModule overview;
    private boolean isSPMLLabel = false;

    public TableRowImpl(Table2RowModel m, Node flightNode, LabelPrintModule labelPrintOverview) {
        super(m);
        this.overview = labelPrintOverview;
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.setSelectable(true);
        this.isSPMLLabel = m.getNode().getValue() instanceof SpecialMealLabelComplete || m.getNode().getValue() instanceof AlaCarteMealLabelComplete;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    TableRowImpl.this.selectLowerRow();
                }
                if (e.getKeyCode() == 38) {
                    TableRowImpl.this.selectUpperRow();
                }
            }
        });
        if (this.isSPMLLabel) {
            this.equipmentName = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-order-menuType-code"}));
            this.galleyName = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-service-cabinClass"}));
            this.equipmentLoading = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-leg"}), ConverterRegistry.getConverter(LegInfoConverter.class));
            this.equipmentType = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-order-stowingPosition-spaceName"}));
            this.printInfo = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-labelConfiguration"}), ConverterRegistry.getConverter(PrintInfoConverter.class));
            this.color = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-labelConfiguration-labelColor"}), ConverterRegistry.getConverter(ColorConverter.class));
            this.cabinClass = new TextLabel(m.getNode().getChildNamed(new String[]{"meal-order-cabinClass"}));
        } else {
            Converter c = ConverterRegistry.getConverter(EquipmentTypeConverter.class);
            if (m.getNode().getChildNamed(new String[]{"handlingLog-item-equipmentSetType"}) == null || m.getNode().getChildNamed(new String[]{"handlingLog-item"}).getValue() instanceof GalleyEquipmentReservedSpaceTrayComplete) {
                this.equipmentName = new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-spaceName"}));
                this.equipmentType = new TextLabel("TR");
                this.equipmentLoading = new TextLabel((String)m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-containingEquipment-positionCode"}).getValue());
                this.galleyName = m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-containingEquipment-containingGalley"}) != null && m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-containingEquipment-containingGalley-galleyCode"}) != null ? new TextLabel((String)m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-containingEquipment-containingGalley-galleyCode"}).getValue()) : new TextLabel("-");
                this.departments = new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-costCenter"}), ConverterRegistry.getConverter(CostCenterListConverter.class));
                this.labelLayout = new TextLabel();
                LabelConfigurationComplete lc = (LabelConfigurationComplete)m.getNode().getChildNamed(new String[]{"handlingLog-item-containingReservedSpace-labelConfiguration"}).getValue();
                String selectedLabel = "";
                selectedLabel = lc.getUseDefaultLabel() != false || lc.getLabelLayout() == null ? labelPrintOverview.getFlight().getLabelLayout().getDescription() : lc.getLabelLayout().getDescription();
                this.labelLayout.setText(selectedLabel);
                this.printInfo = new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-labelConfiguration"}), ConverterRegistry.getConverter(PrintInfoConverter.class));
            } else {
                this.equipmentName = new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-code"}));
                this.equipmentType = new TextLabel("EQ");
                this.equipmentLoading = new TextLabel((String)m.getNode().getChildNamed(new String[]{"handlingLog-item-code"}).getValue());
                this.galleyName = m.getNode().getChildNamed(new String[]{"handlingLog-item-containingGalley"}) != null && m.getNode().getChildNamed(new String[]{"handlingLog-item-containingGalley-galleyCode"}) != null ? new TextLabel((String)m.getNode().getChildNamed(new String[]{"handlingLog-item-containingGalley-galleyCode"}).getValue()) : new TextLabel("-");
                this.equipmentLoading = new TextLabel((String)c.convert(m.getNode().getChildNamed(new String[]{"handlingLog-item-equipmentSetType"}).getValue(), null, new Object[0]));
                this.departments = new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-costCenter"}), ConverterRegistry.getConverter(CostCenterListConverter.class));
                this.labelLayout = new TextLabel();
                LabelConfigurationComplete lc = (LabelConfigurationComplete)m.getNode().getChildNamed(new String[]{"handlingLog-item-labelConfiguration"}).getValue();
                String selectedLabel = "";
                selectedLabel = lc.getUseDefaultLabel() != false || lc.getLabelLayout() == null ? labelPrintOverview.getFlight().getLabelLayout().getDescription() : lc.getLabelLayout().getDescription();
                this.labelLayout.setText(selectedLabel);
            }
            if (this.printInfo == null) {
                this.printInfo = new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-labelConfiguration"}), ConverterRegistry.getConverter(PrintInfoConverter.class));
            }
            this.color = m.getNode().getChildNamed(new String[]{"overrideColor"}).getValue() != null ? new TextLabel(m.getNode().getChildNamed(new String[]{"overrideColor"}), ConverterRegistry.getConverter(ColorConverter.class)) : new TextLabel(m.getNode().getChildNamed(new String[]{"handlingLog-item-labelConfiguration-labelColor"}), ConverterRegistry.getConverter(ColorConverter.class));
            this.cabinClass = new TextLabel(m.getNode().getChildNamed(new String[]{"cabinClasses"}), (Converter)new Converter<List<CabinClassComplete>, String>(){

                public String convert(List<CabinClassComplete> o, Node<List<CabinClassComplete>> currentNode, Object ... param) {
                    String t = "";
                    if (o == null) {
                        return NULL_RETURN;
                    }
                    for (CabinClassComplete cabinClassComplete : o) {
                        if (cabinClassComplete == null) continue;
                        t = t + cabinClassComplete.getCode() + ", ";
                    }
                    if (!t.isEmpty()) {
                        t = t.substring(0, t.length() - 1);
                    }
                    return t;
                }

                public Class getParameterClass() {
                    return List.class;
                }
            });
        }
        this.print = new CheckBox();
        this.equipmentName.setProgress(1.0f);
        this.print.setProgress(1.0f);
        this.printInfo.setProgress(1.0f);
        if (this.galleyName != null) {
            this.galleyName.setProgress(1.0f);
        }
        this.print.addButtonListener(this);
        if (this.galleyName != null) {
            this.add(this.galleyName);
        }
        this.add(this.equipmentType);
        this.add(this.equipmentLoading);
        if (this.departments != null) {
            this.add(this.departments);
        }
        this.add(this.equipmentName);
        this.add(this.print);
        this.add(this.printInfo);
        this.add(this.color);
        if (this.labelLayout != null) {
            this.add(this.labelLayout);
        }
        if (this.cabinClass != null) {
            this.add(this.cabinClass);
        }
    }

    private void selectLowerRow() {
        Table2RowPanel rowAt;
        int currentIndex = this.getModel().getParentModel().getTable().getRowIndex(this);
        if (currentIndex < this.getModel().getParentModel().getTable().getRowCount() && (rowAt = this.getModel().getParentModel().getTable().getRowAt(currentIndex + 1)) != null) {
            this.setSelected(7, false);
            rowAt.setSelected(3);
            rowAt.requestFocusInWindowNow();
        }
    }

    private void selectUpperRow() {
        int currentIndex = this.getModel().getParentModel().getTable().getRowIndex(this);
        if (currentIndex > 0) {
            Table2RowPanel rowAt = this.getModel().getParentModel().getTable().getRowAt(currentIndex - 1);
            this.setSelected(7, false);
            rowAt.setSelected(3);
            rowAt.requestFocusInWindowNow();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.requestFocusInWindow();
    }

    public void rebuildFields(LabelConfigurationComplete labelConfig) {
        if (labelConfig != null) {
            this.printInfo.getNode().setValue((Object)labelConfig, 0L);
            this.printInfo.getNode().updateNode();
        }
        this.printInfo.updateString();
    }

    public Long getId() {
        return ((TrackableItemComplete)this.model.getNode().getValue()).getId();
    }

    public boolean isChecked() {
        if (this.print != null) {
            return this.print.isChecked();
        }
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.equipmentName.setEnabled(isEnabled);
        this.print.setEnabled(isEnabled);
        this.printInfo.setEnabled(isEnabled);
        if (this.galleyName != null) {
            this.galleyName.setEnabled(isEnabled);
        }
        if (this.cabinClass != null) {
            this.cabinClass.setEnabled(isEnabled);
        }
        this.equipmentType.setEnabled(isEnabled);
        this.equipmentLoading.setEnabled(isEnabled);
        this.color.setEnabled(isEnabled);
        if (this.labelLayout != null) {
            this.labelLayout.setEnabled(isEnabled);
        }
        if (this.departments != null) {
            this.departments.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.equipmentName.kill();
        this.equipmentName = null;
        this.print.kill();
        this.print = null;
        this.printInfo.kill();
        this.printInfo = null;
        if (this.labelLayout != null) {
            this.labelLayout.kill();
        }
        this.labelLayout = null;
        if (this.galleyName != null) {
            this.galleyName.kill();
        }
        this.galleyName = null;
        if (this.cabinClass != null) {
            this.cabinClass.kill();
        }
        if (this.departments != null) {
            this.departments.kill();
        }
        this.cabinClass = null;
        this.departments = null;
        this.equipmentType.kill();
        this.equipmentType = null;
        this.equipmentLoading.kill();
        this.equipmentLoading = null;
        this.color.kill();
        this.color = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.print.getFocusComponents();
    }

    @Override
    public Object getObject4Column(int column) {
        return null;
    }

    public void autoSelect(boolean allSelected) {
        this.print.setChecked(allSelected);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.overview.checkStateChanged();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
            int currentX = 0;
            TableRowImpl.this.equipmentName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.equipmentName.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.equipmentName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.equipmentName.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
            if (TableRowImpl.this.galleyName != null) {
                TableRowImpl.this.galleyName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.galleyName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.galleyName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.galleyName.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
            int currentIndex = 2;
            if (TableRowImpl.this.departments != null) {
                TableRowImpl.this.departments.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.departments.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.departments.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.departments.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            }
            TableRowImpl.this.color.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.color.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.color.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.color.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            if (TableRowImpl.this.labelLayout != null) {
                TableRowImpl.this.labelLayout.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.labelLayout.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.labelLayout.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.labelLayout.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            }
            TableRowImpl.this.equipmentLoading.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.equipmentLoading.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.equipmentLoading.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.equipmentLoading.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            TableRowImpl.this.equipmentType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.equipmentType.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.equipmentType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.equipmentType.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            TableRowImpl.this.printInfo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.printInfo.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.printInfo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.printInfo.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(++currentIndex);
            TableRowImpl.this.print.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.print.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.print.setSize(TableRowImpl.this.print.getPreferredSize());
        }
    }
}

