/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert;

import ch.icit.pegasus.client.converter.RoundingStrategyEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ConfigCateringChoicePanel
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> showOnInvoice;
    private TitledItem<CheckBox> ignoreOnDeliverySlip;
    private TitledItem<CheckBox> showAsStandard;
    private TitledItem<ComboBox> roundingStrategy;

    public ConfigCateringChoicePanel(Node<?> node) {
        this.showOnInvoice = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(CateringServicePartChoiceComplete_.ignoreOnInvoice)), Words.IGNORE_ON_INVOICE, TitledItem.TitledItemOrientation.EAST);
        this.ignoreOnDeliverySlip = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(CateringServicePartChoiceComplete_.ignoreOnDeliverySlip)), Words.IGNORE_ON_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
        this.showAsStandard = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(CateringServicePartChoiceComplete_.showAsStandard)), Words.SHOW_AS_STANDARD, TitledItem.TitledItemOrientation.EAST);
        Node strat = node.getChildNamed(CateringServicePartChoiceComplete_.roundingStrategy);
        if (strat.getValue() == null) {
            strat.setValue((Object)RoundingStrategyE.STANDARD, 0L);
        }
        this.roundingStrategy = new TitledItem<ComboBox>(new ComboBox(strat, NodeToolkit.getAffixList(RoundingStrategyE.class), ConverterRegistry.getConverter(RoundingStrategyEConverter.class)), WordsToolkit.toCapitalLetter((String)Words.ROUNDING), TitledItem.TitledItemOrientation.NORTH);
        this.setLayout(new Layout());
        this.add(this.showOnInvoice);
        this.add(this.ignoreOnDeliverySlip);
        this.add(this.roundingStrategy);
        this.add(this.showAsStandard);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.showOnInvoice.kill();
        this.showOnInvoice = null;
        this.ignoreOnDeliverySlip.kill();
        this.ignoreOnDeliverySlip = null;
        this.roundingStrategy.kill();
        this.roundingStrategy = null;
        this.showAsStandard.kill();
        this.showAsStandard = null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.showOnInvoice.getFocusComponents();
        CheckedListAdder.addToList(a, this.ignoreOnDeliverySlip);
        CheckedListAdder.addToList(a, this.showAsStandard);
        CheckedListAdder.addToList(a, this.roundingStrategy);
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.roundingStrategy.getElement().isInnerComponent(c);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 10;
            h = (int)((double)h + ConfigCateringChoicePanel.this.showOnInvoice.getPreferredSize().getHeight());
            h += 5;
            h = (int)((double)h + ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.getPreferredSize().getHeight());
            h += 5;
            h = (int)((double)h + ConfigCateringChoicePanel.this.showAsStandard.getPreferredSize().getHeight());
            h += 5;
            h = (int)((double)h + ConfigCateringChoicePanel.this.roundingStrategy.getPreferredSize().getHeight());
            int w = 20;
            w = (int)((double)w + ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.getPreferredSize().getWidth());
            return new Dimension(w, h += 10);
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigCateringChoicePanel.this.showOnInvoice.setLocation(10, 10);
            ConfigCateringChoicePanel.this.showOnInvoice.setSize(parent.getWidth() - 20, (int)ConfigCateringChoicePanel.this.showOnInvoice.getPreferredSize().getHeight());
            ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.setLocation(10, ConfigCateringChoicePanel.this.showOnInvoice.getY() + ConfigCateringChoicePanel.this.showOnInvoice.getHeight() + 5);
            ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.setSize(parent.getWidth() - 20, (int)ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.getPreferredSize().getHeight());
            ConfigCateringChoicePanel.this.showAsStandard.setLocation(10, ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.getY() + ConfigCateringChoicePanel.this.ignoreOnDeliverySlip.getHeight() + 5);
            ConfigCateringChoicePanel.this.showAsStandard.setSize(parent.getWidth() - 20, (int)ConfigCateringChoicePanel.this.showAsStandard.getPreferredSize().getHeight());
            ConfigCateringChoicePanel.this.roundingStrategy.setLocation(10, ConfigCateringChoicePanel.this.showAsStandard.getY() + ConfigCateringChoicePanel.this.showAsStandard.getHeight() + 5);
            ConfigCateringChoicePanel.this.roundingStrategy.setSize(parent.getWidth() - 20, (int)ConfigCateringChoicePanel.this.roundingStrategy.getPreferredSize().getHeight());
        }
    }
}

