/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert;

import ch.icit.pegasus.client.comparators.CateringPartChoiceStepComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class EditChoiceStepsInsert
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node<List<StepComplete>> steps;
    private TextButton exportSteps;
    private TextButton importSteps;

    public EditChoiceStepsInsert(ListNode<List<StepComplete>, StepComplete> steps) {
        this.setOpaque(false);
        this.steps = steps;
        this.exportSteps = new TextButton("Export Steps");
        this.importSteps = new TextButton("Import Steps");
        this.exportSteps.addButtonListener(this);
        this.importSteps.addButtonListener(this);
        this.table = new Table2(true, Words.ADD_STEP);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                EditChoiceStepsInsert.this.popup.createFocusCycle();
                EditChoiceStepsInsert.this.table.relayoutRequested();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node lastStep = null;
                Iterator it = EditChoiceStepsInsert.this.steps.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node s = (Node)it.next();
                    if (lastStep != null) {
                        Integer value = (Integer)lastStep.getChildNamed(StepComplete_.upperLimit).getValue();
                        Integer nValue = (Integer)s.getChildNamed(StepComplete_.upperLimit).getValue();
                        if (value == null || nValue == null || value >= nValue) continue;
                        lastStep = s;
                        continue;
                    }
                    lastStep = s;
                }
                StepComplete step = new StepComplete();
                step.setClientOId(Long.valueOf(ADTO.getNextId()));
                Integer upQuant = 0;
                Integer resQuant = 0;
                if (lastStep != null) {
                    upQuant = (Integer)lastStep.getChildNamed(StepComplete_.upperLimit).getValue() + 1;
                    resQuant = (Integer)lastStep.getChildNamed(StepComplete_.quantity).getValue() + 1;
                } else {
                    upQuant = 1;
                    resQuant = 1;
                }
                step.setQuantity(resQuant);
                step.setUpperLimit(upQuant);
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)step, true, false);
                EditChoiceStepsInsert.this.steps.addChild(n, System.currentTimeMillis());
                EditChoiceStepsInsert.this.popup.createFocusCycle();
                EditChoiceStepsInsert.this.table.relayoutRequested();
                Table2RowPanel p = EditChoiceStepsInsert.this.table.getRowPanel4Node(n);
                if (p != null) {
                    p.requestFocusInWindowNow();
                }
            }
        });
        this.table.setComparator(ComparatorRegistry.getComparator(CateringPartChoiceStepComparator.class));
        int delSpace = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", delSpace, delSpace, delSpace));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.24);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.36);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(this.steps);
        this.table.updateOrder();
        this.setLayout(new Layout());
        this.add(this.table);
        this.add(this.importSteps);
        this.add(this.exportSteps);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.importSteps.kill();
        this.exportSteps.kill();
        this.importSteps = null;
        this.exportSteps = null;
        this.table.kill();
        this.table = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        if (this.table.getAddButton() != null) {
            this.table.getAddButton().requestFocusInWindow();
            return true;
        }
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.exportSteps) {
            try {
                this.exportSteps();
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        } else if (source == this.importSteps) {
            try {
                this.importSteps();
            }
            catch (ExcelToolkitException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        }
    }

    private void importSteps() throws ExcelToolkitException {
        File f = FileChooserUtil.loadFile();
        if (f != null) {
            List rows = ExcelToolkit.readRows((File)f);
            for (ExcelRow r : rows) {
                Integer upperLimit = ExcelToolkit.readAsInteger((ExcelRow)r, (int)1);
                Integer quantity = ExcelToolkit.readAsInteger((ExcelRow)r, (int)2);
                if (upperLimit == null || quantity == null) continue;
                StepComplete s = new StepComplete();
                s.setClientOId(Long.valueOf(ADTO.getNextId()));
                s.setQuantity(quantity);
                s.setUpperLimit(upperLimit);
                Node sn = INodeCreator.getDefaultImpl().getNode4DTO((Object)s, true, false);
                this.table.getModel().getNode().addChild(sn, 0L);
            }
        }
    }

    private void exportSteps() throws Exception {
        StyledWorkbook workbook = ExcelToolkit.createFastWorkbook();
        Sheet sheet = ExcelToolkit.insertSheet((StyledWorkbook)workbook, (String)"Exported Steps");
        int cr = 0;
        ExcelRow header = new ExcelRow();
        header.addCell((Object)"From", new String[0]);
        header.addCell((Object)"To", new String[0]);
        header.addCell((Object)"Amount", new String[0]);
        cr = header.writeRow(workbook, sheet, true, cr);
        int last = 0;
        for (Table2RowPanel r : this.table.getRows()) {
            ExcelRow row = new ExcelRow();
            row.addCell((Object)last, new String[0]);
            row.addCell(r.getModel().getNode().getChildNamed(StepComplete_.upperLimit).getValue(), new String[0]);
            row.addCell(r.getModel().getNode().getChildNamed(StepComplete_.quantity).getValue(), new String[0]);
            last = (Integer)r.getModel().getNode().getChildNamed(StepComplete_.upperLimit).getValue();
            cr = row.writeRow(workbook, sheet, false, cr);
        }
        File f = FileChooserUtil.saveFile(".xlsx");
        ExcelToolkit.writeWorkBook((File)f, (StyledWorkbook)workbook);
        PrintPopupToolkit.previewFile(f);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel from;
        private ArrowConnectorIcon arrow;
        private TextField toField;
        private TextLabel equals;
        private TextField resultingField;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            Converter fromConverter = new Converter(){

                public Object convert(Object o, Node currentNode, Object ... param) {
                    Node seqNr = TableRowImpl.this.model.getNode().getChildNamed(new String[]{"upperLimit"});
                    if (seqNr.getValue() == null) {
                        return "-";
                    }
                    int nIndex = (Integer)seqNr.getValue();
                    Integer quant = TableRowImpl.this.getLowerUpperLimit(nIndex);
                    if (quant == null) {
                        return "0";
                    }
                    String t = "> " + quant;
                    return t;
                }

                public Class getParameterClass() {
                    return null;
                }
            };
            this.from = new TextLabel(m.getNode(), fromConverter);
            this.arrow = new ArrowConnectorIcon();
            this.toField = new NumberTextField(m.getNode().getChildNamed(new String[]{"upperLimit"}), TextFieldType.INT);
            m.getNode().getChildNamed(new String[]{"upperLimit"}).addNodeListener((NodeListener)this);
            this.equals = new TextLabel("=");
            this.resultingField = new NumberTextField(m.getNode().getChildNamed(new String[]{"quantity"}), TextFieldType.INT);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new TableRowImplLayout());
            this.from.setProgress(1.0f);
            this.toField.setProgress(1.0f);
            this.resultingField.setProgress(1.0f);
            this.add(this.from);
            this.add(this.arrow);
            this.add(this.toField);
            this.add(this.equals);
            this.add(this.resultingField);
            this.add(this.delete);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private int getLowerUpperLimit(int i) {
            Iterator it = this.model.getNode().getParent().getFailSafeChildIterator();
            int min = 0;
            while (it.hasNext()) {
                Node n = (Node)it.next();
                int ii = (Integer)n.getChildNamed(new String[]{"upperLimit"}).getValue();
                if (ii <= min || ii >= i) continue;
                min = ii;
            }
            return min;
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return false;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.from.setEnabled(isEnabled);
            this.arrow.setEnabled(isEnabled);
            this.toField.setEnabled(isEnabled);
            this.equals.setEnabled(isEnabled);
            this.resultingField.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new String[]{"upperLimit"}).removeNodeListener((NodeListener)this);
            this.from.kill();
            this.arrow.kill();
            this.toField.kill();
            this.equals.kill();
            this.resultingField.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.from = null;
            this.arrow = null;
            this.toField = null;
            this.equals = null;
            this.resultingField = null;
            this.delete = null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.toField != null) {
                this.toField.requestFocusInWindowNow();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.toField);
            CheckedListAdder.addToList(a, this.resultingField);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void valueChanged(Node<?> node) {
            int i = EditChoiceStepsInsert.this.table.getRowIndex(this);
            if (i + 1 < EditChoiceStepsInsert.this.table.getRowCount()) {
                Table2RowPanel p = EditChoiceStepsInsert.this.table.getRowAt(i + 1);
                TableRowImpl pp = (TableRowImpl)p;
                pp.updateField();
            }
        }

        private void updateField() {
            this.from.updateString();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TableRowImplLayout
        extends DefaultLayout {
            private TableRowImplLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int aW = 0;
                TableRowImpl.this.from.setLocation(currentX + EditChoiceStepsInsert.this.table.getCellPadding(), (int)((parent.getPreferredSize().getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * EditChoiceStepsInsert.this.table.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.arrow.setLocation(currentX + (int)(((double)w - TableRowImpl.this.arrow.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - TableRowImpl.this.arrow.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.arrow.setSize(TableRowImpl.this.arrow.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                aW = w - 4 * EditChoiceStepsInsert.this.table.getCellPadding();
                TableRowImpl.this.toField.setLocation(currentX + EditChoiceStepsInsert.this.table.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.toField.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.toField.setSize(aW, (int)TableRowImpl.this.toField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.equals.setLocation(currentX + (int)((double)w - TableRowImpl.this.equals.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TableRowImpl.this.equals.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.equals.setSize(TableRowImpl.this.equals.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.resultingField.setLocation(currentX + EditChoiceStepsInsert.this.table.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.resultingField.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.resultingField.setSize(w - 2 * EditChoiceStepsInsert.this.table.getCellPadding(), (int)TableRowImpl.this.resultingField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + (int)((double)w - TableRowImpl.this.delete.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            EditChoiceStepsInsert.this.table.setLocation(0, 0);
            EditChoiceStepsInsert.this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)(2 * border) + EditChoiceStepsInsert.this.importSteps.getPreferredSize().getHeight())));
            EditChoiceStepsInsert.this.importSteps.setLocation(border, EditChoiceStepsInsert.this.table.getHeight() + border);
            EditChoiceStepsInsert.this.importSteps.setSize(EditChoiceStepsInsert.this.importSteps.getPreferredSize());
            EditChoiceStepsInsert.this.exportSteps.setLocation(EditChoiceStepsInsert.this.importSteps.getX() + EditChoiceStepsInsert.this.importSteps.getWidth() + border, EditChoiceStepsInsert.this.table.getHeight() + border);
            EditChoiceStepsInsert.this.exportSteps.setSize(EditChoiceStepsInsert.this.exportSteps.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(500, 250);
        }
    }
}

