/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec;

import ch.icit.pegasus.client.converter.ProductVariantSpecConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.modules.product.ProductModuleDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.ProductBreadCrumbPanel;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.ProductPriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductSpecificationSubModule
extends SubModuleScreenInsert<ProductComplete>
implements RowSmartScreen<ProductComplete>,
MutableFocusContainerListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    static Logger log = LoggerFactory.getLogger(ProductSpecificationSubModule.class);
    private ProductVariantReference lastSelectedItem;
    private ProductBreadCrumbPanel breadPanel;
    private Node<ProductReference> node;
    private FakeSmartScreenTableRow currentRowModel;
    private LoadingAnimation animationPanel;
    private ProductModuleDataHandler dataHandler;
    private LoadingState currentState = LoadingState.NONE;
    private ProductComplete product;
    private TitledItem<ComboBox> variants;
    private Node currentVariant;
    private boolean blockReload;
    private TitledItem<DateChooser> dueDate;
    private boolean masterDataLoaded = false;

    public void createFocusCycle() {
    }

    @Override
    public void saveAndBackDocument() {
        if (this.validateScreen()) {
            this.lastSelectedItem = (ProductVariantReference)this.variants.getElement().getNode().getValue();
            this.showAnimation();
            this.currentState = LoadingState.SAVE_AND_BACK;
            this.doSaveDocument();
        }
    }

    private boolean checkCostCentersInVariant(ProductVariantComplete variant) {
        long now = System.currentTimeMillis();
        if (variant.getValidityPeriod().getStartDate().getTime() > now) {
            return true;
        }
        return variant.getValidityPeriod().getEndDate().getTime() > now;
    }

    private boolean isDepartmentCheck(ProductVariantLight variant) {
        if (variant == null) {
            return false;
        }
        if (variant.getValidityPeriod().within(new Date(System.currentTimeMillis())).booleanValue()) {
            return true;
        }
        return variant.getValidityPeriod().getEndDate().getTime() > System.currentTimeMillis();
    }

    private boolean validateScreen() {
        this.node.commit(ComplexProductVariantComplete.class);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        Iterator it = this.node.getChildNamed(ProductComplete_.variants).getChilds();
        boolean manMinuteOnComponentAreMandatory = Boolean.TRUE.equals(((ProductComplete)this.node.getValue()).getCustomer().getManMinutesOnComponentAreMandatory());
        while (it.hasNext()) {
            Node n = (Node)it.next();
            ProductVariantComplete v = (ProductVariantComplete)n.getValue(ProductVariantComplete.class);
            boolean needsMMCheck = this.isDepartmentCheck((ProductVariantLight)v);
            if (!(v instanceof ComplexProductVariantComplete)) continue;
            ComplexProductVariantComplete p = (ComplexProductVariantComplete)v;
            for (SimpleProductComponentGroupComplete oc : p.getProductComponentGroups()) {
                if (oc.getCostCenter() == null && Boolean.TRUE.equals(settings.getProductGroupDepartmentMandatory()) && this.checkCostCentersInVariant(v)) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Variant (" + v.getValidityPeriod() + ") Group " + oc.getName() + " has no department defined"));
                }
                for (ProductComponentComplete pc : oc.getComponents()) {
                    BasicArticleComplete c;
                    if (pc instanceof SimpleComponentComplete) {
                        c = ((SimpleComponentComplete)pc).getArticle();
                        if (((LinearQuantityInterpolationComplete)pc.getQuantity()).getResultingQuantity().getUnit() == null) {
                            ((LinearQuantityInterpolationComplete)pc.getQuantity()).getResultingQuantity().setUnit(c.getBaseUnit());
                        }
                        UnitComplete u = ((LinearQuantityInterpolationComplete)pc.getQuantity()).getResultingQuantity().getUnit();
                        if (c != null) {
                            if (pc.getCostCenter() == null && Boolean.TRUE.equals(settings.getProductComponentDepartmentMandatory()) && this.checkCostCentersInVariant(v)) {
                                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Variant (" + v.getValidityPeriod() + ") Group " + oc.getName() + ", Component " + c.getName() + " has no department defined"));
                            }
                            if (UnitConversionToolkit.isUnitContaining((UnitComplete)u, (UnitComplete)c.getBaseUnit(), (BasicArticleLight)c, (Timestamp)new Timestamp(((Date)this.getDueDate().getValue()).getTime())) == 11) {
                                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + c.getNumber() + " - " + c.getName() + " uses a invalid Unit (" + u.getShortName() + ")"));
                            }
                            if (!manMinuteOnComponentAreMandatory || !needsMMCheck || !pc.getCateringPointCosts().isEmpty()) continue;
                            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Variant (" + v.getValidityPeriod() + ") Group " + oc.getName() + ", Component " + c.getName() + " has no Man Minutes defined"));
                            continue;
                        }
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + pc.getNumber() + " in Group " + oc.getName() + " not set!"));
                        continue;
                    }
                    c = ((CompoundComponentComplete)pc).getRecipe();
                    RecipeVariantLight rc = c.getCurrentVariant();
                    if (pc.getCostCenter() == null && Boolean.TRUE.equals(settings.getProductComponentDepartmentMandatory()) && this.checkCostCentersInVariant(v)) {
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Variant (" + v.getValidityPeriod() + ") Group " + oc.getName() + ", Component " + rc.getName() + " has no department defined"));
                    }
                    if (!manMinuteOnComponentAreMandatory || !needsMMCheck || !pc.getCateringPointCosts().isEmpty()) continue;
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Variant (" + v.getValidityPeriod() + ") Group " + oc.getName() + ", Component " + rc.getName() + " has no Man Minutes defined"));
                }
            }
        }
        if (!rets.isEmpty()) {
            InnerPopupFactory.showErrorDialog(rets, "Unable to save, following Warnings occurred", (Component)this);
            return false;
        }
        return true;
    }

    @Override
    public void saveDocument() {
        this.lastSelectedItem = (ProductVariantReference)this.variants.getElement().getNode().getValue();
        this.showAnimation();
        boolean validateScreen = this.validateScreen();
        if (validateScreen) {
            this.currentState = LoadingState.SAVE;
            this.doSaveDocument();
        } else {
            this.hideAnimation();
        }
    }

    private String getMessage() {
        return "Do you want to copy your changes in the Tender Scenario Variant? Accepted Tender Scenario aren't changed.";
    }

    private void copyChanges(boolean copy) {
        Node cc = this.node.getChildNamed(new String[]{"copyChanges"});
        if (cc == null) {
            cc = new Node();
            cc.setName("copyChanges");
            this.node.addChild(cc, 0L);
        }
        cc.setValue((Object)copy, 0L);
    }

    private void doSaveDocument() {
        try {
            this.blockReload = true;
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ProductSpecificationSubModule.this.recalculateSalesPrice();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ProductSpecificationSubModule.this.finishSaving();
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Unable to save Product. <br/>" + exception.getMessage(), (Component)ProductSpecificationSubModule.this);
                            ProductSpecificationSubModule.this.hideAnimation();
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog("Unable to save Product. <br/>" + e.getMessage(), (Component)this);
            this.hideAnimation();
        }
    }

    private void finishSaving() {
        this.dataHandler.updateData(this.node, (RemoteLoader)this, (ProgressListener)this.animationPanel);
    }

    private void recalculateSalesPrice() throws Exception {
        if (this.node == null) {
            return;
        }
        CurrencyVariantAccessorImpl accessor = new CurrencyVariantAccessorImpl();
        RecipeVariantAccessorImpl recipeAccessor = new RecipeVariantAccessorImpl();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Iterator it = this.variants.getElement().getPossibleValues().getChilds();
        while (it.hasNext()) {
            Node np = (Node)it.next();
            try {
                ProductVariantComplete p = (ProductVariantComplete)np.getValue(ProductVariantComplete.class);
                if (p instanceof ComplexProductVariantComplete) {
                    np.commitThis(ComplexProductVariantComplete.class);
                } else {
                    np.commitThis(SimpleProductVariantComplete.class);
                }
                if ((p = (ProductVariantComplete)np.getValue(ProductVariantComplete.class)) == null) continue;
                PriceComplete salesPrice = new PriceComplete();
                PriceComplete matPrice = ProductPriceCalculationToolkit.getProductMaterialPrice((ProductVariantComplete)p, (int)1, (ModificationStateE)p.getState(), (SystemSettingsComplete)settings, (Timestamp)new Timestamp(p.getValidityPeriod().getStartDate().getTime()), (RecipeVariantAccessor)new RecipeVariantAccessorImpl(), (CurrencyVariantAccessor)accessor);
                PriceComplete processCost = ((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductProcessCosts(p, new TimestampWrapper(p.getValidityPeriod().getStartDate().getTime()));
                if (!p.getFixedPrice().booleanValue()) {
                    salesPrice.setPrice(Double.valueOf(0.0));
                    salesPrice.setCurrency(matPrice.getCurrency());
                    PriceComplete productionPrice = new PriceComplete();
                    productionPrice.setCurrency(settings.getCurrency());
                    productionPrice.setPrice(Double.valueOf(matPrice.getPrice() + processCost.getPrice()));
                    for (ProductPriceFactorComplete sp : p.getProductPriceFactors()) {
                        double f;
                        if (Boolean.TRUE.equals(sp.getFixPrice())) {
                            f = sp.getFactor();
                            salesPrice.setPrice(Double.valueOf(salesPrice.getPrice() + f));
                            continue;
                        }
                        f = sp.getFactor();
                        double d = productionPrice.getPrice() * f;
                        salesPrice.setPrice(Double.valueOf(salesPrice.getPrice() + (d /= 100.0)));
                    }
                    salesPrice.setPrice(Double.valueOf(salesPrice.getPrice() + matPrice.getPrice() + processCost.getPrice()));
                    if (settings.getProductSalesPriceFactor() != null) {
                        salesPrice.setPrice(Double.valueOf(salesPrice.getPrice() + salesPrice.getPrice() * settings.getProductSalesPriceFactor()));
                    }
                    p.setSalesPrice(salesPrice);
                }
                p.setMaterialPrice(matPrice);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.breadPanel.setEnabled(isEnabled);
        this.variants.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
    }

    public Node getNode() {
        return this.node;
    }

    private void init(FakeSmartScreenTableRow model, ProductVariantReference variant) {
        this.currentRowModel = model;
        this.setRow(model);
        this.variants = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode((Object)variant), null, ConverterRegistry.getConverter(ProductVariantSpecConverter.class), false), "Variants", TitledItem.TitledItemOrientation.WEST);
        this.variants.getElement().setNodeCommittingClass(ProductVariantLight.class);
        this.variants.setIgnorePrefWidth(true);
        Node dn = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dn), Words.DUE_DATE, TitledItem.TitledItemOrientation.WEST);
        this.dueDate.setInnerGap(3);
        this.dueDate.setIgnorePrefWidth(true);
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(ProductAccess.MODULE_PRODUCT, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false){

            @Override
            public boolean isAddable(String field) {
                return true;
            }
        };
        this.breadPanel = new ProductBreadCrumbPanel((IDataHandler)this.dataHandler, this, p);
        this.breadPanel.addFocusCycleChangeListener(this);
        ArrayList<Component> a = new ArrayList<Component>();
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.add(this.variants);
        this.add(this.breadPanel);
        this.add(this.dueDate);
        this.showAnimation();
    }

    private void loadData(ProductComplete prod) {
        this.currentState = LoadingState.LOADING;
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)prod, false, false);
        if (this.dataHandler != null) {
            if (!this.masterDataLoaded) {
                this.dataHandler.loadMasterData(0L, null, this.animationPanel);
                this.masterDataLoaded = true;
            }
            this.dataHandler.reloadDataBeforeOpening(n, (RemoteLoader)this, (ProgressListener)this.animationPanel);
        }
    }

    private void showAnimation() {
        this.setEnabled(false);
        if (this.animationPanel == null) {
            this.animationPanel = new LoadingAnimation();
            this.animationPanel.stateChanged("Load Data");
            this.animationPanel.start();
            this.animationPanel.fadeIn();
            this.add((Component)this.animationPanel, 0);
            this.revalidate();
        }
    }

    private void hideAnimation() {
        this.setEnabled(true);
        if (this.animationPanel != null) {
            this.animationPanel.stop();
            this.animationPanel.fadeOut(true);
            this.animationPanel = null;
        }
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentState == LoadingState.LOADING) {
            this.blockReload = false;
            if (node != null && node.getValue() != null) {
                this.node = node;
                this.hideAnimation();
                if (this.variants != null && this.node != null) {
                    this.variants.getElement().getNode().removeNodeListener((NodeListener)this);
                    this.variants.getElement().refreshPossibleValues(this.node.getChildNamed(ProductComplete_.variants));
                    this.variants.getElement().getNode().addNodeListener((NodeListener)this);
                    if (this.lastSelectedItem != null) {
                        Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)this.lastSelectedItem, true, false);
                        this.valueChanged(node4DTO);
                        this.variants.getElement().setSelectedItem(node4DTO);
                    } else {
                        this.valueChanged(this.variants.getElement().getNode());
                    }
                }
            }
            this.currentState = LoadingState.NONE;
        } else if (this.currentState == LoadingState.SAVE_AND_BACK) {
            this.blockReload = false;
            this.cancelDocument();
        } else if (this.currentState == LoadingState.SAVE) {
            this.blockReload = false;
            this.startDataDownload();
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.blockReload = false;
        this.setCursor(new Cursor(0));
        this.hideAnimation();
        this.setEnabled(true);
        super.errorOccurred(exception);
    }

    public ProductModuleDataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    public void escapeKeyPressed() {
    }

    public LoadingState getCurrentState() {
        return this.currentState;
    }

    @Override
    public void saveKeyPressed() {
        this.saveDocument();
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.blockReload = true;
        this.loadData(this.product);
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.createFocusCycle();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        if (this.variants != null) {
            this.variants.getElement().getNode().removeNodeListener((NodeListener)this);
        }
        super.kill();
    }

    private void showProduct(Node node) {
        if (node.getValue(ProductVariantComplete.class) instanceof ComplexProductVariantComplete) {
            this.breadPanel.setNode(node);
            this.createFocusCycle();
        } else {
            this.breadPanel.showSimple(node);
        }
    }

    public void valueChanged(final Node<?> node) {
        if (node == null || this.blockReload) {
            return;
        }
        final Node<?> oldNode = node;
        final ProductVariantReference ref = (ProductVariantReference)node.getValue(ProductVariantReference.class);
        if (node.getValue(ProductReference.class) != null) {
            log.debug("found product instead of variant " + node.getValue());
        }
        this.showAnimation();
        if (node.getValue(ProductVariantComplete.class) == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ProductVariantLight l = (ProductVariantLight)node.getValue(ProductVariantLight.class);
                    if (l == null) {
                        log.debug("null point will be caused " + (ref != null ? ref.getClass().getSimpleName() : "-") + ", " + (oldNode != null ? oldNode.getValue().getClass().getSimpleName() : ""));
                    }
                    ProductVariantComplete p = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference((ProductVariantReference)l).getValue();
                    Node n = node;
                    n.removeExistingValues();
                    n.setValue((Object)p, 0L);
                    n.updateNode();
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ProductSpecificationSubModule.this.currentVariant = node;
                            ProductSpecificationSubModule.this.showProduct(node);
                            ProductSpecificationSubModule.this.currentState = LoadingState.NONE;
                            ProductSpecificationSubModule.this.hideAnimation();
                        }

                        public void errorOccurred(ClientException exception) {
                            ProductSpecificationSubModule.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.currentVariant = node;
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    if (ProductSpecificationSubModule.this.currentVariant != null) {
                        try {
                            ProductSpecificationSubModule.this.recalculateSalesPrice();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node2) {
                            ProductSpecificationSubModule.this.currentVariant = node;
                            ProductSpecificationSubModule.this.showProduct(node);
                            ProductSpecificationSubModule.this.currentState = LoadingState.NONE;
                            ProductSpecificationSubModule.this.hideAnimation();
                        }

                        public void errorOccurred(ClientException exception) {
                            ProductSpecificationSubModule.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public String getScreenTitle() {
        return ProductAccess.TOOL_PRODUCT_SPECIFICATION.getDisplayName();
    }

    @Override
    public void setRowAttributes(RowTransferObject<ProductComplete> o) {
        if (o == null) {
            return;
        }
        this.product = (ProductComplete)o.getDto();
        FakeSmartScreenTableRow<ProductComplete> rowM = o.getFakeRow();
        this.dataHandler = (ProductModuleDataHandler)o.getDatahandler();
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)this.product, false, false);
        ProductVariantLight v = this.product.getCurrentVariant();
        this.init(rowM, (ProductVariantReference)v);
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return ProductAccess.getSubModuleDefinition((SubModuleAccessDefinition)ProductAccess.TOOL_PRODUCT_SPECIFICATION);
    }

    public Node<Date> getDueDate() {
        return this.dueDate.getElement().getNode();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ProductSpecificationSubModule.this.layoutTitle(parent);
            y = ProductSpecificationSubModule.this.layoutTitleBar(y, parent.getWidth());
            ProductSpecificationSubModule.this.variants.setLocation(0, y + 10);
            ProductSpecificationSubModule.this.variants.setSize(650, (int)ProductSpecificationSubModule.this.variants.getPreferredSize().getHeight());
            ProductSpecificationSubModule.this.dueDate.setLocation(ProductSpecificationSubModule.this.variants.getX() + ProductSpecificationSubModule.this.variants.getWidth() + 10, ProductSpecificationSubModule.this.variants.getY());
            ProductSpecificationSubModule.this.dueDate.setSize(ProductSpecificationSubModule.this.dueDate.getPreferredSize());
            ProductSpecificationSubModule.this.breadPanel.setLocation(0, ProductSpecificationSubModule.this.variants.getY() + ProductSpecificationSubModule.this.variants.getHeight() + 10);
            ProductSpecificationSubModule.this.breadPanel.setSize(parent.getWidth(), parent.getHeight() - ProductSpecificationSubModule.this.breadPanel.getY());
            if (ProductSpecificationSubModule.this.animationPanel != null) {
                ProductSpecificationSubModule.this.animationPanel.setSize(ProductSpecificationSubModule.this.animationPanel.getPreferredSize());
                ProductSpecificationSubModule.this.animationPanel.setLocation(ProductSpecificationSubModule.this.breadPanel.getX() + (ProductSpecificationSubModule.this.breadPanel.getWidth() - ProductSpecificationSubModule.this.animationPanel.getWidth()) / 2, ProductSpecificationSubModule.this.breadPanel.getY() + (ProductSpecificationSubModule.this.breadPanel.getHeight() - ProductSpecificationSubModule.this.animationPanel.getHeight()) / 2);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }

    public static enum LoadingState {
        SAVE_AND_BACK,
        SAVE,
        LOADING,
        NONE;

    }
}

