/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils;

import ch.icit.pegasus.client.converter.ProductComponentGroupConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.ProductModuleDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.ProductBreadCrumbPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.searcher.searchfieldimpls.ProductVariantSearchFieldRemoteSearchAlgorithm;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AddGroupPopupInsert
extends PopUpInsert
implements SearchTextField2Listener,
RemoteLoader,
Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> searchField;
    private Table2 table;
    private TextLabel errorText;
    private Node<?> resultNode;
    private ProductModuleDataHandler dataHandler;
    private LoadingAnimation animation;

    public AddGroupPopupInsert(ProductModuleDataHandler dataHandler, ProductBreadCrumbPanel panel) {
        this.dataHandler = dataHandler;
        this.resultNode = new Node();
        this.searchField = new TitledItem<SearchTextField2<ProductVariantLight>>(SearchTextField2Factory.getProductVariantSearchField(false, new DTOProxyNode()), Words.BASE_PRODUCT, TitledItem.TitledItemOrientation.NORTH);
        ((ProductVariantSearchFieldRemoteSearchAlgorithm)this.searchField.getElement().getSearchAlgorithm()).setSearchTender(null);
        this.searchField.getElement().addSearchTextFieldListener(this);
        Object[] o = new Object[]{null};
        this.searchField.getElement().setAdditionalSearchField(o);
        this.table = new Table2(false, "", true, true, Words.GROUPS);
        this.table.setType(3);
        this.table.setTableBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImps(model)));
        this.table.getModel().addTableSelectionListener(this);
        this.errorText = new TextLabel("* Select a Product Variant");
        this.setLayout(new Layout());
        this.searchField.setProgress(1.0f);
        this.add(this.searchField);
        this.add(this.errorText);
        this.add(this.table);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.searchField.kill();
        this.table.kill();
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
        this.errorText.kill();
        this.errorText = null;
        this.searchField = null;
        this.table = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.searchField);
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[3];
        if (this.resultNode != null && this.table.getModel().getSelectedNode() != null) {
            o[0] = this.resultNode;
            o[1] = this.table.getModel().getSelectedNode();
            return o;
        }
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.searchField != null && this.searchField.getElement().isInnerComponent(c);
    }

    @Override
    public boolean tryToGrabFocus() {
        if (this.searchField != null) {
            this.searchField.getElement().getTextField().requestFocusInWindow();
        }
        return true;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
        this.showAnimation();
        this.dataHandler.createGroup(n, this, this.animation);
    }

    private void showAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.getFader().setPermanent(true);
            this.add((Component)this.animation, 0);
            this.animation.start();
            this.validate();
        }
        if (this.animation.getFader() != null) {
            this.animation.fadeIn();
        }
        this.setEnabled(false);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(false);
            this.animation.stop();
        }
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.searchField != null) {
            this.searchField.setEnabled(isEnabled);
            this.table.setEnabled(isEnabled);
            this.errorText.setEnabled(isEnabled);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.hideAnimation();
        this.resultNode = node;
        if (this.table != null && this.table.getModel() != null) {
            this.table.getModel().setNode(node);
            if (this.table.getModel().getNode().getChildCount() == 0) {
                this.errorText.setText("* Variant don't have any Groups");
            } else {
                this.errorText.setText("* Select Group to copy");
            }
            this.popup.setOkButtonText(Words.COPY);
            this.popup.enableOKButton(false);
        }
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel == null) {
            this.popup.enableOKButton(false);
        } else {
            this.popup.enableOKButton(true);
        }
    }

    private class TableRowImps
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel name;

        public TableRowImps(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ProductComponentGroupConverter.class));
            this.setLayout(new InnerLayout());
            this.add(this.name);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.name.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.name = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                TableRowImps.this.name.setLocation(TableRowImps.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImps.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImps.this.name.setSize(parent.getWidth() - 2 * TableRowImps.this.getCellPadding(), (int)TableRowImps.this.name.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, AddGroupPopupInsert.this.table.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (AddGroupPopupInsert.this.searchField == null) {
                return;
            }
            AddGroupPopupInsert.this.searchField.setLocation(0, 0);
            AddGroupPopupInsert.this.searchField.setSize(parent.getWidth(), (int)AddGroupPopupInsert.this.searchField.getPreferredSize().getHeight());
            AddGroupPopupInsert.this.errorText.setLocation(0, AddGroupPopupInsert.this.searchField.getY() + AddGroupPopupInsert.this.searchField.getHeight() + 10);
            AddGroupPopupInsert.this.errorText.setSize(parent.getWidth(), (int)AddGroupPopupInsert.this.errorText.getPreferredSize().getHeight());
            AddGroupPopupInsert.this.table.setLocation(0, AddGroupPopupInsert.this.errorText.getY() + AddGroupPopupInsert.this.errorText.getHeight() + 10);
            AddGroupPopupInsert.this.table.setSize(parent.getWidth(), parent.getHeight() - AddGroupPopupInsert.this.table.getY());
            if (AddGroupPopupInsert.this.animation != null) {
                AddGroupPopupInsert.this.animation.setSize(AddGroupPopupInsert.this.animation.getPreferredSize());
                AddGroupPopupInsert.this.animation.setLocation((parent.getWidth() - AddGroupPopupInsert.this.animation.getWidth()) / 2, (parent.getHeight() - AddGroupPopupInsert.this.animation.getHeight()) / 2);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }
}

