/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

public class GroupLoader
implements RemoteLoader,
LoadingGroup {
    protected ArrayList<ReloadablePriceView> firstGroup;
    private ArrayList<ReloadablePriceView> supTotals;
    protected ReloadablePriceView firstTotal;
    protected PriorityBlockingQueue<ReloadablePriceView> loadingQueue;
    protected static final int TYPE_GROUP_ONE = 3;
    protected static final int TYPE_SUBTOTAL = 4;
    protected static final int TYPE_TOTAL_ONE = 5;
    private boolean isRunning = false;
    private Component c;

    public GroupLoader(Component c) {
        this.c = c;
        this.firstGroup = new ArrayList();
        this.supTotals = new ArrayList();
        this.loadingQueue = new PriorityBlockingQueue<ReloadablePriceView>(10, new ReloadablePriceComparator());
    }

    public void setFirstTotal(ReloadablePriceView ft) {
        this.firstTotal = ft;
    }

    public void addFirstGroupMember(ReloadablePriceView rpv) {
        this.firstGroup.add(rpv);
    }

    public void remoteFirstGroupMember(ReloadablePriceView rpv) {
        this.firstGroup.remove(rpv);
    }

    public void addSubTotal(ReloadablePriceView rpv) {
        this.supTotals.add(rpv);
    }

    public void removeSubTotal(ReloadablePriceView rpv) {
        this.supTotals.remove(rpv);
    }

    @Override
    public void updateMe(ReloadablePriceView rpv) {
        int type = this.getType(rpv);
        switch (type) {
            case 3: {
                this.startStartONE(true, rpv);
                break;
            }
            case 5: {
                this.startStartONE(true, rpv);
                break;
            }
        }
    }

    private void startStartONE(boolean withall, ReloadablePriceView rpv) {
        if (withall) {
            this.loadingQueue.add(rpv);
            for (ReloadablePriceView r : (ArrayList)this.supTotals.clone()) {
                this.loadingQueue.add(r);
            }
            this.firstTotal.load(false);
            this.loadingQueue.add(this.firstTotal);
        } else {
            this.loadingQueue.add(rpv);
        }
        this.runMe();
    }

    protected int getType(ReloadablePriceView rpv) {
        if (rpv == this.firstTotal) {
            return 5;
        }
        if (this.firstGroup.contains(rpv)) {
            return 3;
        }
        if (this.supTotals.contains(rpv)) {
            return 4;
        }
        return -1;
    }

    protected void runMe() {
        if (this.isRunning) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                while (!GroupLoader.this.loadingQueue.isEmpty()) {
                    ReloadablePriceView r = GroupLoader.this.loadingQueue.poll();
                    CalculationRunnable runing = r.getCurrentRunnable();
                    if (!runing.isAlive()) continue;
                    runing.run();
                    r.loaded();
                }
                GroupLoader.this.isRunning = false;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return GroupLoader.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        this.isRunning = true;
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), this.c);
    }

    public void removeFirstGroupMember(ReloadablePriceView costView) {
        this.firstGroup.remove(costView);
    }

    private class ReloadablePriceComparator
    implements Comparator<ReloadablePriceView> {
        private ReloadablePriceComparator() {
        }

        @Override
        public int compare(ReloadablePriceView o1, ReloadablePriceView o2) {
            Integer t1 = GroupLoader.this.getType(o1);
            Integer t2 = GroupLoader.this.getType(o2);
            return t1.compareTo(t2);
        }
    }
}

