/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.BreadCrumbPriceConverter;
import ch.icit.pegasus.client.converter.ColumnTotalConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter3Decimals;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.product.ProductModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.product.details.utils.ProductComponentIconMapper;
import ch.icit.pegasus.client.gui.modules.recipe.details.utils.ArticleUnitsSorter;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.ProductBreadCrumbPanel;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.ProductSpecificationSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.ComponentOptionsPopupInsert;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.ProductNavigatorConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.SkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.icons.DefaultIconComponent_NEW;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.PriceToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.RecipeScreenToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.DTOUtilException;
import ch.icit.pegasus.server.core.dtos.utils.ProductPriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.ProductRecipeAmountCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.RecipeProductConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.recipe.RecipeCalculationToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductBreadCrumbComponentTable
extends BreadCrumbComponentTable {
    private static final Logger log = LoggerFactory.getLogger(ProductBreadCrumbComponentTable.class);
    private static final long serialVersionUID = 1L;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    private UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
    private boolean isClosed;
    private boolean autoUpdateBrutto;

    public ProductBreadCrumbComponentTable(IDataHandler dataHandler, BreadCrumbPanel master, GroupLoader loader, String buttonText, Node node, RDProvider provider) {
        super(dataHandler, master, loader, buttonText, provider, node);
    }

    @Override
    public boolean hasAddButton() {
        return !this.isClosed;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        Node n = node.getParent().getParent().getParent();
        while (n.getChildNamed(new String[]{"state"}) == null) {
            n = n.getParent().getParent();
        }
        this.isClosed = !this.getProductMaster().canEditSpecification();
        boolean bl = this.autoUpdateBrutto = n.getChildNamed(new String[]{"state"}).getValue() == ModificationStateE.ACCEPTED;
        if (this.isClosed) {
            this.showAddButton(false);
        } else {
            this.showAddButton(true);
        }
        if (node.getParent() != null && node.getParent().getValue() instanceof CompoundComponentComplete) {
            Object[] o = new Object[]{node.getParent().getValue()};
            this.totalCompPrice.getTextLabel().setViewConverterAttributes(o);
        }
        for (Table2RowPanel p : this.table.getRows()) {
            ComponentRow r = (ComponentRow)p;
            r.updateValue();
        }
        this.setEnabled(true);
    }

    public ProductBreadCrumbPanel getProductMaster() {
        return (ProductBreadCrumbPanel)this.master;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    @Override
    public void setTotalCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                if (ProductBreadCrumbComponentTable.this.getProductMaster().getScreen().getCurrentState() != ProductSpecificationSubModule.LoadingState.NONE) {
                    return;
                }
                try {
                    PriceComplete price = new PriceComplete();
                    price.setPrice(Double.valueOf(0.0));
                    if (ProductBreadCrumbComponentTable.this.table != null) {
                        List rows = (List)((ArrayList)ProductBreadCrumbComponentTable.this.table.getRows()).clone();
                        for (Table2RowPanel p : rows) {
                            PriceComplete ppp;
                            ComponentRow pp = (ComponentRow)p;
                            if (pp == null || pp.getPrice() == null || (ppp = pp.getPrice()) == null) continue;
                            price.setPrice(Double.valueOf(price.getPrice() + ppp.getPrice()));
                        }
                    }
                    if (ProductBreadCrumbComponentTable.this.totalCompPrice != null) {
                        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        if (price.getCurrency() == null) {
                            price.setCurrency(settings.getCurrency());
                        }
                        price.setPrice(PriceToolkit.ensureDoubleFinite((Double)price.getPrice()));
                        Node pn = ProductBreadCrumbComponentTable.this.totalCompPrice.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            ProductBreadCrumbComponentTable.this.totalCompPrice.setNode(pn);
                        }
                        pn.setValue((Object)price, 0L);
                    }
                }
                catch (Exception e) {
                    log.error("Error while calculates costs", (Throwable)e);
                }
            }

            @Override
            public boolean isAlive() {
                try {
                    if (ProductBreadCrumbComponentTable.this.totalCompPrice == null) {
                        return false;
                    }
                    return !ProductBreadCrumbComponentTable.this.totalCompPrice.isKilled();
                }
                catch (Exception e) {
                    log.error("Error while calculates costs", (Throwable)e);
                    return false;
                }
            }
        };
        this.totalCompPrice.setRunnable(run);
    }

    @Override
    public Table2RowPanel getComponentTableRow(Table2RowModel model, boolean isHeader) {
        ComponentRow p = new ComponentRow(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.FOUR);
        return p;
    }

    @Override
    public void addButtonPressed(int x, int y) {
        SystemSettingsComplete setttings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SimpleComponentComplete dto = new SimpleComponentComplete();
        dto.setClientOId(Long.valueOf(ADTO.getNextId()));
        LinearQuantityInterpolationComplete linQuant = new LinearQuantityInterpolationComplete();
        QuantityComplete quant = new QuantityComplete();
        quant.setClientOId(Long.valueOf(quant.getNextId()));
        quant.setQuantity(Double.valueOf(0.0));
        linQuant.setResultingQuantity(quant);
        dto.setNumber(Integer.valueOf(this.table.getModel().getNode().getChildCount() + 1));
        UnitComplete unit = ((UnitSystemComplete)NodeToolkit.getAffixList(UnitSystemComplete.class).getChildAt(0).getValue()).getBaseUnit();
        quant.setUnit(unit);
        dto.setQuantity((QuantityInterpolationComplete)linQuant);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, true, false);
        this.table.setRequestFocusOnAdd(true);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.table.setRequestFocusEnabled(false);
        this.table.validate();
    }

    @Override
    public void childRemoved() {
        this.master.recalucalteTotalPrice(true);
        this.table.validate();
    }

    public ArrayList<TableColumnInfo> getColumns(Node node) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dw = 4 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 3 * this.table.getCellPadding() + 2 * this.table.getInnerCellPadding();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
        int tw = CheckBox.getPreferredWidth() + this.table.getInnerCellPadding() + InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) + 2 * this.table.getCellPadding();
        String name = "NET";
        if (node != null) {
            tw = 2 * InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) + CheckBox.getPreferredWidth() + 2 * this.table.getCellPadding() + 2 * this.table.getInnerCellPadding();
            tw -= this.table.getInnerCellPadding();
            tw += this.table.getCellPadding();
            name = "GROSS - NET";
        }
        columns.add(new TableColumnInfo(name, null, null, null, "", tw, tw, tw));
        tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_LONG);
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", tw + 5, tw + 5, tw + 5));
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    @Override
    public Converter getTotalConverter() {
        return ConverterRegistry.getConverter(ColumnTotalConverter.class);
    }

    public Converter getTitleConverter() {
        return ConverterRegistry.getConverter(ProductNavigatorConverter.class);
    }

    public static QuantityComplete resolveSteps(Stack<ProductComponentComplete> toplevel, ProductComponentComplete comp) {
        QuantityComplete currentQuant = null;
        ProductComponentComplete current = null;
        while (!toplevel.isEmpty()) {
            ProductComponentComplete c = toplevel.pop();
            if (current == null) {
                current = c;
                LinearQuantityInterpolationComplete quant = (LinearQuantityInterpolationComplete)c.getQuantity();
                currentQuant = quant.getResultingQuantity();
                continue;
            }
            StepQuantityInterpolationComplete stepQuant = (StepQuantityInterpolationComplete)c.getQuantity();
            try {
                currentQuant = RecipeCalculationToolkit.resolveStep((List)stepQuant.getSteps(), (QuantityComplete)currentQuant);
            }
            catch (DTOUtilException e) {
                e.printStackTrace();
            }
            current = c;
        }
        return currentQuant;
    }

    private class ComponentRow
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener,
    RemoteLoader,
    NodeListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private SearchTextField2 nameField;
        private final InfoButton infoButton;
        private DefaultIconComponent_NEW typeicon;
        private InputComboBox nettoBox;
        private CheckBox autoCalculateBrutto;
        private InputComboBox bruttoBox;
        private ReloadablePriceView costView;
        private SkinButton_NEW fixPrice;
        private ArrowButton upButton;
        private ArrowButton downButton;
        private final ConfigButton configButton;
        private DeleteButton deleteButton;
        private boolean isArticle;

        public ComponentRow(Table2RowModel m) {
            CompoundComponentComplete s;
            super(m);
            this.number = new TextLabel(m.getNode().getChildNamed(new String[]{"number"}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.fixPrice = new SkinButton_NEW(DefaultSkins.LockIcon);
            this.fixPrice.addButtonListener(this);
            this.infoButton = new InfoButton();
            this.infoButton.removeButtonListener(this.infoButton);
            this.infoButton.addButtonListener(this);
            this.number.setProgress(1.0f);
            this.deleteButton = new DeleteButton();
            this.deleteButton.setProgress(1.0f);
            this.deleteButton.addButtonListener(this);
            this.upButton = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Up);
            this.downButton = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Down);
            this.upButton.setProgress(1.0f);
            this.downButton.setProgress(1.0f);
            this.upButton.addButtonListener(this);
            this.downButton.addButtonListener(this);
            this.configButton = new ConfigButton(SizedSkin1Field.SkinSize.SMALL);
            this.configButton.setProgress(1.0f);
            this.configButton.addButtonListener(this);
            this.costView = new ReloadablePriceView((LoadingGroup)ProductBreadCrumbComponentTable.this.loader, BreadCrumbPriceConverter.class);
            this.setLayout(new TableRowLayout());
            this.setCalcAlgorithm();
            this.updateComponents();
            if (this.nettoBox != null) {
                this.nettoBox.setProgress(1.0f);
            }
            if (this.bruttoBox != null) {
                this.bruttoBox.setProgress(1.0f);
            }
            if (this.typeicon != null) {
                this.typeicon.setProgress(1.0f);
            }
            ProductBreadCrumbComponentTable.this.loader.addFirstGroupMember(this.costView);
            this.add(this.infoButton);
            this.add(this.costView);
            this.add(this.upButton);
            this.add(this.downButton);
            this.add(this.deleteButton);
            this.add(this.configButton);
            this.add(this.number);
            this.add(this.fixPrice);
            ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().addNodeListener((NodeListener)this);
            if (((ADTO)m.getNode().getValue()).getId() != null) {
                Node n = m.getNode();
                if (n.getValue() instanceof SimpleComponentComplete) {
                    this.updateUnitList(n.getChildNamed(new String[]{"article"}));
                } else {
                    this.updateUnitList(n.getChildNamed(new String[]{"recipe"}));
                }
                this.costView.load(true);
            } else if (m.getNode().getValue() instanceof SimpleComponentComplete) {
                SimpleComponentComplete s2 = (SimpleComponentComplete)m.getNode().getValue();
                if (s2.getArticle() != null) {
                    this.updateUnitList(m.getNode().getChildNamed(new String[]{"article"}));
                    this.costView.load(true);
                }
            } else if (m.getNode().getValue() instanceof CompoundComponentComplete && (s = (CompoundComponentComplete)m.getNode().getValue()).getUnderlyingRecipe() != null) {
                this.updateUnitList(m.getNode().getChildNamed(new String[]{"recipe"}));
                this.costView.load(true);
            }
        }

        public void updateValue() {
            this.costView.load(true);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    if (this.number == null) break;
                    return this.number.getText();
                }
                case 1: {
                    if (this.nameField == null) break;
                    return this.nameField.getText();
                }
                case 3: {
                    if (this.costView == null || this.costView.getTextLabel() == null) break;
                    return this.costView.getTextLabel().getText();
                }
            }
            return null;
        }

        public PriceComplete getPrice() {
            try {
                if (this.getModel() != null && this.getModel().getNode() != null && this.getModel().getNode().getChildNamed(new String[]{"cPrice"}) != null) {
                    return (PriceComplete)this.getModel().getNode().getChildNamed(new String[]{"cPrice"}).getValue();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public Component getFocusDelegationComponent() {
            if (this.nameField != null) {
                return this.nameField.getTextField();
            }
            return null;
        }

        @Override
        public void updateRowOrder() {
            this.ensureArrowButtonState();
        }

        private void ensureArrowButtonState() {
            try {
                if (this.model != null && this.model.getNode() != null) {
                    int index = (Integer)this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                    int max = this.model.getNode().getParent().getChildCount();
                    boolean up = true;
                    boolean down = true;
                    if (index == 1) {
                        up = false;
                    }
                    if (index == max) {
                        down = false;
                    }
                    boolean isClosed = ProductBreadCrumbComponentTable.this.isClosed;
                    this.upButton.setEnabled(up && !isClosed);
                    this.downButton.setEnabled(down && !isClosed);
                }
            }
            catch (Exception e) {
                log.error("Error while ensure arrow buttons", (Throwable)e);
            }
        }

        private void moveUp() {
            if (this.model != null && this.model.getNode() != null) {
                int i = (Integer)this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                if (i > ProductBreadCrumbComponentTable.this.table.getRowCount()) {
                    i = ProductBreadCrumbComponentTable.this.table.getRowCount();
                }
                if (i == 1) {
                    return;
                }
                int index = i - 1;
                int oppositeIndex = index - 1;
                ComponentRow p = (ComponentRow)this.model.getParentModel().getTable().getRowAt(oppositeIndex);
                int i2 = 0;
                i2 = p.getModel().getNode().getChildNamed(new String[]{"number"}).getValue() != null ? (Integer)p.getModel().getNode().getChildNamed(new String[]{"number"}).getValue() : i;
                long id = System.currentTimeMillis();
                this.model.getNode().getChildNamed(new String[]{"number"}).setValue((Object)(--i), id);
                p.getModel().getNode().getChildNamed(new String[]{"number"}).setValue((Object)(++i2), id);
                this.model.getParentModel().getTable().updateOrder();
                this.model.getParentModel().getTable().relayoutRequested();
            }
        }

        private void moveDown() {
            if (this.model != null && this.model.getNode() != null) {
                int i = (Integer)this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                int max = this.model.getParentModel().getTable().getRowCount();
                if (i > ProductBreadCrumbComponentTable.this.table.getRowCount()) {
                    i = ProductBreadCrumbComponentTable.this.table.getRowCount();
                }
                if (i == max) {
                    return;
                }
                int index = i - 1;
                int oppositeIndex = index + 1;
                ComponentRow p = (ComponentRow)this.model.getParentModel().getTable().getRowAt(oppositeIndex);
                int i2 = 0;
                i2 = p.getModel().getNode().getChildNamed(new String[]{"number"}).getValue() == null ? (Integer)p.getModel().getNode().getChildNamed(new String[]{"number"}).getValue() : i;
                long id = System.currentTimeMillis();
                this.model.getNode().getChildNamed(new String[]{"number"}).setValue((Object)(++i), id);
                p.getModel().getNode().getChildNamed(new String[]{"number"}).setValue((Object)(--i2), id);
                this.model.getParentModel().getTable().updateOrder();
                this.model.getParentModel().getTable().relayoutRequested();
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.nameField != null) {
                this.nameField.requestFocusInWindowNow();
            }
        }

        private void updateComponents() {
            Node np;
            if (this.getModel() == null || this.getModel().getNode() == null || this.getModel().getNode().getValue() == null) {
                return;
            }
            this.isArticle = !(this.getModel().getNode().getValue() instanceof CompoundComponentComplete);
            boolean isItemSet = false;
            if (this.nameField == null) {
                this.nameField = SearchTextField2Factory.getIngredientSearchField(false, new DTOProxyNode());
                this.nameField.setIconMapperClass(ProductComponentIconMapper.class);
                this.nameField.addSearchTextFieldListener(this);
                Object[] additionalFields = new Object[]{ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate()};
                this.nameField.setAdditionalSearchField(additionalFields);
                this.nameField.setSelectiveDelegation(this);
                this.add(this.nameField);
            }
            if ((np = this.getModel().getNode().getChildNamed(new String[]{"cPrice"})) == null) {
                np = new EmbeddedDTONode();
                np.setName("cPrice");
                this.getModel().getNode().addChild(np, System.currentTimeMillis());
            }
            if (this.costView != null) {
                this.costView.setNode(np);
            }
            boolean isTopLevel = false;
            Node nettoQuantity = null;
            Node bruttoQuantity = null;
            nettoQuantity = this.getModel().getNode().getChildNamed(new String[]{"nettoQuantity"});
            bruttoQuantity = this.getModel().getNode().getChildNamed(new String[]{"quantity"});
            if (this.isArticle || this.model.getNode().getParent().getParent().getValue() instanceof CompoundComponentComplete) {
                isTopLevel = false;
            }
            if (this.isArticle) {
                Node aNode = this.getModel().getNode().getChildNamed(new String[]{"article"});
                if (aNode != null && this.nameField != null) {
                    this.nameField.getNode().setValue(aNode.getValue(), 0L);
                }
                if (this.fixPrice != null) {
                    if (this.model.getNode().getChildNamed(ProductComponentComplete_.acceptedPrice).getValue() != null && this.model.getNode().getChildNamed(new DtoField[]{ProductComponentComplete_.acceptedPrice, PriceComplete_.currency}).getValue() != null) {
                        this.fixPrice.setVisible(true);
                    } else {
                        this.fixPrice.setVisible(false);
                    }
                }
                if (this.typeicon == null) {
                    this.typeicon = new DefaultIconComponent_NEW(DefaultSkins.ArticleIcon);
                    this.add(this.typeicon);
                } else {
                    this.typeicon.setSkinClass(DefaultSkins.ArticleIcon);
                }
                if (nettoQuantity != null && nettoQuantity.getValue() instanceof LinearQuantityInterpolationComplete) {
                    Node amountNode = nettoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"});
                    Node unitNode = nettoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"});
                    if (this.nettoBox == null) {
                        this.nettoBox = new InputComboBox(amountNode, unitNode, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                        this.nettoBox.setDefaultSorter(ComparatorRegistry.getComparator(ArticleUnitsSorter.class));
                        this.add((Component)this.nettoBox, 0);
                    } else {
                        this.nettoBox.setNode(amountNode, unitNode);
                    }
                    if (this.nettoBox.getDefaultSorter() == null) {
                        this.nettoBox.setDefaultSorter(ComparatorRegistry.getComparator(ArticleUnitsSorter.class));
                    }
                    if (aNode != null && aNode.getValue(BasicArticleComplete.class) != null) {
                        isItemSet = true;
                    }
                    this.configButton.setEnabled(isItemSet);
                    this.infoButton.setEnabled(isItemSet);
                    this.nettoBox.setEnabled(isItemSet);
                    amountNode = bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"});
                    unitNode = bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"});
                    if (this.bruttoBox == null) {
                        this.bruttoBox = new InputComboBox(amountNode, unitNode, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                        this.bruttoBox.setDefaultSorter(ComparatorRegistry.getComparator(ArticleUnitsSorter.class));
                        this.add((Component)this.bruttoBox, 0);
                    } else {
                        this.bruttoBox.setNode(amountNode, unitNode);
                    }
                    if (this.bruttoBox.getDefaultSorter() == null) {
                        this.bruttoBox.setDefaultSorter(ComparatorRegistry.getComparator(ArticleUnitsSorter.class));
                    }
                    if (this.autoCalculateBrutto == null) {
                        this.autoCalculateBrutto = new CheckBox();
                        this.autoCalculateBrutto.addButtonListener(this);
                        this.add(this.autoCalculateBrutto);
                    }
                    this.autoCalculateBrutto.setNode(this.getModel().getNode().getChildNamed(new String[]{"autoCalculateBrutto"}));
                    boolean b = isItemSet && (Boolean)this.getModel().getNode().getChildNamed(new String[]{"autoCalculateBrutto"}).getValue() != false;
                    this.bruttoBox.setEnabled(b);
                    if (isItemSet) {
                        this.ensureListenerState(false);
                        this.setSelectable(false);
                        ((ArticleUnitsSorter)((Object)this.bruttoBox.getDefaultSorter())).setArticle((BasicArticleComplete)aNode.getValue(BasicArticleComplete.class));
                        this.bruttoBox.setDefaultSorterUserObject(aNode);
                        this.bruttoBox.setProgress(1.0f);
                        ((ArticleUnitsSorter)((Object)this.nettoBox.getDefaultSorter())).setArticle((BasicArticleComplete)aNode.getValue(BasicArticleComplete.class));
                        this.nettoBox.setDefaultSorterUserObject(aNode);
                        this.nettoBox.setProgress(1.0f);
                    }
                } else {
                    if (aNode != null && aNode.getValue(BasicArticleComplete.class) != null) {
                        isItemSet = true;
                    }
                    this.configButton.setEnabled(isItemSet);
                    if (this.nettoBox != null) {
                        this.nettoBox.setEnabled(isItemSet);
                    }
                    this.infoButton.setEnabled(isItemSet);
                    if (isItemSet) {
                        this.setSelectable(false);
                        if (this.nettoBox != null) {
                            this.nettoBox.setProgress(0.0f);
                            this.nettoBox.setEnabled(false);
                        }
                    }
                    if (this.bruttoBox != null) {
                        this.bruttoBox.setEnabled(isItemSet);
                    }
                    if (isItemSet) {
                        this.setSelectable(false);
                        if (this.bruttoBox != null) {
                            this.bruttoBox.setProgress(0.0f);
                            this.bruttoBox.setEnabled(false);
                        }
                    }
                }
            } else {
                Node aNode = this.getModel().getNode().getChildNamed(CompoundComponentComplete_.recipe);
                if (aNode.getValue() != null) {
                    isItemSet = true;
                }
                if (this.model.getNode().getChildNamed(ProductComponentComplete_.acceptedPrice).getValue() != null && this.model.getNode().getChildNamed(new DtoField[]{ProductComponentComplete_.acceptedPrice, PriceComplete_.currency}).getValue() != null) {
                    if (this.fixPrice != null) {
                        this.fixPrice.setVisible(true);
                    }
                } else if (this.fixPrice != null) {
                    this.fixPrice.setVisible(false);
                }
                this.nameField.getNode().setValue((Object)((RecipeComplete)aNode.getValue()).getCurrentVariant(), 0L);
                DefaultSkins skinClazz = null;
                skinClazz = isItemSet ? (Boolean.TRUE.equals(((RecipeComplete)aNode.getValue()).getServiceItem()) ? DefaultSkins.ServiceItemIcon : DefaultSkins.RecipeIcon) : DefaultSkins.RecipeIcon;
                if (this.typeicon == null) {
                    this.typeicon = new DefaultIconComponent_NEW(skinClazz);
                    this.add(this.typeicon);
                } else {
                    this.typeicon.setSkinClass(skinClazz);
                }
                if (nettoQuantity != null && nettoQuantity.getValue() instanceof LinearQuantityInterpolationComplete) {
                    Node amountNode = nettoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"});
                    Node unitNode = nettoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"});
                    if (this.nettoBox == null) {
                        this.nettoBox = new InputComboBox(amountNode, unitNode, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                        this.add((Component)this.nettoBox, 0);
                    } else {
                        this.nettoBox.setNode(amountNode, unitNode);
                    }
                    this.nettoBox.setEnabled(isItemSet);
                    this.configButton.setEnabled(isItemSet);
                    this.infoButton.setEnabled(isItemSet);
                    amountNode = bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"});
                    unitNode = bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"});
                    if (this.bruttoBox == null) {
                        this.bruttoBox = new InputComboBox(amountNode, unitNode, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                        this.bruttoBox.setDefaultSorter(ComparatorRegistry.getComparator(ArticleUnitsSorter.class));
                        this.add((Component)this.bruttoBox, 0);
                    } else {
                        this.bruttoBox.setNode(amountNode, unitNode);
                    }
                    if (this.bruttoBox.getDefaultSorter() == null) {
                        this.bruttoBox.setDefaultSorter(ComparatorRegistry.getComparator(ArticleUnitsSorter.class));
                    }
                    if (this.autoCalculateBrutto == null) {
                        this.autoCalculateBrutto = new CheckBox();
                        this.autoCalculateBrutto.addButtonListener(this);
                        this.add(this.autoCalculateBrutto);
                    }
                    this.autoCalculateBrutto.setNode(this.getModel().getNode().getChildNamed(new String[]{"autoCalculateBrutto"}));
                    boolean b = isItemSet && (Boolean)this.getModel().getNode().getChildNamed(new String[]{"autoCalculateBrutto"}).getValue() != false;
                    this.bruttoBox.setEnabled(b);
                    if (isItemSet) {
                        this.bruttoBox.setProgress(1.0f);
                        this.ensureListenerState(false);
                        this.nettoBox.setProgress(1.0f);
                    } else {
                        this.setSelectable(false);
                    }
                } else {
                    if (this.nettoBox != null) {
                        this.nettoBox.setEnabled(isItemSet);
                    }
                    this.configButton.setEnabled(isItemSet);
                    this.infoButton.setEnabled(isItemSet);
                    if (isItemSet) {
                        if (this.nettoBox != null) {
                            this.nettoBox.setProgress(0.0f);
                        }
                    } else {
                        this.setSelectable(false);
                    }
                    this.setSelectable(false);
                }
            }
            if (!this.isKilled()) {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.nameField);
            if (this.bruttoBox != null && this.bruttoBox.isEnabled()) {
                CheckedListAdder.addToList(a, this.bruttoBox);
            }
            if (this.nettoBox != null && this.nettoBox.isEnabled()) {
                CheckedListAdder.addToList(a, this.nettoBox);
            }
            if (this.upButton.isEnabled()) {
                CheckedListAdder.addToList(a, this.upButton);
            }
            if (this.downButton.isEnabled()) {
                CheckedListAdder.addToList(a, this.downButton);
            }
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            Node n = this.model.getNode();
            boolean isClosed = ProductBreadCrumbComponentTable.this.isClosed;
            this.fixPrice.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            if (this.nameField != null) {
                this.nameField.setEnabled(isEnabled && !isClosed);
            }
            this.typeicon.setEnabled(isEnabled);
            if (this.nettoBox != null) {
                this.nettoBox.setEnabled(isEnabled && !isClosed);
            }
            boolean b = true;
            if (this.model.getNode().getChildNamed(new String[]{"autoCalculateBrutto"}) != null) {
                if (this.model.getNode().getChildNamed(new String[]{"autoCalculateBrutto"}).getValue() == null) {
                    this.model.getNode().getChildNamed(new String[]{"autoCalculateBrutto"}).setValue((Object)true, 0L);
                }
                b = (Boolean)this.model.getNode().getChildNamed(new String[]{"autoCalculateBrutto"}).getValue();
            }
            if (this.bruttoBox != null) {
                this.bruttoBox.setEnabled(isEnabled && !isClosed && !b);
            }
            if (this.autoCalculateBrutto != null) {
                boolean access = ProductBreadCrumbComponentTable.this.provider.isWritable("canEditCookingWaste");
                this.autoCalculateBrutto.setEnabled(isEnabled && !isClosed && access);
            }
            this.deleteButton.setEnabled(isEnabled && !isClosed);
            this.costView.setEnabled(isEnabled);
            if (!isEnabled) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                this.ensureArrowButtonState();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            ProductBreadCrumbComponentTable.this.loader.removeFirstGroupMember(this.costView);
            ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().removeNodeListener((NodeListener)this);
            this.fixPrice.kill();
            this.number.kill();
            if (this.nameField != null) {
                this.nameField.kill();
            }
            this.typeicon.kill();
            if (this.nettoBox != null) {
                this.nettoBox.kill();
            }
            if (this.bruttoBox != null) {
                this.bruttoBox.kill();
            }
            this.upButton.kill();
            this.downButton.kill();
            this.deleteButton.kill();
            this.costView.kill();
            this.fixPrice = null;
            this.number = null;
            this.nameField = null;
            this.typeicon = null;
            this.nettoBox = null;
            this.bruttoBox = null;
            this.upButton = null;
            this.downButton = null;
            this.deleteButton = null;
            this.costView = null;
            super.kill();
        }

        private String getRowName() {
            if (this.model.getNode().getValue() instanceof SimpleComponentComplete) {
                return (String)this.model.getNode().getChildNamed(new String[]{"article-name"}).getValue();
            }
            return (String)this.model.getNode().getChildNamed(new String[]{"recipe-currentVariant-name"}).getValue();
        }

        private void ensureNumber() {
            ProductBreadCrumbComponentTable.this.writeNumbers();
        }

        private void ensureListenerState(boolean fromCheckboxToggle) {
            Node bruttoQuantity = this.getModel().getNode().getChildNamed(new String[]{"quantity"});
            Node nettoQuantity = this.getModel().getNode().getChildNamed(new String[]{"nettoQuantity"});
            if (this.autoCalculateBrutto != null) {
                if (this.autoCalculateBrutto.isChecked()) {
                    if (this.bruttoBox != null) {
                        bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"}).removeNodeListener((NodeListener)this);
                        bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"}).removeNodeListener((NodeListener)this);
                    }
                    nettoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"}).addNodeListener((NodeListener)this);
                    nettoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"}).addNodeListener((NodeListener)this);
                } else {
                    if (this.bruttoBox != null) {
                        bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"}).addNodeListener((NodeListener)this);
                        bruttoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"}).addNodeListener((NodeListener)this);
                    }
                    nettoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"}).removeNodeListener((NodeListener)this);
                    nettoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"}).removeNodeListener((NodeListener)this);
                }
            } else {
                nettoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"}).removeNodeListener((NodeListener)this);
                nettoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"}).removeNodeListener((NodeListener)this);
                nettoQuantity.getChildNamed(new String[]{"resultingQuantity-quantity"}).addNodeListener((NodeListener)this);
                nettoQuantity.getChildNamed(new String[]{"resultingQuantity-unit"}).addNodeListener((NodeListener)this);
            }
            if (fromCheckboxToggle) {
                this.costView.load(true);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
                ProductBreadCrumbComponentTable.this.writeNumbers();
                ProductBreadCrumbComponentTable.this.totalCompPrice.load(true);
            } else if (source == this.fixPrice) {
                String t = "<b>Fixed material Price</b><br/>";
                Double price = (Double)this.getModel().getNode().getChildNamed(new DtoField[]{ProductComponentComplete_.acceptedPrice, PriceComplete_.price}).getValue();
                CurrencyComplete currency = (CurrencyComplete)this.getModel().getNode().getChildNamed(new DtoField[]{ProductComponentComplete_.acceptedPrice, PriceComplete_.currency}).getValue();
                if (price == null || currency == null) {
                    t = t + "No fix price saved";
                } else {
                    Converter dc = ConverterRegistry.getConverter(FormattedDoubleConverter3Decimals.class);
                    t = t + (String)dc.convert((Object)price, null, new Object[0]);
                    t = t + " " + currency.getCode();
                }
                t = t + "<br/><br/>";
                String info = (String)this.getModel().getNode().getChildNamed(ProductComponentComplete_.acceptedInfo).getValue();
                if (info == null || info.equals("")) {
                    info = "Details not set";
                }
                t = t + "<b>Price Details</b><br/>";
                t = t + info + "<br/><br/>";
                Converter timeConverter = ConverterRegistry.getConverter(DateTimeConverter.class);
                ProductVariantComplete variant = (ProductVariantComplete)ProductBreadCrumbComponentTable.this.getProductMaster().getNode().getValue(ProductVariantComplete.class);
                t = t + "<b>Accept Time</b><br/>";
                t = variant.getAcceptTime() != null ? t + timeConverter.convert((Object)variant.getAcceptTime(), null, new Object[0]) + "<br/><br/>" : t + "Time not set<br/><br/>";
                t = t + "<b>Accept User</b><br/>";
                t = variant.getAcceptUser() != null ? t + variant.getAcceptUser().getContact().getFirstName() + " " + variant.getAcceptUser().getContact().getLastName() + "" : t + "User not set";
                InnerPopupFactory.showMessageDialog(t, "Tender Price", (Component)this);
            } else if (source == this.autoCalculateBrutto) {
                this.setEnabled(this.isEnabled());
                this.ensureListenerState(true);
            } else if (source == this.downButton) {
                this.ensureNumber();
                this.moveDown();
                this.ensureNumber();
            } else if (source == this.upButton) {
                this.ensureNumber();
                this.moveUp();
            } else if (source == this.configButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.configButton, false, false, Words.OPTIONS_FOR + " " + this.getRowName());
                popUp.hideCancelButton();
                boolean canEditSpecification = ProductBreadCrumbComponentTable.this.getProductMaster().canEditSpecification();
                popUp.setView(new ComponentOptionsPopupInsert(ProductBreadCrumbComponentTable.this.provider, (Node<ProductComponentComplete>)this.model.getNode(), (Node<QuantityComplete>)this.model.getNode().getChildNamed(new DtoField[]{ProductComponentComplete_.nettoQuantity, LinearQuantityInterpolationComplete_.resultingQuantity}), (java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue(), !canEditSpecification));
                popUp.showPopUp(x, y, 700, -1, this, this.configButton, PopupType.NORMAL);
                ((ComponentOptionsPopupInsert)popUp.getView()).revalidate();
                ((ComponentOptionsPopupInsert)popUp.getView()).invalidate();
                ((ComponentOptionsPopupInsert)popUp.getView()).validate();
            } else if (source == this.infoButton) {
                CustomerLight customer = ((ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue()).getProduct().getCustomer();
                boolean useTender = ((ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue()).getTenderVariant();
                Node node = this.getModel().getNode().getValue() instanceof SimpleComponentComplete ? this.getModel().getNode().getChildNamed(SimpleComponentComplete_.article) : this.getModel().getNode().getChildNamed(CompoundComponentComplete_.recipe);
                Node componentNode = this.getModel().getNode();
                this.createInfoPopupString(node, componentNode, customer, useTender);
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
            if (this.isKilled()) {
                return;
            }
            ProductBreadCrumbComponentTable.this.master.commitNode();
            if (node.getValue() != null) {
                this.costView.load(true);
            }
            if (ProductBreadCrumbComponentTable.this.parentTableRow != null && ProductBreadCrumbComponentTable.this.parentTableRow instanceof ComponentRow) {
                ComponentRow r = (ComponentRow)ProductBreadCrumbComponentTable.this.parentTableRow;
                r.updateCosts();
            }
            if (this.isArticle) {
                this.updateUnitList(this.model.getNode().getChildNamed(SimpleComponentComplete_.article));
            }
        }

        private void updateCosts() {
            if (this.isKilled()) {
                return;
            }
            ProductBreadCrumbComponentTable.this.master.commitNode();
            this.costView.load(true);
            if (ProductBreadCrumbComponentTable.this.parentTableRow != null && ProductBreadCrumbComponentTable.this.parentTableRow instanceof ComponentRow) {
                ComponentRow r = (ComponentRow)ProductBreadCrumbComponentTable.this.parentTableRow;
                r.updateCosts();
            }
        }

        private void setCalcAlgorithm() {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    block42: {
                        if (ProductBreadCrumbComponentTable.this.getProductMaster().getScreen().getCurrentState() != ProductSpecificationSubModule.LoadingState.NONE) {
                            return;
                        }
                        try {
                            if (ComponentRow.this.model.getNode().getValue() == null || ProductBreadCrumbComponentTable.this.settings == null) break block42;
                            PriceComplete p = null;
                            ProductVariantLight variantLight = (ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue();
                            CustomerLight customer = variantLight.getProduct().getCustomer();
                            boolean useTender = variantLight.getTenderVariant();
                            Timestamp validityDate = ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp();
                            if (ComponentRow.this.model.getNode().getValue() instanceof SimpleComponentComplete) {
                                if (((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getArticle() != null && ((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity() != null) {
                                    if (((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity() instanceof LinearQuantityInterpolationComplete) {
                                        LinearQuantityInterpolationComplete l = (LinearQuantityInterpolationComplete)((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity();
                                        ModificationStateE state = (ModificationStateE)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getChildNamed(new String[]{"state"}).getValue();
                                        BasicArticleComplete art = ((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getArticle();
                                        if (!ProductBreadCrumbComponentTable.this.autoUpdateBrutto && ComponentRow.this.autoCalculateBrutto != null && ComponentRow.this.autoCalculateBrutto.isChecked()) {
                                            double cookingWaste = ProductPriceCalculationToolkit.getCookingWaste((SimpleComponentComplete)((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()), (ModificationStateE)state, (CustomerReference)((CustomerReference)ProductBreadCrumbComponentTable.this.master.getNode().getChildNamed(new String[]{"product-customer"}).getValue()), (boolean)useTender);
                                            double nb = l.getResultingQuantity().getQuantity() / ((100.0 - cookingWaste) / 100.0);
                                            if (ComponentRow.this.bruttoBox != null) {
                                                ComponentRow.this.bruttoBox.getValueNode().setValue((Object)nb, 0L);
                                                ComponentRow.this.bruttoBox.getUnitNode().setValue((Object)l.getResultingQuantity().getUnit(), 0L);
                                            }
                                        }
                                        ComponentRow.this.model.getNode().commit();
                                        SimpleComponentComplete scc = (SimpleComponentComplete)ComponentRow.this.model.getNode().getValue();
                                        l = (LinearQuantityInterpolationComplete)scc.getQuantity();
                                        if (variantLight.getState() == ModificationStateE.ACCEPTED) {
                                            p = new PriceComplete(scc.getAcceptedPrice());
                                        }
                                        if (p == null) {
                                            p = ArticlePriceCalculationToolkit.getBruttoForQuantity((BasicArticleComplete)((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getArticle(), (QuantityComplete)l.getResultingQuantity(), null, null, (boolean)true, (boolean)true, (CustomerReference)customer, (Timestamp)validityDate, (boolean)useTender);
                                        }
                                    } else {
                                        Node aP = ComponentRow.this.model.getNode().getParent().getParent();
                                        Stack<ProductComponentComplete> parents = new Stack<ProductComponentComplete>();
                                        boolean found = false;
                                        while (aP != null && !found) {
                                            parents.push((ProductComponentComplete)aP.getValue());
                                            if (aP.getValue() instanceof CompoundComponentComplete && ((ProductComponentComplete)aP.getValue()).getQuantity() instanceof LinearQuantityInterpolationComplete) {
                                                found = true;
                                                continue;
                                            }
                                            aP = aP.getParent().getParent();
                                        }
                                        SimpleComponentComplete scc = (SimpleComponentComplete)ComponentRow.this.model.getNode().getValue();
                                        if (variantLight.getState() == ModificationStateE.ACCEPTED) {
                                            p = new PriceComplete(scc.getAcceptedPrice());
                                        }
                                        if (p == null) {
                                            try {
                                                QuantityComplete q = ProductRecipeAmountCalculationToolkit.resolveSteps(parents, (ProductComponentComplete)((ProductComponentComplete)ComponentRow.this.model.getNode().getValue()));
                                                p = ArticlePriceCalculationToolkit.getBruttoForQuantity((BasicArticleComplete)((SimpleComponentComplete)ComponentRow.this.model.getNode().getValue()).getArticle(), (QuantityComplete)q, null, null, (boolean)true, (boolean)true, (CustomerReference)customer, (Timestamp)validityDate, (boolean)useTender);
                                            }
                                            catch (DTOUtilException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            } else if (ComponentRow.this.model.getNode().getValue() instanceof CompoundComponentComplete) {
                                ModificationStateE state = (ModificationStateE)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getChildNamed(new String[]{"state"}).getValue();
                                if (((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getUnderlyingRecipe() != null && ((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity() != null) {
                                    ComponentRow.this.model.getNode().commit(CompoundComponentComplete.class);
                                    if (((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity() instanceof LinearQuantityInterpolationComplete) {
                                        LinearQuantityInterpolationComplete l = (LinearQuantityInterpolationComplete)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity();
                                        if (!ProductBreadCrumbComponentTable.this.autoUpdateBrutto && ComponentRow.this.autoCalculateBrutto != null && ComponentRow.this.autoCalculateBrutto.isChecked()) {
                                            l = (LinearQuantityInterpolationComplete)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getNettoQuantity();
                                            double cookingWaste = 0.0;
                                            cookingWaste = useTender ? ArticlePriceCalculationToolkit.getRecipeGroupTenderCookingWaste((RecipeVariantLight)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getRecipe().getCurrentVariant(), (java.sql.Date)((java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue())) : ArticlePriceCalculationToolkit.getRecipeGroupProductiveCookingWaste((RecipeVariantLight)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getRecipe().getCurrentVariant(), (java.sql.Date)((java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue()));
                                            double nb = l.getResultingQuantity().getQuantity() / ((100.0 - cookingWaste) / 100.0);
                                            if (ComponentRow.this.bruttoBox != null) {
                                                ComponentRow.this.bruttoBox.getValueNode().setValue((Object)nb, 0L);
                                                ComponentRow.this.bruttoBox.getUnitNode().setValue((Object)l.getResultingQuantity().getUnit(), 0L);
                                            }
                                        }
                                        ComponentRow.this.model.getNode().commit();
                                        l = (LinearQuantityInterpolationComplete)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getQuantity();
                                        Object q = null;
                                        Timestamp ts = ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp();
                                        RecipeVariantComplete recipe = (RecipeVariantComplete)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor().loadData((Object)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getUnderlyingRecipe(), ts);
                                        PriceComplete rp = RecipeCalculationToolkit.getPrice((RecipeVariantComplete)recipe, (QuantityComplete)l.getResultingQuantity(), (CurrencyComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), (CurrencyVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getCurrencyAccessor(), (RecipeVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor(), (Timestamp)validityDate, (CustomerReference)customer, (boolean)useTender);
                                        if (rp == null) {
                                            rp = new PriceComplete(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), Double.valueOf(0.0));
                                        }
                                        if (rp.getPrice() == null) {
                                            rp.setPrice(Double.valueOf(0.0));
                                        }
                                        if (rp.getCurrency() == null) {
                                            rp.setCurrency(ProductBreadCrumbComponentTable.this.settings.getCurrency());
                                        }
                                        CompoundComponentComplete scc = (CompoundComponentComplete)ComponentRow.this.model.getNode().getValue();
                                        if (variantLight.getState() == ModificationStateE.ACCEPTED) {
                                            p = new PriceComplete(scc.getAcceptedPrice());
                                        }
                                        if (p == null) {
                                            p = new PriceComplete(rp);
                                        }
                                    } else {
                                        Node aP = ComponentRow.this.model.getNode().getParent().getParent();
                                        Stack<ProductComponentComplete> parents = new Stack<ProductComponentComplete>();
                                        boolean found = false;
                                        while (aP != null && !found) {
                                            parents.push((ProductComponentComplete)aP.getValue());
                                            if (aP.getValue() instanceof CompoundComponentComplete && ((ProductComponentComplete)aP.getValue()).getQuantity() instanceof LinearQuantityInterpolationComplete) {
                                                found = true;
                                                continue;
                                            }
                                            aP = aP.getParent().getParent();
                                        }
                                        CompoundComponentComplete scc = (CompoundComponentComplete)ComponentRow.this.model.getNode().getValue();
                                        if (variantLight.getState() == ModificationStateE.ACCEPTED) {
                                            p = new PriceComplete(scc.getAcceptedPrice());
                                        }
                                        if (p == null) {
                                            try {
                                                QuantityComplete q = ProductRecipeAmountCalculationToolkit.resolveSteps(parents, (ProductComponentComplete)((ProductComponentComplete)ComponentRow.this.model.getNode().getValue()));
                                                CurrencyComplete cur = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency();
                                                RecipeVariantComplete variant = (RecipeVariantComplete)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor().loadData((Object)((CompoundComponentComplete)ComponentRow.this.model.getNode().getValue()).getUnderlyingRecipe(), ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp());
                                                p = RecipeCalculationToolkit.getPrice((RecipeVariantComplete)variant, (QuantityComplete)q, (CurrencyComplete)cur, (CurrencyVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getCurrencyAccessor(), (RecipeVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor(), (Timestamp)ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp(), (CustomerReference)customer, (boolean)useTender);
                                            }
                                            catch (DTOUtilException e1) {
                                                e1.printStackTrace();
                                            }
                                        }
                                    }
                                } else {
                                    try {
                                        p = ProductPriceCalculationToolkit.getProductMaterialPrice((ProductVariantComplete)((ProductVariantComplete)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue(ProductVariantComplete.class)), (int)1, (ModificationStateE)state, (SystemSettingsComplete)ProductBreadCrumbComponentTable.this.settings, (Timestamp)validityDate, (RecipeVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor(), (CurrencyVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getCurrencyAccessor());
                                    }
                                    catch (DTOUtilException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (p != null) {
                                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                                if (!settings.getCurrency().equals((Object)p.getCurrency())) {
                                    CurrencyVariantComplete cu = (CurrencyVariantComplete)ProductBreadCrumbComponentTable.this.getProductMaster().getCurrencyAccessor().loadData((Object)p.getCurrency(), ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp());
                                    p.setPrice(Double.valueOf(p.getPrice() * cu.getExchangeRate()));
                                    p.setCurrency(settings.getCurrency());
                                }
                                p.setPrice(PriceToolkit.ensureDoubleFinite((Double)p.getPrice()));
                                if (ComponentRow.this.costView != null) {
                                    Node pn = ComponentRow.this.costView.getNode();
                                    if (pn == null) {
                                        pn = new EmbeddedDTONode();
                                        pn.setName("compPrice");
                                        ComponentRow.this.costView.setNode(pn);
                                    }
                                    pn.setValue(p, 0L);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public boolean isAlive() {
                    if (ComponentRow.this.costView != null) {
                        return !ComponentRow.this.costView.isKilled();
                    }
                    return false;
                }
            };
            this.costView.setRunnable(run);
        }

        private void createComponent(Node node) throws Exception {
            int cNumber = (Integer)this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            UnitComplete stUnit = settings.getPieceUnit();
            UnitComplete kgUnit = settings.getDefaultCustomsPenaltyUnit();
            CustomerLight customer = ((ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue()).getProduct().getCustomer();
            boolean useTender = ((ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue()).getTenderVariant();
            if (node.getValue(BasicArticleComplete.class) != null) {
                if (this.typeicon != null) {
                    this.typeicon.setSkinClass(DefaultSkins.ArticleIcon);
                }
                SimpleComponentComplete newArticle = (SimpleComponentComplete)RecipeProductConversionToolkit.convertToProductComponent((BasicArticleComplete)((BasicArticleComplete)node.getValue(BasicArticleComplete.class)), null, null, (UnitComplete)stUnit, (UnitComplete)kgUnit, (Timestamp)new Timestamp(System.currentTimeMillis()), (CustomerReference)customer, (boolean)useTender);
                newArticle.setNumber(Integer.valueOf(cNumber));
                this.model.getNode().removeExistingValues();
                this.model.getNode().removeAllChilds();
                this.model.getNode().setValue((Object)newArticle, 0L);
                this.model.getNode().updateNode();
            } else if (node.getValue(RecipeVariantLight.class) != null) {
                RecipeVariantLight variant = (RecipeVariantLight)node.getValue(RecipeVariantLight.class);
                if (this.typeicon != null) {
                    if (Boolean.TRUE.equals(variant.getServiceItem())) {
                        this.typeicon.setSkinClass(DefaultSkins.ServiceItemIcon);
                    } else {
                        this.typeicon.setSkinClass(DefaultSkins.RecipeIcon);
                    }
                }
                CompoundComponentComplete newRecipe = (CompoundComponentComplete)RecipeProductConversionToolkit.convertToProductComponent((RecipeVariantComplete)((RecipeVariantComplete)node.getValue(RecipeVariantComplete.class)), null, null, (Timestamp)ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp(), (RecipeVariantAccessor)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor(), (UnitComplete)stUnit, (UnitComplete)kgUnit, (CustomerReference)customer, (boolean)useTender);
                newRecipe.setNumber(Integer.valueOf(cNumber));
                this.model.getNode().removeExistingValues();
                this.model.getNode().removeAllChilds();
                this.model.getNode().setValue((Object)newRecipe, 0L);
                this.model.getNode().updateNode();
            }
        }

        private void updateUnitList(Node node) {
            if (node.getValue() instanceof BasicArticleLight) {
                this.typeicon.setSkinClass(DefaultSkins.ArticleIcon);
                BasicArticleComplete artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
                List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)new Timestamp(((java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue()).getTime()), (TransactionType)TransactionType.IN_PRODUCT, (UserComplete)ProductBreadCrumbComponentTable.this.currentUser, null, null, (SystemSettingsComplete)ProductBreadCrumbComponentTable.this.settings);
                if (this.nettoBox != null) {
                    this.nettoBox.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                }
                if (this.bruttoBox != null) {
                    this.bruttoBox.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                }
                CustomerLight customer = ((ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue(ProductVariantLight.class)).getProduct().getCustomer();
                boolean useTender = ((ProductVariantLight)ProductBreadCrumbComponentTable.this.master.getCommitingNode().getValue(ProductVariantLight.class)).getTenderVariant();
                if (this.costView != null) {
                    this.costView.fadeIn();
                }
            } else if (node.getValue() instanceof RecipeComplete) {
                RecipeComplete pc = (RecipeComplete)node.getValue();
                if (Boolean.TRUE.equals(pc.getServiceItem())) {
                    this.typeicon.setSkinClass(DefaultSkins.ServiceItemIcon);
                } else {
                    this.typeicon.setSkinClass(DefaultSkins.RecipeIcon);
                }
                List units = UnitConversionToolkit.getPossibleUnits((RecipeVariantLight)((RecipeComplete)node.getValue(RecipeComplete.class)).getCurrentVariant());
                if (this.nettoBox != null) {
                    this.nettoBox.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                }
                if (this.bruttoBox != null) {
                    this.bruttoBox.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                }
                if (this.costView != null) {
                    this.costView.fadeIn();
                }
            } else if (node.getValue() instanceof RecipeVariantLight) {
                RecipeVariantLight variant = (RecipeVariantLight)node.getValue();
                if (Boolean.TRUE.equals(variant.getRecipe().getServiceItem())) {
                    this.typeicon.setSkinClass(DefaultSkins.ServiceItemIcon);
                } else {
                    this.typeicon.setSkinClass(DefaultSkins.RecipeIcon);
                }
                List units = UnitConversionToolkit.getPossibleUnits((RecipeVariantLight)((RecipeVariantLight)node.getValue(RecipeVariantLight.class)));
                if (this.nettoBox != null) {
                    this.nettoBox.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                }
                if (this.bruttoBox != null) {
                    this.bruttoBox.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                }
                if (this.costView != null) {
                    this.costView.fadeIn();
                }
            }
        }

        public void createInfoPopupString(Node node, Node componentNode, CustomerLight customer, boolean useTender) {
            if (node.getValue() instanceof BasicArticleLight) {
                String t = ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)node.getValue(BasicArticleComplete.class), ProductBreadCrumbComponentTable.this.getProductMaster().getTimestamp(), 69069);
                if (componentNode != null) {
                    PriceComplete cp = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)((BasicArticleLight)componentNode.getChildNamed(SimpleComponentComplete_.article).getValue()), (Date)((Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue()), (CustomerReference)customer, (boolean)useTender);
                    UnitComplete cu = (UnitComplete)componentNode.getChildNamed(new DtoField[]{SimpleComponentComplete_.article, BasicArticleLight_.priceUnit}).getValue();
                    if (cp != null && cu != null) {
                        Converter cpc = ConverterRegistry.getConverter(PriceConverter2.class);
                        Converter cuc = ConverterRegistry.getConverter(UnitConverter.class);
                        String tt = "<b>Standard Price</b><ul><li>" + cpc.convert((Object)cp, null, new Object[0]) + " / " + cuc.convert((Object)cu, null, new Object[0]);
                        tt = tt + "</li></ul>";
                        t = t + tt;
                    }
                }
                this.infoButton.installStringViewer(t);
            } else if (node.getValue() instanceof RecipeComplete) {
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                RecipeComplete r = (RecipeComplete)node.getValue(RecipeComplete.class);
                RecipeVariantLight rv = r.getCurrentVariant();
                try {
                    rv = (RecipeVariantLight)ProductBreadCrumbComponentTable.this.getProductMaster().getVariantAccessor().loadData((Object)r, new Timestamp(((java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue()).getTime()));
                }
                catch (Exception e) {
                    rv = r.getCurrentVariant();
                }
                this.infoButton.installStringViewer(RecipeScreenToolkit.getRecipeInfoString(rv, s.getCurrency(), (java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue(), RecipeScreenToolkit.getAllTypes()));
            } else if (node.getValue() instanceof RecipeVariantLight) {
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                this.infoButton.installStringViewer(RecipeScreenToolkit.getRecipeInfoString((RecipeVariantLight)node.getValue(RecipeVariantLight.class), s.getCurrency(), (java.sql.Date)ProductBreadCrumbComponentTable.this.getProductMaster().getDueDate().getValue(), RecipeScreenToolkit.getAllTypes()));
            }
            this.infoButton.buttonPressed(this.infoButton, 0, 0);
        }

        @Override
        public void remoteObjectLoaded(Node<?> node) {
            if (this.isKilled()) {
                return;
            }
            try {
                this.createComponent(node);
            }
            catch (Exception e) {
                e.printStackTrace();
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
            this.updateComponents();
            this.updateUnitList(node);
            this.invalidate();
            this.validate();
            this.getModel().getParentModel().recreateFocusCycle();
        }

        @Override
        public void errorOccurred(ClientException exception) {
            ProductBreadCrumbComponentTable.this.errorOccurred(exception);
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            ((ProductModuleDataHandler)ProductBreadCrumbComponentTable.this.dataHandler).reloadDataNow(n, this);
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TableRowLayout
        extends DefaultLayout {
            private TableRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = ComponentRow.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                ComponentRow.this.number.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.number.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.number.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = ComponentRow.this.model.getParentModel().getColumnWidth(1);
                ComponentRow.this.typeicon.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)((double)parent.getHeight() - ComponentRow.this.typeicon.getPreferredSize().getHeight()) / 2);
                ComponentRow.this.typeicon.setSize(ComponentRow.this.typeicon.getPreferredSize());
                int ux = ComponentRow.this.typeicon.getX() + ComponentRow.this.typeicon.getWidth() + ComponentRow.this.getInnerCellPadding();
                if (ComponentRow.this.nameField != null) {
                    ComponentRow.this.nameField.setLocation(ux, (int)(((double)parent.getHeight() - ComponentRow.this.nameField.getPreferredSize().getHeight()) / 2.0));
                    ComponentRow.this.nameField.setSize((int)((double)w - ((double)(2 * ComponentRow.this.getCellPadding()) + ComponentRow.this.typeicon.getPreferredSize().getWidth() + (double)ComponentRow.this.getInnerCellPadding() + 5.0 + ComponentRow.this.infoButton.getPreferredSize().getWidth())), (int)ComponentRow.this.nameField.getPreferredSize().getHeight());
                    ux = ComponentRow.this.nameField.getX() + ComponentRow.this.nameField.getWidth();
                }
                ComponentRow.this.infoButton.setLocation(ux + 5, (int)(((double)parent.getHeight() - ComponentRow.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.infoButton.setSize(ComponentRow.this.infoButton.getPreferredSize());
                currentX += w;
                w = ComponentRow.this.model.getParentModel().getColumnWidth(2);
                int cx = currentX + ComponentRow.this.getCellPadding();
                if (ComponentRow.this.bruttoBox != null && ComponentRow.this.autoCalculateBrutto != null) {
                    ComponentRow.this.autoCalculateBrutto.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.autoCalculateBrutto.getPreferredSize().getHeight()) / 2.0));
                    ComponentRow.this.autoCalculateBrutto.setSize(ComponentRow.this.autoCalculateBrutto.getPreferredSize());
                    ComponentRow.this.bruttoBox.setLocation(ComponentRow.this.autoCalculateBrutto.getX() + ComponentRow.this.autoCalculateBrutto.getWidth() + ComponentRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.bruttoBox.getPreferredSize().getHeight()) / 2.0));
                    ComponentRow.this.bruttoBox.setSize(InputComboBox.getPreferredWidth(ComponentRow.this.nettoBox, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), (int)ComponentRow.this.bruttoBox.getPreferredSize().getHeight());
                    cx = ComponentRow.this.bruttoBox.getX() + ComponentRow.this.bruttoBox.getWidth();
                    cx += ComponentRow.this.getCellPadding();
                } else if (ComponentRow.this.nettoBox != null) {
                    cx = (int)((double)(currentX + w) - (ComponentRow.this.nettoBox.getPreferredSize().getWidth() + (double)ComponentRow.this.getCellPadding()));
                }
                if (ComponentRow.this.nettoBox != null) {
                    ComponentRow.this.nettoBox.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.nettoBox.getPreferredSize().getHeight()) / 2.0));
                    ComponentRow.this.nettoBox.setSize(InputComboBox.getPreferredWidth(ComponentRow.this.nettoBox, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), (int)ComponentRow.this.nettoBox.getPreferredSize().getHeight());
                    cx = ComponentRow.this.nettoBox.getX() + ComponentRow.this.nettoBox.getWidth();
                    cx += ComponentRow.this.getCellPadding();
                }
                currentX += w;
                w = ComponentRow.this.model.getParentModel().getColumnWidth(3);
                ComponentRow.this.costView.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.costView.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.costView.setSize((int)((double)w - ((double)(2 * ComponentRow.this.getCellPadding() + ComponentRow.this.getInnerCellPadding()) + ComponentRow.this.fixPrice.getPreferredSize().getWidth())), (int)ComponentRow.this.costView.getPreferredSize().getHeight());
                ComponentRow.this.fixPrice.setLocation(ComponentRow.this.costView.getX() + ComponentRow.this.costView.getWidth() + ComponentRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.fixPrice.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.fixPrice.setSize(ComponentRow.this.fixPrice.getPreferredSize());
                currentX += w;
                w = ComponentRow.this.model.getParentModel().getColumnWidth(4);
                ComponentRow.this.setControlsX(currentX);
                ComponentRow.this.configButton.setLocation(currentX + ComponentRow.this.getCellPadding(), ComponentRow.this.deleteButton.getY());
                ComponentRow.this.configButton.setSize(ComponentRow.this.configButton.getPreferredSize());
                ComponentRow.this.upButton.setLocation(ComponentRow.this.configButton.getX() + ComponentRow.this.configButton.getWidth() + ComponentRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.upButton.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.upButton.setSize(ComponentRow.this.upButton.getPreferredSize());
                ComponentRow.this.downButton.setLocation(ComponentRow.this.upButton.getX() + ComponentRow.this.upButton.getWidth() + ComponentRow.this.getInnerCellPadding(), ComponentRow.this.upButton.getY());
                ComponentRow.this.downButton.setSize(ComponentRow.this.downButton.getPreferredSize());
                ComponentRow.this.deleteButton.setLocation(ComponentRow.this.downButton.getX() + ComponentRow.this.downButton.getWidth() + ComponentRow.this.getCellPadding(), ComponentRow.this.downButton.getY());
                ComponentRow.this.deleteButton.setSize(ComponentRow.this.deleteButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, ComponentRow.this.getDefaultRowHeight());
            }
        }
    }
}

