/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.purchase.receive;

import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IStoreQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.sql.Timestamp;

public class ReceiveToolkit {
    public static boolean isAmountOverflow(StoreQuantityComplete ordered, StoreQuantityComplete alreadyReceived, QuantityComplete receivedQt, SystemSettingsComplete settings, SupplierLight supplier, BasicArticleComplete article, Timestamp validity) {
        Double threshOverflow = settings.getReceiveThreshold();
        if (Boolean.TRUE.equals(supplier.getOverrideReceiveThreshold())) {
            threshOverflow = supplier.getReceiveThresholdOverFlow();
        }
        if (threshOverflow == null) {
            return true;
        }
        double ul = (double)ordered.getAmount().longValue() * (1.0 + threshOverflow / 100.0);
        double ll = ordered.getAmount().longValue();
        double received = UnitCalculator.convert((IBasicArticle)article, (IQuantity)receivedQt, (IUnit)ordered.getUnit(), (Timestamp)validity);
        return ReceiveToolkit.isInside(ul, ll, received += UnitCalculator.convert((IBasicArticle)article, (IStoreQuantity)alreadyReceived, (IUnit)ordered.getUnit(), (Timestamp)validity), true);
    }

    public static boolean isAmountUnderflow(StoreQuantityComplete ordered, StoreQuantityComplete alreadyReceived, QuantityComplete recieve, SystemSettingsComplete settings, SupplierLight supplier, BasicArticleComplete article, Timestamp validity) {
        Double threshUnderflow = settings.getReceiveThresholdUnderflow();
        if (Boolean.TRUE.equals(supplier.getOverrideReceiveThreshold())) {
            threshUnderflow = supplier.getReceiveThresholdUnderFlow();
        }
        if (threshUnderflow == null) {
            return true;
        }
        double ul = ordered.getAmount().longValue();
        double ll = (double)ordered.getAmount().longValue() * (1.0 - threshUnderflow / 100.0);
        double received = UnitCalculator.convert((IBasicArticle)article, (IQuantity)recieve, (IUnit)ordered.getUnit(), (Timestamp)validity);
        return ReceiveToolkit.isInside(ul, ll, received += UnitCalculator.convert((IBasicArticle)article, (IStoreQuantity)alreadyReceived, (IUnit)ordered.getUnit(), (Timestamp)validity), false);
    }

    private static boolean isInside(Double upperLimit, Double lowerLimit, Double value, boolean overflow) {
        if (overflow) {
            return upperLimit > value;
        }
        return lowerLimit < value;
    }
}

