/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.purchase.receive.tableui;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class StoreChangePopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> department;
    private TitledItem<SearchTextField2<StoreLight>> searchBox;
    private TitledItem<CheckBox> useCommentAsName;
    private TitledItem<TextField> comment;

    public StoreChangePopupInsert(Node<StoreLight> node) {
        this(node, null, null, null, false);
    }

    public StoreChangePopupInsert(Node<StoreLight> node, Node<InternalCostCenterComplete> departmentNode, Node<Boolean> useCommentAsNameNode, Node<String> commentNode, boolean showDepartment) {
        if (showDepartment) {
            this.department = new TitledItem<ComboBox>(new ComboBox(departmentNode, NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(DepartmentConverter.class), true, true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.searchBox = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, node), Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.searchBox.getElement().setNode((Node)node);
        if (useCommentAsNameNode != null) {
            this.useCommentAsName = new TitledItem<CheckBox>(new CheckBox(useCommentAsNameNode), Words.USE_COMMENT_AS_NAME, TitledItem.TitledItemOrientation.EAST);
            this.useCommentAsName.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        }
        if (commentNode != null) {
            this.comment = new TitledItem<TextField>(new TextField(commentNode), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setLayout(new Layout());
        this.add(this.searchBox);
        if (showDepartment) {
            this.add(this.department);
        }
        if (this.useCommentAsName != null) {
            this.add(this.useCommentAsName);
            this.add(this.comment);
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.searchBox.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.comment != null && this.useCommentAsName != null) {
            this.comment.setEnabled(this.useCommentAsName.getElement().isChecked() && enabled);
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.department != null) {
            return this.department.isInnerComponent(c);
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.searchBox.kill();
        this.searchBox = null;
        if (this.department != null) {
            this.department.kill();
            this.department = null;
        }
        if (this.useCommentAsName != null) {
            this.useCommentAsName.kill();
            this.useCommentAsName = null;
        }
        if (this.comment != null) {
            this.comment.kill();
            this.comment = null;
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)(StoreChangePopupInsert.this.searchBox.getPreferredSize().getHeight() + 20.0);
            if (StoreChangePopupInsert.this.department != null) {
                h = (int)((double)h + (StoreChangePopupInsert.this.department.getPreferredSize().getHeight() + 10.0));
            }
            if (StoreChangePopupInsert.this.useCommentAsName != null) {
                h = (int)((double)h + (StoreChangePopupInsert.this.useCommentAsName.getPreferredSize().getHeight() + 10.0));
            }
            if (StoreChangePopupInsert.this.comment != null) {
                h = (int)((double)h + (StoreChangePopupInsert.this.comment.getPreferredSize().getHeight() + 10.0));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            StoreChangePopupInsert.this.searchBox.setLocation(10, 10);
            StoreChangePopupInsert.this.searchBox.setSize(parent.getWidth() - 20, (int)StoreChangePopupInsert.this.searchBox.getPreferredSize().getHeight());
            int cy = StoreChangePopupInsert.this.searchBox.getY() + StoreChangePopupInsert.this.searchBox.getHeight() + 10;
            if (StoreChangePopupInsert.this.department != null) {
                StoreChangePopupInsert.this.department.setLocation(10, StoreChangePopupInsert.this.searchBox.getY() + StoreChangePopupInsert.this.searchBox.getHeight() + 10);
                StoreChangePopupInsert.this.department.setSize(parent.getWidth() - 20, (int)StoreChangePopupInsert.this.searchBox.getPreferredSize().getHeight());
                cy = StoreChangePopupInsert.this.department.getY() + StoreChangePopupInsert.this.department.getHeight() + 10;
            }
            if (StoreChangePopupInsert.this.useCommentAsName != null) {
                StoreChangePopupInsert.this.useCommentAsName.setLocation(10, cy);
                StoreChangePopupInsert.this.useCommentAsName.setSize(StoreChangePopupInsert.this.useCommentAsName.getPreferredSize());
                cy = StoreChangePopupInsert.this.useCommentAsName.getY() + StoreChangePopupInsert.this.useCommentAsName.getHeight() + 10;
            }
            if (StoreChangePopupInsert.this.comment != null) {
                StoreChangePopupInsert.this.comment.setLocation(10, cy);
                StoreChangePopupInsert.this.comment.setSize(parent.getWidth() - 20, (int)StoreChangePopupInsert.this.comment.getPreferredSize().getHeight());
            }
        }
    }
}

