/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.requisition.deliver.tableui.chargebased;

import ch.icit.pegasus.client.converter.ArticleChargeBatchConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.RequisitionPositionNameConverter;
import ch.icit.pegasus.client.gui.submodules.tool.requisition.deliver.tableui.chargebased.RequisitionDeliveryScreenCBSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.requisition.deliver.tableui.chargebased.StorePos_ArticleKey;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderStateRenderer;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.UnitSelectionUtil;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.SendMailButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.image.ImagePanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryWithBarcodeServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ARequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreEntryTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.BarcodeDevice;
import ch.icit.utils.BarcodeType;
import ch.icit.utils.reader.BarcodeHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class TableRowPanelImpl
extends Table2RowPanel
implements ButtonListener,
RemoteLoader,
ItemListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private final RDProvider provider;
    private CellViewOrderStateRenderer orderState;
    private TextLabel articleName;
    private QuantityRenderer orderAmount;
    private QuantityRenderer pendingAmount;
    private InputComboBox2 deliverAmount;
    private InfoButton artInfo;
    private SendMailButton sendMailButton;
    private ImagePanel imagePanel;
    private ComboBox allDelivered;
    private CheckBox isChecked;
    private TextLabel availableAmount;
    private ComboBox storeSearch;
    private ComboBox storePositionSearch;
    private ComboBox batchList;
    private BarcodeHandler storeHandler;
    private BarcodeHandler positionHandler;
    private BarcodeHandler batchHandler;
    private Button addRemoveButton;
    private boolean isFirst = true;
    private Node batches;
    private Map<StorePositionLight, StoreQuantityComplete> currentMap;
    private static final int STATE_LOAD_STORES = 3;
    private static final int STATE_LOAD_CHARGES = 5;
    private int currentState = 3;
    private boolean isUpdating;
    private RequisitionDeliveryScreenCBSubModule screen;
    private Node<UnitComplete> targetUnit;
    private SystemSettingsComplete settings;
    private UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();

    public TableRowPanelImpl(Table2RowModel m, final RequisitionDeliveryScreenCBSubModule screen, RDProvider provider) {
        super(m);
        this.provider = provider;
        this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        this.screen = screen;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (m.getNode() instanceof ProxyNode) {
            this.isFirst = false;
        }
        if (m.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState) != null) {
            m.getNode().removeChild(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState), 0L);
        }
        boolean a2 = true;
        BasicArticleComplete article = (BasicArticleComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        Node<QuantityComplete> pendingNode = this.getPendingView(m.getNode(), article, (RequisitionOrderPositionComplete)m.getNode().getValue(RequisitionOrderPositionComplete.class));
        if (m.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState).getValue().equals(OrderStateE.CLOSED)) {
            a2 = false;
        }
        StoreLight preferredStore = this.getPreferredStore(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article));
        if (this.isFirst) {
            this.addRemoveButton = new AddButton();
            this.orderState = new CellViewOrderStateRenderer((OrderStateE)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState).getValue());
            this.articleName = new TextLabel(m.getNode(), ConverterRegistry.getConverter(RequisitionPositionNameConverter.class));
            this.orderAmount = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.quantity));
            if (Boolean.TRUE.equals(this.settings.getShowImageOnRequisitionWorkTools())) {
                this.imagePanel = new ImagePanel();
                this.imagePanel.setFixSize(60);
                this.updateImage(preferredStore);
            }
            this.pendingAmount = new QuantityRenderer(pendingNode);
            this.sendMailButton = new SendMailButton();
            this.sendMailButton.addButtonListener((e, x, y) -> this.showMailingPopup(e, x, y));
        } else {
            this.addRemoveButton = new DeleteButton();
        }
        this.availableAmount = new TextLabel(null, ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
        Node store = this.model.getNode().getChildNamed(new String[]{"store"});
        if (store == null) {
            store = new DTOProxyNode();
            store.setName("store");
            this.model.getNode().addChild(store, 0L);
        }
        store.setValue((Object)preferredStore, 0L);
        this.storeSearch = new ComboBox(store, null, ConverterRegistry.getConverter(StoreViewConverter.class));
        this.storeSearch.addItemListener(this);
        this.storeHandler = new BarcodeHandler((barcodeType, barcode) -> this.selectStore(barcodeType, barcode), this.getCompanyCode(this.settings.getCompanyCode())){

            public BarcodeDevice getCurrentDevice() {
                return screen.getScannerType();
            }
        };
        this.storeHandler.registerInputListener((JComponent)this.storeSearch);
        DTOProxyNode storePositionN = new DTOProxyNode();
        this.storePositionSearch = new ComboBox((Node)storePositionN, null, ConverterRegistry.getConverter(StorePositionConverter.class));
        this.storePositionSearch.setEnabled(this.storeSearch.getNode().getValue() != null & a2);
        this.storePositionSearch.addItemListener(this);
        this.positionHandler = new BarcodeHandler((barcodeType, barcode) -> this.selectPosition(barcodeType, barcode), this.getCompanyCode(this.settings.getCompanyCode())){

            public BarcodeDevice getCurrentDevice() {
                return screen.getScannerType();
            }
        };
        this.positionHandler.registerInputListener((JComponent)this.storePositionSearch);
        DTOProxyNode chargeN = new DTOProxyNode();
        Converter n2n = ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class);
        Converter viewC = ConverterRegistry.getConverter(ArticleChargeBatchConverter.class);
        this.batches = new DTOProxyNode();
        if (screen.isChargeBased()) {
            this.batchList = new ComboBox((Node)chargeN, this.batches, n2n, n2n, viewC);
            this.batchList.setEnabled(this.storePositionSearch.getNode().getValue() != null & a2);
            this.batchList.setNode((Node)chargeN);
            this.batchList.addItemListener(this);
            this.batchHandler = new BarcodeHandler((barcodeType, barcode) -> this.selectBatch(barcodeType, barcode), this.getCompanyCode(this.settings.getCompanyCode())){

                public BarcodeDevice getCurrentDevice() {
                    return screen.getScannerType();
                }
            };
            this.batchHandler.registerInputListener((JComponent)this.batchList);
        }
        QuantityComplete q = new QuantityComplete();
        q.setQuantity((Double)pendingNode.getChildNamed(QuantityComplete_.quantity).getValue());
        q.setUnit((UnitComplete)pendingNode.getChildNamed(QuantityComplete_.unit).getValue());
        Node a = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
        a.setName("deliver");
        this.deliverAmount = new InputComboBox2(a.getChildNamed(QuantityComplete_.quantity), a.getChildNamed(QuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        List units = StoreToolkit.getPossibleUnits((BasicArticleLight)article, null, (Timestamp)this.getValidityDate(), (TransactionType)TransactionType.REQUISITION_DELIVER, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)settings);
        if (!units.contains(q.getUnit())) {
            units.add(q.getUnit());
        }
        this.deliverAmount.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
        a.getChildNamed(new String[]{"unit"}).addNodeListener((NodeListener)this);
        if (screen.isChargeBased()) {
            this.deliverAmount.setEnabled(this.batchList.getNode().getValue() != null & a2);
        } else {
            this.deliverAmount.setEnabled(this.storePositionSearch.getNode().getValue() != null & a2);
        }
        this.artInfo = new InfoButton("Info");
        this.isChecked = new CheckBox();
        this.isChecked.addButtonListener(this);
        this.allDelivered = new ComboBox();
        this.allDelivered.addItem(Words.ALL_DELIVERED);
        this.allDelivered.addItem(" ");
        this.selectAllDeliveredSelection();
        this.allDelivered.addItemListener(e -> this.ensureAllDeliveredSelection());
        this.allDelivered.setToolTipText(Words.ALL_DELIVERED);
        this.setLayout(new Layout());
        if (this.isFirst) {
            this.orderAmount.setProgress(1.0f);
            this.pendingAmount.setProgress(1.0f);
            this.sendMailButton.setProgress(1.0f);
        }
        this.artInfo.setProgress(1.0f);
        this.deliverAmount.setProgress(1.0f);
        this.storeSearch.setProgress(1.0f);
        this.storePositionSearch.setProgress(1.0f);
        if (screen.isChargeBased()) {
            this.batchList.setProgress(1.0f);
        }
        this.availableAmount.setProgress(1.0f);
        this.addRemoveButton.setProgress(1.0f);
        this.addRemoveButton.addButtonListener(this);
        this.changeUnit();
        this.setEnabled(false);
        this.loadStockForArticleAndStore((BasicArticleLight)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue());
        if (this.isFirst) {
            this.add(this.orderState);
            this.add(this.articleName);
            this.add(this.orderAmount);
            this.add(this.pendingAmount);
            this.add(this.sendMailButton);
            if (this.imagePanel != null) {
                this.add(this.imagePanel);
            }
        }
        this.add(this.artInfo);
        this.add(this.deliverAmount);
        this.add(this.storeSearch);
        this.add(this.storePositionSearch);
        if (screen.isChargeBased()) {
            this.add(this.batchList);
        }
        this.add(this.availableAmount);
        this.add(this.addRemoveButton);
        this.add(this.isChecked);
        this.add(this.allDelivered);
    }

    private String getCompanyCode(String companyCode) {
        return companyCode.replaceAll("0", "").trim();
    }

    private void selectBatch(final BarcodeType barcodeType, final String barcode) {
        this.setEnabled(false);
        this.batchHandler.resetBarcode();
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                String usedBarcode = barcode.toUpperCase();
                Node storeNode = (Node)TableRowPanelImpl.this.storeSearch.getSelectedItem();
                Node storePosNode = (Node)TableRowPanelImpl.this.storePositionSearch.getSelectedItem();
                StorePositionComplete posComp = (StorePositionComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStore((StorePositionLight)storePosNode.getValue()).getValue();
                StoreComplete storeComp = (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreByReference((StoreReference)storeNode.getValue()).getValue();
                storeNode.setValue((Object)storeComp, 0L);
                storePosNode.setValue((Object)posComp, 0L);
                ArticleChargeComplete charge = (ArticleChargeComplete)((InventoryWithBarcodeServiceManager)ServiceManagerRegistry.getService(InventoryWithBarcodeServiceManager.class)).getChargeForBarcode(barcodeType, usedBarcode, (StoreReference)storeNode.getValue(), (StorePositionLight)storePosNode.getValue()).getValue();
                if (charge == null) {
                    throw new IllegalStateException("Charge not found in given Store " + storeComp.getCode() + " " + posComp.getName());
                }
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)charge, false, true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TableRowPanelImpl.this.setEnabled(true);
                        ArticleChargeComplete charge = (ArticleChargeComplete)node.getValue();
                        Node storePosNode = (Node)TableRowPanelImpl.this.storePositionSearch.getSelectedItem();
                        for (ArticleChargeBatchComplete batchComplete : ((StorePositionComplete)storePosNode.getValue(StorePositionComplete.class)).getCharges()) {
                            if (!batchComplete.getCharge().equals((Object)charge)) continue;
                            TableRowPanelImpl.this.batchList.setSelectedItem(INodeCreator.getDefaultImpl().getNode4DTO((Object)batchComplete, true, false));
                        }
                        TableRowPanelImpl.this.isChecked.requestFocusInWindowNow();
                    }

                    public void errorOccurred(ClientException exception) {
                        TableRowPanelImpl.this.setEnabled(true);
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)TableRowPanelImpl.this);
                        TableRowPanelImpl.this.batchList.requestFocusInWindowNow();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void selectPosition(final BarcodeType barcodeType, final String barcode) {
        this.setEnabled(false);
        this.positionHandler.resetBarcode();
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                String usedBarcode = barcode.toUpperCase();
                StorePositionLight selectedPosition = (StorePositionLight)((InventoryWithBarcodeServiceManager)ServiceManagerRegistry.getService(InventoryWithBarcodeServiceManager.class)).getStorePositionForBarcode(barcodeType, usedBarcode).getValue();
                if (selectedPosition != null) {
                    StoreComplete store = (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreByReference(new StoreReference(selectedPosition.getStore().getId())).getValue();
                    for (StorePositionComplete position : store.getPositions()) {
                        if (!position.equals((Object)selectedPosition)) continue;
                        Node posNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)position, false, false);
                        Node storeNode = posNode.getChildNamed(StorePositionComplete_.store);
                        storeNode.setValue((Object)store, 0L);
                        return posNode;
                    }
                }
                throw new IllegalStateException("Position not found");
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TableRowPanelImpl.this.setEnabled(true);
                        StoreComplete storeComplete = (StoreComplete)node.getChildNamed(StorePositionComplete_.store).getValue(StoreComplete.class);
                        TableRowPanelImpl.this.storeSearch.setSelectedItem(INodeCreator.getDefaultImpl().getNode4DTO((Object)storeComplete, true, false));
                        TableRowPanelImpl.this.storePositionSearch.setSelectedItem(node);
                        if (TableRowPanelImpl.this.batchList != null) {
                            TableRowPanelImpl.this.batchList.requestFocusInWindowNow();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        TableRowPanelImpl.this.setEnabled(true);
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)TableRowPanelImpl.this);
                        TableRowPanelImpl.this.storePositionSearch.requestFocusInWindowNow();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void selectStore(final BarcodeType barcodeType, final String barcode) {
        this.setEnabled(false);
        this.storeHandler.resetBarcode();
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                String usedBarcode = barcode.toUpperCase();
                StoreComplete selectedStore = (StoreComplete)((InventoryWithBarcodeServiceManager)ServiceManagerRegistry.getService(InventoryWithBarcodeServiceManager.class)).getStoreForBarcode(barcodeType, usedBarcode).getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)selectedStore, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TableRowPanelImpl.this.setEnabled(true);
                        StoreComplete selectedStore = (StoreComplete)node.getValue();
                        StorePositionLight selectedPosition = selectedStore.getDefaultStorePosition();
                        TableRowPanelImpl.this.storeSearch.setSelectedItem(node);
                        TableRowPanelImpl.this.storePositionSearch.setSelectedItem(INodeCreator.getDefaultImpl().getNode4DTO((Object)selectedPosition, true, false));
                        TableRowPanelImpl.this.storePositionSearch.requestFocusInWindowNow();
                    }

                    public void errorOccurred(ClientException exception) {
                        TableRowPanelImpl.this.setEnabled(true);
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)TableRowPanelImpl.this);
                        TableRowPanelImpl.this.storeSearch.requestFocusInWindowNow();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showMailingPopup(Component source, int x, int y) {
        InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
        popUp.setAttributes(source, true, true, "Send Notification to Supervisor");
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)"", false, false);
        popUp.setView(new EnterMessagePopupInsert(node));
        InnerPopUpListener2 listener2 = (source1, xargs) -> {
            if (xargs == null) {
                return;
            }
            this.sendMessageToSupervisor((String)node.getValue());
        };
        popUp.showPopUp(x, y, 400, 400, listener2, source, PopupType.NORMAL);
    }

    private void sendMessageToSupervisor(final String value) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).sendMessageToSupervisor((RequisitionOrderPositionComplete)TableRowPanelImpl.this.model.getNode().getValue(), value);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessageDialog("Message sent", TableRowPanelImpl.this);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog("Unable to send Message", (Component)TableRowPanelImpl.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void stopDownload() {
        if (this.imagePanel != null) {
            this.imagePanel.setStopDownload(true);
        }
    }

    private void updateOrderConversionState() {
        if (this.orderAmount != null) {
            if (this.isUnitOrderConvertible()) {
                this.orderAmount.setValid();
            } else {
                this.orderAmount.setInvalid();
            }
        }
    }

    private boolean isUnitOrderConvertible() {
        return Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.orderUnitConversionValidity).getValue());
    }

    private void updateUnitsList() {
        BasicArticleComplete article = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        boolean loadChargeBased = this.screen.isChargeBased();
        if (loadChargeBased) {
            if (this.batchList.getSelectedItem() instanceof Node) {
                if (((ArticleChargeBatchComplete)((Node)this.batchList.getSelectedItem()).getValue()).getCharge() == null) {
                    loadChargeBased = false;
                }
            } else {
                loadChargeBased = false;
            }
        }
        if (loadChargeBased) {
            ArticleChargeComplete charge = ((ArticleChargeBatchComplete)((Node)this.batchList.getSelectedItem()).getValue()).getCharge();
            List unitList = StoreToolkit.getPossibleUnits((ArticleChargeComplete)charge, (TransactionType)TransactionType.REQUISITION_DELIVER, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
            Object value = this.deliverAmount.getUnitNode().getValue();
            if (value instanceof UnitComplete && !unitList.contains(value)) {
                unitList.add((UnitComplete)value);
            }
            this.deliverAmount.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(unitList));
        } else {
            Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
            List unitList = StoreToolkit.getPossibleUnits((BasicArticleLight)article, null, (Timestamp)new Timestamp(date.getTime()), (TransactionType)TransactionType.REQUISITION_DELIVER, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
            Object value = this.deliverAmount.getUnitNode().getValue();
            if (value instanceof UnitComplete && !unitList.contains(value)) {
                unitList.add((UnitComplete)value);
            }
            this.deliverAmount.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(unitList));
        }
    }

    private void changeUnit() {
        BasicArticleComplete articleComplete = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        this.targetUnit = this.deliverAmount.getUnitNode();
        if (this.pendingAmount != null && this.pendingAmount.getNode() != null) {
            this.updateQuantityNode(this.pendingAmount.getNode(), articleComplete, this.targetUnit);
        }
        if (this.orderAmount != null && this.orderAmount.getNode() != null) {
            this.updateQuantityNode(this.orderAmount.getNode(), articleComplete, this.targetUnit);
        }
        if (this.availableAmount != null && this.availableAmount.getNode() != null) {
            this.updateAvailableQuantityNode(this.availableAmount.getNode(), articleComplete, this.targetUnit);
        }
    }

    private void updateQuantityNode(Node qtyNode, BasicArticleComplete articleComplete, Node<UnitComplete> targetUnit) {
        Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
        Timestamp validity = new Timestamp(date.getTime());
        if (qtyNode.getValue() instanceof StoreQuantityComplete) {
            StoreQuantityComplete availableQty = (StoreQuantityComplete)qtyNode.getValue();
            double convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)availableQty.getUnit(), (UnitComplete)((UnitComplete)targetUnit.getValue()), (double)availableQty.getAmount().longValue(), (BasicArticleLight)articleComplete, (Timestamp)validity);
            QuantityComplete nq = new QuantityComplete(Double.valueOf(convertedAmount), (UnitComplete)targetUnit.getValue());
            qtyNode.setValue((Object)nq, 0L);
            qtyNode.updateNode();
        } else if (qtyNode.getValue() instanceof QuantityComplete) {
            QuantityComplete availableQty = (QuantityComplete)qtyNode.getValue();
            double convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)availableQty.getUnit(), (UnitComplete)((UnitComplete)targetUnit.getValue()), (double)availableQty.getQuantity(), (BasicArticleLight)articleComplete, (Timestamp)validity);
            QuantityComplete nq = new QuantityComplete(Double.valueOf(convertedAmount), (UnitComplete)targetUnit.getValue());
            qtyNode.setValue((Object)nq, 0L);
            qtyNode.updateNode();
        }
    }

    private void updateAvailableQuantityNode(Node qtyNode, BasicArticleComplete articleComplete, Node<UnitComplete> targetUnit) {
        Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
        Timestamp validity = new Timestamp(date.getTime());
        if (qtyNode.getValue() instanceof StoreQuantityComplete) {
            StoreQuantityComplete availableQty = (StoreQuantityComplete)qtyNode.getValue();
            double convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)availableQty.getUnit(), (UnitComplete)((UnitComplete)targetUnit.getValue()), (double)availableQty.getAmount().longValue(), (BasicArticleLight)articleComplete, (Timestamp)validity);
            QuantityComplete nq = new QuantityComplete(Double.valueOf(convertedAmount), (UnitComplete)targetUnit.getValue());
            qtyNode.setValue((Object)nq, 0L);
            qtyNode.updateNode();
        } else if (qtyNode.getValue() instanceof QuantityComplete) {
            QuantityComplete availableQty = (QuantityComplete)qtyNode.getValue();
            QuantityComplete quantityInTargetUnit = null;
            double convertedAmount = 0.0;
            if (qtyNode.getParent() != null && qtyNode.getParent().getValue(ArticleChargeBatchComplete.class) != null) {
                ArticleChargeBatchComplete batch = (ArticleChargeBatchComplete)qtyNode.getParent().getValue(ArticleChargeBatchComplete.class);
                quantityInTargetUnit = UnitConversionToolkit.getQuantityInTargetUnit((ArticleChargeBatchComplete)batch, (UnitComplete)((UnitComplete)targetUnit.getValue()));
            } else if (qtyNode.getParent() != null && qtyNode.getParent().getValue() != null) {
                List articleChargeBatches = (List)this.batches.getValue();
                StorePositionLight position = ((ArticleChargeBatchComplete)articleChargeBatches.get(0)).getPosition();
                BasicArticleLight basicArticle = ((ArticleChargeBatchComplete)articleChargeBatches.get(0)).getCharge().getBasicArticle();
                try {
                    StoreQuantityComplete stockInTargetUnitIfPossible = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockOnPositionInTargetUnitIfPossible(new BasicArticleReference(basicArticle.getId()), position, (UnitComplete)targetUnit.getValue());
                    quantityInTargetUnit = new QuantityComplete(Double.valueOf(stockInTargetUnitIfPossible.getAmount().doubleValue()), stockInTargetUnitIfPossible.getUnit());
                }
                catch (ServiceException serviceException) {}
            } else {
                convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)availableQty.getUnit(), (UnitComplete)((UnitComplete)targetUnit.getValue()), (double)availableQty.getQuantity(), (BasicArticleLight)articleComplete, (Timestamp)validity);
                quantityInTargetUnit = new QuantityComplete(Double.valueOf(convertedAmount), (UnitComplete)targetUnit.getValue());
            }
            qtyNode.setValue((Object)quantityInTargetUnit, 0L);
            qtyNode.updateNode();
        }
    }

    private void selectAllDeliveredSelection() {
        if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered).getValue())) {
            this.allDelivered.setSelectedItem(Words.ALL_DELIVERED);
        } else {
            this.allDelivered.setSelectedItem(" ");
        }
    }

    private void ensureAllDeliveredSelection() {
        if (this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered) != null) {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            if (Words.ALL_DELIVERED.equals(this.allDelivered.getSelectedItem())) {
                this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered).setValue((Object)true, 0L);
            } else {
                this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered).setValue((Object)false, 0L);
            }
            this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDeliveredUser).setValue((Object)user, 0L);
            this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDeliveredDate).setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
        }
    }

    private StoreLight getPreferredStore(Node articleNode) {
        if (articleNode != null && articleNode.getChildNamed(BasicArticleComplete_.storeConditions) != null) {
            Iterator it = articleNode.getChildNamed(BasicArticleComplete_.storeConditions).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (StoreConditionTypeE.REQUISITION_DELIVER != n.getChildNamed(StoreConditionComplete_.type).getValue()) continue;
                return (StoreLight)n.getChildNamed(new DtoField[]{StoreConditionComplete_.position, StorePositionLight_.store}).getValue();
            }
        }
        return null;
    }

    @Override
    public Object getObject4Column(int column) {
        return null;
    }

    public RequisitionOrderPreparationComplete getSupplierTransaction() {
        if (this.isChecked.isChecked()) {
            ArticleChargeComplete charge;
            Object value;
            RequisitionOrderPreparationComplete transaction = new RequisitionOrderPreparationComplete();
            transaction.setOrderPosition((RequisitionOrderPositionComplete)this.model.getNode().getValue());
            RequisitionOrderPositionComplete pos = transaction.getOrderPosition();
            BasicArticleComplete artC = null;
            artC = this.articleName != null ? ((value = this.articleName.getNode().getValue()) instanceof BasicArticleComplete ? (BasicArticleComplete)this.articleName.getNode().getValue(BasicArticleComplete.class) : (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class)) : (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            StoreQuantityComplete quant = new StoreQuantityComplete();
            Long l = TransactionToolkit.getLongValue(this.deliverAmount.getValueNode());
            quant.setAmount(l);
            quant.setUnit((UnitComplete)this.deliverAmount.getUnitNode().getValue());
            UnitComplete targetUnit = artC.getBaseUnit();
            while (targetUnit.getSubUnit() != null) {
                targetUnit = targetUnit.getSubUnit();
            }
            List conversion = null;
            if (this.screen.isChargeBased()) {
                if (l != 0L && this.batchList.getSelectedItem() != null) {
                    charge = ((ArticleChargeBatchComplete)((Node)this.batchList.getSelectedItem()).getValue()).getCharge();
                    conversion = charge.getPackingQuantities();
                }
            } else if (l != 0L && this.batches.getChildCount() > 0) {
                charge = ((ArticleChargeBatchComplete)this.batches.getChildAt(0).getValue()).getCharge();
                conversion = charge.getPackingQuantities();
            }
            if (conversion == null) {
                PackagingQuantityBaseComplete articleConversion = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)artC, (Timestamp)this.getValidityDate());
                conversion = articleConversion.getPackingQuantities();
            }
            Collections.sort(conversion);
            double moveAmount = UnitConversionToolkit.convertUnit((UnitComplete)quant.getUnit(), (UnitComplete)targetUnit, (double)quant.getAmount().doubleValue(), (BasicArticleLight)artC, (List)conversion);
            QuantityComplete quantity = new QuantityComplete();
            quantity.setUnit(targetUnit);
            quantity.setQuantity(Double.valueOf(moveAmount));
            quant = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(moveAmount), quantity.getUnit()), (BasicArticleLight)artC, (Timestamp)this.getValidityDate());
            transaction.setAmount(quant);
            if (this.screen.isChargeBased()) {
                if (l != 0L) {
                    transaction.setOriginCharge((ArticleChargeLight)((ArticleChargeBatchComplete)((Node)this.batchList.getSelectedItem()).getValue()).getCharge());
                }
            } else if (l != 0L) {
                transaction.setOriginCharge((ArticleChargeLight)((ArticleChargeBatchComplete)this.batches.getChildAt(0).getValue()).getCharge());
            }
            if (l != 0L) {
                transaction.setOriginPosition((StorePositionLight)((Node)this.storePositionSearch.getSelectedItem()).getValue());
            }
            transaction.setDate(new Timestamp(System.currentTimeMillis()));
            transaction.setClientOId(Long.valueOf(ADTO.getNextId()));
            transaction.setReceivingStorePosition(pos.getReceivingStore());
            return transaction;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean isEnabled = enabled && this.isUnitOrderConvertible();
        this.updateOrderConversionState();
        boolean notDelivered = this.model.getNode() != null && this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDelivered) != null && Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDelivered).getValue());
        boolean allDeliver = this.model.getNode() != null && this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered) != null && Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered).getValue());
        boolean closed = false;
        if (this.model.getNode() != null && this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState) != null && this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState).getValue() == OrderStateE.CLOSED && isEnabled) {
            closed = true;
        }
        if (closed && notDelivered) {
            closed = false;
        }
        if (allDeliver) {
            closed = true;
        }
        if (this.isFirst) {
            this.orderState.setEnabled(isEnabled && !closed);
            this.articleName.setEnabled(isEnabled && !closed);
            this.orderAmount.setEnabled(isEnabled && !closed);
            this.pendingAmount.setEnabled(isEnabled && !closed);
            if (this.provider.isWritable(RequisitionOrderAccess.SEND_MAIL_TO_SUPERVISOR)) {
                this.sendMailButton.setEnabled(isEnabled && !closed);
            } else {
                this.sendMailButton.setEnabled(false);
            }
            if (this.imagePanel != null) {
                this.imagePanel.setEnabled(isEnabled && !closed);
            }
        }
        this.artInfo.setEnabled(enabled && !closed);
        this.deliverAmount.setEnabled(isEnabled && !closed);
        this.storePositionSearch.setEnabled(isEnabled && !closed);
        this.storeSearch.setEnabled(isEnabled && !closed);
        if (this.screen.isChargeBased()) {
            this.batchList.setEnabled(isEnabled && !closed);
        }
        this.isChecked.setEnabled(isEnabled && !closed);
        this.availableAmount.setEnabled(isEnabled && !closed);
        this.addRemoveButton.setEnabled(isEnabled && !closed);
        this.allDelivered.setEnabled(isEnabled && !closed);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        if (!this.isChecked.isChecked()) {
            CheckedListAdder.addToList(focusList, this.deliverAmount);
            CheckedListAdder.addToList(focusList, this.storeSearch);
            CheckedListAdder.addToList(focusList, this.storePositionSearch);
            CheckedListAdder.addToList(focusList, this.batchList);
            focusList.addAll(this.addRemoveButton.getFocusComponents());
        }
        focusList.addAll(this.isChecked.getFocusComponents());
        focusList.addAll(this.allDelivered.getFocusComponents());
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isFirst) {
            this.orderState.kill();
            this.articleName.kill();
            this.orderAmount.kill();
            this.pendingAmount.kill();
            this.sendMailButton.kill();
            if (this.imagePanel != null) {
                this.imagePanel.kill();
            }
        }
        this.artInfo.kill();
        this.deliverAmount.getUnitNode().removeNodeListener((NodeListener)this);
        this.deliverAmount.kill();
        this.storeSearch.kill();
        this.storePositionSearch.kill();
        if (this.screen.isChargeBased()) {
            this.batchList.kill();
        }
        this.isChecked.kill();
        this.availableAmount.kill();
        this.addRemoveButton.kill();
        this.allDelivered.kill();
        this.artInfo = null;
        this.orderState = null;
        this.articleName = null;
        this.orderAmount = null;
        this.storeSearch = null;
        this.storePositionSearch = null;
        this.batchList = null;
        this.pendingAmount = null;
        this.sendMailButton = null;
        this.deliverAmount = null;
        this.isChecked = null;
        this.addRemoveButton = null;
        this.availableAmount = null;
        this.allDelivered = null;
        this.imagePanel = null;
    }

    private Node<QuantityComplete> getPendingView(Node node, BasicArticleComplete article, RequisitionOrderPositionComplete position) {
        EmbeddedDTONode q = new EmbeddedDTONode();
        QuantityComplete qq = null;
        if (node.getChildNamed(RequisitionOrderPositionComplete_.quantity).getValue() instanceof StoreQuantityComplete) {
            StoreQuantityComplete sq = (StoreQuantityComplete)node.getChildNamed(RequisitionOrderPositionComplete_.quantity).getValue();
            qq = new QuantityComplete(Double.valueOf(sq.getAmount().doubleValue()), sq.getUnit());
        } else if (node.getChildNamed(RequisitionOrderPositionComplete_.quantity).getValue() instanceof QuantityComplete) {
            qq = (QuantityComplete)node.getChildNamed(RequisitionOrderPositionComplete_.quantity).getValue();
        }
        q.setValue(qq, 0L);
        double pendingAmount = 0.0;
        double needed = this.readAmount(node, RequisitionOrderPositionComplete_.quantity.getFieldName(), StoreQuantityComplete_.amount.getFieldName()).longValue();
        double prepared = this.readAmount(node, RequisitionOrderPositionComplete_.preparedAmount.getFieldName(), StoreQuantityComplete_.amount.getFieldName()).longValue();
        double delivered = this.readAmount(node, RequisitionOrderPositionComplete_.deliveredAmount.getFieldName(), StoreQuantityComplete_.amount.getFieldName()).longValue();
        double rejected = this.readAmount(node, RequisitionOrderPositionComplete_.rejectedAmount.getFieldName(), StoreQuantityComplete_.amount.getFieldName()).longValue();
        Timestamp validity = new Timestamp(position.getOrder().getRequiredOn().getTime());
        prepared = UnitConversionToolkit.convertUnit((UnitComplete)this.readUnit(node, RequisitionOrderPositionComplete_.preparedAmount.getFieldName(), StoreQuantityComplete_.unit.getFieldName()), (UnitComplete)((QuantityComplete)q.getValue()).getUnit(), (double)prepared, (BasicArticleLight)article, (Timestamp)validity);
        delivered = UnitConversionToolkit.convertUnit((UnitComplete)this.readUnit(node, RequisitionOrderPositionComplete_.deliveredAmount.getFieldName(), StoreQuantityComplete_.unit.getFieldName()), (UnitComplete)((QuantityComplete)q.getValue()).getUnit(), (double)delivered, (BasicArticleLight)article, (Timestamp)validity);
        rejected = UnitConversionToolkit.convertUnit((UnitComplete)this.readUnit(node, RequisitionOrderPositionComplete_.rejectedAmount.getFieldName(), StoreQuantityComplete_.unit.getFieldName()), (UnitComplete)((QuantityComplete)q.getValue()).getUnit(), (double)rejected, (BasicArticleLight)article, (Timestamp)validity);
        pendingAmount = needed - (prepared + delivered + rejected);
        QuantityComplete r = new QuantityComplete();
        pendingAmount = UnitConversionToolkit.convertUnit((UnitComplete)((QuantityComplete)q.getValue()).getUnit(), (UnitComplete)position.getQuantity().getUnit(), (double)pendingAmount, (BasicArticleLight)article, (Timestamp)validity);
        r.setQuantity(Double.valueOf(pendingAmount));
        r.setUnit(position.getQuantity().getUnit());
        try {
            QuantityComplete q1 = UnitConversionToolkit.normalizeQuantity((QuantityComplete)r, (BasicArticleComplete)article, (Timestamp)validity);
            q.setValue((Object)q1, 0L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return q;
    }

    private Long readAmount(Node node, String qty, String amount) {
        if (node != null) {
            Node qtyNode = node.getChildNamed(new String[]{qty});
            if (qtyNode == null) {
                return 0L;
            }
            Node amountNode = qtyNode.getChildNamed(new String[]{amount});
            if (amountNode == null) {
                return 0L;
            }
            if (amountNode.getValue() == null) {
                return 0L;
            }
            if (amountNode.getValue() instanceof Integer) {
                return ((Integer)amountNode.getValue()).longValue();
            }
            if (amountNode.getValue() instanceof Double) {
                return ((Double)amountNode.getValue()).longValue();
            }
            return (Long)amountNode.getValue();
        }
        return 0L;
    }

    private UnitComplete readUnit(Node node, String qty, String unit) {
        if (node != null) {
            Node qtyNode = node.getChildNamed(new String[]{qty});
            if (qtyNode == null) {
                return null;
            }
            Node unitNode = qtyNode.getChildNamed(new String[]{unit});
            if (unitNode == null) {
                return null;
            }
            return (UnitComplete)unitNode.getValue();
        }
        return null;
    }

    private boolean validateComponents() {
        ArticleChargeComplete charge;
        Object value;
        boolean isValid = true;
        Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
        Timestamp validity = new Timestamp(date.getTime());
        BasicArticleComplete artC = null;
        artC = this.articleName != null ? ((value = this.articleName.getNode().getValue()) instanceof BasicArticleComplete ? (BasicArticleComplete)this.articleName.getNode().getValue(BasicArticleComplete.class) : (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class)) : (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean canOverrideThreshold = HUDToolkit.hasAccess(RequisitionOrderAccess.MODULE_REQUISITION, RequisitionOrderAccess.CAN_OVERRIDE_DELIVER_THRESHOLD, this.currentUser);
        Long l = TransactionToolkit.getLongValue(this.deliverAmount.getValueNode());
        if (Words.ALL_DELIVERED.equals(this.allDelivered.getSelectedItem()) && l == 0L) {
            return true;
        }
        if (this.storeSearch.getNode().getValue() == null) {
            isValid = false;
            this.storeSearch.setInvalid();
        } else {
            StoreLight store = (StoreLight)this.storeSearch.getNode().getValue();
            if (store.getInventoryInProgress() != null) {
                isValid = false;
                this.storeSearch.setInvalid();
            }
        }
        if (this.storePositionSearch.getNode() == null) {
            isValid = false;
            this.storePositionSearch.setInvalid();
        }
        List conversion = null;
        if (this.screen.isChargeBased()) {
            if (l != 0L) {
                if (this.batchList.getSelectedItem() != null) {
                    charge = ((ArticleChargeBatchComplete)((Node)this.batchList.getSelectedItem()).getValue()).getCharge();
                    conversion = charge.getPackingQuantities();
                } else {
                    isValid = false;
                }
            }
        } else if (l != 0L) {
            if (this.batches.getChildCount() > 0) {
                charge = ((ArticleChargeBatchComplete)this.batches.getChildAt(0).getValue()).getCharge();
                conversion = charge.getPackingQuantities();
            } else {
                isValid = false;
            }
        }
        if (conversion == null) {
            PackagingQuantityBaseComplete articleConversion = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)artC, (Timestamp)this.getValidityDate());
            conversion = articleConversion.getPackingQuantities();
        }
        Collections.sort(conversion);
        if (l <= 0L) {
            isValid = false;
            this.deliverAmount.setInvalid();
        } else if (this.availableAmount.getNode() != null) {
            StoreQuantityComplete sq;
            QuantityComplete av = this.availableAmount.getNode().getValue() instanceof QuantityComplete ? (QuantityComplete)this.availableAmount.getNode().getValue() : ((sq = (StoreQuantityComplete)this.availableAmount.getNode().getValue()) != null && sq.getAmount() != null ? new QuantityComplete(Double.valueOf(sq.getAmount().doubleValue()), sq.getUnit()) : new QuantityComplete(Double.valueOf(0.0), artC.getMainStoreUnit()));
            Long nl = l;
            StoreQuantityComplete dl = new StoreQuantityComplete(nl, (UnitComplete)this.deliverAmount.getUnitNode().getValue());
            double deliveredQuantityInAvailableUnit = UnitConversionToolkit.convertUnit((UnitComplete)dl.getUnit(), (UnitComplete)av.getUnit(), (double)dl.getAmount().longValue(), (BasicArticleLight)artC, (List)conversion);
            if (deliveredQuantityInAvailableUnit > av.getQuantity()) {
                this.deliverAmount.setInvalid();
                this.availableAmount.setInvalid();
                isValid = false;
            } else if (canOverrideThreshold) {
                this.availableAmount.setValid();
            } else {
                double amount = 0.0;
                UnitComplete unit = null;
                Object quantity = this.model.getNode().getChildNamed(new String[]{"quantity"}).getValue();
                if (quantity instanceof StoreQuantityComplete) {
                    amount = ((StoreQuantityComplete)quantity).getAmount().doubleValue();
                    unit = ((StoreQuantityComplete)quantity).getUnit();
                } else if (quantity instanceof QuantityComplete) {
                    amount = ((QuantityComplete)quantity).getQuantity();
                    unit = ((QuantityComplete)quantity).getUnit();
                }
                double orderedQuantityInAvailableUnit = UnitConversionToolkit.convertUnit((UnitComplete)unit, (UnitComplete)av.getUnit(), (double)amount, (BasicArticleLight)artC, (List)conversion);
                if (deliveredQuantityInAvailableUnit > orderedQuantityInAvailableUnit) {
                    double overflow = deliveredQuantityInAvailableUnit / orderedQuantityInAvailableUnit;
                    overflow -= 1.0;
                    overflow *= 100.0;
                    if (Boolean.TRUE.equals(settings.getUseRequisitionDeliverThreshold()) && settings.getRequisitionDeliverOverflowThreshold() < overflow) {
                        isValid = false;
                        this.deliverAmount.setInvalid();
                    } else {
                        isValid = true;
                        this.deliverAmount.setValid();
                    }
                } else {
                    double underflow = deliveredQuantityInAvailableUnit / orderedQuantityInAvailableUnit;
                    underflow = 1.0 - underflow;
                    underflow *= 100.0;
                    if (Boolean.TRUE.equals(settings.getUseRequisitionDeliverThreshold()) && settings.getRequisitionDeliverUnderflowThreshold() < underflow) {
                        isValid = false;
                        this.deliverAmount.setInvalid();
                    } else {
                        isValid = true;
                        this.deliverAmount.setValid();
                    }
                }
            }
        } else {
            this.availableAmount.setInvalid();
            isValid = false;
        }
        return isValid;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.isChecked) {
            boolean isValidated = true;
            if (this.isChecked.isChecked() && !this.validateComponents()) {
                isValidated = false;
                this.isChecked.setChecked(!this.isChecked.isChecked());
            }
            if (isValidated) {
                if (this.isFirst) {
                    this.articleName.setEnabled(!this.isChecked.isChecked());
                    this.orderAmount.setEnabled(!this.isChecked.isChecked());
                    this.pendingAmount.setEnabled(!this.isChecked.isChecked());
                    this.sendMailButton.setEnabled(!this.isChecked.isChecked());
                }
                this.artInfo.setEnabled(!this.isChecked.isChecked());
                this.deliverAmount.setEnabled(!this.isChecked.isChecked());
                this.storeSearch.setEnabled(!this.isChecked.isChecked());
                this.storePositionSearch.setEnabled(!this.isChecked.isChecked());
                if (this.screen.isChargeBased()) {
                    this.batchList.setEnabled(!this.isChecked.isChecked());
                }
                this.availableAmount.setEnabled(!this.isChecked.isChecked());
                this.addRemoveButton.setEnabled(!this.isChecked.isChecked());
                this.screen.recreateFocusCycle();
            }
        } else if (source == this.addRemoveButton) {
            if (source instanceof AddButton) {
                DTOProxyNode n = new DTOProxyNode(this.model.getNode());
                this.screen.addNewRow((ProxyNode)n);
            } else if (source instanceof DeleteButton) {
                this.screen.removeNewRow(this.model.getNode());
            }
            this.screen.getTable().revalidate();
            this.screen.recreateFocusCycle();
        }
        this.screen.ensureButtonState();
    }

    private Node getSelectableValues() {
        ListNode list = new ListNode();
        ArrayList a = new ArrayList();
        HashSet<StoreLight> stores = new HashSet<StoreLight>();
        if (this.currentMap != null) {
            Set<Map.Entry<StorePositionLight, StoreQuantityComplete>> set = this.currentMap.entrySet();
            Iterator<Map.Entry<StorePositionLight, StoreQuantityComplete>> it = set.iterator();
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (Boolean.TRUE.equals(s.getUseStoreEntryTypeRestrictionForManualTransactions())) {
                while (it.hasNext()) {
                    Map.Entry<StorePositionLight, StoreQuantityComplete> ent = it.next();
                    if (ent.getKey().getStore().getStoreEntryType() != null && ent.getKey().getStore().getStoreEntryType() != StoreEntryTypeE.ALL && ent.getKey().getStore().getStoreEntryType() != StoreEntryTypeE.OUT) continue;
                    stores.add(ent.getKey().getStore());
                }
            } else {
                while (it.hasNext()) {
                    Map.Entry<StorePositionLight, StoreQuantityComplete> ent = it.next();
                    stores.add(ent.getKey().getStore());
                }
            }
        }
        a.addAll(stores);
        list.setValue(a, 0L);
        list.initList();
        return list;
    }

    @Override
    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
        if (!this.isKilled()) {
            this.setEnabled(true);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.isUpdating = true;
        if (this.currentState == 3) {
            if (this.storeSearch == null) {
                return;
            }
            this.storeSearch.refreshPossibleValues(this.getSelectableValues());
            boolean b = true;
            if (this.isFirst) {
                b = ((QuantityComplete)this.pendingAmount.getNode().getValue()).getQuantity() > 0.0;
            }
            this.storePositionSearch.setEnabled(this.storeSearch.getItemCount() > 0 & b);
            this.isUpdating = false;
            StorePositionLight storePositionWithFirstExpiryDate = null;
            ArrayList<StorePositionLight> possiblePositions = new ArrayList<StorePositionLight>();
            for (Map.Entry<StorePositionLight, StoreQuantityComplete> entry : this.currentMap.entrySet()) {
                if (!Boolean.TRUE.equals(entry.getKey().getStore().getMainStore())) continue;
                possiblePositions.add(entry.getKey());
            }
            Collections.sort(possiblePositions, (o1, o2) -> {
                if (o1 == null) {
                    return o2 != null ? -1 : 0;
                }
                if (o2 == null) {
                    return 1;
                }
                int r = 0;
                if (o1.getFirstExpiryDate() == null) {
                    return o2.getFirstExpiryDate() == null ? 0 : -1;
                }
                if (o2.getFirstExpiryDate() == null) {
                    return 1;
                }
                r = o1.getFirstExpiryDate().compareTo(o2.getFirstExpiryDate());
                if (r == 0) {
                    String s1 = o1.getStore().getStoreGroup();
                    String s2 = o2.getStore().getStoreGroup();
                    if (s1 == null) {
                        s1 = "100000000";
                    }
                    if (s2 == null) {
                        s2 = "100000000";
                    }
                    r = s1.compareTo(s2);
                }
                if (r == 0) {
                    r = o1.getName().compareTo(o2.getName());
                }
                return r;
            });
            if (!possiblePositions.isEmpty()) {
                storePositionWithFirstExpiryDate = (StorePositionLight)possiblePositions.get(0);
            }
            if (storePositionWithFirstExpiryDate != null) {
                Iterator it = this.storeSearch.getPossibleValues().getFailSafeChildIterator();
                Node storeToSelect = null;
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    if (!((StoreLight)next.getValue()).equals((Object)storePositionWithFirstExpiryDate.getStore())) continue;
                    storeToSelect = next;
                }
                if (storeToSelect != null) {
                    this.storeSearch.setSelectedItem(storeToSelect);
                }
                this.itemStateChanged(new ItemEvent(this.storeSearch, 0, this.storeSearch.getSelectedItem(), 1));
            } else {
                this.itemStateChanged(new ItemEvent(this.storeSearch, 0, this.storeSearch.getSelectedItem(), 1));
            }
        } else if (this.currentState == 5) {
            this.batches = node;
            if (!this.isKilled()) {
                if (this.screen.isChargeBased()) {
                    this.batchList.refreshPossibleValues(node);
                    if (this.isFirst) {
                        this.batchList.setEnabled(true & ((QuantityComplete)this.pendingAmount.getNode().getValue()).getQuantity() > 0.0);
                    } else {
                        this.batchList.setEnabled(true);
                    }
                    Node b = (Node)this.batchList.getSelectedItem();
                    if (b == null) {
                        b = this.batchList.getNode();
                    }
                    this.availableAmount.setNode(b.getChildNamed(new String[]{"quantity"}));
                    b.updateNode();
                    this.changeUnit();
                    this.updateInfoPopup();
                } else {
                    QuantityComplete q = null;
                    BasicArticleComplete ac = null;
                    Iterator it = this.batches.getChilds();
                    while (it.hasNext()) {
                        Node batch = (Node)it.next();
                        if (batch.getChildNamed(new String[]{"charge-basicArticle"}).getValue(BasicArticleComplete.class) != null) {
                            ac = (BasicArticleComplete)batch.getChildNamed(new String[]{"charge-basicArticle"}).getValue(BasicArticleComplete.class);
                        } else {
                            BasicArticleReference bal = (BasicArticleReference)batch.getChildNamed(new String[]{"charge-basicArticle"}).getValue();
                            try {
                                ac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(bal.getId())).getValue();
                            }
                            catch (ClientServerCallException e) {
                                this.errorOccurred((ClientException)((Object)e));
                                return;
                            }
                        }
                        StoreQuantityComplete bq = (StoreQuantityComplete)batch.getChildNamed(new String[]{"quantity"}).getValue();
                        if (q == null) {
                            q = new QuantityComplete();
                            q.setClientOId(Long.valueOf(q.getNextId()));
                            q.setQuantity(Double.valueOf(0.0));
                            q.setUnit(ac.getFloatStoreUnit());
                        }
                        ArticleChargeBatchComplete batchValue = (ArticleChargeBatchComplete)batch.getValue();
                        double a = UnitConversionToolkit.convertUnit((UnitComplete)bq.getUnit(), (UnitComplete)ac.getFloatStoreUnit(), (double)bq.getAmount().longValue(), (BasicArticleLight)ac, (Timestamp)batchValue.getCharge().getCreationDate());
                        q.setQuantity(Double.valueOf(q.getQuantity() + a));
                    }
                    Node avN = this.availableAmount.getNode();
                    if (avN == null) {
                        avN = new EmbeddedDTONode();
                        this.availableAmount.setNode(avN);
                    }
                    avN.setValue(q, System.currentTimeMillis());
                    avN.setParent(this.batches);
                    avN.updateNode();
                    if (node.getChildCount() > 0) {
                        StoreLight store = (StoreLight)this.storeSearch.getNode().getValue();
                        List units = StoreToolkit.getPossibleUnits((BasicArticleLight)ac, null, (Timestamp)this.getValidityDate(), (TransactionType)TransactionType.REQUISITION_DELIVER, (UserComplete)this.currentUser, (StoreLight)store, null, (SystemSettingsComplete)this.settings);
                        Object value = this.deliverAmount.getUnitNode().getValue();
                        if (value instanceof UnitComplete && !units.contains(value)) {
                            units.add((UnitComplete)value);
                        }
                        InputComboBox2 b = this.deliverAmount;
                        b.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                        this.updateInfoPopup();
                        this.availableAmount.setEnabled(true);
                        this.deliverAmount.setEnabled(true);
                    }
                }
                if (!((List)node.getValue()).isEmpty()) {
                    BasicArticleLight artC = ((ArticleChargeBatchComplete)((List)node.getValue()).get(0)).getCharge().getBasicArticle();
                    StoreLight store = (StoreLight)this.storeSearch.getNode().getValue();
                    List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)this.getValidityDate(), (TransactionType)TransactionType.REQUISITION_DELIVER, (UserComplete)this.currentUser, (StoreLight)store, null, (SystemSettingsComplete)this.settings);
                    Object value = this.deliverAmount.getUnitNode().getValue();
                    if (value instanceof UnitComplete && !units.contains(value)) {
                        units.add((UnitComplete)value);
                    }
                    this.deliverAmount.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                    UnitSelectionUtil.selectUnit(units, this.deliverAmount, artC);
                }
                this.changeUnit();
                this.setEnabled(true);
            }
            this.isUpdating = false;
        }
        if (!this.isKilled()) {
            this.getModel().getParentModel().recreateFocusCycle();
        }
    }

    private void loadStockForArticleAndStore(final BasicArticleLight article) {
        CursorController.showCursor(this, true);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HashMap sq = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockPerStorePosition(new BasicArticleReference(article.getId())).getMap();
                TableRowPanelImpl.this.currentMap = StoreToolkit.filter((Map)sq, (TransactionType)TransactionType.REQUISITION_DELIVER, (UserComplete)TableRowPanelImpl.this.currentUser, (SystemSettingsComplete)TableRowPanelImpl.this.settings);
                if (Boolean.TRUE.equals(TableRowPanelImpl.this.settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !TableRowPanelImpl.this.provider.isWritable(ARequisitionOrderAccess.MOVE_FROM_TO_ANY_STORE)) {
                    sq = new HashMap();
                    for (Map.Entry entry : TableRowPanelImpl.this.currentMap.entrySet()) {
                        if (!((StorePositionLight)entry.getKey()).getStore().getRequisitionAllowed().booleanValue() || ((StorePositionLight)entry.getKey()).getStore().getStoreEntryType() != StoreEntryTypeE.ALL && ((StorePositionLight)entry.getKey()).getStore().getStoreEntryType() != StoreEntryTypeE.OUT) continue;
                        sq.put(entry.getKey(), entry.getValue());
                    }
                    TableRowPanelImpl.this.currentMap = sq;
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return TableRowPanelImpl.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void valueChanged(Node<?> node) {
        this.changeUnit();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    private Node getSelectablePositions(StoreLight currentStore) {
        ListNode list = new ListNode();
        ArrayList<StorePositionLight> a = new ArrayList<StorePositionLight>();
        if (this.currentMap != null) {
            Set<Map.Entry<StorePositionLight, StoreQuantityComplete>> set = this.currentMap.entrySet();
            for (Map.Entry<StorePositionLight, StoreQuantityComplete> ent : set) {
                if (!currentStore.equals((Object)ent.getKey().getStore())) continue;
                a.add(ent.getKey());
            }
        }
        list.setValue(a, 0L);
        list.initList();
        return list;
    }

    private void enableBatchSearch() {
        this.currentState = 5;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n;
                if (TableRowPanelImpl.this.storePositionSearch != null) {
                    Node nn = (Node)TableRowPanelImpl.this.storePositionSearch.getSelectedItem();
                    StorePositionLight l = (StorePositionLight)nn.getValue();
                    BasicArticleLight al = (BasicArticleLight)TableRowPanelImpl.this.model.getNode().getChildNamed(new String[]{"article"}).getValue();
                    List batchList = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getBatches((BasicArticleReference)al, l).getList();
                    for (ArticleChargeBatchComplete batch : batchList) {
                        if (batch.getCharge() != null) continue;
                        ArticleChargeComplete charge = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(batch.getChargeId())).getValue();
                        batch.setCharge(charge);
                    }
                    n = INodeCreator.getDefaultImpl().createNodes(batchList, false);
                } else {
                    n = INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false);
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return TableRowPanelImpl.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isUpdating && e.getStateChange() == 1) {
            if (e.getSource() == this.storeSearch) {
                boolean isEnabled = false;
                StoreLight value = null;
                if (this.storeSearch.getItemCount() > 0) {
                    value = (StoreLight)((Node)this.storeSearch.getSelectedItem()).getValue();
                    Node selectablePositions = this.getSelectablePositions(value);
                    this.storePositionSearch.refreshPossibleValues(selectablePositions);
                    Node selectedPosition = null;
                    ArrayList<Node> possiblePositions = new ArrayList<Node>();
                    Iterator it = selectablePositions.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node next = (Node)it.next();
                        if (!Boolean.TRUE.equals(((StorePositionLight)next.getValue()).getStore().getMainStore())) continue;
                        possiblePositions.add(next);
                    }
                    Collections.sort(possiblePositions, (o1, o2) -> {
                        StorePositionLight p1 = (StorePositionLight)o1.getValue();
                        StorePositionLight p2 = (StorePositionLight)o2.getValue();
                        if (p1.getFirstExpiryDate() == null) {
                            return p2.getFirstExpiryDate() == null ? 0 : -1;
                        }
                        if (p2.getFirstExpiryDate() == null) {
                            return 1;
                        }
                        int r = p1.getFirstExpiryDate().compareTo(p2.getFirstExpiryDate());
                        if (r == 0) {
                            r = p1.getName().compareTo(p2.getName());
                        }
                        return r;
                    });
                    if (!possiblePositions.isEmpty()) {
                        selectedPosition = (Node)possiblePositions.get(0);
                    }
                    if (selectedPosition != null) {
                        this.storePositionSearch.setSelectedItem(selectedPosition);
                        this.itemStateChanged(new ItemEvent(this.storePositionSearch, 0, selectedPosition, 1));
                    }
                }
                if (this.screen.isChargeBased()) {
                    this.batchList.setEnabled(isEnabled);
                }
                this.updateImage(value);
            } else if (e.getSource() == this.storePositionSearch) {
                this.enableBatchSearch();
            } else if (e.getSource() == this.batchList) {
                Node b = (Node)this.batchList.getSelectedItem();
                this.availableAmount.setNode(b.getChildNamed(new String[]{"quantity"}));
                this.updateUnitsList();
                this.changeUnit();
                this.updateInfoPopup();
            }
        }
        this.getModel().getParentModel().recreateFocusCycle();
    }

    private void updateImage(StoreLight value) {
        if (this.imagePanel != null) {
            if (value == null) {
                this.imagePanel.setNode(this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.article, BasicArticleComplete_.floatStoreUnitImage}));
            } else if (Boolean.TRUE.equals(value.getMainStore())) {
                this.imagePanel.setNode(this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.article, BasicArticleComplete_.mainStoreUnitImage}));
            } else {
                this.imagePanel.setNode(this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.article, BasicArticleComplete_.floatStoreUnitImage}));
            }
        }
    }

    private void updateInfoPopup() {
        if (this.screen.isChargeBased()) {
            List packingQuantities = null;
            if (this.availableAmount.getNode().getParent() != null && this.availableAmount.getNode().getParent().getValue(ArticleChargeBatchComplete.class) != null) {
                ArticleChargeBatchComplete batch = (ArticleChargeBatchComplete)this.availableAmount.getNode().getParent().getValue(ArticleChargeBatchComplete.class);
                packingQuantities = batch.getCharge().getPackingQuantities();
            }
            this.artInfo.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class), this.getValidityDate(), 11, packingQuantities));
            this.artInfo.setEnabled(true);
        } else {
            List charges = (List)this.batches.getValue();
            this.artInfo.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class), charges, 31));
            this.artInfo.setEnabled(true);
        }
    }

    private Timestamp getValidityDate() {
        return new Timestamp(((Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue()).getTime());
    }

    public boolean isChecked() {
        return this.isChecked.isChecked();
    }

    public void setChecked(boolean select) {
        if (select != this.isChecked()) {
            boolean closed;
            boolean bl = closed = this.model.getNode() != null && this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState) != null && this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliverState).getValue() == OrderStateE.CLOSED;
            if (!closed) {
                this.isChecked.setChecked(select);
                this.buttonPressed(this.isChecked, 0, 0);
            }
        }
    }

    public boolean validateCheckout(Hashtable<Object, QuantityComplete> checkedout) {
        if (this.isChecked.isChecked()) {
            StoreQuantityComplete quant = new StoreQuantityComplete();
            Long l = TransactionToolkit.getLongValue(this.deliverAmount.getValueNode());
            Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            quant.setAmount(l);
            quant.setUnit((UnitComplete)this.deliverAmount.getUnitNode().getValue());
            if (this.screen.isChargeBased()) {
                if (l != 0L && this.batchList != null && this.batchList.getSelectedItem() != null) {
                    ArticleChargeBatchComplete s = (ArticleChargeBatchComplete)((Node)this.batchList.getSelectedItem()).getValue();
                    QuantityComplete q = checkedout.get(s);
                    if (q == null) {
                        q = new QuantityComplete(Double.valueOf(quant.getAmount().doubleValue()), quant.getUnit());
                        checkedout.put(s, q);
                    } else {
                        double d = UnitConversionToolkit.convertUnit((UnitComplete)quant.getUnit(), (UnitComplete)q.getUnit(), (double)quant.getAmount().longValue(), (BasicArticleLight)s.getCharge().getBasicArticle(), (Timestamp)s.getCharge().getCreationDate());
                        q.setQuantity(Double.valueOf(q.getQuantity() + d));
                    }
                    StoreQuantityComplete q2 = s.getQuantity();
                    double d = UnitConversionToolkit.convertUnit((UnitComplete)q2.getUnit(), (UnitComplete)q.getUnit(), (double)q2.getAmount().longValue(), (BasicArticleLight)s.getCharge().getBasicArticle(), (Timestamp)s.getCharge().getCreationDate());
                    if (d < q.getQuantity()) {
                        this.deliverAmount.setInvalid();
                        return false;
                    }
                }
            } else if (l != 0L) {
                double d;
                StorePos_ArticleKey s;
                QuantityComplete q;
                QuantityComplete a = this.availableAmount != null && this.availableAmount.getNode() != null ? (QuantityComplete)this.availableAmount.getNode().getValue() : null;
                StorePositionLight pos = (StorePositionLight)((Node)this.storePositionSearch.getSelectedItem()).getValue();
                BasicArticleComplete art = (BasicArticleComplete)this.model.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
                if (a == null) {
                    a = new QuantityComplete(Double.valueOf(0.0), art.getMainStoreUnit());
                }
                if (a.getUnit() == null) {
                    a.setUnit(art.getMainStoreUnit());
                }
                if (a.getQuantity() == null) {
                    a.setQuantity(Double.valueOf(0.0));
                }
                if ((q = checkedout.get(s = new StorePos_ArticleKey((BasicArticleLight)art, pos))) == null) {
                    q = new QuantityComplete(Double.valueOf(quant.getAmount().doubleValue()), quant.getUnit());
                    checkedout.put(s, q);
                } else {
                    d = UnitConversionToolkit.convertUnit((UnitComplete)quant.getUnit(), (UnitComplete)q.getUnit(), (double)quant.getAmount().longValue(), (BasicArticleLight)art, (Timestamp)validity);
                    q.setQuantity(Double.valueOf(q.getQuantity() + d));
                }
                d = UnitConversionToolkit.convertUnit((UnitComplete)a.getUnit(), (UnitComplete)quant.getUnit(), (double)a.getQuantity(), (BasicArticleLight)art, (Timestamp)validity);
                if (d < q.getQuantity()) {
                    this.deliverAmount.setInvalid();
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(0);
            int currentX = 0;
            if (TableRowPanelImpl.this.isFirst) {
                TableRowPanelImpl.this.orderState.setLocation(TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.orderState.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.orderState.setSize(w - 2 * TableRowPanelImpl.this.getCellPadding(), (int)TableRowPanelImpl.this.orderState.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(1);
            if (TableRowPanelImpl.this.isFirst) {
                TableRowPanelImpl.this.articleName.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.articleName.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.articleName.setSize((int)((double)w - ((double)(2 * TableRowPanelImpl.this.getCellPadding() + TableRowPanelImpl.this.getInnerCellPadding()) + TableRowPanelImpl.this.artInfo.getPreferredSize().getWidth())), (int)TableRowPanelImpl.this.articleName.getPreferredSize().getHeight());
            }
            int index = 2;
            if (TableRowPanelImpl.this.isFirst && TableRowPanelImpl.this.imagePanel != null) {
                currentX += w;
                w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowPanelImpl.this.imagePanel.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.imagePanel.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.imagePanel.setSize(w - 2 * TableRowPanelImpl.this.getCellPadding(), (int)TableRowPanelImpl.this.imagePanel.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowPanelImpl.this.isFirst) {
                TableRowPanelImpl.this.orderAmount.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.orderAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.orderAmount.setSize(w - 2 * TableRowPanelImpl.this.getCellPadding(), (int)TableRowPanelImpl.this.orderAmount.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowPanelImpl.this.isFirst) {
                TableRowPanelImpl.this.pendingAmount.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.pendingAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.pendingAmount.setSize(w - 2 * TableRowPanelImpl.this.getCellPadding(), (int)TableRowPanelImpl.this.pendingAmount.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            if (!TableRowPanelImpl.this.isFirst) {
                currentX += w;
                w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            }
            TableRowPanelImpl.this.deliverAmount.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.deliverAmount.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.deliverAmount.setSize(w - 2 * TableRowPanelImpl.this.getCellPadding() - (TableRowPanelImpl.this.artInfo.getWidth() + TableRowPanelImpl.this.getCellPadding()), (int)TableRowPanelImpl.this.deliverAmount.getPreferredSize().getHeight());
            TableRowPanelImpl.this.artInfo.setLocation(TableRowPanelImpl.this.deliverAmount.getX() + TableRowPanelImpl.this.deliverAmount.getWidth() + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.artInfo.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.artInfo.setSize(TableRowPanelImpl.this.artInfo.getPreferredSize());
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            int tw = w - 2 * TableRowPanelImpl.this.getCellPadding();
            tw -= 3 * TableRowPanelImpl.this.getInnerCellPadding();
            tw -= 80;
            tw = TableRowPanelImpl.this.screen.isChargeBased() ? (tw /= 3) : (tw /= 2);
            int cx = 0;
            TableRowPanelImpl.this.storeSearch.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.storeSearch.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.storeSearch.setSize(tw, (int)TableRowPanelImpl.this.storeSearch.getPreferredSize().getHeight());
            TableRowPanelImpl.this.storePositionSearch.setLocation(TableRowPanelImpl.this.storeSearch.getX() + TableRowPanelImpl.this.storeSearch.getWidth() + TableRowPanelImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.storePositionSearch.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.storePositionSearch.setSize(tw, (int)TableRowPanelImpl.this.storePositionSearch.getPreferredSize().getHeight());
            cx = TableRowPanelImpl.this.storePositionSearch.getX() + TableRowPanelImpl.this.storePositionSearch.getWidth() + TableRowPanelImpl.this.getInnerCellPadding();
            if (TableRowPanelImpl.this.screen.isChargeBased()) {
                TableRowPanelImpl.this.batchList.setLocation(cx, (int)(((double)parent.getHeight() - TableRowPanelImpl.this.batchList.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.batchList.setSize(tw, (int)TableRowPanelImpl.this.batchList.getPreferredSize().getHeight());
                cx += TableRowPanelImpl.this.batchList.getWidth() + TableRowPanelImpl.this.getInnerCellPadding();
            }
            TableRowPanelImpl.this.availableAmount.setLocation(cx, (int)(((double)parent.getHeight() - TableRowPanelImpl.this.availableAmount.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.availableAmount.setSize(80, (int)TableRowPanelImpl.this.availableAmount.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            TableRowPanelImpl.this.addRemoveButton.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.addRemoveButton.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.addRemoveButton.setSize(TableRowPanelImpl.this.addRemoveButton.getPreferredSize());
            currentX += w;
            w = TableRowPanelImpl.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowPanelImpl.this.sendMailButton != null) {
                TableRowPanelImpl.this.sendMailButton.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.sendMailButton.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.sendMailButton.setSize(TableRowPanelImpl.this.sendMailButton.getPreferredSize());
                TableRowPanelImpl.this.allDelivered.setLocation(TableRowPanelImpl.this.sendMailButton.getX() + TableRowPanelImpl.this.sendMailButton.getWidth() + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.allDelivered.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.allDelivered.setSize((int)((double)w - ((double)(2 * TableRowPanelImpl.this.getModel().getParentModel().getTable().getCellPadding() + 2 * TableRowPanelImpl.this.getModel().getParentModel().getTable().getInnerCellPadding()) + TableRowPanelImpl.this.isChecked.getPreferredSize().getWidth() + TableRowPanelImpl.this.sendMailButton.getPreferredSize().getWidth())), (int)TableRowPanelImpl.this.allDelivered.getPreferredSize().getHeight());
            } else {
                TableRowPanelImpl.this.allDelivered.setLocation(currentX + TableRowPanelImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.allDelivered.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImpl.this.allDelivered.setSize((int)((double)w - ((double)(2 * TableRowPanelImpl.this.getModel().getParentModel().getTable().getCellPadding() + TableRowPanelImpl.this.getModel().getParentModel().getTable().getInnerCellPadding()) + TableRowPanelImpl.this.isChecked.getPreferredSize().getWidth())), (int)TableRowPanelImpl.this.allDelivered.getPreferredSize().getHeight());
            }
            TableRowPanelImpl.this.setControlsX(currentX);
            TableRowPanelImpl.this.isChecked.setLocation(TableRowPanelImpl.this.allDelivered.getX() + TableRowPanelImpl.this.allDelivered.getWidth() + TableRowPanelImpl.this.getModel().getParentModel().getTable().getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImpl.this.isChecked.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImpl.this.isChecked.setSize(TableRowPanelImpl.this.isChecked.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (Boolean.TRUE.equals(TableRowPanelImpl.this.settings.getShowImageOnRequisitionWorkTools())) {
                return new Dimension(0, 70);
            }
            return new Dimension(0, TableRowPanelImpl.this.getDefaultRowHeight());
        }
    }
}

