/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.sob.crewmember;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.SalesOnBoardServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberLight;
import ch.icit.pegasus.server.core.dtos.sob.MoneyTypComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SOBCrewMemberToolComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private final FlightLight flightLight;
    private Node<List<CrewMemberLight>> crewList;
    private Table2 table;
    private boolean isLoadingRemains = false;

    public SOBCrewMemberToolComponent(FlightLight flightLight) {
        super(false, false);
        this.flightLight = flightLight;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.setOkButtonText(Words.SAVE);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List crewMembers = ((SalesOnBoardServiceManager)ServiceManagerRegistry.getService(SalesOnBoardServiceManager.class)).getCrewMembers(new FlightReference(SOBCrewMemberToolComponent.this.flightLight.getId())).getList();
                SOBCrewMemberToolComponent.this.crewList = INodeCreator.getDefaultImpl().createNodes(crewMembers, true);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(MoneyTypComplete.class);
                return SOBCrewMemberToolComponent.this.crewList;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SOBCrewMemberToolComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            this.removeAnimation(false);
            this.createInners();
            this.table.getModel().setNode(node);
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new Table2(true, Words.ADD, true, false);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SOBCrewMemberToolComponent.this.crewList.addChild((Node)new DTOProxyNode(), 0L);
            }

            @Override
            public void childRemoved() {
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, 120, Integer.MAX_VALUE, 120));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return WordsToolkit.toUpperCase((String)Words.ARTICLE_NAME);
    }

    @Override
    protected String getFinishedText() {
        return Words.DATA_SAVED;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_DATA;
        }
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleValue() {
        return this.flightLight.getOutboundCode();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            this.popup.hidePopUp(new Object[0]);
        } else if (isOK == PopupAction.OK_FOREGROUND) {
            List<ScreenValidationObject> errors = this.validateBeforePrint();
            if (!errors.isEmpty()) {
                InnerPopupFactory.showErrorDialog(errors, "Unable to save", (Component)this);
                return;
            }
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    SOBCrewMemberToolComponent.this.ensureAnimation();
                    SOBCrewMemberToolComponent.this.setEnabled(false);
                    SOBCrewMemberToolComponent.this.crewList.commitThis();
                    List v = (List)SOBCrewMemberToolComponent.this.crewList.getValue();
                    Iterator it = v.iterator();
                    while (it.hasNext()) {
                        CrewMemberLight crew = (CrewMemberLight)it.next();
                        if (crew != null) continue;
                        it.remove();
                    }
                    ((SalesOnBoardServiceManager)ServiceManagerRegistry.getService(SalesOnBoardServiceManager.class)).updateCrewMember(new FlightReference(SOBCrewMemberToolComponent.this.flightLight.getId()), new ListWrapper(v));
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            SOBCrewMemberToolComponent.this.popup.hidePopUp(new Object[0]);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Error while saving", (Component)SOBCrewMemberToolComponent.this);
                            SOBCrewMemberToolComponent.this.popup.hidePopUp(new Object[0]);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.table != null) {
            for (Table2RowPanel row : this.table.getRows()) {
                if (!row.isInnerComponent(c)) continue;
                return true;
            }
        }
        return super.isInnerComponent(c);
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        HashSet<CrewMemberLight> crews = new HashSet<CrewMemberLight>();
        if (this.table != null && this.table.getRows() != null) {
            for (Table2RowPanel p : this.table.getRows()) {
                CrewMemberLight cm = (CrewMemberLight)p.getModel().getNode().getValue();
                if (crews.add(cm) || cm == null) continue;
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Crew Member " + cm.getCrewID() + " is added twice"));
            }
        }
        return o;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<CrewMemberLight> crew;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.crew = SearchTextField2Factory.getCrewSearchField(true, this.model.getNode());
            this.crew.setAdditionalSearchField(false);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.add(this.crew);
            this.add(this.delete);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return this.crew.isInnerComponent(c);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.crew.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.crew.kill();
            this.delete.kill();
            this.crew = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.getModel().getParentModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.crew.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.crew.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.crew.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.crew.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = SOBCrewMemberToolComponent.this.layoutInheritedComponents(parent);
            if (SOBCrewMemberToolComponent.this.table != null) {
                SOBCrewMemberToolComponent.this.table.setLocation(SOBCrewMemberToolComponent.this.border, SOBCrewMemberToolComponent.this.border);
                SOBCrewMemberToolComponent.this.table.setSize(parent.getWidth() - 2 * SOBCrewMemberToolComponent.this.border, parent.getHeight() - SOBCrewMemberToolComponent.this.border);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SOBCrewMemberToolComponent.this.getInheritedComponentsHeight() + SOBCrewMemberToolComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

