/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MessageProvidedRowEditor<T extends IDTO>
extends RowEditor<T> {
    private static final long serialVersionUID = 1L;
    private static final int SAVE_STATE_MESSAGE_DRIVEN = 34;
    protected int currentSaveState = -1;
    private boolean errorsAreOrdered = false;
    private final String currenMessageSuffix;
    private boolean hadErrors;
    private String validationMessageText = "";

    public MessageProvidedRowEditor(RowModel<T> model, String messageSuffix) {
        super(model);
        this.currenMessageSuffix = messageSuffix;
    }

    public void orderErrors(boolean b) {
        this.errorsAreOrdered = b;
    }

    public void doRemoteValidation() {
        String t = this.model.getParentModel().getDataHandler().getRemoteValidationText();
        if (t != null) {
            this.setEnabled(false);
            this.showCommittingAnimation(t);
            this.model.getParentModel().getDataHandler().doRemoteValidation(this.model.getNode(), new RemoteLoader(){

                public void remoteObjectLoaded(Node<?> node) {
                    MessageProvidedRowEditor.this.hideCommittingAnimation();
                    if (node != null && node.getValue() != null && node.getValue() instanceof List) {
                        List l = (List)node.getValue();
                        if (ScreenValidationObject.isError((List)l)) {
                            InnerPopupFactory.showErrorDialog((List<ScreenValidationObject>)l, "", new InnerPopUpListener2(){

                                @Override
                                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                                    MessageProvidedRowEditor.this.setEnabled(true);
                                }
                            }, (Component)MessageProvidedRowEditor.this);
                        } else {
                            InnerPopupFactory.showMessageDialog((List<ScreenValidationObject>)l, MessageProvidedRowEditor.this.getValidationMessageText(), new InnerPopUpListener2(){

                                @Override
                                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                                    if (xargs == null) {
                                        MessageProvidedRowEditor.this.setEnabled(true);
                                        return;
                                    }
                                    MessageProvidedRowEditor.this.doContinueAfterValidation();
                                }
                            }, (Component)MessageProvidedRowEditor.this);
                        }
                    } else {
                        MessageProvidedRowEditor.this.doContinueAfterValidation();
                    }
                }

                public void errorOccurred(ClientException exception) {
                    MessageProvidedRowEditor.this.errorOccurred(exception);
                }
            }, this.model.getParentModel().getTable().getLoadingAnimation(), false);
        } else {
            this.doContinueAfterValidation();
        }
    }

    protected void doContinueAfterValidation() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        for (Component com : this.getComponents()) {
            List<RemoteCommitter> b;
            if (!(com instanceof DetailsEditorParagraph) || (b = ((DetailsEditorParagraph)((Object)com)).commitParagraph()) == null) continue;
            for (RemoteCommitter commiters : b) {
                if (!(commiters instanceof FileCommitter) || ((FileCommitter)commiters).getFile() == null) continue;
                a.add(commiters);
            }
        }
        this.model.getNode().removeAllListenersRecursivley();
        this.model.getNode().commit(this.model.getParentModel().getDataHandler().getCommittingClass(), (Map)this.mapping);
        if (a != null && a.size() > 0) {
            for (RemoteCommitter c : a) {
                this.remoteCommitter.add(c);
            }
            this.invokeCommitter();
        } else {
            this.fileUploaded(null, null);
        }
    }

    private void doRest() {
        this.showCommittingAnimation(Words.SAVE_DATA);
        if (this.model.getParentModel().isSaveInTable() || this.model.isAddRow() && !this.isInnerElement()) {
            if (this.model.getNode() != null) {
                this.model.getParentModel().block4Saving(true);
                this.setComponentsEnabled(false);
                this.doRemoteValidation();
            }
        } else {
            if (this.model.isAddRow()) {
                this.model.setCurrentState(3);
            }
            this.model.getNode().commit(this.model.getParentModel().getDataHandler().getCommittingClass(), (Map)this.mapping);
            this.model.remoteObjectLoaded(this.model.getNode());
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null || this.hadErrors) {
            this.enableCancelButton(true);
            this.hadErrors = false;
            this.setEnabled(true);
            return;
        }
        this.hadErrors = false;
        if (this.currentSaveState == 0) {
            this.enableSaveButton(false);
            this.doRest();
        } else {
            super.popUpClosed(source, xargs);
        }
    }

    @Override
    public void doSave(List<ScreenValidationObject> o) {
        this.currentSaveState = 0;
        if (o != null && !o.isEmpty()) {
            boolean isError;
            this.nextTool2Open = null;
            this.hideCommittingAnimation();
            this.hadErrors = isError = ScreenValidationObject.isFatal(o);
            if (!isError) {
                InnerPopupFactory.showWarningDialog(o, "Warning", "Review", this.currenMessageSuffix, this, this);
            } else {
                InnerPopupFactory.showErrorDialog(o, "Unable to save", (Component)this);
            }
        } else {
            this.currentSaveState = -1;
            this.doRest();
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            this.showCommittingAnimation("Validate Data");
            this.doValidation();
        } else if (source == this.cancel) {
            this.setEnabled(false);
            this.currentSaveState = -1;
            if (this.getModel().getNode() != null && this.getModel().getNode().hasDataChanged(new HashSet())) {
                InnerPopupFactory.CANCEL_TYPES type = InnerPopupFactory.CANCEL_TYPES.CANCEL_NORMAL;
                if (this.overrideType != null) {
                    type = this.overrideType;
                } else if (this.model.isAddRow()) {
                    type = InnerPopupFactory.CANCEL_TYPES.CANCEL_ADD;
                }
                InnerPopupFactory.showEnsureCancelPopup(this.cancel, x, y, this, type);
            } else {
                Object[] o = new Object[]{};
                this.popUpClosed(null, o);
            }
        }
    }

    public String getValidationMessageText() {
        return this.validationMessageText;
    }

    public void setValidationMessageText(String validationMessageText) {
        this.validationMessageText = validationMessageText;
    }
}

