/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.AttributeConvertingDescriptor;
import ch.icit.pegasus.client.gui.table.CellFactory;
import ch.icit.pegasus.client.gui.table.HiddenHeaderRowPanel;
import ch.icit.pegasus.client.gui.table.HiddenRowPanel;
import ch.icit.pegasus.client.gui.table.RowFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.RowSelectionListener;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableAddRemoveRowListener;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.attributedescriptors.NextExpiryDescriptor;
import ch.icit.pegasus.client.gui.table.attributedescriptors.StoreValueDescriptor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO_;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO_;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;

public class TableModel<T extends IUniversal, E extends Enum<E>>
implements AttributeListener,
NodeListener,
RemoteLoader,
Killable {
    private Table<T, E> table;
    private List<TableColumnInfo> columnInfo = new ArrayList<TableColumnInfo>();
    private RowFactory<T, E> rowFactory;
    private List<RowModel<T>> models = new ArrayList<RowModel<T>>();
    private RowModel headerModel;
    private RowModel<T> addRow;
    private List<Integer> currentColumnWidth;
    private boolean isSaveInTable = true;
    private List<RemoteLoader> dataLoadingListeners = new ArrayList<RemoteLoader>();
    private List<RowSelectionListener> listeners = new ArrayList<RowSelectionListener>();
    private List<TableAddRemoveRowListener> addremoveRowListeners = new ArrayList<TableAddRemoveRowListener>();
    private RowModel<T> selectedModel;
    private RowPanel<T> expandedRowPanel;
    private Component parentView;
    private IDataHandler dataHandler;
    private long animationTime;
    private Timer animationTimer;
    private boolean hasCellEditors;
    private Node rootDTO;
    private int rowCount = 0;
    private Comparator defaultComparator;
    private int collapsedRowHeight = 30;
    private int collapsedTitleHeight = 12;
    private List<RowPanel<T>> viewableRows = new ArrayList<RowPanel<T>>();
    private boolean isModal = true;
    private boolean isKilled;
    private boolean isDeleteAllowed;

    public TableModel(Table<T, E> table, Component parentView, RowFactory<T, E> rowFactory, IDataHandler dataHandler, List<TableColumnInfo> infos) {
        this(table, parentView, rowFactory, dataHandler, true, infos);
    }

    public TableModel(Table<T, E> table, Component parentView, RowFactory<T, E> rowFactory, IDataHandler dataHandler, boolean hasAddRow, List<TableColumnInfo> infos) {
        this(table, parentView, rowFactory, dataHandler, hasAddRow, true, infos);
    }

    public TableModel(Table<T, E> table, Component parentView, RowFactory<T, E> rowFactory, IDataHandler dataHandler, boolean hasAddRow, boolean canDelete, List<TableColumnInfo> infos) {
        this.table = table;
        this.rowFactory = rowFactory;
        this.dataHandler = dataHandler;
        this.parentView = parentView;
        this.isDeleteAllowed = canDelete;
        this.table.setModel(this);
        if (this.dataHandler != null) {
            this.dataHandler.setModel(this);
        }
        this.attributeChanged("All attributes changed");
        this.currentColumnWidth = new ArrayList<Integer>();
        for (TableColumnInfo tableColumnInfo : infos) {
            this.columnInfo.add(tableColumnInfo);
            this.currentColumnWidth.add(tableColumnInfo.getPreferredWidth());
        }
        this.installHeader(hasAddRow);
        if (hasAddRow) {
            this.installAddRow();
        }
    }

    public boolean isDeleteAllowed() {
        return this.isDeleteAllowed;
    }

    private Object getData4String(String name, TableColumnInfo info, Node node) {
        Node n = node;
        if (name.equals("")) {
            Converter c = ConverterRegistry.getConverter((Class)info.getBasicColumnClass());
            if (c != null) {
                return c.convert(null, node, new Object[0]);
            }
            return null;
        }
        Object m = null;
        if (info.isNodeValue()) {
            if (n.getChildNamed(new String[]{name}) != null) {
                m = n.getChildNamed(new String[]{name}).getValue();
            }
        } else {
            m = n.getValueForNamed(name);
        }
        if (m == null) {
            return null;
        }
        Converter c = ConverterRegistry.getConverter((Class)info.getBasicColumnClass());
        if (c != null) {
            return c.convert(m, node, new Object[0]);
        }
        return m.toString();
    }

    public Object getData(TableColumnInfo info, Node node) {
        String attName = info.getAttributeName();
        if (attName == null) {
            if (info.getBasicColumnClass().equals(String.class)) {
                return "-";
            }
            if (info.getBasicColumnClass().equals(Date.class)) {
                throw new NullPointerException("info.getBasicColumnClass is Date, create new one");
            }
        } else {
            int s = attName.indexOf("&");
            if (s != -1) {
                String[] splits = attName.split("&");
                if (node != null) {
                    splits[0] = (String)this.getData4String(splits[0], info, node);
                    splits[1] = (String)this.getData4String(splits[1], info, node);
                    return splits;
                }
                return "-";
            }
            s = attName.indexOf("$");
            if (s != -1) {
                String[] splits = attName.split("\\$");
                Object[] values = new Object[splits.length];
                Node n = node;
                for (int i = 0; i < values.length; ++i) {
                    Object m = n.getValueForNamed(splits[i]);
                    if (m == null) continue;
                    values[i] = m;
                }
                return values;
            }
            s = attName.indexOf("%");
            if (s != -1) {
                String descriptorName = "";
                int e = attName.indexOf("%", s + 1);
                if (e != -1) {
                    descriptorName = attName.substring(s + 1, e);
                    String subAttName = attName.substring(e + 1, attName.length());
                    AttributeConvertingDescriptor descr = null;
                    if (descriptorName.equals("NextExpiryDescriptor")) {
                        descr = new NextExpiryDescriptor();
                    } else if (descriptorName.equals("StoreValueDescriptor")) {
                        descr = new StoreValueDescriptor();
                    } else {
                        return "-";
                    }
                    Object o = descr.convert(this.getNode(), attName, subAttName);
                    if (o == null) {
                        return "-";
                    }
                    return o;
                }
            }
            if ((s = attName.indexOf("#")) != -1) {
                String split = attName.substring(1, attName.length());
                if (node != null) {
                    Object o = this.getData4String(split, info, node);
                    if (o == null) {
                        return "-";
                    }
                    return o;
                }
                return "-";
            }
            s = attName.indexOf("-");
            if (s != -1) {
                String[] splits = attName.split("-");
                if (node != null) {
                    Object t = this.getData4String(splits[0], info, node);
                    Object t2 = this.getData4String(splits[1], info, node);
                    if (t == null || t2 == null) {
                        return "-";
                    }
                    return t + " - " + t2;
                }
                return "-";
            }
            if (node != null) {
                if (attName.isEmpty()) {
                    return node.getValue();
                }
                Object o = this.getData4String(attName, info, node);
                return o;
            }
        }
        return "-";
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.columnInfo.clear();
        this.columnInfo = null;
        this.rowFactory = null;
        this.models.clear();
        this.models = null;
        this.headerModel = null;
        this.addRow = null;
        this.currentColumnWidth.clear();
        this.currentColumnWidth = null;
        this.dataLoadingListeners.clear();
        this.dataLoadingListeners = null;
        this.listeners.clear();
        this.listeners = null;
        this.addremoveRowListeners.clear();
        this.addremoveRowListeners = null;
        this.selectedModel = null;
        this.expandedRowPanel = null;
        this.parentView = null;
        this.dataHandler = null;
        this.animationTimer = null;
        if (this.rootDTO != null) {
            this.rootDTO.removeNodeListenerRecursively((NodeListener)this);
        }
        this.rootDTO = null;
        this.defaultComparator = null;
        this.viewableRows.clear();
        this.viewableRows = null;
        this.table = null;
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }

    public void setDataHandler(IDataHandler dh) {
        this.dataHandler = dh;
        this.dataHandler.setModel(this);
    }

    public void addAddRemoveRowListener(TableAddRemoveRowListener l) {
        if (!this.addremoveRowListeners.contains(l)) {
            this.addremoveRowListeners.add(l);
        }
    }

    public int getColumnIndex4Enum(Enum<?> e) {
        int j = 0;
        for (TableColumnInfo i : this.columnInfo) {
            if (i.getColumnAttribute() != null && i.getColumnAttribute().equals(e)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public void removeAddRemoveRowListeners(TableAddRemoveRowListener l) {
        this.addremoveRowListeners.remove(l);
    }

    private void fireEvent(boolean isAdd, RowModel<T> m) {
        for (TableAddRemoveRowListener l : this.addremoveRowListeners) {
            if (isAdd) {
                l.rowAdded(m);
                continue;
            }
            l.rowRemoved(m);
        }
    }

    public Object getInnerSelectedDTO() {
        if (this.expandedRowPanel != null) {
            return this.expandedRowPanel.getModel().getInnerSelectedDTO();
        }
        if (this.selectedModel != null) {
            return this.selectedModel.getInnerSelectedDTO();
        }
        return null;
    }

    public Converter getConverter() {
        return null;
    }

    public int getCollapsedRowHeight() {
        return this.collapsedRowHeight;
    }

    public Comparator getDefaultComparator() {
        return this.defaultComparator;
    }

    public void setDefaultComparator(Comparator defaultComparator) {
        this.defaultComparator = defaultComparator;
    }

    public boolean isSaveInTable() {
        return this.isSaveInTable;
    }

    public void setSaveInTable(boolean isSaveInTable) {
        this.isSaveInTable = isSaveInTable;
    }

    public void setCollapsedRowHeight(int collapsedRowHeight) {
        this.collapsedRowHeight = collapsedRowHeight;
    }

    public int getCollapsedTitleHeight() {
        return this.collapsedTitleHeight;
    }

    public void setCollapsedTitleHeight(int collapsedTitleHeight) {
        this.collapsedTitleHeight = collapsedTitleHeight;
    }

    public void loadData() {
        this.dataHandler.loadMasterData(this.dataHandler.getLoadingID(), null, this.table.getLoadingAnimation());
    }

    protected void installDataTable() {
        if (this.rootDTO != null) {
            this.rootDTO.removeNodeListener((NodeListener)this);
            this.rootDTO.addNodeListener((NodeListener)this);
        }
    }

    public void setModal(boolean b) {
        this.isModal = b;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void addRemoteLoaderListener(RemoteLoader l) {
        this.dataLoadingListeners.add(l);
    }

    public void removeRemoteLoaderListener(RemoteLoader l) {
        this.dataLoadingListeners.remove(l);
    }

    private void fireEvent(Node n) {
        for (RemoteLoader l : this.dataLoadingListeners) {
            l.remoteObjectLoaded(n);
        }
    }

    public void setSelectedModel(RowModel<T> sm, boolean isSilent) {
        if (this.expandedRowPanel != null) {
            return;
        }
        if (this.selectedModel != null && this.selectedModel.getView() != null) {
            if (this.selectedModel.getView().isExpanded()) {
                return;
            }
            this.selectedModel.select(false);
        }
        this.selectedModel = sm;
        if (this.selectedModel != null && this.selectedModel.getView() != null) {
            this.selectedModel.select(true);
        }
        if (!isSilent && this.selectedModel != null) {
            this.fireSelectionEvent(this.selectedModel);
        }
    }

    public Node getNode() {
        return this.rootDTO;
    }

    public IDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public void setHasCellEditors(boolean b) {
        this.hasCellEditors = b;
    }

    public boolean hasCellEditors() {
        return this.hasCellEditors;
    }

    public void mergeData(Node<?> newDTOs) {
        ArrayList<RowModel<T>> usedModels = new ArrayList<RowModel<T>>();
        usedModels.addAll(this.models);
        Iterator it = newDTOs.getChilds();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Node node2 = node.getChildNamed(ADTO_.id);
            if (node2 == null || node2.getValue() == null) continue;
            RowModel<T> foundRowModel = this.update4Id((Long)node2.getValue(), node);
            if (foundRowModel == null) {
                this.childAdded(newDTOs, node);
                continue;
            }
            usedModels.remove(foundRowModel);
        }
        for (RowModel rowModel : usedModels) {
            this.table.removeRow(rowModel.getView());
        }
        if (this.rootDTO != null) {
            this.rootDTO.removeNodeListener((NodeListener)this);
        }
        this.rootDTO = newDTOs;
        this.rootDTO.addNodeListener((NodeListener)this);
    }

    private RowModel<T> update4Id(long id, Node node) {
        for (RowModel<T> model : this.models) {
            Node nodeId;
            Node nn = model.getNode();
            if (!(nn instanceof Node) || (nodeId = nn.getChildNamed(ADTO_.id)).getValue() == null || (Long)nodeId.getValue() != id) continue;
            model.mergeNode(node);
            return model;
        }
        return null;
    }

    private void propagteColumnWidth(boolean updateViewImediate) {
        if (this.headerModel != null) {
            this.headerModel.propagateColumnWidth(updateViewImediate);
            ((HiddenHeaderRowPanel)this.headerModel.getView()).getHiddenEditor().getModel().propagateColumnWidth(updateViewImediate);
        }
        for (RowModel<T> row : this.models) {
            row.propagateColumnWidth(updateViewImediate);
        }
    }

    public ArrayList<RowPanel<T>> getRowsThreadSafe() {
        return this.table.getRowsThreadSafe();
    }

    public ArrayList<RowPanel<T>> getRows() {
        return this.table.getRows();
    }

    public void setViewableRows(List<RowPanel<T>> rows) {
        this.viewableRows = rows;
        this.updateOrder();
        this.table.updateViewableRows(this.viewableRows);
    }

    private void updateOrder() {
        if (this.defaultComparator != null) {
            Collections.sort(this.viewableRows, this.defaultComparator);
        }
    }

    public List<RowPanel<T>> getViewableRows() {
        return this.viewableRows;
    }

    public void addRowSelectionListener(RowSelectionListener l) {
        this.listeners.add(l);
    }

    public void removeRowSelectionListener(RowSelectionListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionEvent(RowModel<T> model) {
        for (RowSelectionListener l : this.listeners) {
            l.rowSelected(model, this.table);
        }
    }

    public RowModel<T> getExpandedModel() {
        if (this.expandedRowPanel != null) {
            return this.expandedRowPanel.getModel();
        }
        return null;
    }

    public boolean isARowExpanded() {
        return this.expandedRowPanel != null;
    }

    protected boolean expandRow(RowPanel<T> panel) {
        if (this.expandedRowPanel != null) {
            return false;
        }
        if (this.selectedModel != panel.getModel()) {
            this.setSelectedModel(panel.getModel(), true);
        }
        if (panel.isHidden()) {
            this.table.switchHeaders(true);
        }
        this.disableRows(panel, true);
        if (this.table.getOutSideConnection() != null) {
            this.table.getOutSideConnection().configureHUDButtons(false);
        }
        this.expandedRowPanel = panel;
        return true;
    }

    public void block4Saving(boolean isSaveing) {
    }

    private void disableRows(RowPanel<T> panel, boolean isDisabled) {
        for (RowModel<T> model : this.models) {
            if (model.getView() != panel) {
                model.getView().setDisabled(isDisabled);
                continue;
            }
            model.getView().disableSmartButtons(isDisabled);
        }
        if (this.addRow != null && ((HiddenRowPanel)this.addRow.getView()).getHiddenEditor() == null) {
            this.addRow.getView().setDisabled(isDisabled);
        } else if (this.addRow != null && ((HiddenRowPanel)this.addRow.getView()).getHiddenEditor() != panel) {
            this.addRow.getView().setDisabled(isDisabled);
        } else if (this.addRow != null) {
            // empty if block
        }
        this.parentView.setEnabled(!isDisabled);
    }

    protected void colapseRow(RowPanel<T> panel) {
        if (this.expandedRowPanel == panel) {
            this.selectedModel = this.expandedRowPanel.getModel();
            this.expandedRowPanel = null;
        }
        this.table.requestFocusInWindow();
        this.disableRows(null, false);
        if (this.table.getOutSideConnection() != null) {
            this.table.getOutSideConnection().configureHUDButtons(true);
        }
    }

    protected Timer getAnimationTimer(ActionListener listener) {
        this.ensureAnimationTimer(listener);
        return this.animationTimer;
    }

    protected void tryToStopAnimationTimer(ActionListener listener) {
        if (this.animationTimer != null) {
            this.animationTimer.removeActionListener(listener);
            if (((ActionListener[])this.animationTimer.getListeners(ActionListener.class)).length == 0) {
                this.animationTimer.stop();
                this.animationTimer = null;
            }
        }
    }

    protected int getIndex4TableColumnInfo(TableColumnInfo columnInfo) {
        return this.columnInfo.indexOf(columnInfo);
    }

    protected int getColumnIndex4X(int x) {
        int currentX = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (x > currentX && x < currentX + this.currentColumnWidth.get(i)) {
                return i;
            }
            currentX += this.currentColumnWidth.get(i).intValue();
        }
        return -1;
    }

    protected void callBackRelayout() {
        this.table.callBack4Layout();
    }

    private void ensureAnimationTimer(ActionListener listener) {
        if (this.animationTimer == null) {
            this.animationTimer = new Timer(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationRate")), listener);
        } else {
            this.animationTimer.addActionListener(listener);
        }
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    public int ensureColumnWidths(int columnIndex, int newWidth, boolean dontUseViewPort, boolean imediateUpdate) {
        if (columnIndex == -1) {
            int viewPortSpace = this.table.getViewableWidth(false);
            if (dontUseViewPort) {
                viewPortSpace = newWidth;
            }
            int currentWidth = 0;
            for (Integer width : this.currentColumnWidth) {
                currentWidth += width.intValue();
            }
            switch (this.table.getPossibleSmartIcons()) {
                case ONE: {
                    Skin1Field f = (Skin1Field)DefaultSkins.TableSingleSubModuleBackgroundIcon.createDynamicSkin();
                    viewPortSpace -= f.getImage(Button.ButtonState.UP).getWidth();
                    break;
                }
                case TWO: {
                    Skin1Field f = (Skin1Field)DefaultSkins.TableSubModuleBackgroundIcon.createDynamicSkin();
                    viewPortSpace -= f.getImage(Button.ButtonState.UP).getWidth();
                    f = (Skin1Field)DefaultSkins.TableSubModulePopupIcon.createDynamicSkin();
                    viewPortSpace -= f.getImage(Button.ButtonState.UP).getWidth();
                    break;
                }
            }
            if (currentWidth >= viewPortSpace) {
                int diff = currentWidth - viewPortSpace;
                int down = diff / this.currentColumnWidth.size();
                ArrayList<Integer> columnsToResize = new ArrayList<Integer>();
                int count = 0;
                do {
                    columnsToResize.clear();
                    ++count;
                    for (int i = 0; i < this.currentColumnWidth.size(); ++i) {
                        if (this.currentColumnWidth.get(i) - down >= this.columnInfo.get(i).getMinWidth()) {
                            columnsToResize.add(i);
                            this.currentColumnWidth.set(i, this.currentColumnWidth.get(i) - down);
                            if ((diff -= down) != 0) continue;
                            this.propagteColumnWidth(imediateUpdate);
                            return 0;
                        }
                        this.currentColumnWidth.set(i, this.columnInfo.get(i).getMinWidth());
                        if ((diff -= this.currentColumnWidth.get(i) - this.columnInfo.get(i).getMinWidth()) != 0) continue;
                        this.propagteColumnWidth(imediateUpdate);
                        return 0;
                    }
                    if (columnsToResize.size() > 0) {
                        down = diff / columnsToResize.size();
                    }
                    if (down >= 1) continue;
                    down = 1;
                } while (columnsToResize.size() > 0 && diff > 0);
            } else if (currentWidth <= viewPortSpace) {
                int diff = viewPortSpace - currentWidth;
                int up = diff / this.currentColumnWidth.size();
                ArrayList<Integer> columnsToResize = new ArrayList<Integer>();
                int count = 0;
                do {
                    ++count;
                    columnsToResize.clear();
                    for (int i = 0; i < this.currentColumnWidth.size(); ++i) {
                        if (this.currentColumnWidth.get(i) + up <= this.columnInfo.get(i).getMaxWidth()) {
                            columnsToResize.add(i);
                            this.currentColumnWidth.set(i, this.currentColumnWidth.get(i) + up);
                            if ((diff -= up) != 0) continue;
                            this.propagteColumnWidth(imediateUpdate);
                            return 0;
                        }
                        this.currentColumnWidth.set(i, this.columnInfo.get(i).getMaxWidth());
                        if ((diff -= this.columnInfo.get(i).getMaxWidth() - this.currentColumnWidth.get(i)) != 0) continue;
                        this.propagteColumnWidth(imediateUpdate);
                        return 0;
                    }
                    if (columnsToResize.size() > 0) {
                        up = diff / columnsToResize.size();
                    }
                    if (up >= 1) continue;
                    up = 1;
                } while (columnsToResize.size() > 0 && diff > 0);
            }
            this.propagteColumnWidth(imediateUpdate);
            return 0;
        }
        TableColumnInfo column = this.getColumnInfo(columnIndex);
        if (column.getMaxWidth() < newWidth) {
            this.currentColumnWidth.set(columnIndex, column.getMaxWidth());
        } else if (column.getMinWidth() > newWidth) {
            this.currentColumnWidth.set(columnIndex, column.getMinWidth());
        } else {
            this.currentColumnWidth.set(columnIndex, newWidth);
        }
        this.propagteColumnWidth(imediateUpdate);
        this.table.layoutRows();
        return 0;
    }

    protected void horizontalScrollValueChanged() {
        if (this.headerModel != null) {
            this.headerModel.updateView();
        }
    }

    protected int getRowWidth() {
        int w = 0;
        for (int i = 0; i < this.currentColumnWidth.size(); ++i) {
            w += this.currentColumnWidth.get(i).intValue();
        }
        return w;
    }

    protected int getHorizontalScrollOffSet() {
        int v = 0;
        if (this.table.getHorizontalScrollBar() != null) {
            v = this.table.getHorizontalScrollBar().getValue();
        }
        return v;
    }

    public void installHeader(boolean hasAddRow) {
        this.headerModel = this.rowFactory.getRowModel(this, true, null);
        HiddenRowPanel header = (HiddenRowPanel)this.rowFactory.getHeaderRowPanel(this.headerModel);
        header.setModel(this.headerModel);
        this.headerModel.setView(header);
        this.headerModel.setParentModel(this);
        this.headerModel.setCellFactory(new CellFactory());
        if (hasAddRow) {
            this.table.setHeaderRow(header, header.getHiddenEditor());
        } else {
            this.table.setHeaderRow(header, null);
        }
        this.headerModel.fetchData();
    }

    public void removeAddRow() {
        this.addRow.kill();
        this.addRow = null;
    }

    public void installAddRow() {
        this.addRow = this.rowFactory.getRowModel(this, false, null);
        HiddenRowPanel addRowPanel = (HiddenRowPanel)this.rowFactory.getRowPanel(this.addRow, true, false);
        addRowPanel.setModel(this.addRow);
        this.addRow.setAddRow(true);
        this.addRow.setView(addRowPanel);
        this.addRow.setParentModel(this);
        this.table.setAddRow(addRowPanel, addRowPanel.getHiddenEditor());
    }

    protected void removeRow(final RowPanel row) {
        boolean isSelection = false;
        int currentIndex = 0;
        if (row.getModel() == this.selectedModel) {
            isSelection = true;
            currentIndex = this.table.getRows().indexOf(row);
        }
        switch (MainFrame.usedState) {
            case FADIN: {
                this.table.removeRow(row);
                this.models.remove(row.getModel());
                this.viewableRows.remove(row);
                row.kill();
                this.table.layoutRows();
                --this.rowCount;
                break;
            }
            case MOVEIN: {
                row.setRemoved(true);
                row.setRemoveIndex(this.viewableRows.indexOf(row));
                row.getFader().addAnimationListener(new AnimationListener(){

                    @Override
                    public void animationFinished(boolean wasFadin) {
                        TableModel.this.table.removeRow(row);
                        TableModel.this.models.remove(row.getModel());
                        TableModel.this.viewableRows.remove(row);
                        row.getModel().kill();
                        TableModel.this.table.layoutRows();
                        TableModel.this.rowCount--;
                    }
                });
                row.setLocationSmooth(-1 * row.getWidth(), row.getY());
                row.setProgress(1.0f);
                row.getFader().fadeOut(false);
                break;
            }
        }
    }

    private RowModel hasGUIRepresentation(Node child) {
        if (this.models != null) {
            for (RowModel<T> m : this.models) {
                if (m.getNode() == child) {
                    return m;
                }
                if (m.getNode() == null || m.getNode().getValue() == null || child == null || !m.getNode().getValue().equals(child.getValue())) continue;
                return m;
            }
        }
        return null;
    }

    protected void addRow(int dy, Node child) {
        RowModel m = this.hasGUIRepresentation(child);
        if (m == null && this.rowFactory != null) {
            Boolean deleted;
            RowModel<T> aModel = this.rowFactory.getRowModel(this, false, child);
            boolean isDeleted = false;
            Node dc = child.getChildNamed(ADeletableDTO_.isDeleted);
            if (dc != null && (deleted = (Boolean)dc.getValue()) != null) {
                isDeleted = deleted;
            }
            RowPanel<T> aPanel = this.rowFactory.getRowPanel(aModel, false, isDeleted);
            aPanel.setModel(aModel);
            aModel.setView(aPanel);
            aModel.setParentModel(this);
            aModel.setCellFactory(new CellFactory());
            this.models.add(aModel);
            this.viewableRows.add(aPanel);
            aModel.fetchData();
            aModel.propagateColumnWidth(false);
            ++this.rowCount;
            this.updateOrder();
            aPanel.setEnabled(this.table.isEnabled());
            this.table.addRow(dy, aPanel);
            aPanel.configureSmartButtons();
            this.fireEvent(true, aModel);
        } else if (m != null) {
            m.mergeNode(child, true);
        }
    }

    public TableColumnInfo getColumnInfo(int index) {
        if (index != -1 && this.columnInfo.size() > index) {
            return this.columnInfo.get(index);
        }
        return null;
    }

    public Table<T, E> getTable() {
        return this.table;
    }

    protected void fetchData() {
        if (this.rootDTO != null) {
            this.rootDTO.getAllChildAddEvents((NodeListener)this);
        }
    }

    public void setTable(Table<T, E> table) {
        this.table = table;
    }

    public RowFactory<T, E> getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(RowFactory<T, E> rowFactory) {
        this.rowFactory = rowFactory;
    }

    public RowModel getHeaderModel() {
        return this.headerModel;
    }

    public int getColumnWidth(int columnIndex) {
        if (columnIndex == -1) {
            int all = 0;
            for (Integer width : this.currentColumnWidth) {
                all += width.intValue();
            }
            return all;
        }
        return this.currentColumnWidth.get(columnIndex);
    }

    public int getColumnCount() {
        return this.columnInfo.size();
    }

    public long getAnimationTime() {
        return this.animationTime;
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.animationTime = AttributesConverter.getLong4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime"));
            this.collapsedTitleHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_header_rowheight"));
        }
    }

    public void revalidateHeaderValue() {
        if (this.headerModel != null) {
            this.headerModel.revalidateHeaderNames();
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.addRow(this.rowCount, child);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        for (RowModel<T> m : this.models) {
            if (m.getNode() != child) continue;
            this.removeRow(m.getView());
            return;
        }
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void valueChanged(Node<?> node) {
    }

    public Object getSelectedDTO(Class clazz) {
        if (this.expandedRowPanel != null && !this.expandedRowPanel.getModel().isAddRow()) {
            return this.expandedRowPanel.getModel().getNode().getValue(clazz);
        }
        if (this.selectedModel != null && this.selectedModel.getNode() != null && !this.selectedModel.isAddRow()) {
            return this.selectedModel.getNode().getValue(clazz);
        }
        return null;
    }

    public RowModel<T> getSelectedRow() {
        if (this.expandedRowPanel != null) {
            return this.expandedRowPanel.getModel();
        }
        return this.selectedModel;
    }

    public void selectNode(Node node, boolean isSilent) {
        for (RowModel<T> mod : this.models) {
            if (mod.getNode() != node) continue;
            this.setSelectedModel(mod, isSilent);
            return;
        }
        this.setSelectedModel(null, isSilent);
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (this.isKilled()) {
            return;
        }
        if (this.rootDTO == null) {
            this.rootDTO = new Node();
            if (this.addRow != null) {
                this.addRow.resetNode();
            }
            this.installDataTable();
            this.fetchData();
            this.fireEvent(this.rootDTO);
        }
    }

    public void errorOccurred(ClientException exception) {
        if (this.getTable() != null) {
            this.getTable().hideAnimation();
            this.getTable().setEnabled(true);
        }
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), this.getTable());
    }

    public void setNewNode(Node node) {
        if (this.isKilled()) {
            return;
        }
        if (this.rootDTO != null) {
            this.rootDTO.removeNodeListener((NodeListener)this);
            for (RowPanel p : (ArrayList)this.getRows().clone()) {
                this.removeRow(p);
            }
        }
        this.rootDTO = node;
        if (this.addRow != null) {
            this.addRow.resetNode();
        }
        this.installDataTable();
        this.fetchData();
        this.fireEvent(this.rootDTO);
    }

    public void stopAnimationImmediately() {
    }

    protected void panelColapsed(RowPanel<T> rowPanel) {
        if (rowPanel.isHidden()) {
            this.table.switchHeaders(false);
            this.addRow.getView().panelColapsed();
        }
    }

    protected void committingFinished(RowPanel<T> rowPanel) {
        if (this.parentView instanceof ScreenTableView) {
            ((ScreenTableView)this.parentView).commitingFinished();
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        this.addRow(this.rowCount, nodes);
    }

    private void addRow(int rowCount2, Node[] iWriteNodes) {
        int dy = rowCount2;
        for (Node child : iWriteNodes) {
            RowModel m = this.hasGUIRepresentation(child);
            if (m == null) {
                Boolean deleted;
                boolean isDeleted = false;
                Node dc = child.getChildNamed(ADeletableDTO_.isDeleted);
                if (dc != null && (deleted = (Boolean)dc.getValue()) != null) {
                    isDeleted = deleted;
                }
                RowModel<T> aModel = this.rowFactory.getRowModel(this, false, child);
                RowPanel<T> aPanel = this.rowFactory.getRowPanel(aModel, false, isDeleted);
                aPanel.setModel(aModel);
                aModel.setView(aPanel);
                aModel.setParentModel(this);
                aModel.setCellFactory(new CellFactory());
                this.models.add(aModel);
                this.viewableRows.add(aPanel);
                aModel.fetchData();
                ++this.rowCount;
                this.table.addRow(dy, aPanel, false);
                ++dy;
                continue;
            }
            m.mergeNode(child);
        }
        this.updateOrder();
        this.propagteColumnWidth(false);
        this.table.layoutRows();
    }

    public List<TableColumnInfo> getColumnInfos() {
        return this.columnInfo;
    }
}

