/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.StateSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultTwoStateSkin1Field;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewBooleanRenderer
extends CellRenderer
implements AttributeListener {
    private static final long serialVersionUID = 1L;
    private DefaultTwoStateSkin1Field skin;
    private DefaultToggleSkin1Field skin2;
    private int xInsert;
    private Boolean currentState;

    public CellViewBooleanRenderer(Boolean state) {
        this(state, false);
    }

    public CellViewBooleanRenderer(Boolean state, boolean useCheckSkin) {
        this.currentState = state;
        if (useCheckSkin) {
            this.skin2 = (DefaultToggleSkin1Field)DefaultSkins.CheckCrossBoxIcon.createDynamicSkin();
            this.skin = null;
        } else {
            this.skin = (DefaultTwoStateSkin1Field)DefaultSkins.TwoStateIcon.createDynamicSkin();
            this.skin2 = null;
        }
        this.attributeChanged("All attributes changed");
    }

    @Override
    public Dimension getPreferredSize() {
        boolean s = true;
        if (this.currentState != null) {
            s = this.currentState;
        }
        if (this.skin != null) {
            int a = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getWidth();
            int b = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getHeight();
            return new Dimension(a * 4 + 3, b);
        }
        int a = this.skin2.getImage(Button.ButtonState.UP, s).getWidth();
        int b = this.skin2.getImage(Button.ButtonState.UP, s).getHeight();
        return new Dimension(a * 4 + 3, b);
    }

    @Override
    public String getStringValue() {
        return CellViewBooleanRenderer.getValueString(this.currentState);
    }

    public void setCurrentState(Boolean currentState) {
        this.currentState = currentState;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.currentState != null) {
            int currentX = 0;
            int currentY = 0;
            currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
            if (this.skin != null) {
                currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getHeight()) / 2;
                this.skin.paint(g2, currentX, currentY, Button.ButtonState.UP, Boolean.TRUE.equals(this.currentState) ? StateSkin.StateType.Green : StateSkin.StateType.Orange);
            } else {
                currentY = (this.getHeight() - this.skin2.getImage(Button.ButtonState.UP, this.currentState).getHeight()) / 2;
                this.skin2.paint(g2, currentX, currentY, Button.ButtonState.UP, this.currentState);
            }
        }
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public static String getValueString(Boolean currentState2) {
        if (currentState2 == null) {
            return "";
        }
        return currentState2.toString();
    }
}

