/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Component;
import java.sql.Date;
import java.sql.Time;

public class CellViewDateTimeWindowRenderer
extends CellRenderer {
    private Date currentDate;
    private Time windowStartTime;
    private Time windowEndTime;
    private TextLabel label;
    private boolean isHeader;

    public CellViewDateTimeWindowRenderer(Object[] data, boolean isHeader, Component delegate) {
        this.currentDate = (Date)data[0];
        this.windowStartTime = (Time)data[1];
        this.windowEndTime = (Time)data[2];
        this.isHeader = isHeader;
        String t = "";
        if (this.currentDate != null) {
            t = new DateConverter().convert((Object)this.currentDate, null, new Object[0]);
            Date d1 = new Date(this.windowStartTime.getTime());
            Date d2 = new Date(this.windowEndTime.getTime());
            DayTimeConverter c1 = new DayTimeConverter();
            t = t + " " + c1.convert((Object)d1, null, new Object[0]) + " - " + c1.convert((Object)d2, null, new Object[0]);
        }
        this.label = new TextLabel(t);
        this.label.setDelegateComponent(delegate);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.label);
    }

    @Override
    public String getStringValue() {
        return this.label.getText();
    }

    public Object[] getData() {
        Object[] o = new Object[]{this.currentDate, this.windowStartTime, this.windowEndTime};
        return o;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
    }

    @Override
    public void setSize(int w, int h) {
        this.label.setSize(w - 2 * this.label.getX(), h);
        super.setSize(w, h);
    }

    @Override
    protected void layoutCell() {
        if (this.isFirstColumn) {
            this.label.setLocation(this.firstColumnInset, 0);
        } else {
            this.label.setLocation(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")), 0);
        }
    }

    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.setSize(this.getWidth(), this.getHeight());
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.layoutCell();
        }
    }

    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            if (!this.isHeader) {
                this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
            } else {
                this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_table_header_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
                this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_table_header_foreground")));
            }
        }
    }

    public static String getValueString(Object[] value) {
        Date c = (Date)value[0];
        Time ws = (Time)value[1];
        Time we = (Time)value[2];
        String t = "";
        if (c != null) {
            t = new DateConverter().convert((Object)c, null, new Object[0]);
            Date d1 = new Date(ws.getTime());
            Date d2 = new Date(we.getTime());
            DayTimeConverter c1 = new DayTimeConverter();
            t = t + " " + c1.convert((Object)d1, null, new Object[0]) + " - " + c1.convert((Object)d2, null, new Object[0]);
            return t;
        }
        return "";
    }
}

