/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewHandlingCostTypeRenderer
extends CellRenderer {
    private static final long serialVersionUID = 1L;
    private Skin1Field skin;
    private HandlingCostTypeE currentType;

    public CellViewHandlingCostTypeRenderer(HandlingCostTypeE type) {
        this.currentType = type;
        this.setOpaque(false);
        switch (type) {
            case ARTICLE: {
                this.skin = (Skin1Field)DefaultSkins.ArticleIcon.createDynamicSkin();
                break;
            }
            case FLIGHT: {
                this.skin = (Skin1Field)DefaultSkins.AircraftIcon.createDynamicSkin();
                break;
            }
            case PAX: {
                this.skin = (Skin1Field)DefaultSkins.PaxIcon.createDynamicSkin();
                break;
            }
            case PRODUCT: {
                this.skin = (Skin1Field)DefaultSkins.ProductIcon.createDynamicSkin();
                break;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.skin.getImage(Button.ButtonState.UP).getWidth(), this.skin.getImage(Button.ButtonState.UP).getHeight());
    }

    public static int getPreferredWidth() {
        return (int)new CellViewHandlingCostTypeRenderer(HandlingCostTypeE.FLIGHT).getPreferredSize().getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (this.getWidth() - this.skin.getImage(Button.ButtonState.UP).getWidth()) / 2;
        int y = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP).getHeight()) / 2;
        this.skin.paint(g2, x, y, Button.ButtonState.UP);
        this.paintChildren(g2);
    }

    public static String getStringValue(HandlingCostTypeE type) {
        switch (type) {
            case ARTICLE: {
                return "Article";
            }
            case FLIGHT: {
                return "Flight";
            }
            case PAX: {
                return "Pax";
            }
            case PRODUCT: {
                return "Product";
            }
        }
        return "";
    }

    @Override
    public String getStringValue() {
        return CellViewHandlingCostTypeRenderer.getStringValue(this.currentType);
    }
}

