/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.OrderReviewStateSkin;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewOrderReviewStateRenderer
extends CellRenderer
implements AttributeListener,
Stringable {
    private static final long serialVersionUID = 1L;
    private OrderReviewStateSkin skin;
    private OrderReviewStateE currentState;

    public CellViewOrderReviewStateRenderer(OrderReviewStateE state) {
        this.currentState = state;
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(OrderReviewStateSkin.class);
        this.attributeChanged("All attributes changed");
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int h = this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getHeight();
        this.skin.paint(g2, 5, (this.getHeight() - h) / 2, this.getWidth(), Button.ButtonState.UP, (Enum)this.currentState);
        this.paintChildren(g2);
    }

    public OrderReviewStateE getOrderState() {
        return this.currentState;
    }

    @Override
    public Dimension getPreferredSize() {
        int currentX = 0;
        return new Dimension(currentX += this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getWidth() * 3 + 3, this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getHeight());
    }

    public static int getPreferredWidth() {
        return 0;
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.repaint(32L);
        }
    }

    @Override
    public String getStringValue() {
        return this.currentState.toString();
    }

    public static String getValueString(OrderStateE value) {
        return value.toString();
    }
}

