/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.OrderStateSkin;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewOrderStateRenderer
extends CellRenderer
implements AttributeListener,
Stringable {
    private static final long serialVersionUID = 1L;
    private TypedSkin3Field skin;
    private int calculationWarningInset = 8;
    private OrderStateE currentState;
    private boolean hasWarnings = false;

    public CellViewOrderStateRenderer(OrderStateE state) {
        this.currentState = state;
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(OrderStateSkin.class);
        this.attributeChanged("All attributes changed");
    }

    public CellViewOrderStateRenderer(OrderStateE state, RequisitionOrderPositionComplete position) {
        this.currentState = state;
        if (position != null && position.getIncludesMultipleConversions() != null) {
            this.hasWarnings = position.getIncludesMultipleConversions();
        }
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(OrderStateSkin.class);
        this.attributeChanged("All attributes changed");
        if (position != null) {
            this.updateTooltip(position.getConversionWarnings());
        }
    }

    private void updateTooltip(String txt) {
        if (txt != null) {
            this.setToolTipText(txt);
        }
    }

    public OrderStateE getOrderState() {
        return this.currentState;
    }

    @Override
    public Dimension getPreferredSize() {
        int currentX = 0;
        return new Dimension(currentX += this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getWidth() * 3 + 2, this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getHeight());
    }

    public static int getPreferredWidth() {
        return (int)new CellViewOrderStateRenderer(OrderStateE.PENDING).getPreferredSize().getWidth();
    }

    @Override
    public void paint(Graphics g) {
        String t;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 5;
        int y = (this.getHeight() - this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getHeight()) / 2;
        String string = t = this.hasWarnings ? "!" : "";
        if (!t.isEmpty()) {
            g2.setColor(Color.red);
            g2.setFont(AttributesConverter.getDefaultBoldFont());
            g2.drawString(t, currentX, (this.getHeight() + g2.getFont().getSize()) / 2 - 1);
            currentX += this.calculationWarningInset;
        }
        this.skin.paint(g2, currentX, y, this.getWidth(), Button.ButtonState.UP, (Enum)this.currentState);
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.repaint(32L);
        }
    }

    @Override
    public String getStringValue() {
        return this.currentState.toString();
    }

    public static String getValueString(OrderStateE value) {
        return value.toString();
    }
}

