/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public abstract class CellViewSplittedStringRenderer
extends CellRenderer
implements AttributeListener,
LafListener {
    private static final long serialVersionUID = 1L;
    private boolean isHeader;
    private TextLabel label;
    private int cellHorizontalPadding;
    private String[] texts;

    public CellViewSplittedStringRenderer(String[] texts, boolean isHeader, Component delegate) {
        this.isHeader = isHeader;
        this.label = new TextLabel();
        this.label.setDelegateComponent(delegate);
        this.texts = texts;
        String t = null;
        for (int i = 0; i < texts.length; ++i) {
            t = t != null ? t + this.getSeparatorToken() + texts[i] : texts[i];
        }
        this.label.setText(t);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.setLayout(new CellViewSplittedStringLayout());
        this.setOpaque(false);
        this.add(this.label);
    }

    @Override
    public String getStringValue() {
        return this.label.getText();
    }

    public abstract String getSeparatorToken();

    public String[] getTexts() {
        return this.texts;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.cellHorizontalPadding = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.validate();
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        if (!this.isHeader) {
            this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
        } else {
            this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
        }
    }

    private class CellViewSplittedStringLayout
    extends DefaultLayout {
        private CellViewSplittedStringLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = parent.getHeight();
            int w = parent.getWidth();
            int currentX = CellViewSplittedStringRenderer.this.cellHorizontalPadding;
            CellViewSplittedStringRenderer.this.label.setLocation(currentX, (int)(((double)h - CellViewSplittedStringRenderer.this.label.getPreferredSize().getHeight()) / 2.0));
            CellViewSplittedStringRenderer.this.label.setSize(w - 2 * CellViewSplittedStringRenderer.this.cellHorizontalPadding, (int)CellViewSplittedStringRenderer.this.label.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentX = CellViewSplittedStringRenderer.this.cellHorizontalPadding;
            currentX = (int)((double)currentX + CellViewSplittedStringRenderer.this.label.getPreferredSize().getWidth());
            return new Dimension(currentX += CellViewSplittedStringRenderer.this.cellHorizontalPadding, 0);
        }
    }
}

