/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;

public class CellViewTimeStampRenderer
extends CellRenderer {
    private static final long serialVersionUID = 1L;
    private Timestamp currentDate;
    private TextLabel label;
    private boolean isHeader;

    public CellViewTimeStampRenderer(Timestamp date, boolean isHeader, Component delegate) {
        this.currentDate = date;
        this.isHeader = isHeader;
        String t = "";
        Date nDate = null;
        if (this.currentDate != null) {
            nDate = new Date(this.currentDate.getTime());
            t = ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)nDate, null, new Object[0]);
        } else {
            t = "";
        }
        this.label = new TextLabel(t);
        this.label.setDelegateComponent(delegate);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.label);
    }

    @Override
    public String getStringValue() {
        return this.label.getText();
    }

    public Timestamp getTimestamp() {
        return this.currentDate;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
    }

    @Override
    public void setSize(int w, int h) {
        this.label.setSize(w - 2 * this.label.getX(), h);
        super.setSize(w, h);
    }

    @Override
    protected void layoutCell() {
        if (this.isFirstColumn) {
            this.label.setLocation(this.firstColumnInset, 0);
        } else {
            this.label.setLocation(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")), 0);
        }
    }

    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.setSize(this.getWidth(), this.getHeight());
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.layoutCell();
        }
    }

    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            if (!this.isHeader) {
                this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
            } else {
                this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_table_header_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
                this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_table_header_foreground")));
            }
        }
    }

    public static String getValueString(Timestamp value) {
        return ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)value, null, new Object[0]);
    }
}

