/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.StateIndicatorFive;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class StateIndicatorFiveWithCheckRenderer<T extends Enum>
extends CellRenderer
implements AttributeListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private StateIndicatorFive skin;
    private SizedSkin1Field checked;
    private int xInsert;
    private T currentState;
    private Node<T> currentStateNode;
    private Node<Boolean> checkedNode;

    public StateIndicatorFiveWithCheckRenderer(Node<T> state, Node<Boolean> checkedNode) {
        this((Enum)state.getValue());
        this.currentStateNode = state;
        this.checkedNode = checkedNode;
        this.currentStateNode.addNodeListener(this);
        this.checkedNode.addNodeListener(this);
    }

    public StateIndicatorFiveWithCheckRenderer(T value) {
        this.currentState = value;
        this.skin = SkinRegistry.getSkin(StateIndicatorFive.class);
        this.checked = (SizedSkin1Field)DefaultSkins.CheckIcon.createDynamicSkin();
        this.attributeChanged("All attributes changed");
    }

    public Node<?> getNode() {
        return this.currentStateNode;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.currentStateNode != null) {
            this.currentStateNode.removeNodeListener((NodeListener)this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int a = this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getWidth();
        int b = this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getHeight();
        int c = this.checked.getImage(Button.ButtonState.UP, SizedSkin1Field.SkinSize.SMALL).getHeight();
        return new Dimension(a * 4 + 4 + c, b);
    }

    @Override
    public String getStringValue() {
        return this.getValueString(this.currentState);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 0;
        int currentY = 0;
        currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
        currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getHeight()) / 2;
        this.skin.paint(g2, currentX, currentY, Button.ButtonState.UP, (Enum)this.currentState);
        if (this.checkedNode != null && this.checkedNode.getValue() != null && ((Boolean)this.checkedNode.getValue()).booleanValue()) {
            int a = this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getWidth();
            int ax = currentX + a * 5 + 5;
            this.checked.paint(g2, ax += 3, currentY, Button.ButtonState.UP, SizedSkin1Field.SkinSize.SMALL);
        }
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public String getValueString(T currentState2) {
        if (currentState2 == null) {
            return "";
        }
        return ((Enum)currentState2).toString();
    }

    public void valueChanged(Node<?> node) {
        this.currentState = (Enum)this.currentStateNode.getValue();
        this.repaint(32L);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

