/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.StateSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultTwoStateSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class StateIndicatorTwoRenderer<T extends Enum>
extends CellRenderer
implements AttributeListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private DefaultTwoStateSkin1Field skin;
    private int xInsert;
    private T currentState;
    private Node<T> currentStateNode;

    public StateIndicatorTwoRenderer(Node<T> state) {
        this((Enum)state.getValue());
        this.currentStateNode = state;
        this.currentStateNode.addNodeListener(this);
    }

    public StateIndicatorTwoRenderer(T value) {
        this.currentState = value;
        this.skin = (DefaultTwoStateSkin1Field)DefaultSkins.TwoStateIcon.createDynamicSkin();
        this.attributeChanged("All attributes changed");
    }

    public Node<?> getNode() {
        return this.currentStateNode;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.currentStateNode != null) {
            this.currentStateNode.removeNodeListener((NodeListener)this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int a = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getWidth();
        int b = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getHeight();
        return new Dimension(a * 2 + 1, b);
    }

    @Override
    public String getStringValue() {
        return this.getValueString(this.currentState);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 0;
        int currentY = 0;
        currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
        int t = ((Enum)this.currentState).ordinal();
        StateSkin.StateType st = null;
        if (t == 0) {
            st = StateSkin.StateType.Orange;
        } else if (t == 1) {
            st = StateSkin.StateType.Green;
        }
        currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, st).getHeight()) / 2;
        this.skin.paint(g2, currentX, currentY, Button.ButtonState.UP, st);
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public String getValueString(T currentState2) {
        if (currentState2 == null) {
            return "";
        }
        return ((Enum)currentState2).toString();
    }

    public void valueChanged(Node<?> node) {
        this.currentState = (Enum)this.currentStateNode.getValue();
        this.repaint(32L);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

