/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.table2.DefaultParentRowFinder;
import ch.icit.pegasus.client.gui.table2.FootablePanel;
import ch.icit.pegasus.client.gui.table2.ParentRowFinder;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.columnsorter.TableRowPanelComparator;
import ch.icit.pegasus.client.gui.table2.special.ColumnSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.Resizable;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.DisablePanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.MouseConsumer;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.ISkin;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table2
extends BorderedInletPanel
implements ButtonListener,
LafListener,
AttributeListener,
Fadable,
Resizable,
VisibleContainer,
Focusable,
MouseConsumer,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Table2.class);
    protected Table2Model model;
    protected Table2RowPanel headerRow;
    protected List<Table2RowPanel> rows = new ArrayList<Table2RowPanel>();
    private int dontUseScrollBar;
    private Table2RowPanel fixedRow;
    private int rowFixedAt = 0;
    private boolean isColorInversion;
    private Focusable detailsFocusView;
    private int maxY;
    private Comparator comparator;
    private AlphaFader<Table2> fader;
    private Resizer<Table2> resizer;
    public static final int TYPE_DEFAULT = 3;
    public static final int TYPE_PAXTABLE = 5;
    private int currentType = 5;
    public static final int STATE_READONLY = 3;
    public static final int STATE_READWRITE = 5;
    private int currentState = 5;
    private int currentViewPortWidth = 0;
    private List<Integer> fatLines = new ArrayList<Integer>();
    private Skin9Field overlaySkin;
    private List<ColumnSelectionListener> columnSelectionListeners = new ArrayList<ColumnSelectionListener>();
    private VisibleContainer outerVisibleContainer;
    protected ScrollPane scrollPane;
    private JPanel viewPort;
    protected int maxRows = -1;
    protected boolean fixHeight = false;
    protected int headerHeight = 23;
    protected int cellPadding = 5;
    protected Color lineColor = Color.LIGHT_GRAY;
    protected Color fontColor;
    protected Font textFont;
    protected TextButton addButton;
    protected TextButton secondButton;
    private Component additionalButton;
    private TextLabel tableText;
    private Table2ButtonHandler buttonHandler;
    protected LoadingAnimation loadingAnimation;
    private int defaultRowHeight;
    private boolean isPrefSizeSet;
    private Dimension userPrefSize;
    private DisablePanel disablePanel;
    private ParentRowFinder parentRowFinder;
    private int currentColumnSelection = -1;
    private Color rowEvenColor;
    private Color rowOddColor;
    protected FootablePanel footerPanel;
    private boolean isExpandable;
    private boolean hasLastLine;
    private boolean requestFocusOnAdd;
    private int inner_cellPadding;
    private TableRowPanelComparator columnSorters = new TableRowPanelComparator();
    private int sortedColumn = -1;
    private RDProvider provider;
    private boolean hasAddButton;
    private String buttonText;
    private String overrideName;
    private boolean useWrite;
    private boolean useAccessRight;
    private boolean useAddButton = true;
    private boolean isScrollDownOnAdd = true;
    private boolean isFadebleAdd;
    private boolean isEditable;
    private boolean sortable = true;
    private boolean toggle = false;
    private List<Integer> defaultSearchColumns = new ArrayList<Integer>();

    public Table2(boolean hasAddButton, String name) {
        this(hasAddButton, name, false);
    }

    public Table2(boolean hasAddButton, String name, boolean hasBackground) {
        this(hasAddButton, name, hasBackground, false);
    }

    public Table2(boolean hasAddButton, String name, boolean hasBackground, boolean hasTitlebar) {
        this(hasAddButton, name, hasBackground, hasTitlebar, name);
    }

    public Table2(boolean hasAddButton, String name, boolean hasBackground, boolean hasTitlebar, String titleName) {
        super(hasTitlebar, hasBackground);
        this.hasAddButton = hasAddButton;
        if (hasAddButton && name == null) {
            name = Words.ADD;
        }
        this.buttonText = name;
        this.setScrollDownOnAdd(this.hasAddButton);
        this.setLayout(this.getTableLayouter());
        this.disablePanel = new DisablePanel();
        this.fader = new AlphaFader<Table2>(this, true);
        this.resizer = new Resizer<Table2>(this);
        if (hasBackground) {
            this.hasSkin = true;
            this.hasBackground = true;
            this.setTitleText(titleName);
        } else {
            this.hasSkin = false;
            this.hasBackground = false;
            this.useCliping = false;
        }
        this.fontColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.textFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.viewPort = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Table2.this.viewPort.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                int usedHeight = Table2.this.getDefaultRowHeight();
                g2.setColor(Table2.this.lineColor);
                if (Table2.this.currentType == 3) {
                    int h = Table2.this.rows.size() * usedHeight;
                    g2.drawRect(0, 0, this.getWidth() - 1, h);
                } else if (Table2.this.currentType == 5) {
                    // empty if block
                }
                if (Table2.this.hasLastLine) {
                    g2.drawLine(0, Table2.this.addButton.getY() - 5, this.getWidth(), Table2.this.addButton.getY() - 5);
                }
                if (Table2.this.getCurrentColumnSelection() != -1 && Table2.this.overlaySkin != null) {
                    int i = Table2.this.getCurrentColumnSelection();
                    int x = 0;
                    int w = 0;
                    int c = 0;
                    while (c < i) {
                        x += Table2.this.model.getColumnWidth(c++);
                    }
                    w = Table2.this.model.getColumnWidth(i);
                    int y = (int)this.getPreferredSize().getHeight();
                    Table2.this.overlaySkin.paint(g2, x - 2, y, w += 5, this.getHeight() - y, Button.ButtonState.UP);
                }
                if (Table2.this.addButton == null) {
                    int currentY;
                    int ny = currentY = Table2.this.maxY;
                    int i = Table2.this.getCurrentRowCount() % 2;
                    while (currentY < this.getHeight()) {
                        if (i == 0) {
                            g2.setColor(Table2.this.getEvenColor());
                            i = 1;
                        } else {
                            g2.setColor(Table2.this.getOddColor());
                            i = 0;
                        }
                        g2.fillRect(0, currentY, this.getWidth(), usedHeight);
                        currentY += usedHeight;
                    }
                    int currentX = 0;
                    g2.setColor(Table2.this.lineColor);
                    int stop = Table2.this.model.getColumnCount();
                    --stop;
                    for (int j = 0; stop > j; ++j) {
                        int cx = Table2.this.model.getColumnWidth(j);
                        g2.drawLine(currentX += cx, ny, currentX, this.getHeight());
                        if (Table2.this.fatLines == null || !Table2.this.fatLines.contains(j)) continue;
                        g2.drawLine(currentX - 1, ny, currentX - 1, this.getHeight());
                        g2.drawLine(currentX + 1, ny, currentX + 1, this.getHeight());
                    }
                }
                this.paintChildren(g);
            }
        };
        this.viewPort.setLayout(new ViewPortLayout());
        this.scrollPane.setViewportView(this.viewPort);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.setOpaque(false);
        this.ensureAddButton(this.buttonText, hasAddButton);
        this.setTableBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color")));
        this.add((Component)this.scrollPane, 0);
        this.disablePanel.setVisible(false);
        this.add((Component)this.disablePanel, -1);
        this.setProgress(1.0f);
        this.setDontUseScrollBar(5);
        this.setRequestFocusOnAdd(true);
    }

    public void setUseAddButton(boolean b) {
        this.useAddButton = b;
    }

    public void ensureAddButton(String name, boolean hasAdd) {
        if (this.hasAddButton && hasAdd) {
            if (this.addButton == null) {
                this.addButton = new TextButton(name);
                this.addButton.addButtonListener(this);
                this.addButton.fadeIn();
                this.viewPort.add(this.addButton);
            }
        } else if (this.addButton != null) {
            this.addButton.kill();
            this.addButton = null;
        }
        this.revalidate();
    }

    public void setSecondButton(TextButton button) {
        this.secondButton = button;
        this.viewPort.add(this.secondButton);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        super.paint(g2);
    }

    public void setHasAddButton(boolean b) {
        this.hasAddButton = b;
    }

    public LayoutManager2 getTableLayouter() {
        return new TableLayout();
    }

    public void setFooterPanel(FootablePanel panel) {
        if (this.footerPanel != null) {
            this.footerPanel.kill();
            this.footerPanel = null;
        }
        this.footerPanel = panel;
        this.add(this.footerPanel);
    }

    public void setColumnSorters(TableRowPanelComparator columnSorters) {
        this.columnSorters = columnSorters;
        columnSorters.setSortedColumn(this.sortedColumn);
        columnSorters.setToggle(this.toggle);
    }

    public void allInstalled() {
        for (Table2RowPanel p : this.rows) {
            p.allInstalled();
        }
    }

    public void initSortedColumn(int c, boolean toggle) {
        this.toggle = toggle;
        if (this.columnSorters != null) {
            this.columnSorters.setToggle(toggle);
        }
        this.setSortedColumn(c, false);
    }

    public void setSortedColumn(int c, boolean withToggle) {
        this.sortedColumn = c;
        if (this.columnSorters != null) {
            if (this.columnSorters.getSortedColumn() == c) {
                if (withToggle) {
                    this.columnSorters.toggle();
                }
                if (this.headerRow != null) {
                    ((Table2HeaderPanel)this.headerRow).setSortedColumn(c);
                }
            } else {
                if (this.headerRow != null) {
                    ((Table2HeaderPanel)this.headerRow).setSortedColumn(c);
                }
                this.columnSorters.setSortedColumn(this.sortedColumn);
            }
        }
        this.viewPort.invalidate();
        this.viewPort.validate();
    }

    public void setSortedColumn(int c) {
        this.setSortedColumn(c, true);
    }

    public void setSortDirection(boolean up) {
        this.toggle = up;
        if (this.columnSorters != null) {
            this.columnSorters.setToggle(up);
        }
    }

    public void setSortable(boolean b) {
        this.sortable = b;
        if (this.headerRow != null) {
            ((Table2HeaderPanel)this.headerRow).setSortable(b);
        }
    }

    public void enableAdditionalButton(String text) {
        if (this.additionalButton == null) {
            this.additionalButton = new TextButton(text);
            ((TextButton)this.additionalButton).addButtonListener(this);
            this.viewPort.add(this.additionalButton);
            ((TextButton)this.additionalButton).fadeIn();
        }
        ((TextButton)this.additionalButton).setText(text);
    }

    public void enableAdditionalComponent(Component comp) {
        this.hideAdditionalButton();
        this.additionalButton = comp;
        this.viewPort.add(this.additionalButton);
        if (this.additionalButton instanceof Fadable) {
            ((Fadable)((Object)this.additionalButton)).fadeIn();
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void hideAdditionalButton() {
        if (this.additionalButton != null && this.additionalButton instanceof Killable) {
            ((Killable)((Object)this.additionalButton)).kill();
        }
        this.additionalButton = null;
    }

    public void showLoadingAnimation(String text) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(text);
            this.add((Component)this.loadingAnimation, 0);
            this.revalidate();
            this.loadingAnimation.fadeIn();
        }
        this.loadingAnimation.start();
    }

    public void updateLoadingAnimation(String text) {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stateChanged(text);
        }
    }

    public void hideLoadingAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
            this.revalidate();
        }
    }

    private int getCurrentRowCount() {
        List r = (List)((ArrayList)this.rows).clone();
        int i = r.size();
        try {
            for (Table2RowPanel p : r) {
                if (p == null || !p.isExpanded()) continue;
                i += p.getChildren().size();
            }
        }
        catch (NoSuchElementException e) {
            logger.error("No such element Exception within while(hasNext)");
        }
        return i;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public void setOverlayClass(Class<? extends ISkin> clazz) {
        this.overlaySkin = (Skin9Field)SkinRegistry.getSkin(clazz);
    }

    public void setDetailsFocusView(Focusable f) {
        this.detailsFocusView = f;
    }

    public void writeNumber(DtoField dtoField, int start) {
        this.writeNumber(dtoField.getFieldName(), start);
    }

    public void writeNumber(String att, int start) {
        if (this.model.isReseting()) {
            return;
        }
        int count = start;
        long currentID = System.currentTimeMillis();
        List rclone = (List)((ArrayList)this.rows).clone();
        for (Table2RowPanel p : rclone) {
            if (p.getModel().getNode() == null) continue;
            Node n = p.getModel().getNode().getChildNamed(new String[]{att});
            if (n != null) {
                n.setValue((Object)count, currentID);
            }
            ++count;
        }
        this.updateOrder();
    }

    public Focusable getDetailsFocusView() {
        return this.detailsFocusView;
    }

    public void setHasLastLine(boolean hasLastLine) {
        this.hasLastLine = hasLastLine;
    }

    @Override
    public void setHasBackground(boolean hasBackground) {
        this.hasSkin = hasBackground;
    }

    public void addColumnSelectionListener(ColumnSelectionListener l) {
        this.columnSelectionListeners.add(l);
    }

    public void removeColumnSelectionListener(ColumnSelectionListener l) {
        this.columnSelectionListeners.remove(l);
    }

    public void fireColumnSelectionEvent(Table2RowPanel effectedPanel, int columnNr) {
        this.currentColumnSelection = columnNr;
        for (ColumnSelectionListener l : this.columnSelectionListeners) {
            l.newColumnSelected(this, effectedPanel, columnNr);
        }
    }

    public int getCurrentColumnSelection() {
        return this.currentColumnSelection;
    }

    public int getRowFixedAt() {
        return this.rowFixedAt;
    }

    public void setRowFixedAt(int rowFixedAt) {
        this.rowFixedAt = rowFixedAt;
    }

    public Table2RowPanel getFixedRow() {
        return this.fixedRow;
    }

    public void setFixedRow(Table2RowPanel fixedRow) {
        this.fixedRow = fixedRow;
    }

    public void enableTableText(Node aNv, Converter viewC) {
        this.enableTableText();
        this.tableText.setViewConverter(viewC);
        this.tableText.setNode(aNv);
    }

    public void enableTableText() {
        this.tableText = new TextLabel();
        this.viewPort.add(this.tableText);
    }

    public boolean isTableValid() {
        boolean isValid = true;
        for (Table2RowPanel p : this.rows) {
            if (p.isRowValid()) continue;
            isValid = false;
        }
        return isValid;
    }

    public boolean isColorInversion() {
        return this.isColorInversion;
    }

    public void setColorInversion(boolean isColorInversion) {
        this.isColorInversion = isColorInversion;
    }

    public void setTableText(String t) {
        if (this.tableText != null) {
            this.tableText.setText(t);
        }
    }

    public void setButtonText(String t) {
        if (this.addButton != null) {
            this.addButton.setText(t);
        }
    }

    public Table2RowPanel getRowAt(int i) {
        if (i > this.rows.size() - 1 || i < 0) {
            return null;
        }
        return this.rows.get(i);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setDefaultSearchColumns(int ... c) {
        int[] nArray = c;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            this.defaultSearchColumns.add(i2);
        }
    }

    public void updateOrder() {
        if (this.comparator != null) {
            try {
                Collections.sort(this.rows, this.comparator);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.columnSorters != null && this.rows != null) {
            try {
                Collections.sort(this.rows, this.columnSorters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List crows = (List)((ArrayList)this.rows).clone();
        for (Table2RowPanel p : crows) {
            if (p == null) continue;
            p.updateRowOrder();
        }
        this.model.fireFocusCycleCreatorEvent(null, false);
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    public void setExpandable(boolean isExpandable) {
        this.isExpandable = isExpandable;
    }

    public void setState(int newState) {
        this.currentState = newState;
        this.viewPort.validate();
    }

    public void setRowIndex(Table2RowPanel p, int index) {
        this.rows.remove(p);
        this.rows.add(index, p);
    }

    public int getType() {
        return this.currentType;
    }

    public boolean getToggle() {
        return this.columnSorters.isToggled();
    }

    public void setType(int currentType) {
        this.currentType = currentType;
    }

    public void enableAddButton(boolean isEnabled) {
        if (this.addButton != null) {
            this.addButton.setEnabled(isEnabled);
        }
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public void setPreferredSize(int w, int h) {
        this.isPrefSizeSet = true;
        this.userPrefSize = new Dimension(w, h);
    }

    public void setDontUseScrollBar(int dontUseScrollBar) {
        if (dontUseScrollBar % 3 == 0) {
            this.scrollPane.setVerticalScrollBarPolicy(21);
        } else {
            this.scrollPane.setVerticalScrollBarPolicy(20);
        }
        if (dontUseScrollBar % 5 == 0) {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(30);
        }
        this.dontUseScrollBar = dontUseScrollBar;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public TextButton getAddButton() {
        return this.addButton;
    }

    public Table2ButtonHandler getButtonHandler() {
        return this.buttonHandler;
    }

    public void setButtonHandler(Table2ButtonHandler buttonHandler) {
        this.buttonHandler = buttonHandler;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public int getInnerCellPadding() {
        return this.inner_cellPadding;
    }

    public Table2Model getModel() {
        return this.model;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getRowIndex(Table2RowPanel p) {
        return this.rows.indexOf(p);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        for (Table2RowPanel row : this.rows) {
            row.setEnabled(isEditable);
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(isEditable);
        }
        if (this.additionalButton != null) {
            this.additionalButton.setEnabled(isEditable);
        }
        this.repaint(32L);
    }

    public void setLocked(boolean isEditable) {
        this.setEnabled(true);
        this.setEditable(isEditable);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (isEnabled) {
            this.ensureRowCount(isEnabled && this.useAddButton);
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(isEnabled);
        }
        if (this.scrollPane != null) {
            if (this.scrollPane.getVerticalScrollBar() != null) {
                this.scrollPane.getVerticalScrollBar().setEnabled(isEnabled);
            }
            if (this.scrollPane.getHorizontalScrollBar() != null) {
                this.scrollPane.getHorizontalScrollBar().setEnabled(isEnabled);
            }
        }
        if (this.rows != null) {
            List r = (List)((ArrayList)this.rows).clone();
            for (Table2RowPanel row : r) {
                row.setEnabled(isEnabled);
            }
        }
        if (this.footerPanel != null) {
            this.footerPanel.setEnabled(isEnabled);
        }
        this.repaint(32L);
    }

    public void relayoutRequested() {
        this.revalidate();
        this.invalidate();
        this.validate();
    }

    public void updateTable() {
        for (Table2RowPanel row : this.rows) {
            row.updateRow(null);
        }
    }

    public void resortTable() {
        this.updateOrder();
        this.viewPort.revalidate();
    }

    public void setFadebleAdd(boolean b) {
        this.isFadebleAdd = b;
    }

    public void addRow(Table2RowPanel row) {
        if (this.requestFocusOnAdd && !this.isKilled()) {
            SwingUtilities.invokeLater(() -> row.requestFocusInWindowNow());
        }
        this.rows.add(row);
        this.updateOrder();
        row.setVisibleContainer(this);
        this.viewPort.add(row);
        row.setProgress(1.0f);
        this.viewPort.invalidate();
        this.viewPort.validate();
        this.viewPort.revalidate();
        row.setEnabled(this.isEnabled());
        this.ensureRowCount(this.isEnabled());
        this.model.fireFocusCycleCreatorEvent(null, true);
        if (!row.wasInstallCalled()) {
            row.allInstalled();
        }
        if (this.isScrollDownOnAdd && this.scrollPane != null && this.scrollPane.getVerticalScrollBar() != null && this.dontUseScrollBar % 3 != 0) {
            SwingUtilities.invokeLater(() -> {
                if (this.scrollPane != null && this.scrollPane.getVerticalScrollBar() != null) {
                    this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
                }
            });
        }
    }

    public void ensureRowCount(boolean b) {
        if (this.maxRows != -1) {
            if (this.rows.size() == this.maxRows) {
                if (this.addButton != null) {
                    boolean now = this.addButton.isEnabled();
                    this.addButton.setEnabled(false & b);
                    if (now != this.addButton.isEnabled()) {
                        this.model.recreateFocusCycle();
                    }
                }
            } else if (this.addButton != null && !this.addButton.isEnabled()) {
                this.addButton.setEnabled(true & b);
                this.model.recreateFocusCycle();
            }
        } else if (this.addButton != null) {
            this.addButton.setEnabled(b);
        }
    }

    public void setRequestFocusOnAdd(boolean request) {
        this.requestFocusOnAdd = request;
    }

    public void addRowToViewPort(Table2RowPanel row) {
        this.viewPort.add(row);
        this.viewPort.validate();
        row.setVisibleContainer(this);
        row.fadeIn();
        row.allInstalled();
    }

    public void removeRowFromViewPort(Table2RowPanel row) {
        this.viewPort.remove(row);
    }

    protected void removeFromList(Table2RowPanel row) {
        this.rows.remove(row);
        if (this.getButtonHandler() != null && !this.model.isReseting()) {
            this.getButtonHandler().childRemoved();
        }
        for (Table2RowPanel r : row.getChildren()) {
            this.removeRow(r, false);
        }
    }

    public void removeRow(Table2RowPanel row, boolean doValidate) {
        this.rows.remove(row);
        row.setVisible(false);
        row.kill();
        this.viewPort.remove(row);
        this.model.models.remove(row.getModel());
        if (this.buttonHandler != null) {
            this.buttonHandler.childRemoved();
        }
        if (doValidate) {
            this.viewPort.validate();
            this.viewPort.repaint(32L);
        }
        this.ensureRowCount(this.isEnabled());
        this.model.fireFocusCycleCreatorEvent(null, true);
    }

    public ParentRowFinder getParentRowFinder() {
        return this.parentRowFinder;
    }

    public void setParentRowFinder(ParentRowFinder parentRowFinder) {
        this.parentRowFinder = parentRowFinder;
    }

    public Table2RowPanel getRowPanel4Node(Node n) {
        if (this.parentRowFinder == null) {
            this.parentRowFinder = new DefaultParentRowFinder(this);
        }
        return this.parentRowFinder.getRowPanel4Node(n);
    }

    public List<Table2RowPanel> getRows() {
        return this.rows;
    }

    public List<Table2RowPanel> getRowsFailSafe() {
        return (List)((ArrayList)this.rows).clone();
    }

    public void setTableBackground(Color c) {
        this.setBackground(c);
        this.viewPort.setBackground(c);
        this.scrollPane.setBackground(c);
        this.scrollPane.getHorizontalScrollBar().setBackground(c);
        this.scrollPane.getVerticalScrollBar().setBackground(c);
    }

    public void setHeaderRow(Table2RowPanel row) {
        if (this.headerRow != null) {
            this.remove(this.headerRow);
        }
        this.headerRow = row;
        ((Table2HeaderPanel)this.headerRow).setSortable(this.sortable);
        this.add((Component)this.headerRow, 0);
        this.headerRow.fadeIn();
        this.validate();
    }

    public void reLayoutUpperContainer() {
    }

    public void setModel(Table2Model model) {
        this.model = model;
        this.model.setTable(this);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.viewPort.invalidate();
        if (this.model != null) {
            this.model.ensureColumnWidths(-1, 0, false, true);
        }
        if (this.disablePanel != null) {
            this.disablePanel.setSize(w, h);
        }
    }

    public int getViewableWidth() {
        return (int)((ViewPortLayout)this.viewPort.getLayout()).preferredLayoutSize(this).getWidth();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPrefSizeSet) {
            return this.userPrefSize;
        }
        return this.getLayout().preferredLayoutSize(this);
    }

    public void setMaxRows(int i, boolean fixHeight) {
        this.maxRows = i;
        this.fixHeight = fixHeight;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Table2RowModel getHeader() {
        return this.headerRow.getModel();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.buttonHandler != null) {
            this.buttonHandler.addButtonPressed(x, y, source);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        this.rowEvenColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_color_even"));
        this.rowOddColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_color_odd"));
        this.lineColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("leg_table_line_color"));
        this.innerBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color"));
    }

    public Color getEvenColor() {
        if (this.isColorInversion) {
            return this.rowOddColor;
        }
        return this.rowEvenColor;
    }

    public Color getOddColor() {
        if (this.isColorInversion) {
            return this.rowEvenColor;
        }
        return this.rowOddColor;
    }

    public boolean isOddColor(Table2RowPanel p) {
        return this.rows.indexOf(p) % 2 == 0;
    }

    public Color getColor4Row(Table2RowPanel p) {
        return this.getColor4Index(this.rows.indexOf(p));
    }

    public Color getColor4Index(int index) {
        if (index % 2 == 0) {
            return this.getEvenColor();
        }
        return this.getOddColor();
    }

    @Override
    public void attributeChanged(String attributeName) {
        super.attributeChanged(attributeName);
        this.defaultRowHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table2_default_row_height"));
        this.headerHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_header_rowheight"));
        this.cellPadding = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_default_cellpadding"));
        this.inner_cellPadding = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_default_innercellpadding"));
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fader.fadeIn(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fader.fadeOut(animationTime, destroy);
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.fader.fadeOut(destroy);
    }

    public AlphaFader<Table2> getFader() {
        return this.fader;
    }

    @Override
    public float getProgress() {
        return this.fader.getProgress();
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        return this.fader.isAnimating(fadeIn);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.headerRow != null) {
            this.headerRow.kill();
        }
        this.headerRow = null;
        if (this.model != null) {
            this.model.setReseting(true);
            this.model.kill();
        }
        this.model = null;
        if (this.rows != null) {
            for (Table2RowPanel r : this.rows) {
                r.kill();
            }
            this.rows.clear();
        }
        this.rows = null;
        if (this.fixedRow != null) {
            this.fixedRow.kill();
        }
        this.fixedRow = null;
        this.detailsFocusView = null;
        this.comparator = null;
        if (this.fader != null) {
            this.fader.kill();
        }
        this.fader = null;
        if (this.resizer != null) {
            this.resizer.kill();
        }
        this.resizer = null;
        this.fatLines.clear();
        this.fatLines = null;
        this.overlaySkin = null;
        this.columnSelectionListeners.clear();
        this.columnSelectionListeners = null;
        this.outerVisibleContainer = null;
        if (this.addButton != null) {
            this.addButton.kill();
        }
        this.addButton = null;
        if (this.secondButton != null) {
            this.secondButton.kill();
        }
        this.secondButton = null;
        if (this.additionalButton != null && this.additionalButton instanceof Killable) {
            ((Killable)((Object)this.additionalButton)).kill();
        }
        this.additionalButton = null;
        if (this.tableText != null) {
            this.tableText.kill();
        }
        this.tableText = null;
        this.buttonHandler = null;
        if (this.loadingAnimation != null) {
            this.loadingAnimation.kill();
        }
        this.loadingAnimation = null;
        this.scrollPane.kill();
        this.scrollPane = null;
        this.viewPort.removeAll();
        this.viewPort = null;
        if (this.disablePanel != null) {
            this.disablePanel.kill();
        }
        this.disablePanel = null;
        this.parentRowFinder = null;
        if (this.footerPanel != null) {
            this.footerPanel.kill();
        }
        this.footerPanel = null;
        this.columnSorters = null;
        this.provider = null;
        this.defaultSearchColumns.clear();
        this.defaultSearchColumns = null;
    }

    @Override
    public void setProgress(float progress) {
        this.fader.setProgress(progress);
    }

    public void resetTable() {
        for (Table2RowPanel p : (List)((ArrayList)this.rows).clone()) {
            this.removeRow(p, false);
        }
        this.viewPort.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        try {
            for (Table2RowPanel p : this.rows) {
                CheckedListAdder.addToList(focusList, p);
            }
            CheckedListAdder.addToList(focusList, this.addButton);
            if (this.additionalButton instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.additionalButton));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CheckedListAdder.addToList(focusList, this.footerPanel);
        return focusList;
    }

    @Override
    public void scrollTo(Focusable f) {
        if (f instanceof Component && f != null && this.viewPort != null && SwingUtilities.isDescendingFrom(this.viewPort, (Component)((Object)f))) {
            Point p = SwingUtilities.convertPoint((Component)((Object)f), ((Component)((Object)f)).getX(), ((Component)((Object)f)).getY(), this.viewPort);
            int i = (int)((double)this.scrollPane.getVerticalScrollBar().getValue() + this.scrollPane.getViewport().getBounds().getHeight());
            int y = (int)(p.getY() - 10.0);
            if (y < this.scrollPane.getVerticalScrollBar().getValue()) {
                this.scrollPane.getVerticalScrollBar().setValue(y);
                return;
            }
            y = (int)(p.getY() + 10.0);
            if (y > i) {
                int dif = y - i;
                dif += 5;
                dif = this.scrollPane.getVerticalScrollBar().getValue() + dif;
                this.scrollPane.getVerticalScrollBar().setValue(dif);
            }
        }
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.outerVisibleContainer = pane;
        if (this.addButton != null) {
            this.addButton.setVisibleContainer(pane);
        }
        if (this.additionalButton != null && this.additionalButton instanceof Focusable) {
            ((Focusable)((Object)this.additionalButton)).setVisibleContainer(pane);
        }
        for (Table2RowPanel p : this.rows) {
            p.setVisibleContainer(pane);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.rows.size() > 0) {
            this.rows.get(0).requestFocusInWindowNow();
        } else if (this.addButton != null) {
            this.addButton.requestFocusInWindowNow();
        }
    }

    public TextLabel getLabelText() {
        return this.tableText;
    }

    public void enableAdditionalButton(boolean b) {
        if (this.additionalButton != null) {
            this.additionalButton.setEnabled(b);
        }
    }

    public boolean getIsSearchToggled() {
        return this.columnSorters.isToggled();
    }

    public FootablePanel getFootablePanel() {
        return this.footerPanel;
    }

    @Deprecated
    public JPanel getViewPort() {
        return this.viewPort;
    }

    @Deprecated
    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean isWritable() {
        if (this.provider != null) {
            if (this.overrideName != null) {
                if (this.useAccessRight) {
                    return this.provider.hasSubRight(this.overrideName);
                }
                return this.provider.isWritable(this.overrideName);
            }
            if (this.getModel().getNode() != null) {
                if (this.useAccessRight) {
                    return this.provider.hasSubRight(this.getModel().getNode().getName());
                }
                return this.provider.isWritable(this.getModel().getNode().getName());
            }
        }
        return true;
    }

    public void setScrollDownOnAdd(boolean b) {
        this.isScrollDownOnAdd = b;
    }

    public void setProvider(RDProvider provider) {
        this.provider = provider;
    }

    public RDProvider getProvider() {
        return this.provider;
    }

    public void setOverrideName(String overrideName) {
        this.overrideName = overrideName;
    }

    public void setOverrideName(DtoField overrideName) {
        if (overrideName != null) {
            this.overrideName = overrideName.getFieldName();
        }
    }

    public String getOverrideName() {
        return this.overrideName;
    }

    public void setUseWriteAccessRight(boolean b) {
        this.useWrite = b;
    }

    public boolean useWrite() {
        return this.useWrite;
    }

    public boolean isUseAccessRight() {
        return this.useAccessRight;
    }

    public void setUseAccessRight(boolean useAccessRight) {
        this.useAccessRight = useAccessRight;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.headerRow != null && this.headerRow.isInnerComponent(c)) {
            return true;
        }
        for (Table2RowPanel p : this.rows) {
            if (!p.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog(exception.getMessage(), (Component)this);
        this.hideLoadingAnimation();
    }

    public void showAddButton(boolean b) {
        if (!b && this.addButton != null) {
            this.addButton.kill();
            this.addButton = null;
        }
    }

    public void setFatLines(List<Integer> fatLines) {
        this.fatLines = fatLines;
    }

    public List<Integer> getFatLines() {
        return this.fatLines;
    }

    @Override
    public Resizer getResizer() {
        return this.resizer;
    }

    @Override
    public void setSizeSmooth(int w, int h) {
        this.resizer.setSizeSmooth(w, h);
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = (int)this.preferredLayoutSize(parent).getWidth();
            if (Table2.this.currentViewPortWidth != w) {
                Table2.this.currentViewPortWidth = w;
                Table2.this.model.ensureColumnWidths(-1, -1, false, false);
            }
            if (Table2.this.columnSorters != null && Table2.this.sortedColumn > -1) {
                try {
                    Collections.sort(Table2.this.rows, Table2.this.columnSorters);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int currentX = 0;
            int currentY = 0;
            int verticalGap = 0;
            int count = 0;
            List r = (List)((ArrayList)Table2.this.rows).clone();
            for (Table2RowPanel p : r) {
                if (p == null) continue;
                if (p == Table2.this.fixedRow) {
                    currentY = Table2.this.rowFixedAt * p.getDefaultRowHeight();
                }
                p.setLocation(currentX, currentY);
                p.setSize(w, (int)p.getPreferredSize().getHeight());
                currentY += p.getHeight() + verticalGap;
                p.setColorIndex(count);
                if (p.isExpanded() && p.isLayoutInnerChildsSelf()) {
                    for (Table2RowPanel p2 : p.getChildren()) {
                        p2.applyInset();
                        p2.setColorIndex(++count);
                        p2.setLocation(currentX, currentY);
                        p2.setSize(w, (int)p2.getPreferredSize().getHeight());
                        currentY += p2.getHeight() + verticalGap;
                        if (!p2.isExpanded() || !p2.isLayoutInnerChildsSelf()) continue;
                        for (Table2RowPanel p3 : p2.getChildren()) {
                            p3.applyInset();
                            p3.setColorIndex(++count);
                            p3.setLocation(currentX, currentY);
                            p3.setSize(w, (int)p3.getPreferredSize().getHeight());
                            currentY += p3.getHeight() + verticalGap;
                        }
                    }
                }
                ++count;
            }
            Table2.this.maxY = currentY;
            int cx = 0;
            if (Table2.this.addButton != null) {
                Table2.this.addButton.setLocation(Table2.this.cellPadding, currentY + Table2.this.cellPadding);
                Table2.this.addButton.setSize(Table2.this.addButton.getPreferredSize());
                cx = Table2.this.addButton.getX() + Table2.this.addButton.getWidth() + 10;
            }
            if (Table2.this.additionalButton != null) {
                if (Table2.this.addButton == null) {
                    cx += Table2.this.getCellPadding();
                }
                Table2.this.additionalButton.setLocation(cx, currentY + Table2.this.cellPadding);
                Table2.this.additionalButton.setSize(Table2.this.additionalButton.getPreferredSize());
            }
            if (Table2.this.tableText != null) {
                Table2.this.tableText.setLocation(w - 150, currentY + Table2.this.cellPadding);
                Table2.this.tableText.setSize(150 - Table2.this.getCellPadding(), (int)Table2.this.tableText.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = 0;
            int maxWidth = 0;
            boolean verticalGap = false;
            try {
                if (Table2.this.maxRows != -1 && Table2.this.fixHeight) {
                    currentY = Table2.this.maxRows * Table2.this.getDefaultRowHeight();
                } else {
                    for (Table2RowPanel p : Table2.this.rows) {
                        if (p == Table2.this.fixedRow) {
                            currentY = Table2.this.rowFixedAt * p.getDefaultRowHeight();
                        }
                        currentY = (int)((double)currentY + (p.getPreferredSize().getHeight() + (double)verticalGap));
                        if (!p.isExpanded() || !p.isLayoutInnerChildsSelf()) continue;
                        for (Table2RowPanel p2 : p.getChildren()) {
                            currentY = (int)((double)currentY + (p2.getPreferredSize().getHeight() + (double)verticalGap));
                            if (!p2.isExpanded() || !p2.isLayoutInnerChildsSelf()) continue;
                            for (Table2RowPanel p3 : p2.getChildren()) {
                                currentY = (int)((double)currentY + (p3.getPreferredSize().getHeight() + (double)verticalGap));
                            }
                        }
                    }
                    if (Table2.this.addButton != null) {
                        currentY += Table2.this.cellPadding;
                        currentY = (int)((double)currentY + Table2.this.addButton.getPreferredSize().getHeight());
                        currentY += Table2.this.cellPadding;
                    } else if (Table2.this.additionalButton != null) {
                        currentY += Table2.this.cellPadding;
                        currentY = (int)((double)currentY + Table2.this.additionalButton.getPreferredSize().getHeight());
                        currentY += Table2.this.cellPadding;
                    }
                }
                maxWidth = currentY < Table2.this.scrollPane.getHeight() || Table2.this.dontUseScrollBar % 3 == 0 ? Table2.this.scrollPane.getWidth() : (int)((double)Table2.this.scrollPane.getWidth() - Table2.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Dimension(maxWidth, currentY);
        }
    }

    private class TableLayout
    extends DefaultLayout {
        private TableLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int currentX = 0;
            int currentY = 0;
            int endAdded = 0;
            Table2.this.layoutTitle(parent);
            if (Table2.this.hasSkin) {
                if (Table2.this.hasTitle) {
                    currentX = 1;
                    endAdded = 1;
                    currentY += Table2.this.getTitleHeight();
                } else {
                    currentX = 2;
                    endAdded = 2;
                    currentY = 2;
                }
            }
            if (Table2.this.headerRow != null) {
                Table2.this.headerRow.setLocation(currentX, currentY);
                if (Table2.this.headerRow.isPrefSizeSet()) {
                    Table2.this.headerRow.setSize(w - 2 * currentX, (int)Table2.this.headerRow.getPreferredSize().getHeight());
                } else {
                    Table2.this.headerRow.setSize(w - 2 * currentX, Table2.this.headerHeight);
                }
                currentY += Table2.this.headerRow.getHeight();
            }
            if (Table2.this.footerPanel != null) {
                Table2.this.footerPanel.setLocation(0, (int)((double)parent.getHeight() - Table2.this.footerPanel.getPreferredSize().getHeight()));
                Table2.this.footerPanel.setSize(parent.getWidth(), (int)Table2.this.footerPanel.getPreferredSize().getHeight());
                endAdded += Table2.this.footerPanel.getHeight();
            }
            Table2.this.scrollPane.setLocation(currentX, currentY);
            Table2.this.scrollPane.setSize(w - 2 * currentX, h - (currentY + endAdded));
            if (Table2.this.loadingAnimation != null) {
                Table2.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - Table2.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - Table2.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                Table2.this.loadingAnimation.setSize(Table2.this.loadingAnimation.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = null;
            int usedHeight = Table2.this.getDefaultRowHeight();
            if (Table2.this.maxRows != -1 && Table2.this.fixHeight) {
                d = new Dimension(30, Table2.this.maxRows * usedHeight + Table2.this.headerHeight);
            } else if (Table2.this.rows != null) {
                int h = 0;
                for (Table2RowPanel p : Table2.this.rows) {
                    h = (int)((double)h + p.getPreferredSize().getHeight());
                    if (!p.isExpanded() || !p.isLayoutInnerChildsSelf()) continue;
                    for (Table2RowPanel p1 : p.getChildren()) {
                        h = (int)((double)h + p1.getPreferredSize().getHeight());
                    }
                }
                d = new Dimension(30, h + Table2.this.headerHeight + 4);
                if (Table2.this.addButton != null) {
                    d.setSize(30.0, d.getHeight() + Table2.this.addButton.getPreferredSize().getHeight() + (double)(2 * Table2.this.cellPadding));
                }
            }
            return d;
        }
    }
}

