/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.TableControlsFadeSkin;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;

public abstract class Table2RowPanel
extends JPanelFadable
implements AttributeListener,
MouseListener,
LafListener,
Focusable,
Selectable,
FocusListener,
RemoteLoader,
MutableFocusContainer {
    private static final long serialVersionUID = 1L;
    protected Table2RowModel model;
    protected int cellPadding;
    protected boolean hasBackground = true;
    protected boolean hasHorizontalLine = true;
    private List<MutableFocusContainerListener> focusCycleListener = new ArrayList<MutableFocusContainerListener>();
    private boolean wasInstallCalled = false;
    private boolean layoutInnerChildsSelf;
    protected int isSelected;
    protected Color selectionColor;
    protected int lineDrawingHeight = -1;
    protected Focusable nextFocusComponent;
    protected Table2RowPanel parentRow;
    protected int colorIndex;
    private boolean isSelectable = false;
    protected int position2LineOffset = 0;
    protected BackgroundFadeSkin selectedSkin;
    protected TableControlsFadeSkin tableControlsSkin;
    protected int controlsX = 0;
    protected TableControlsType useControls = TableControlsType.NONE;
    protected List<Table2RowPanel> children = new ArrayList<Table2RowPanel>();
    protected int style;
    protected boolean isExpanded = true;
    protected boolean isPrefSizeSet = false;
    private boolean drawButtomLine;

    public Table2RowPanel(Table2RowModel m) {
        this.selectedSkin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.tableControlsSkin = SkinRegistry.getSkin(TableControlsFadeSkin.class);
        this.attributeChanged("All attributes changed");
        if (!m.isHeader()) {
            this.lafAttributeChanged("All attribues changed");
        }
        this.model = m;
        this.setOpaque(false);
        this.ensureExpandedState();
    }

    public void fadeInAll() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof Fadable)) continue;
            ((Fadable)((Object)c)).fadeIn();
        }
    }

    public abstract Object getObject4Column(int var1);

    @Override
    public void requestFocusInWindowNow() {
    }

    protected void layoutComponent(Container parent, Component comp, int currentX, int currentW, boolean expand) {
        comp.setLocation(currentX + this.getCellPadding(), (int)(((double)parent.getHeight() - comp.getPreferredSize().getHeight()) / 2.0));
        if (expand) {
            comp.setSize(currentW - 2 * this.getCellPadding(), (int)comp.getPreferredSize().getHeight());
        } else {
            comp.setSize(comp.getPreferredSize());
        }
    }

    public int getPosition2LineOffset() {
        return this.position2LineOffset;
    }

    public boolean isPrefSizeSet() {
        return this.isPrefSizeSet;
    }

    public void setPosition2LineOffset(int position2LineOffset) {
        this.position2LineOffset = position2LineOffset;
    }

    public void setControlsX(int x) {
        this.controlsX = x;
    }

    public void setUseControlSkin(TableControlsType isUse) {
        this.useControls = isUse;
    }

    public boolean isLayoutInnerChildsSelf() {
        return this.layoutInnerChildsSelf;
    }

    public void setLayoutInnerChildsSelf(boolean layoutInnerChildsSelf) {
        this.layoutInnerChildsSelf = layoutInnerChildsSelf;
    }

    @Override
    public boolean isSelectable() {
        return this.isSelectable;
    }

    public int getDefaultRowHeight() {
        return this.model.getParentModel().getTable().getDefaultRowHeight();
    }

    public void setDefaultRowHeight(int rowHeight) {
        this.model.getParentModel().getTable().setDefaultRowHeight(rowHeight);
    }

    protected void fireFocusCycleChangeEvent(MutableFocusContainer target) {
        for (MutableFocusContainerListener l : this.focusCycleListener) {
            l.focusCycleChanged(target);
        }
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.add(listener);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.add(listener);
    }

    @Override
    public final void setVisibleContainer(VisibleContainer pane) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof Focusable)) continue;
            ((Focusable)((Object)c)).setVisibleContainer(pane);
        }
    }

    public void applyInset() {
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
        if (!isSelectable) {
            this.removeMouseListener(this);
            this.removeFocusListener(this);
        } else {
            this.addFocusListener(this);
            this.addMouseListener(this);
        }
    }

    public Table2RowPanel getChild4Node(Node<?> n) {
        for (Table2RowPanel p : this.children) {
            if (p.getModel().getNode() != n) continue;
            return p;
        }
        return null;
    }

    public int getCellPadding() {
        return this.model.getParentModel().getTable().getCellPadding();
    }

    public int getInnerCellPadding() {
        return this.model.getParentModel().getTable().getInnerCellPadding();
    }

    public boolean isRowValid() {
        return true;
    }

    public boolean wasInstallCalled() {
        return this.wasInstallCalled;
    }

    public void allInstalled() {
        this.wasInstallCalled = true;
    }

    public int getLineDrawingHeight() {
        return this.lineDrawingHeight;
    }

    public void setLineDrawingHeight(int lineDrawingHeight) {
        this.lineDrawingHeight = lineDrawingHeight;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.setExpanded(isExpanded, true);
    }

    public void setExpanded(boolean isExpanded, boolean revalidate) {
        if (this.isExpanded != isExpanded) {
            this.isExpanded = isExpanded;
            for (Table2RowPanel p : this.children) {
                p.setVisible(isExpanded);
            }
            if (revalidate) {
                this.model.getParentModel().getTable().relayoutRequested();
                this.model.getParentModel().getTable().getHeader().getView().repaint(32L);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getLayout() != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return new Dimension(0, 0);
    }

    public boolean usesNode(Node<?> node) {
        return false;
    }

    public void updateRow(Node<?> node) {
    }

    public void updateRowOrder() {
    }

    public Object getIdentifier() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.children != null) {
            for (Table2RowPanel r : this.children) {
                r.setEnabled(isEnabled);
            }
        }
    }

    protected void ensureExpandedState() {
    }

    public Table2RowModel addRow(Node<?> n) {
        Table2RowModel m = new Table2RowModel(n, this.model.getParentModel(), false);
        m.setInnerElement(true);
        this.model.getParentModel().addTableRowModel(m);
        this.children.add(m.getView());
        m.getView().setRowParent(this);
        this.ensureExpandedState();
        this.model.getParentModel().getTable().addRowToViewPort(m.getView());
        this.model.getParentModel().fireFocusCycleCreatorEvent(this, true);
        return m;
    }

    protected void setRowParent(Table2RowPanel tableRowPanel) {
        this.parentRow = tableRowPanel;
    }

    public Table2RowPanel getRowParent() {
        return this.parentRow;
    }

    public void addRow(Table2RowPanel p) {
        this.children.add(p);
        p.setRowParent(this);
    }

    public int getRowCount() {
        return this.children.size();
    }

    public int getRowIndex(Table2RowPanel p) {
        return this.children.indexOf(p);
    }

    public void removeRow(Table2RowPanel p) {
        this.model.getParentModel().removeTableRowModel(p.getModel());
        this.children.remove(p);
        this.ensureExpandedState();
        this.model.getParentModel().getTable().removeRowFromViewPort(p);
        this.model.getParentModel().fireFocusCycleCreatorEvent(p, false);
    }

    public void setColorIndex(int i) {
        this.colorIndex = i;
    }

    public Color getRowColor(Table2RowPanel p) {
        return this.model.getParentModel().getTable().getColor4Index(this.colorIndex);
    }

    public List<Table2RowPanel> getChildren() {
        return this.children;
    }

    public Table2RowModel getModel() {
        return this.model;
    }

    public void setModel(Table2RowModel model) {
        this.model = model;
    }

    public boolean isHasHorizontalLine() {
        return this.hasHorizontalLine;
    }

    public void setHasHorizontalLine(boolean hasHorizontalLine) {
        this.hasHorizontalLine = hasHorizontalLine;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int aHeight = this.lineDrawingHeight;
        if (aHeight == -1) {
            aHeight = this.getHeight();
        }
        if (this.isSelected == 3) {
            this.selectedSkin.paint(g2, 0, 0, this.getWidth(), 7);
        } else if (this.isSelected == 5) {
            this.selectedSkin.paint(g2, 0, 0, this.getWidth(), 13);
        } else if (this.hasBackground) {
            g2.setColor(this.getRowColor(this));
            g2.fillRect(0, 0, this.getWidth(), aHeight);
        }
        switch (this.useControls) {
            case ONE: {
                this.tableControlsSkin.paint(g2, this.controlsX, 0, this.getHeight(), SizedSkin1Field.SkinSize.SMALL);
                break;
            }
            case TWO: {
                this.tableControlsSkin.paint(g2, this.controlsX, 0, this.getHeight(), SizedSkin1Field.SkinSize.MEDIUM);
                break;
            }
            case THREE: 
            case FOUR: {
                this.tableControlsSkin.paint(g2, this.controlsX, 0, this.getHeight(), SizedSkin1Field.SkinSize.BIG);
                break;
            }
        }
        g2.setColor(this.model.getParentModel().getTable().getLineColor());
        int currentX = this.position2LineOffset;
        for (int i = 0; i < this.model.getParentModel().getColumnCount() - 1; ++i) {
            g2.drawLine(currentX += this.model.getParentModel().getColumnWidth(i), 0, currentX, aHeight);
            if (this.model.getParentModel().getTable().getFatLines() == null || !this.model.getParentModel().getTable().getFatLines().contains(i)) continue;
            g2.drawLine(currentX + 1, 0, currentX + 1, aHeight);
            g2.drawLine(currentX - 1, 0, currentX - 1, aHeight);
        }
        if (this.getDrawButtomLine()) {
            g2.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }
        this.paintChildren(g2);
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isSelectable & this.isEnabled()) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected void selectCurrentRow(Table2RowPanel p, boolean wasClick, int type) {
        this.model.getParentModel().selectRow(p, true, wasClick, type);
    }

    public void updateWidth() {
        if (this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        this.cellPadding = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.selectionColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_selection_color"));
    }

    public void setSelected(int b, boolean wasClick) {
        this.isSelected = b;
        this.delegateSelection2Childs(b);
        this.repaint(32L);
    }

    @Override
    public void setSelected(int isSelected) {
        this.selectCurrentRow(this, false, isSelected);
    }

    @Override
    public int isSelected() {
        return this.isSelected;
    }

    public void delegateSelection2Childs(int isSelected) {
    }

    public Object getSortableObject() {
        return null;
    }

    public void setNextFocusableComponent(Focusable c) {
        this.nextFocusComponent = c;
    }

    @Override
    public void focusGained(FocusEvent e) {
        SelectionManager.getSelectionManager().focusGained(this);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public Component getFocusDelegationComponent() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Component c : this.getComponents()) {
            if (!(c instanceof Focusable)) continue;
            CheckedListAdder.addToList(a, (Focusable)((Object)c));
        }
        return a;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    public boolean isInnerComponent(Component c) {
        return false;
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
    }

    public boolean getDrawButtomLine() {
        return this.drawButtomLine;
    }

    public void setDrawButtomLine(boolean drawButtomLine) {
        this.drawButtomLine = drawButtomLine;
    }

    public static enum TableControlsType {
        NONE,
        ONE,
        TWO,
        THREE,
        FOUR;

    }
}

