/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2.defaults;

import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DefaultTable2RowPanelLayout
extends DefaultLayout {
    private final Table2RowPanel panel;
    private final List<Element> elements = new ArrayList<Element>();

    public DefaultTable2RowPanelLayout(Table2RowPanel panel) {
        this.panel = panel;
    }

    public void layoutElement(Component component, LayoutType layoutType) {
        this.elements.add(new Element(component, layoutType));
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(0, this.panel.getDefaultRowHeight());
    }

    @Override
    public void layoutContainer(Container parent) {
        int currentX = 0;
        int count = 0;
        for (Element element : this.elements) {
            int w = this.panel.getModel().getParentModel().getColumnWidth(count);
            if (element.layoutType == LayoutType.FILL) {
                element.component.setLocation(currentX + this.panel.getCellPadding(), (int)(((double)parent.getHeight() - element.component.getPreferredSize().getHeight()) / 2.0));
                element.component.setSize(w - 2 * this.panel.getCellPadding(), (int)element.component.getPreferredSize().getHeight());
            } else {
                element.component.setLocation(currentX + (int)(((double)w - element.component.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - element.component.getPreferredSize().getHeight()) / 2.0));
                element.component.setSize(element.component.getPreferredSize());
            }
            currentX += w;
            ++count;
        }
    }

    private class Element {
        public final Component component;
        public final LayoutType layoutType;

        private Element(Component component, LayoutType layoutType) {
            this.component = component;
            this.layoutType = layoutType;
        }
    }

    public static enum LayoutType {
        FILL,
        FIX;

    }
}

