/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2.filterChain;

import ch.icit.pegasus.client.gui.table2.filterChain.TableFilterChainListener;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDayTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodListener;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.layout.simple.FilterChainLayout;
import ch.icit.pegasus.client.gui.utils.layout.simple.FilterChainLayout2;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.searchbox.ConfigurableSearchTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextFieldListener;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class TableFilterChain
extends JPanelKillable
implements ItemListener,
SearchTextField2Listener,
Focusable,
SearchTextFieldListener,
ButtonListener,
NodeListener,
TitledPeriodListener {
    private static final long serialVersionUID = 1L;
    private List<TableFilterChainListener> listeners = new ArrayList<TableFilterChainListener>();
    private List<Component> components = new ArrayList<Component>();
    private TextButton search;
    private boolean isBlind;

    public TableFilterChain() {
        this.setLayout(new FilterChainLayout2());
        this.getFilterChainLayout().setHorizontalComponentsGap(10);
        this.getFilterChainLayout().setComponents(this.components);
        this.setOpaque(false);
    }

    public FilterChainLayout getFilterChainLayout() {
        return (FilterChainLayout)this.getLayout();
    }

    public void addSearchButton() {
        if (this.search == null) {
            this.search = new TextButton(Words.SEARCH);
            this.add(this.search);
            this.getFilterChainLayout().setSearchButton(this.search);
            this.search.addButtonListener(this);
        }
    }

    public void addTableFilterChainListener(TableFilterChainListener listener) {
        this.listeners.add(listener);
    }

    public void setDefault_comboBoxWidth(int default_comboBoxWidth) {
        this.getFilterChainLayout().setDefaultComboBoxWidth(default_comboBoxWidth);
    }

    public void setDefault_comboSearchFieldWidth(int default_comboSearchFieldWidth) {
        this.getFilterChainLayout().setDefaultSearchTextField2Width(default_comboSearchFieldWidth);
    }

    public void setDefault_searchFieldWidth(int default_searchFieldWidth) {
        this.getFilterChainLayout().setDefaultSearchBoxWidth(default_searchFieldWidth);
    }

    public void removeTableFilterChainListener(TableFilterChainListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(String id, Object value, Component source) {
        if (this.isBlind) {
            return;
        }
        for (TableFilterChainListener l : this.listeners) {
            l.valueChanged(id, value, source);
        }
    }

    public SearchComboBox addStoreSearch(String id, String title) {
        return this.addStoreSearch(id, title, false);
    }

    public SearchComboBox addStoreSearch(String id, String title, boolean withall) {
        SearchComboBox b = SearchComboBoxFactory.getStoreSearchField(withall);
        b.setID(id);
        b.addSearchTextFieldListener(this);
        TitledItem<SearchComboBox> t = new TitledItem<SearchComboBox>(b, title, TitledItem.TitledItemOrientation.NORTH);
        t.setProgress(1.0f);
        this.add(t);
        this.components.add(t);
        return b;
    }

    public SearchTextField2<StorePositionLight> addStorePositionSearch(String id, String title, boolean withall) {
        SearchTextField2<StorePositionLight> b = SearchTextField2Factory.getStorePositionSearchField(withall, new DTOProxyNode());
        b.setID(id);
        b.addSearchTextFieldListener(this);
        TitledItem<SearchTextField2<StorePositionLight>> t = new TitledItem<SearchTextField2<StorePositionLight>>(b, title, TitledItem.TitledItemOrientation.NORTH);
        t.setProgress(1.0f);
        this.add(t);
        this.components.add(t);
        return b;
    }

    public SearchComboBox addSupplierSearch(String id, String title) {
        SearchComboBox b = SearchComboBoxFactory.getSupplierSearchField(true);
        b.setID(id);
        b.addSearchTextFieldListener(this);
        TitledItem<SearchComboBox> t = new TitledItem<SearchComboBox>(b, title, TitledItem.TitledItemOrientation.NORTH);
        t.setProgress(1.0f);
        this.add(t);
        this.components.add(t);
        return b;
    }

    public SearchComboBox addCustomerSearchField(String id) {
        SearchComboBox b = SearchComboBoxFactory.getCustomerSearchField(true);
        b.setID(id);
        b.addSearchTextFieldListener(this);
        TitledItem<SearchComboBox> t = new TitledItem<SearchComboBox>(b, Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        t.setProgress(1.0f);
        this.add(t);
        this.components.add(t);
        return b;
    }

    public void addStowingListTemplateField(String id) {
        SearchTextField2<StowingListTemplateComplete> searchField = SearchTextField2Factory.getStowingTemplateSearchField(true, new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("StowingList");
        TitledItem<SearchTextField2<StowingListTemplateComplete>> item = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(searchField, Words.STOWING_LIST, TitledItem.TitledItemOrientation.NORTH);
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public ComboBox addSelectionCombo(String id, String title, ComboBox box) {
        box.setID(id);
        box.addItemListener(this);
        TitledItem<ComboBox> t = new TitledItem<ComboBox>(box, title, TitledItem.TitledItemOrientation.NORTH);
        t.setProgress(1.0f);
        this.add(t);
        this.components.add(t);
        return box;
    }

    public SearchTextField addSeachField(String id, String title) {
        SearchTextField text = new SearchTextField();
        text.setID(id);
        text.addSearchTextFieldListener(this);
        TitledItem<SearchTextField> t = new TitledItem<SearchTextField>(text, title, TitledItem.TitledItemOrientation.NORTH);
        this.add(t);
        this.components.add(t);
        return text;
    }

    public void addConfigurableSearchField(String id, String title, String defaultText, MiniComboBox comboBox) {
        ConfigurableSearchTextField configSearchField = new ConfigurableSearchTextField();
        configSearchField.setUseUpperCase(false);
        configSearchField.setMiniComboBox(comboBox);
        configSearchField.setID(id);
        configSearchField.setName(title);
        configSearchField.setDefaultText(defaultText);
        configSearchField.addSearchTextFieldListener(this);
        TitledItem<ConfigurableSearchTextField> item = new TitledItem<ConfigurableSearchTextField>(configSearchField, title, TitledItem.TitledItemOrientation.NORTH);
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        this.validate();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() instanceof ComboBox) {
                ComboBox b = (ComboBox)e.getSource();
                this.fireEvent(b.getID(), b.getSelectedItem(), (Component)e.getSource());
            } else if (e.getSource() instanceof MultiSelectionComboBox) {
                MultiSelectionComboBox box = (MultiSelectionComboBox)e.getSource();
                this.fireEvent(box.getID(), box.getSelectedObjects(), box);
            } else if (e.getSource() instanceof MultiSelectionPanel) {
                MultiSelectionPanel box = (MultiSelectionPanel)e.getSource();
                this.fireEvent(box.getID(), e.getItem(), box);
            }
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.fireEvent(source.getID(), n.getValue(), source);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.listeners.clear();
        for (Component c : this.components) {
            if (c instanceof Killable) {
                ((Killable)((Object)c)).kill();
                continue;
            }
            this.remove(c);
        }
        this.components.clear();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Component c : this.components) {
            if (!(c instanceof Focusable)) continue;
            a.addAll(((Focusable)((Object)c)).getFocusComponents());
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (Component c : this.components) {
            c.setEnabled(isEnabled);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        for (Component c : this.components) {
            if (!(c instanceof Focusable)) continue;
            ((Focusable)((Object)c)).requestFocusInWindowNow();
            return;
        }
    }

    @Override
    public void textChanged(String nText, SearchTextField source) {
        this.fireEvent(source.getID(), nText, source);
    }

    public void setBlind(boolean b) {
        this.isBlind = b;
    }

    public boolean isBlind() {
        return this.isBlind;
    }

    public void addSpecialComponent(Component c) {
        this.add(c);
        this.components.add(c);
    }

    public SearchTextField2 addArticleSearchField(String id, String title) {
        SearchComboBox b = SearchComboBoxFactory.getBasicArticleSearchField(true);
        b.setID(id);
        b.addSearchTextFieldListener(this);
        TitledItem<SearchComboBox> t = new TitledItem<SearchComboBox>(b, title, TitledItem.TitledItemOrientation.NORTH);
        t.setProgress(1.0f);
        this.add(t);
        this.components.add(t);
        return b;
    }

    public boolean isInnerComponent(Component c) {
        for (Component comp : this.components) {
            ComboBox b = null;
            if (comp instanceof ComboBox) {
                b = (ComboBox)comp;
            } else if (comp instanceof TitledItem && ((TitledItem)comp).getElement() instanceof ComboBox) {
                b = (ComboBox)((TitledItem)comp).getElement();
            }
            if (b == null) continue;
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(b.getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    public CheckBox addCheckBox(String filterCheckbox, boolean b) {
        CheckBox box = new CheckBox();
        box.setID(filterCheckbox);
        box.setDefaultValue(b);
        box.setChecked(b);
        box.addButtonListener(this);
        this.add(box);
        this.components.add(box);
        return box;
    }

    public CheckBox addCheckBox(String filterCheckbox, String title, boolean b) {
        CheckBox box = new CheckBox();
        box.setID(filterCheckbox);
        box.setDefaultValue(b);
        box.setChecked(b);
        box.addButtonListener(this);
        TitledItem<CheckBox> i = new TitledItem<CheckBox>(box, title, TitledItem.TitledItemOrientation.EAST);
        this.add(i);
        this.components.add(i);
        return box;
    }

    public void fadeInAllComponents() {
        for (Component c : this.components) {
            if (!(c instanceof Fadable)) continue;
            ((Fadable)((Object)c)).fadeIn();
        }
    }

    public void addMultiSelection(MultiSelectionPanel<MultiHaulTypeSelectionComboBox> box, String id, String title) {
        box.setID(id);
        box.setName(title);
        box.setProgress(1.0f);
        TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>> item = new TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>>(box, title, TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        box.addItemListener(this);
        this.validate();
    }

    public TitledPeriodEditor addPeriodSelection(String id, java.util.Date startDate, java.util.Date endDate, String title, boolean useDefaultTitle) {
        ViewNode sD = new ViewNode("startDate");
        sD.setValue((Object)startDate, 0L);
        ViewNode eD = new ViewNode("endDate");
        eD.setValue((Object)endDate, 0L);
        sD.addNodeListener((NodeListener)this);
        eD.addNodeListener((NodeListener)this);
        JPanelFadable edit = null;
        if (useDefaultTitle) {
            edit = new TitledPeriodEditor((Node<Date>)sD, (Node<Date>)eD, useDefaultTitle, null);
            ((TitledPeriodEditor)edit).setFilterChain(true);
            ((TitledPeriodEditor)edit).setId(id);
            ((TitledPeriodEditor)edit).setTitleText(Words.PERIOD_START, Words.PERIOD_TO);
            ((TitledPeriodEditor)edit).getStartDateTitledItem().setInnerGap(-2);
            ((TitledPeriodEditor)edit).getEndDateTitledItem().setInnerGap(-2);
            ((TitledPeriodEditor)edit).setProgress(0.0f);
            ((TitledPeriodEditor)edit).addTitledPeriodListener(this);
        } else {
            edit = new TitledItem<TitledPeriodEditor>(new TitledPeriodEditor((Node<Date>)sD, (Node<Date>)eD, false, null), title, TitledItem.TitledItemOrientation.NORTH);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).setFilterChain(true);
            ((TitledItem)edit).setInnerGap(-4);
            ((TitledItem)edit).setProgress(0.0f);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).setId(id);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).addTitledPeriodListener(this);
        }
        this.components.add(edit);
        this.add(edit);
        this.validate();
        if (useDefaultTitle) {
            return (TitledPeriodEditor)edit;
        }
        return (TitledPeriodEditor)((TitledItem)edit).getElement();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source instanceof CheckBox) {
            CheckBox b = (CheckBox)source;
            this.fireEvent(b.getID(), b.isChecked(), b);
        } else if (source == this.search) {
            this.fireEvent("Search", null, this.search);
        }
    }

    public void valueChanged(Node<?> node) {
        TitledDayTimePeriodChooser t;
        if (node.getName().equals("startDate")) {
            TitledPeriodEditor t2 = this.getPeriodSelector4Node(node);
            if (t2 != null) {
                this.fireEvent(t2.getId(), t2, t2);
            }
        } else if (node.getName().equals("endDate")) {
            TitledPeriodEditor t3 = this.getPeriodSelector4Node(node);
            if (t3 != null) {
                this.fireEvent(t3.getId(), t3, t3);
            }
        } else if (node.getName().equals("startTime")) {
            TitledDayTimePeriodChooser t4 = this.getDayTimeSelection4Node(node);
            if (t4 != null) {
                this.fireEvent(t4.getId(), t4, t4);
            }
        } else if (node.getName().equals("endTime") && (t = this.getDayTimeSelection4Node(node)) != null) {
            this.fireEvent(t.getId(), t, t);
        }
    }

    private TitledPeriodEditor getPeriodSelector4Node(Node node) {
        for (Component c : this.components) {
            TitledPeriodEditor p;
            if (c instanceof TitledPeriodEditor) {
                p = (TitledPeriodEditor)c;
                if (p.getStartDateChooser().getNode() == node) {
                    return p;
                }
                if (p.getEndDateChooser().getNode() != node) continue;
                return p;
            }
            if (!(c instanceof TitledItem) || !(((TitledItem)c).getElement() instanceof TitledPeriodEditor)) continue;
            p = (TitledPeriodEditor)((TitledItem)c).getElement();
            if (p.getStartDateChooser().getNode() == node) {
                return p;
            }
            if (p.getEndDateChooser().getNode() != node) continue;
            return p;
        }
        return null;
    }

    private TitledDayTimePeriodChooser getDayTimeSelection4Node(Node node) {
        for (Component c : this.components) {
            TitledDayTimePeriodChooser p;
            if (c instanceof TitledDayTimePeriodChooser) {
                p = (TitledDayTimePeriodChooser)c;
                if (p.getTimeStartNode() == node) {
                    return p;
                }
                if (p.getTimeEndNode() != node) continue;
                return p;
            }
            if (!(c instanceof TitledItem) || !(((TitledItem)c).getElement() instanceof TitledDayTimePeriodChooser)) continue;
            p = (TitledDayTimePeriodChooser)((TitledItem)c).getElement();
            if (p.getTimeStartNode() == node) {
                return p;
            }
            if (p.getTimeEndNode() != node) continue;
            return p;
        }
        return null;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void newPeriodSelected(Date start, Date end, TitledPeriodEditor source) {
        TitledPeriodEditor t = source;
        if (t != null) {
            this.fireEvent(t.getId(), t, t);
        }
    }

    public void updateSearch() {
        this.fireEvent(null, null, this);
    }

    public TextButton getSearchButton() {
        return this.search;
    }
}

