/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.production.DayFiguresComplete;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class DayFiguresView
extends JPanelFadable
implements Focusable,
NodeListener,
LafListener {
    private static final long serialVersionUID = 1L;
    private Node<DayFiguresComplete> node;
    private TextLabel onStockRead;
    private TextField onStockWrite;
    private TextLabel required;
    private TextField plannedWrite;
    private TextLabel plannedRead;
    private boolean isStockEnterPossible = false;
    private boolean isLocked = true;
    private boolean userSetted = false;
    private Color userSettedColor;
    private Color stockOverflow;
    private Color stockUnderflow;
    private boolean isEdit = true;
    private final Table2RowPanel rowPanel;

    public DayFiguresView(Node<DayFiguresComplete> n, boolean preCalcStock, Table2RowPanel p) {
        this.rowPanel = p;
        this.setFocusable(false);
        this.setOpaque(false);
        this.lafAttributeChanged("All attribues changed");
        this.userSetted = ((DayFiguresComplete)n.getValue()).getSetByUser();
        this.setLayout(new Layout());
        Date fd = ((DayFiguresComplete)n.getValue()).getDay();
        if (CalendarUtil.isSameDay((Date)fd, (int)1)) {
            this.isStockEnterPossible = true;
        }
        this.setNode(n, preCalcStock);
        this.lock();
        if (this.userSetted) {
            this.activateUserSetted();
        }
        this.checkOverUnderFlow();
    }

    public boolean isUnlockable() {
        return this.isStockEnterPossible;
    }

    public void unlock() {
        this.isLocked = false;
        this.onStockRead.fadeOut(false);
        this.onStockWrite.fadeIn();
    }

    public void lock() {
        this.isLocked = true;
        this.onStockRead.fadeIn();
        this.onStockWrite.fadeOut(false);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isUnlocked() {
        return !this.isLocked;
    }

    public Component getFocusableComponent() {
        return this.plannedWrite.getTextField();
    }

    public void setNode(Node<DayFiguresComplete> n, boolean preCalcStock) {
        if (this.node != null) {
            this.node.getChildNamed(new String[]{"stock"}).removeNodeListener((NodeListener)this);
            if (this.node.getChildNamed(new String[]{"preCalc"}) != null) {
                this.node.getChildNamed(new String[]{"preCalc"}).addNodeListener((NodeListener)this);
            }
            this.node.getParent().getParent().getChildNamed(new String[]{"minStock"}).removeNodeListener((NodeListener)this);
            this.node.getParent().getParent().getChildNamed(new String[]{"optimumStock"}).removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            String stockName = "preCalc";
            if (this.node.getChildNamed(new String[]{stockName}) != null) {
                this.node.getChildNamed(new String[]{stockName}).addNodeListener((NodeListener)this);
            }
            if (this.userSetted) {
                stockName = "stock";
            }
            if (this.onStockRead == null) {
                this.onStockRead = new TextLabel(this.node.getChildNamed(new String[]{stockName}), ConverterRegistry.getConverter(IntegerConverter.class));
                this.onStockRead.getFader().setPermanent(true);
                this.onStockRead.setAlignment(0);
                this.onStockRead.setReadOnlyTextField(true);
                this.onStockRead.setProgress(0.0f);
                this.add(this.onStockRead);
            } else {
                this.onStockRead.setNode(this.node.getChildNamed(new String[]{stockName}));
            }
            stockName = "stock";
            this.node.getChildNamed(new String[]{stockName}).addNodeListener((NodeListener)this);
            if (this.onStockWrite == null) {
                this.onStockWrite = new NumberTextField(this.node.getChildNamed(new String[]{stockName}), TextFieldType.INT);
                this.onStockWrite.getFader().setPermanent(true);
                this.onStockWrite.setProgress(0.0f);
                this.add(this.onStockWrite);
            } else {
                this.onStockWrite.setNode(this.node.getChildNamed(new String[]{stockName}));
            }
            if (this.required == null) {
                this.required = new TextLabel(this.node.getChildNamed(new String[]{"requiredAmount"}), ConverterRegistry.getConverter(IntegerConverter.class));
                this.required.setAlignment(0);
                this.required.setReadOnlyTextField(true);
                this.required.setProgress(1.0f);
                this.add(this.required);
            } else {
                this.required.setNode(this.node.getChildNamed(new String[]{"requiredAmount"}));
            }
            if (this.plannedRead == null) {
                this.plannedRead = new TextLabel(this.node.getChildNamed(new String[]{"plannedAmount"}), ConverterRegistry.getConverter(IntegerConverter.class));
                this.plannedRead.setProgress(1.0f);
                this.plannedRead.setReadOnlyTextField(true);
                this.plannedRead.setAlignment(0);
                this.add(this.plannedRead);
            } else {
                this.plannedRead.setNode(this.node.getChildNamed(new String[]{"plannedAmount"}));
            }
            if (this.plannedWrite == null) {
                this.plannedWrite = new NumberTextField(this.node.getChildNamed(new String[]{"plannedAmount"}), TextFieldType.INT);
                this.plannedWrite.setProgress(1.0f);
                this.add(this.plannedWrite);
            } else {
                this.plannedWrite.setNode(this.node.getChildNamed(new String[]{"plannedAmount"}));
            }
            this.node.getParent().getParent().getChildNamed(new String[]{"minStock"}).addNodeListener((NodeListener)this);
            this.node.getParent().getParent().getChildNamed(new String[]{"optimumStock"}).addNodeListener((NodeListener)this);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (isEnabled) {
            this.plannedWrite.setEnabled(isEnabled);
        } else {
            this.plannedRead.setEnabled(isEnabled);
        }
        this.onStockWrite.setEnabled(isEnabled);
        this.onStockRead.setEnabled(isEnabled);
        this.required.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (!this.isLocked) {
            CheckedListAdder.addToList(a, this.onStockWrite);
        }
        CheckedListAdder.addToList(a, this.plannedWrite);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.plannedWrite.setVisibleContainer(pane);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.plannedWrite.kill();
        if (this.onStockRead != null) {
            this.onStockRead.kill();
        }
        if (this.onStockWrite != null) {
            this.onStockWrite.kill();
        }
        this.plannedRead.kill();
        this.required.kill();
        this.plannedWrite = null;
        this.plannedRead = null;
        this.onStockWrite = null;
        this.onStockRead = null;
        this.required = null;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    private void activateUserSetted() {
        this.onStockRead.setLeftUpperCornerPainting(true, this.userSettedColor);
    }

    private void activateOverFlow() {
        this.onStockRead.setRightUpperCornerPainting(true, this.stockOverflow);
    }

    private void activateUnderFlow() {
        this.onStockRead.setRightUpperCornerPainting(true, this.stockUnderflow);
    }

    private void deactivateUnderOverFlow() {
        this.onStockRead.setRightUpperCornerPainting(false, null);
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals("stock")) {
            this.node.getChildNamed(new String[]{"setByUser"}).setValue((Object)true, System.currentTimeMillis());
            this.onStockRead.setNode(this.node.getChildNamed(new String[]{"stock"}));
            this.activateUserSetted();
        }
        this.checkOverUnderFlow();
    }

    private void checkOverUnderFlow() {
        int amount = 0;
        if (((Boolean)this.node.getChildNamed(new String[]{"setByUser"}).getValue()).booleanValue()) {
            amount = (Integer)this.node.getChildNamed(new String[]{"stock"}).getValue();
        } else if (this.node.getChildNamed(new String[]{"preCalc"}) != null) {
            amount = (Integer)this.node.getChildNamed(new String[]{"preCalc"}).getValue();
        }
        if (!this.checkUnderFlow(amount)) {
            if (this.checkOverFlow(amount)) {
                this.activateOverFlow();
            } else {
                this.deactivateUnderOverFlow();
            }
        } else {
            this.activateUnderFlow();
        }
    }

    private boolean checkUnderFlow(int amount) {
        Node ppfc = this.rowPanel.getModel().getNode();
        Node min = ppfc.getChildNamed(new String[]{"minStock"});
        if (min.getValue() != null) {
            return amount < (Integer)min.getValue();
        }
        return false;
    }

    private boolean checkOverFlow(int amount) {
        Node ppfc = this.rowPanel.getModel().getNode();
        Node opt = ppfc.getChildNamed(new String[]{"optimumStock"});
        if (opt.getValue() != null) {
            return amount > (Integer)opt.getValue();
        }
        return false;
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.userSettedColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color"));
        this.stockOverflow = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stockoverflow_color"));
        this.stockUnderflow = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stockunderflow_color"));
    }

    public void setPlannedEditable(boolean isEdit) {
        this.isEdit = isEdit;
        if (isEdit) {
            this.plannedWrite.setEnabled(true);
            this.plannedWrite.setProgress(1.0f);
            this.plannedRead.setEnabled(false);
            this.plannedRead.setProgress(0.0f);
        } else {
            this.plannedWrite.setEnabled(false);
            this.plannedWrite.setProgress(0.0f);
            this.plannedRead.setEnabled(true);
            this.plannedRead.setProgress(1.0f);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.onStockWrite != null) {
            this.onStockWrite.requestFocusInWindowNow();
        } else if (this.plannedWrite != null) {
            this.plannedWrite.requestFocusInWindowNow();
        }
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int innerGap = 2;
            w -= 2 * innerGap;
            int currentW = 0;
            DayFiguresView.this.onStockWrite.setLocation(0, (int)(((double)parent.getHeight() - DayFiguresView.this.onStockWrite.getPreferredSize().getHeight()) / 2.0));
            DayFiguresView.this.onStockWrite.setSize(w /= 3, (int)DayFiguresView.this.onStockWrite.getPreferredSize().getHeight());
            DayFiguresView.this.onStockRead.setLocation(0, (int)(((double)parent.getHeight() - DayFiguresView.this.onStockRead.getPreferredSize().getHeight()) / 2.0));
            DayFiguresView.this.onStockRead.setSize(w, (int)DayFiguresView.this.onStockRead.getPreferredSize().getHeight());
            currentW = DayFiguresView.this.onStockRead.getX() + DayFiguresView.this.onStockRead.getWidth();
            DayFiguresView.this.required.setLocation(currentW + innerGap, (int)(((double)parent.getHeight() - DayFiguresView.this.required.getPreferredSize().getHeight()) / 2.0));
            DayFiguresView.this.required.setSize(w, (int)DayFiguresView.this.required.getPreferredSize().getHeight());
            DayFiguresView.this.plannedWrite.setLocation(DayFiguresView.this.required.getX() + DayFiguresView.this.required.getWidth() + innerGap, (int)(((double)parent.getHeight() - DayFiguresView.this.plannedWrite.getPreferredSize().getHeight()) / 2.0));
            DayFiguresView.this.plannedWrite.setSize(w, (int)DayFiguresView.this.plannedWrite.getPreferredSize().getHeight());
            DayFiguresView.this.plannedRead.setLocation(DayFiguresView.this.required.getX() + DayFiguresView.this.required.getWidth() + innerGap, (int)(((double)parent.getHeight() - DayFiguresView.this.plannedRead.getPreferredSize().getHeight()) / 2.0));
            DayFiguresView.this.plannedRead.setSize(w, (int)DayFiguresView.this.plannedRead.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h = !DayFiguresView.this.isLocked ? (int)DayFiguresView.this.onStockWrite.getPreferredSize().getHeight() : (int)DayFiguresView.this.onStockRead.getPreferredSize().getHeight();
            if ((double)h < DayFiguresView.this.required.getPreferredSize().getHeight()) {
                h = (int)DayFiguresView.this.required.getPreferredSize().getHeight();
            }
            if ((double)h < DayFiguresView.this.plannedWrite.getPreferredSize().getHeight()) {
                h = (int)DayFiguresView.this.plannedWrite.getPreferredSize().getHeight();
            }
            return new Dimension(0, h);
        }
    }
}

