/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ExcecutionTimeDisplayer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ExcecutionTimeDisplayer displayer;
    private HashMap<Long, Element> hash = new HashMap();
    private ScrollPane scrollPane;
    private JPanel viewPort;
    private List<GroupElement> viewlist = new ArrayList<GroupElement>();
    private GroupElement currentGroup;
    private static boolean isActiv;

    private ExcecutionTimeDisplayer() {
        super("Roundtrip Measure");
        if (isActiv) {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
            this.scrollPane = new ScrollPane();
            this.viewPort = new JPanel();
            this.viewPort.setBackground(this.getBackground());
            this.scrollPane.setBackground(this.getBackground());
            this.viewPort.setLayout(new ViewPortLayout());
            this.scrollPane.setViewportView(this.viewPort);
            this.getContentPane().setLayout(new Layout());
            this.getContentPane().add(this.scrollPane);
            this.setSize(400, 400);
            this.setVisible(true);
        }
    }

    public static ExcecutionTimeDisplayer getExcecutionTimeDisplayer() {
        if (displayer == null) {
            displayer = new ExcecutionTimeDisplayer();
        }
        return displayer;
    }

    public void startNewGroup(String groupName) {
        if (this.currentGroup != null) {
            this.closeGroup();
        }
        this.currentGroup = new GroupElement(System.currentTimeMillis(), groupName);
        if (isActiv) {
            this.viewlist.add(this.currentGroup);
            this.viewPort.add(this.currentGroup);
        }
    }

    public void closeGroup() {
        if (this.currentGroup != null) {
            this.currentGroup.closeGroup();
        }
        this.currentGroup = null;
    }

    public long startTimeMeasure(String nameOfProcess) {
        if (isActiv) {
            if (this.currentGroup == null) {
                this.startNewGroup("Autocreated group");
            }
            Element a = new Element(nameOfProcess, System.currentTimeMillis());
            this.hash.put(a.getStartTime(), a);
            this.currentGroup.addElement(a);
            this.viewPort.validate();
            return a.getStartTime();
        }
        return 0L;
    }

    public void pushTimeStamp(String newProcess, long id) {
        Element a;
        if (isActiv && (a = this.hash.get(id)) != null) {
            a.pushTimeStamp(new TimeMeasure(System.currentTimeMillis(), newProcess));
        }
    }

    public void stopTimeMeasure(long id, String name) {
        Element a;
        if (isActiv && (a = this.hash.get(id)) != null) {
            a.pushTimeStamp(new TimeMeasure(System.currentTimeMillis(), name));
        }
    }

    private static String getFooterString(GroupElement e) {
        String t = "All Complete";
        long totalDif = 0L;
        for (Element el : e.elements) {
            long startT = el.startTime;
            long endT = ((TimeMeasure)el.timeStamps.get(el.timeStamps.size() - 1)).time;
            long dif = endT - startT;
            totalDif += dif;
        }
        String r = ExcecutionTimeDisplayer.getTimeString(totalDif);
        t = t + "     Server2Node roundtrip was " + r;
        long dif = e.endTime - e.startTime;
        r = ExcecutionTimeDisplayer.getTimeString(dif);
        t = t + "     Process roundtrip was " + r;
        return t;
    }

    private static String getTimeString(long t) {
        String value = "";
        long nt = t / 1000L;
        long nt2 = 0L;
        if (nt == 0L) {
            return "" + t + " ms";
        }
        nt2 = nt / 60L;
        if (nt2 == 0L) {
            return "" + nt + " s";
        }
        nt = nt2 / 60L;
        if (nt == 0L) {
            return "" + nt2 + " min";
        }
        return "" + nt + " h";
    }

    static {
        isActiv = false;
    }

    private class TimeMeasure {
        private long time;
        private String name;

        public TimeMeasure(long t, String n) {
            this.time = t;
            this.name = n;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private class Element
    extends JPanel {
        private long startTime;
        private String processName;
        private List<TimeMeasure> timeStamps = new ArrayList<TimeMeasure>();
        private ArrayList<TextLabel> times = new ArrayList();

        public Element(String name, long t) {
            this.startTime = t;
            this.processName = name;
            this.pushTimeStamp(new TimeMeasure(this.startTime, name));
            this.setOpaque(false);
            this.setLayout(new ElementLayout());
            TextLabel f = new TextLabel("Start measure of " + this.processName);
            this.times.add(f);
            this.add(f);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.lightGray);
            g2.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            this.paintChildren(g2);
        }

        public void pushTimeStamp(TimeMeasure t) {
            this.timeStamps.add(t);
            int i = this.timeStamps.indexOf(t);
            if (i > 0) {
                long nt = t.getTime();
                long ot = this.timeStamps.get(i - 1).getTime();
                long dif = nt - ot;
                TextLabel l = new TextLabel(t.getName() + ":     " + ExcecutionTimeDisplayer.getTimeString(dif));
                this.times.add(l);
                this.add(l);
                ExcecutionTimeDisplayer.this.viewPort.revalidate();
            }
        }

        public long getStartTime() {
            return this.startTime;
        }

        private class ElementLayout
        extends DefaultLayout {
            private ElementLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentY = 0;
                for (TextLabel t : (ArrayList)Element.this.times.clone()) {
                    t.setLocation(0, currentY);
                    t.setSize(parent.getWidth(), (int)t.getPreferredSize().getHeight());
                    currentY += t.getHeight();
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int currentY = 0;
                List l = (List)Element.this.times.clone();
                for (TextLabel t : l) {
                    currentY = (int)((double)currentY + t.getPreferredSize().getHeight());
                }
                return new Dimension(0, currentY);
            }
        }
    }

    private class GroupElement
    extends JPanel
    implements ButtonListener {
        private long startTime;
        private long endTime;
        private String groupName;
        private List<Element> elements = new ArrayList<Element>();
        private ExpandIcon expand;
        private TextLabel title;
        private TextLabel footer;
        private boolean isExpanded = true;

        public GroupElement(long start, String gn) {
            this.startTime = start;
            this.groupName = gn;
            this.setOpaque(false);
            this.title = new TextLabel(this.groupName);
            this.expand = new ExpandIcon();
            this.expand.setExpanded(true);
            this.expand.addButtonListener(this);
            this.title.setProgress(1.0f);
            this.expand.setProgress(1.0f);
            this.setLayout(new GroupElementLayout());
            this.add(this.title);
            this.add(this.expand);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(new Color(72, 72, 72));
            if (this.isExpanded && this.footer != null) {
                g2.fillRect(0, this.getHeight() - 20, this.getWidth(), 20);
            }
            this.paintChildren(g2);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.expand) {
                this.isExpanded = !this.isExpanded;
                this.invalidate();
                ExcecutionTimeDisplayer.this.viewPort.validate();
                ExcecutionTimeDisplayer.this.viewPort.revalidate();
            }
        }

        public void closeGroup() {
            this.endTime = System.currentTimeMillis();
            if (isActiv) {
                this.footer = new TextLabel(ExcecutionTimeDisplayer.getFooterString(this));
                this.add(this.footer);
                this.invalidate();
                ExcecutionTimeDisplayer.this.viewPort.validate();
                ExcecutionTimeDisplayer.this.viewPort.revalidate();
            }
        }

        public void addElement(Element e) {
            this.elements.add(e);
            this.add(e);
        }

        private class GroupElementLayout
        extends DefaultLayout {
            private GroupElementLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentY = 5;
                GroupElement.this.expand.setLocation(5, 6);
                GroupElement.this.expand.setSize(GroupElement.this.expand.getPreferredSize());
                GroupElement.this.title.setLocation(GroupElement.this.expand.getX() + GroupElement.this.expand.getWidth() + 5, 0);
                GroupElement.this.title.setSize(parent.getWidth() - GroupElement.this.title.getX(), (int)GroupElement.this.title.getPreferredSize().getHeight());
                currentY += GroupElement.this.title.getHeight();
                if (GroupElement.this.isExpanded) {
                    for (Element t : GroupElement.this.elements) {
                        t.setLocation(30, currentY);
                        t.setSize(parent.getWidth() - 30, (int)t.getPreferredSize().getHeight());
                        currentY += t.getHeight();
                    }
                    if (GroupElement.this.footer != null) {
                        GroupElement.this.footer.setLocation(10, currentY);
                        GroupElement.this.footer.setSize(parent.getWidth() - GroupElement.this.footer.getX(), (int)GroupElement.this.footer.getPreferredSize().getHeight());
                        currentY += GroupElement.this.footer.getHeight();
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int currentY = 5;
                currentY = (int)((double)currentY + GroupElement.this.title.getPreferredSize().getHeight());
                if (GroupElement.this.isExpanded) {
                    for (Element t : GroupElement.this.elements) {
                        currentY = (int)((double)currentY + t.getPreferredSize().getHeight());
                    }
                    if (GroupElement.this.footer != null) {
                        currentY = (int)((double)currentY + GroupElement.this.footer.getPreferredSize().getHeight());
                    }
                }
                return new Dimension(0, currentY);
            }
        }
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = 0;
            for (GroupElement e : ExcecutionTimeDisplayer.this.viewlist) {
                e.setLocation(0, currentY);
                e.setSize(parent.getWidth(), (int)e.getPreferredSize().getHeight());
                currentY += e.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = 0;
            for (GroupElement e : ExcecutionTimeDisplayer.this.viewlist) {
                currentY = (int)((double)currentY + e.getPreferredSize().getHeight());
            }
            return new Dimension(0, currentY);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ExcecutionTimeDisplayer.this.scrollPane.setLocation(0, 0);
            ExcecutionTimeDisplayer.this.scrollPane.setSize(parent.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

