/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class HorizontalSeparator
extends JPanelFadable
implements LafListener {
    private static final long serialVersionUID = 1L;
    private Color separatorColor;
    private int customPrefWidth = 0;
    private boolean useBackground;

    public HorizontalSeparator() {
        this.lafAttributeChanged("All attribues changed");
    }

    public boolean isUseBackground() {
        return this.useBackground;
    }

    public void setUseBackground(boolean useBackground) {
        this.useBackground = useBackground;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.useBackground) {
            g2.setColor(this.getBackground());
        } else {
            g2.setColor(this.separatorColor);
        }
        g2.drawLine(0, 0, this.getWidth(), 0);
    }

    public void setPreferredWidth(int w) {
        this.customPrefWidth = w;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.customPrefWidth, 1);
    }

    public void setSeparatorColor(Color c) {
        this.separatorColor = c;
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            this.separatorColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_editor_default_separator_color"));
            this.repaint(32L);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }
}

