/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.IPDFViewer;
import ch.icit.pegasus.client.gui.utils.LinkListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import com.sun.pdfview.PDFFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PageChooser
extends DefaultPanel
implements LinkListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private PDFFile currentFile;
    private int innerGap = 4;
    private boolean isFileSet;
    private Color selectionColor = new Color(102, 102, 102);
    private Color defaultColor;
    private ArrowButton previous;
    private ArrowButton next;
    private TextLabel currentSelectedLink;
    private IPDFViewer viewer;
    private int currentPage;
    private List<TextLabel> numbers = new ArrayList<TextLabel>();

    public PageChooser(IPDFViewer parentViewer) {
        this.viewer = parentViewer;
        this.init();
        this.setPDF(null);
    }

    public void setPDF(PDFFile pdfFile) {
        this.currentFile = pdfFile;
        this.installPDF();
    }

    private void init() {
        this.setLayout(new Layout());
        this.defaultColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.previous = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Left);
        this.next = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Right);
        this.previous.addButtonListener(this);
        this.next.addButtonListener(this);
        this.add(this.previous);
        this.add(this.next);
    }

    private void installPDF() {
        if (!this.isFileSet && this.numbers.size() > 0) {
            this.numbers.get(0).setText("1");
        }
        boolean bl = this.isFileSet = this.currentFile != null;
        if (this.isFileSet) {
            int i = this.numbers.size() - this.currentFile.getNumPages();
            if (i != 0) {
                TextLabel t;
                if (i > 0) {
                    while (i > 0) {
                        t = this.numbers.get(this.numbers.size() - 1);
                        this.remove(t);
                        t.removeLinkListener(this);
                        this.numbers.remove(t);
                        --i;
                    }
                } else if (i < 0) {
                    while (i < 0) {
                        t = new TextLabel();
                        t.setText("" + this.numbers.size() + 1);
                        t.setLink(true);
                        t.addLinkListener(this);
                        this.add(t);
                        this.numbers.add(t);
                        ++i;
                    }
                }
            }
            int c = 1;
            for (TextLabel l : this.numbers) {
                l.setText("" + c++);
                l.setLink(true);
                l.setForeground(this.defaultColor);
            }
        } else {
            for (int i = this.numbers.size(); i > 1; --i) {
                TextLabel t = this.numbers.get(this.numbers.size() - 1);
                this.remove(t);
                t.removeLinkListener(this);
                this.numbers.remove(t);
            }
            TextLabel l = null;
            if (this.numbers.size() > 0) {
                l = this.numbers.get(0);
            } else {
                l = new TextLabel();
                l.setLink(true);
                l.addLinkListener(this);
                this.add(l);
                this.numbers.add(l);
            }
            l.setForeground(this.selectionColor);
            l.setLink(false);
            l.setText("No Pages");
        }
        this.setEnabled(true);
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = this.isFileSet;
        if (b) {
            b = this.currentFile.getNumPages() > 0;
        }
        b = b && isEnabled;
        boolean n = b && this.currentPage < this.numbers.size();
        boolean p = b && this.currentPage > 1;
        this.next.setEnabled(n);
        this.previous.setEnabled(p);
        for (TextLabel t : this.numbers) {
            t.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.next.kill();
        this.previous.kill();
        this.next = null;
        this.previous = null;
        for (TextLabel t : this.numbers) {
            t.kill();
        }
        this.numbers.clear();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.previous);
        CheckedListAdder.addToList(a, this.previous);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.next.setVisibleContainer(pane);
        this.previous.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.previous.requestFocusInWindowNow();
    }

    @Override
    public void linkClicked(TextLabel label) {
        int pageNo = this.numbers.indexOf(label) + 1;
        this.viewer.pageChange(pageNo);
    }

    public void setSelectedPage(int i) {
        this.currentPage = i;
        if (this.currentSelectedLink != null) {
            this.currentSelectedLink.setForeground(this.defaultColor);
            this.currentSelectedLink.setLink(true);
        }
        TextLabel t = this.numbers.get(i - 1);
        t.setForeground(this.selectionColor);
        t.setLink(false);
        this.currentSelectedLink = t;
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.previous) {
            this.viewer.pageChange(this.currentPage - 1);
        } else if (source == this.next) {
            this.viewer.pageChange(this.currentPage + 1);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)PageChooser.this.next.getPreferredSize().getHeight();
            h += 10;
            int w = (int)PageChooser.this.previous.getPreferredSize().getWidth();
            w += PageChooser.this.innerGap;
            for (TextLabel t : PageChooser.this.numbers) {
                w = (int)((double)w + t.getPreferredSize().getWidth());
                w += PageChooser.this.innerGap;
            }
            w = (int)((double)w + PageChooser.this.next.getPreferredSize().getWidth());
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int cx = 0;
            PageChooser.this.previous.setLocation(cx, (int)(((double)parent.getHeight() - PageChooser.this.previous.getPreferredSize().getHeight()) / 2.0));
            PageChooser.this.previous.setSize(PageChooser.this.previous.getPreferredSize());
            cx += PageChooser.this.previous.getWidth() + PageChooser.this.innerGap;
            for (TextLabel l : PageChooser.this.numbers) {
                l.setLocation(cx, (int)(((double)parent.getHeight() - l.getPreferredSize().getHeight()) / 2.0));
                l.setSize(l.getPreferredSize());
                cx += l.getWidth() + PageChooser.this.innerGap;
            }
            PageChooser.this.next.setLocation(cx, (int)(((double)parent.getHeight() - PageChooser.this.next.getPreferredSize().getHeight()) / 2.0));
            PageChooser.this.next.setSize(PageChooser.this.next.getPreferredSize());
        }
    }
}

