/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Font;

public class QuantityRenderer
extends TextLabel {
    private static final long serialVersionUID = 1L;
    private static int amountWidth = -1;
    private static int unitWidth = -1;

    public QuantityRenderer(Node<?> n) {
        super(n, ConverterRegistry.getConverter(QuantityConverter1Decimal.class));
    }

    public QuantityRenderer(Node<?> n, Converter<?, ?> conf) {
        super(n, conf);
    }

    private static void ensurePrefWidths(Component c) {
        if (amountWidth == -1 && unitWidth == -1) {
            int alphanumerics;
            String t = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_unittext");
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            unitWidth = alphanumerics = c.getFontMetrics(f).stringWidth(t);
            t = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_amounttext");
            amountWidth = alphanumerics = c.getFontMetrics(f).stringWidth(t);
        }
    }

    public static int getPreferredSize(Component c) {
        QuantityRenderer.ensurePrefWidths(c);
        return amountWidth + 5 + unitWidth;
    }

    public boolean isFieldValid() {
        return this.isValid;
    }
}

