/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.utils.ScreenInsert;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.animators.Animator;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.node.IUndoable;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class Screen<T extends IUniversal>
extends JPanel
implements MouseListener,
Fadable,
IUndoable,
AnimationListener {
    private static final long serialVersionUID = 1L;
    private ScreenInsert<T> view;
    private Animator animator;
    private boolean isDestruction;
    private boolean isKilled;

    public Screen(ScreenInsert<T> view) {
        this.view = view;
        this.setLayout(null);
        this.setOpaque(false);
        this.setFocusable(true);
        this.addMouseListener(this);
        this.add(this.view);
        this.view.setLocation(0, 0);
        this.setVisible(true);
    }

    public void setAnimator(Animator ani) {
        this.animator = ani;
        if (this.animator.getAnimator() instanceof Mover) {
            ((Mover)this.animator.getAnimator()).addAnimationListener(this);
        } else if (this.animator.getAnimator() instanceof AlphaFader) {
            ((AlphaFader)this.animator.getAnimator()).addAnimationListener(this);
        }
    }

    public void escapeKeyPressed() {
        if (this.view != null) {
            this.view.escapeKeyPressed();
        }
    }

    public void saveKeyPressed() {
        if (this.view != null) {
            this.view.saveKeyPressed();
        }
    }

    public void killAfterFadeOut() {
        this.isDestruction = true;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.animator.getAnimationProgress()));
        this.paintChildren(g2);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.view.setEnabled(isEnabled);
    }

    @Override
    public void setProgress(float p) {
        this.animator.setAnimationProgress(p);
    }

    @Override
    public float getProgress() {
        return this.animator.getAnimationProgress();
    }

    @Override
    public void setSize(int w, int h) {
        this.view.setSize(w, h);
        super.setSize(w, h);
    }

    public void completeAllAnimationsImmediately() {
        this.view.stopAnimationsImmediately();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void animateForward(long time) {
        if (this.animator != null) {
            this.animator.animateForward(time);
        }
    }

    public void animateBackward(long time, boolean att) {
        this.animator.animateBackward(att, time);
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        if (this.view != null) {
            this.view.kill();
        }
        this.view = null;
        this.animator = null;
        this.removeMouseListener(this);
    }

    public ScreenInsert<T> getView() {
        return this.view;
    }

    @Override
    public void fadeIn() {
        this.animator.animateForward(-1L);
    }

    @Override
    public void fadeIn(long animationTime) {
        this.animator.animateForward(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.animator.animateBackward(destroy, animationTime);
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.animator.animateBackward(destroy, -1L);
    }

    public AlphaFader<Screen> getFader() {
        return null;
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        if (this.animator != null) {
            if (this.animator.getAnimator() instanceof Mover) {
                return ((Mover)this.animator.getAnimator()).isAnimating();
            }
            if (this.animator.getAnimator() instanceof AlphaFader) {
                return ((AlphaFader)this.animator.getAnimator()).isAnimating(AlphaFader.FadeType.FadeIn) || ((AlphaFader)this.animator.getAnimator()).isAnimating(AlphaFader.FadeType.FadeOut);
            }
        }
        return false;
    }

    public void redo() {
        if (this.view != null) {
            this.view.redo();
        }
    }

    public void undo() {
        if (this.view != null) {
            this.view.undo();
        }
    }

    @Override
    public void animationFinished(boolean wasFadin) {
        if (this.isDestruction) {
            this.kill();
        } else if (this.view instanceof RowSmartScreen) {
            ((RowSmartScreen)((Object)this.view)).startDataDownload();
        } else {
            this.view.loadingAnimationDone();
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void showHud(boolean show) {
        if (this.view != null) {
            this.view.showHud(show);
        }
    }
}

