/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.gui.utils.LinkListener;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ValueChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class TextLabel
extends JPanelFadable
implements Movable,
NodeListener,
LafListener,
MouseListener,
MouseMotionListener,
Validatable,
Nodable {
    private static final long serialVersionUID = 1L;
    private Color foregroundColor2;
    private Color disabledForegroundColor2;
    private String overriddenToolTipText;
    private String errorString;
    private boolean isReadOnlyTextField;
    private String text;
    private String displayedString = "";
    private int alignment = 7;
    private int textPosX;
    private int textWidth = 0;
    private int border = 0;
    private boolean isEmbossed = false;
    private List<LinkListener> linkListeners = new ArrayList<LinkListener>();
    private boolean isShortend = false;
    private int isSelected;
    private boolean isLineWrap = false;
    private int maxWidth = 0;
    private boolean isLink;
    private boolean delegateMouseEvents;
    private Component delegateComponent;
    private Mover<TextLabel> mover;
    private List<Node> nodes = new ArrayList<Node>();
    private List<ValueChangeListener> valueListeners = new ArrayList<ValueChangeListener>();
    private boolean isEnabled = true;
    private boolean shouldListenChildAddRemove = false;
    private Color foreground;
    private Color warningForeground;
    private Color invalidForeground;
    private Color disabledForeground;
    private Skin3Field mySkin;
    private Font normalFont;
    private Font selectedFont;
    protected Node node;
    protected Converter viewConverter;
    protected Object[] viewConverterAttributes;
    private boolean isLeftUpperCornerPainting;
    private boolean isRightUpperCornerPainting;
    private boolean isMouseOver = false;
    private Color leftUpperCornerColor;
    private Color rightUpperCornerColor;
    int cornerWidth = 7;
    protected boolean isValid = true;
    protected boolean isPermantent = false;
    private boolean isNodeBased;
    private boolean shouldValidate;
    private boolean isValidStatePermanent;
    private boolean isWarning = false;

    public TextLabel() {
        this("");
    }

    public TextLabel(String text) {
        this.setText(text);
        this.foregroundColor2 = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("save_cancel_button_foreground_enabled_color2"));
        this.disabledForegroundColor2 = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("save_cancel_button_foreground_disabled_color2"));
        this.mySkin = (Skin3Field)DefaultSkins.TextLabelTexture.createDynamicSkin();
        this.displayedString = text;
        this.mover = new Mover<TextLabel>(this);
        this.setProgress(1.0f);
        this.lafAttributeChanged("All attribues changed");
        this.setOpaque(false);
    }

    public void setOverriddenToolTipText(String t) {
        this.overriddenToolTipText = t;
    }

    public void setShouldValidate(boolean v) {
        this.shouldValidate = v;
    }

    public void setForegroundColor2(Color c) {
        this.foregroundColor2 = c;
    }

    public void setDisabledForegroundColor2(Color disabledForegroundColor2) {
        this.disabledForegroundColor2 = disabledForegroundColor2;
    }

    public void setDisableForegroundColor(Color c) {
        this.disabledForeground = c;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public void setLink(boolean isLink) {
        this.isLink = isLink;
        if (isLink) {
            this.addMouseListener(this);
        }
    }

    public void setViewConverterAttributes(Object[] o) {
        this.viewConverterAttributes = o;
    }

    public boolean isEmbossed() {
        return this.isEmbossed;
    }

    public void setErrorString(String t) {
        this.errorString = t;
    }

    public void setEmbossed(boolean isEmbossed) {
        this.isEmbossed = isEmbossed;
    }

    public void addLinkListener(LinkListener l) {
        this.linkListeners.add(l);
    }

    public void removeLinkListener(LinkListener l) {
    }

    private void fireLinkEvent() {
        for (LinkListener l : this.linkListeners) {
            l.linkClicked(this);
        }
    }

    public TextLabel(Node node) {
        this("");
        this.setNode(node);
    }

    public TextLabel(Converter viewConverter) {
        this(null, viewConverter);
    }

    public TextLabel(Node node, Converter viewConverter) {
        this();
        this.node = node;
        this.viewConverter = viewConverter;
        if (node != null && viewConverter != null) {
            this.setText("" + viewConverter.convert(node.getValue(), node, new Object[0]));
            this.node.addNodeListener((NodeListener)this);
        } else if (node != null) {
            this.setText(node.toString());
            this.node.addNodeListener((NodeListener)this);
        }
    }

    public void addNodeToTextLabel(Node n) {
        this.nodes.add(n);
        n.addNodeListener((NodeListener)this);
    }

    public void removeNodeFromTextLabel(Node n) {
        this.nodes.remove(n);
        n.removeNodeListener((NodeListener)this);
    }

    public void setLeftUpperCornerPainting(boolean isActive, Color usedColor) {
        this.isLeftUpperCornerPainting = isActive;
        this.leftUpperCornerColor = usedColor;
    }

    public void setRightUpperCornerPainting(boolean isActive, Color usedColor) {
        this.isRightUpperCornerPainting = isActive;
        this.rightUpperCornerColor = usedColor;
    }

    public boolean isReadOnlyTextField() {
        return this.isReadOnlyTextField;
    }

    public void setReadOnlyTextField(boolean isReadOnlyTextField) {
        this.isReadOnlyTextField = isReadOnlyTextField;
        this.border = this.isReadOnlyTextField ? 5 : 0;
    }

    public void setLineWrap(boolean isLineWrap, int maxWidth) {
        this.isLineWrap = isLineWrap;
        this.maxWidth = maxWidth;
    }

    public void setSelected(int isSelected) {
        if (this.isSelected != isSelected) {
            this.isSelected = isSelected;
            if (isSelected == 3) {
                this.setFont(this.selectedFont);
            } else {
                this.setFont(this.normalFont);
            }
            this.repaint(32L);
        }
    }

    public void setViewConverter(Converter c) {
        this.viewConverter = c;
    }

    public Converter getViewConverter() {
        return this.viewConverter;
    }

    public void updateString() {
        this.valueChanged(this.node);
    }

    public boolean isDelegateMouseEvents() {
        return this.delegateMouseEvents;
    }

    public void addValueChangeListener(ValueChangeListener l) {
        this.valueListeners.add(l);
    }

    public void removeValueChangeListener(ValueChangeListener l) {
        this.valueListeners.remove(l);
    }

    private void fireValueChangedEvent(Object value) {
        for (ValueChangeListener l : this.valueListeners) {
            l.valueChanged(value);
        }
    }

    public void listenToChildAddRemove(boolean listen) {
        this.shouldListenChildAddRemove = listen;
    }

    private void setDelegateMouseEvents(boolean delegateMouseEvents) {
        if (this.delegateMouseEvents != delegateMouseEvents) {
            this.delegateMouseEvents = delegateMouseEvents;
            if (this.delegateMouseEvents) {
                if (this.delegateComponent instanceof MouseListener) {
                    this.addMouseListener(this);
                } else if (this.delegateComponent instanceof RDField) {
                    this.addMouseListener(this);
                }
                if (this.delegateComponent instanceof MouseMotionListener) {
                    this.addMouseMotionListener(this);
                } else if (this.delegateComponent instanceof RDField) {
                    this.addMouseMotionListener(this);
                }
            } else {
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
            }
        }
    }

    public Component getDelegateComponent() {
        return this.delegateComponent;
    }

    public void setDelegateComponent(Component delegateComponent) {
        this.delegateComponent = delegateComponent;
        if (this.delegateComponent != null) {
            if (!this.delegateMouseEvents) {
                this.setDelegateMouseEvents(true);
            }
        } else {
            this.setDelegateMouseEvents(false);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int w = fm.stringWidth("...");
        return new Dimension(w, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getFont() == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (this.text != null) {
            this.textWidth = fm.stringWidth(this.text);
        }
        int h = 0;
        if (this.isLineWrap) {
            h += this.getFont().getSize() + 3;
            int currentW = 0;
            boolean currentY = false;
            String[] strings = this.text.split(" ");
            for (int i = 0; i < strings.length; ++i) {
                String ct = strings[i];
                int strW = fm.stringWidth(ct);
                if (currentW + strW > this.maxWidth) {
                    h += this.getFont().getSize() + 3;
                    currentW = 0;
                }
                currentW += fm.stringWidth(ct + " ");
            }
        } else if (this.text != null && !this.text.equals("")) {
            h = this.getFont().getSize() + this.getFont().getSize();
        }
        if (h == 0) {
            h = this.getFont().getSize() * 2;
        }
        return new Dimension(this.textWidth + 2 * this.border, h);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.delegateComponent = null;
        this.mover.deregister();
        this.mover = null;
        if (this.node != null) {
            try {
                this.node.removeNodeListenerRecursively((NodeListener)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.nodes != null) {
            for (Node n : this.nodes) {
                try {
                    n.removeNodeListenerRecursively((NodeListener)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.nodes.clear();
        }
        this.nodes = null;
        this.mySkin = null;
        this.normalFont = null;
        this.selectedFont = null;
        this.valueListeners.clear();
        this.delegateComponent = null;
        this.viewConverter = null;
    }

    private void calculateTextWidthAndPos() {
        if (this.text == null || this.text != null && this.text.length() == 0 || this.getWidth() == 0 || this.getFont() == null) {
            return;
        }
        try {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.textWidth = fm.stringWidth(this.text);
            if (this.textWidth > this.getWidth() - 2 * this.border) {
                if (this.isLineWrap) {
                    this.textWidth = this.getWidth() - 2 * this.border;
                } else {
                    this.isShortend = true;
                    int currentIndex = this.text.length() - 1;
                    String sub = this.text.substring(0, currentIndex);
                    sub = sub + "...";
                    this.textWidth = fm.stringWidth(sub);
                    boolean out = false;
                    while (this.textWidth > this.getWidth() - 2 * this.border && !out) {
                        if (--currentIndex < 0) {
                            out = true;
                            sub = ".";
                            this.textWidth = fm.stringWidth(sub);
                            continue;
                        }
                        sub = this.text.substring(0, currentIndex);
                        sub = sub + "...";
                        this.textWidth = fm.stringWidth(sub);
                    }
                    this.displayedString = sub;
                }
            } else {
                this.isShortend = false;
                this.displayedString = this.text;
            }
            switch (this.alignment) {
                case 0: {
                    this.textPosX = (this.getWidth() - this.textWidth) / 2;
                    break;
                }
                case 3: {
                    this.textPosX = this.getWidth() - (this.border + this.textWidth);
                    break;
                }
                case 7: {
                    this.textPosX = this.border;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        int[] yCoo;
        int[] xCoo;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.isReadOnlyTextField) {
            this.mySkin.paint(g2, 0, 0, this.getWidth(), Button.ButtonState.UP);
        }
        if (this.isValid) {
            if (this.isEnabled) {
                g2.setColor(this.foreground);
            } else {
                g2.setColor(this.disabledForeground);
            }
        } else {
            g2.setColor(this.invalidForeground);
        }
        if (this.isWarning) {
            g2.setColor(this.warningForeground);
        }
        if (this.getFont() != null && this.displayedString != null) {
            g2.setFont(this.getFont());
            Color c1 = null;
            Color c2 = null;
            if (!this.isEnabled) {
                c1 = this.disabledForeground;
                c2 = this.disabledForegroundColor2;
            } else {
                c1 = this.foreground;
                c2 = this.foregroundColor2;
            }
            if (!this.isValid && this.errorString != null) {
                g2.drawString(this.errorString, this.textPosX, (this.getHeight() + this.getFont().getSize()) / 2 - 1);
            } else {
                if (this.isLineWrap) {
                    if (this.isEmbossed) {
                        GraphicsUtils.paintWrapedTextEmbossed(g2, this.maxWidth, this.text, this.textPosX, (int)(((double)this.getHeight() - this.getPreferredSize().getHeight()) / 2.0) + g2.getFont().getSize(), g2.getFontMetrics(), g2.getFont(), c1, c2);
                    } else {
                        GraphicsUtils.paintWrapedText(g2, this.getWidth(), this.text, this.textPosX, (int)(((double)this.getHeight() - this.getPreferredSize().getHeight()) / 2.0) + g2.getFont().getSize(), g2.getFontMetrics(), g2.getFont());
                    }
                } else if (this.isEmbossed) {
                    DrawToolkit.drawEmbossedString(g2, this.displayedString, this.textPosX, (this.getHeight() + g2.getFont().getSize()) / 2 - 1, c1, c2);
                } else {
                    g2.drawString(this.displayedString, this.textPosX, (this.getHeight() + this.getFont().getSize()) / 2 - 1);
                }
                if (this.isLink && this.isMouseOver) {
                    int ay = (this.getHeight() + this.getFont().getSize()) / 2;
                    g2.drawLine(0, ay, this.getWidth(), ay);
                }
            }
        }
        if (this.isLeftUpperCornerPainting) {
            g2.setColor(this.leftUpperCornerColor);
            xCoo = new int[3];
            yCoo = new int[3];
            xCoo[0] = 0;
            xCoo[1] = 0;
            xCoo[2] = this.cornerWidth;
            yCoo[0] = 0;
            yCoo[1] = this.cornerWidth;
            yCoo[2] = 0;
            g2.fillPolygon(xCoo, yCoo, 3);
        }
        if (this.isRightUpperCornerPainting) {
            g2.setColor(this.rightUpperCornerColor);
            xCoo = new int[3];
            yCoo = new int[3];
            xCoo[0] = this.getWidth();
            xCoo[1] = this.getWidth() - this.cornerWidth;
            xCoo[2] = this.getWidth();
            yCoo[0] = 0;
            yCoo[1] = 0;
            yCoo[2] = this.cornerWidth;
            g2.fillPolygon(xCoo, yCoo, 3);
        }
    }

    @Override
    public void setForeground(Color c) {
        this.foreground = c;
    }

    public Color getComponentForeground() {
        return this.foreground;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.calculateTextWidthAndPos();
        if (this.overriddenToolTipText != null) {
            this.setToolTipText(this.overriddenToolTipText);
        } else if (this.displayedString != null && !this.displayedString.equals(this.text)) {
            this.setToolTipText(this.text);
        } else {
            this.setToolTipText(null);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getDisplayedText() {
        return this.displayedString;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (text != null && this.delegateComponent == null && this.getParent() != null) {
            this.setDelegateComponent(this.getParent());
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.text == null) {
            this.text = "";
        }
        this.displayedString = text;
        this.setSize(this.getWidth(), this.getHeight());
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
        this.fireValueChangedEvent(text);
        this.repaint(32L);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.calculateTextWidthAndPos();
    }

    public void setNormalFont(Font font) {
        this.normalFont = font;
        this.selectedFont = font;
        this.setFont(font);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.calculateTextWidthAndPos();
    }

    public void setTextBorder(int border) {
        this.border = border;
        this.calculateTextWidthAndPos();
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    public Mover<TextLabel> getMover() {
        return this.mover;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (this.shouldListenChildAddRemove) {
            this.valueChanged(this.node);
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        if (this.shouldListenChildAddRemove) {
            this.valueChanged(this.node);
        }
    }

    public void valueChanged(Node<?> node) {
        boolean hadListener;
        boolean bl = hadListener = node != null ? node.removeNodeListener((NodeListener)this) : false;
        if (this.node != null && this.node == node) {
            if (this.viewConverter != null) {
                String t = "" + this.viewConverter.convert(this.node.getValue(), this.node, this.viewConverterAttributes);
                this.setText(t);
            } else if (this.node.getValue() != null) {
                this.setText("" + this.node.getValue());
            } else {
                this.setText("");
            }
        } else if (this.viewConverter != null) {
            if (this.node != null) {
                this.setText("" + this.viewConverter.convert(this.node.getValue(), this.node, this.viewConverterAttributes));
            } else {
                String ct = "";
                try {
                    ct = (String)this.viewConverter.convert(this.nodes, null, this.viewConverterAttributes);
                }
                catch (Exception e) {
                    ct = "";
                }
                this.setText(ct);
            }
        }
        if (!this.isValidStatePermanent) {
            this.isValid = true;
        }
        if (this.getParent() != null && this.shouldValidate) {
            this.getParent().validate();
        } else {
            this.validate();
        }
        if (hadListener) {
            node.addNodeListener((NodeListener)this);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.foreground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.disabledForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        this.invalidForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_error_string_color"));
        this.warningForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_warning_string_color"));
        Font defaultFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Font selectedF = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_selected_font_type"));
        this.normalFont = defaultFont;
        this.selectedFont = selectedF;
        this.setFont(defaultFont);
    }

    public Font getDefaultFont() {
        return this.normalFont;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.repaint(32L);
    }

    public void setNode(Node altNameA) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = altNameA;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            this.updateString();
        } else if (this.isNodeBased) {
            this.setText("");
        }
    }

    public boolean isNodeBased() {
        return this.isNodeBased;
    }

    public void setNodeBased(boolean isNodeBased) {
        this.isNodeBased = isNodeBased;
    }

    private MouseEvent transformMouseEvent4Delegation(MouseEvent e) {
        Point oPoint = e.getPoint();
        Point nPoint = SwingUtilities.convertPoint(this, oPoint, this.delegateComponent);
        MouseEvent ne = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), (int)nPoint.getX(), (int)nPoint.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return ne;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseListener) {
                ((MouseListener)((Object)this.delegateComponent)).mouseClicked(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMouseClicked(this.transformMouseEvent4Delegation(e));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseListener) {
                ((MouseListener)((Object)this.delegateComponent)).mouseEntered(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMouseEntered(this.transformMouseEvent4Delegation(e));
            }
        }
        if (this.isLink) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.isMouseOver = true;
            this.repaint(32L);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseListener) {
                ((MouseListener)((Object)this.delegateComponent)).mouseExited(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMouseExited(this.transformMouseEvent4Delegation(e));
            }
        }
        if (this.isLink) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.isMouseOver = false;
            this.repaint(32L);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseListener) {
                ((MouseListener)((Object)this.delegateComponent)).mousePressed(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMousePressed(this.transformMouseEvent4Delegation(e));
            }
        }
        if (this.isLink) {
            this.fireLinkEvent();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseListener) {
                ((MouseListener)((Object)this.delegateComponent)).mouseReleased(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMouseReleased(this.transformMouseEvent4Delegation(e));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseMotionListener) {
                ((MouseMotionListener)((Object)this.delegateComponent)).mouseDragged(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMouseDragged(this.transformMouseEvent4Delegation(e));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.delegateComponent != null) {
            if (this.delegateComponent instanceof MouseMotionListener) {
                ((MouseMotionListener)((Object)this.delegateComponent)).mouseMoved(this.transformMouseEvent4Delegation(e));
            } else if (this.delegateComponent instanceof RDField) {
                ((RDField)this.delegateComponent).processMouseMoved(this.transformMouseEvent4Delegation(e));
            }
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setInvalid() {
        this.isValid = false;
        this.isWarning = false;
        this.repaint(32L);
    }

    @Override
    public void setValid() {
        this.isValid = true;
        this.isWarning = false;
        this.repaint(32L);
    }

    @Override
    public void setWarning() {
        this.isWarning = true;
        this.repaint(32L);
    }

    public Color getDisableForegroundColor() {
        return this.disabledForeground;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void disableNodes() {
        this.nodes = null;
    }

    @Override
    public void setPermanent(boolean isPermanent) {
        this.isValidStatePermanent = isPermanent;
    }
}

