/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JToolTip;

public class ToolTip
extends JToolTip {
    private static final long serialVersionUID = 1L;
    private TextLabel text = new TextLabel();
    private Color background;

    public ToolTip() {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.loadBackground();
        this.add(this.text);
    }

    private void loadBackground() {
        this.background = new Color(35, 35, 35);
    }

    @Override
    public void setTipText(String tipText) {
        this.text.setText(tipText);
        this.validate();
        super.setTipText(tipText);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.background);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(new Color(110, 110, 110));
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.paintChildren(g2);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            int w = (int)ToolTip.this.text.getPreferredSize().getWidth();
            if (w > parent.getWidth() - 2 * border) {
                w = parent.getWidth() - 2 * border;
            }
            ToolTip.this.text.setLocation((parent.getWidth() - w) / 2, (int)(((double)parent.getHeight() - ToolTip.this.text.getPreferredSize().getHeight()) / 2.0));
            ToolTip.this.text.setSize(w, (int)ToolTip.this.text.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return ToolTip.this.text.getPreferredSize();
        }
    }
}

