/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.Timer;

public class AnimationProvider
implements ActionListener {
    private static AnimationProvider provider;
    private static Timer animationTimer;
    private static ArrayList<ActionListener> animaters;
    private static Stack<ActionListener> scheduleRemoveListeners;
    private static Stack<ActionListener> scheduleAddListener;
    public static boolean isAnimationActiv;

    private AnimationProvider() {
    }

    public static String getMetaString() {
        String t = "";
        t = "A=" + animaters.size() + ", SR=" + scheduleRemoveListeners.size() + ", SA=" + scheduleAddListener.size();
        return t;
    }

    private static void ensureProvider() {
        if (provider == null) {
            provider = new AnimationProvider();
        }
    }

    public static boolean isAnimating() {
        return animaters.size() != 0 || scheduleAddListener.size() != 0;
    }

    public static void registerAnimater(ActionListener animater) {
        scheduleAddListener.push(animater);
        AnimationProvider.ensureProvider();
        provider.ensureTimer();
    }

    private void registerScheduled() {
        while (!scheduleAddListener.isEmpty()) {
            ActionListener l = scheduleAddListener.pop();
            animaters.add(l);
            provider.ensureTimer();
            if (animationTimer == null) continue;
            animationTimer.addActionListener(l);
        }
    }

    public static void deregisterAnimater(ActionListener animater) {
        scheduleRemoveListeners.push(animater);
    }

    private void deregisterScheduled() {
        while (!scheduleRemoveListeners.isEmpty()) {
            ActionListener l = scheduleRemoveListeners.pop();
            animaters.remove(l);
            if (animationTimer == null) continue;
            animationTimer.removeActionListener(l);
        }
        this.tryToStopTimer();
    }

    private void tryToStopTimer() {
        if (animaters.size() == 0 && animationTimer != null) {
            animationTimer.stop();
            animationTimer = null;
        }
    }

    private void ensureTimer() {
        if (animationTimer == null) {
            animationTimer = new Timer(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationRate")), this);
            animationTimer.setRepeats(true);
            animationTimer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Stack<ActionListener> resizer = new Stack<ActionListener>();
        this.registerScheduled();
        for (ActionListener animater : animaters) {
            if (animater instanceof Resizer) {
                resizer.push(animater);
                continue;
            }
            animater.actionPerformed(e);
        }
        while (!resizer.isEmpty()) {
            ((ActionListener)resizer.pop()).actionPerformed(e);
        }
        this.deregisterScheduled();
    }

    static {
        animaters = new ArrayList();
        scheduleRemoveListeners = new Stack();
        scheduleAddListener = new Stack();
        isAnimationActiv = false;
    }
}

