/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Resizer<T extends Component>
implements ActionListener {
    private int startWidth;
    private int startHeight;
    private int endWidth;
    private int endHeight;
    private T view;
    protected float resizeProgress = 0.0f;
    private boolean isResizeAction = false;
    private long resizeStartTime;
    private Runnable excuteable;
    private boolean isKilled;

    public Resizer(T view) {
        this.view = view;
    }

    public int getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(int endHeight) {
        this.endHeight = endHeight;
    }

    public float getProgress() {
        return this.resizeProgress;
    }

    public void setExcutable(Runnable exce) {
        this.excuteable = exce;
    }

    public boolean isAnimating() {
        return this.isResizeAction;
    }

    public void setSizeSmooth(int nWidth, int nHeight) {
        if (AnimationProvider.isAnimationActiv) {
            this.startWidth = ((Component)this.view).getWidth();
            this.startHeight = ((Component)this.view).getHeight();
            this.endWidth = nWidth;
            this.endHeight = nHeight;
            this.isResizeAction = true;
            this.resizeProgress = 0.0f;
            this.resizeStartTime = System.currentTimeMillis();
            AnimationProvider.registerAnimater(this);
        } else {
            ((Component)this.view).setSize(nWidth, nHeight);
            this.runExcec();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isResizeAction) {
            return;
        }
        this.resizeProgress = (float)(System.currentTimeMillis() - this.resizeStartTime) / Float.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).floatValue();
        float p = (float)Math.sin((double)this.resizeProgress * 1.5707963267948966);
        if (this.resizeProgress >= 1.0f) {
            if (this.view != null) {
                ((Component)this.view).setSize(this.endWidth, this.endHeight);
            }
            this.isResizeAction = false;
            AnimationProvider.deregisterAnimater(this);
        } else {
            int dw = this.endWidth - this.startWidth;
            int dh = this.endHeight - this.startHeight;
            int cw = (int)((float)this.startWidth + (float)dw * p);
            int ch = (int)((float)this.startHeight + (float)dh * p);
            if (this.view != null) {
                ((Component)this.view).setSize(cw, ch);
                if (((Component)this.view).getParent() != null) {
                    ((Component)this.view).getParent().invalidate();
                    ((Component)this.view).getParent().revalidate();
                    ((Component)this.view).getParent().repaint(32L);
                }
            }
        }
        this.runExcec();
    }

    private void runExcec() {
        if (this.excuteable != null) {
            this.excuteable.run();
        }
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.view = null;
    }

    public void deregister() {
        AnimationProvider.deregisterAnimater(this);
    }
}

