/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.ScheduledFadeInListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;

public class ScheduledFadeIn
implements ActionListener {
    private LinkedList<Fadable> list = new LinkedList();
    private boolean isRunning = false;
    private int count = 0;
    private int createActionAt = 2;
    private ArrayList<ScheduledFadeInListener> listeners = new ArrayList();
    private boolean isKilled;

    public void addScheduledFadeInListener(ScheduledFadeInListener l) {
        this.listeners.add(l);
    }

    public void removeScheduledFadeInListener(ScheduledFadeInListener l) {
        this.listeners.remove(l);
    }

    private void fireAllFadedInEvent() {
        for (ScheduledFadeInListener l : this.listeners) {
            l.allFadedIn();
        }
    }

    public void addItem(Fadable f) {
        this.list.add(f);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void insertAllImmediately() {
        this.stopFadeIn();
        while (!this.list.isEmpty()) {
            Fadable l = this.list.poll();
            l.fadeIn();
            l.setProgress(1.0f);
            if (this.list.size() != this.createActionAt) continue;
            this.fireAllFadedInEvent();
        }
    }

    public void startFadeIn() {
        if (AnimationProvider.isAnimationActiv) {
            this.isRunning = true;
            AnimationProvider.registerAnimater(this);
        } else {
            this.insertAllImmediately();
        }
    }

    public void stopFadeIn() {
        if (AnimationProvider.isAnimationActiv) {
            this.isRunning = false;
            AnimationProvider.deregisterAnimater(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isKilled) {
            return;
        }
        if (this.count < 4) {
            ++this.count;
            return;
        }
        this.count = 0;
        if (!this.list.isEmpty()) {
            Fadable l = this.list.poll();
            l.fadeIn();
        }
        if (this.list.size() == this.createActionAt) {
            this.fireAllFadedInEvent();
        }
        if (this.list.isEmpty()) {
            this.stopFadeIn();
        }
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        AnimationProvider.deregisterAnimater(this);
        this.list.clear();
        this.list = null;
        this.listeners.clear();
        this.listeners = null;
    }
}

