/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class ScreenSwitchMover<T extends Component>
implements ActionListener {
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private T view;
    private ArrayList<AnimationListener> listeners = new ArrayList();
    protected float moveProgress = 0.0f;
    private boolean isMoveAction = false;
    private long moveStartTime;
    private boolean isKilled;
    private float animationDuration;

    public ScreenSwitchMover(T comp) {
        this.view = comp;
        this.animationDuration = Float.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).floatValue();
    }

    public ScreenSwitchMover(T comp, int startX, int startY, int endX, int endY) {
        this.view = comp;
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.animationDuration = Float.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).floatValue();
    }

    public void setAnimationDuration(float animationDuration) {
        this.animationDuration = animationDuration;
    }

    public void addAnimationListener(AnimationListener l) {
        this.listeners.add(l);
    }

    public void removeAnimationListener(AnimationListener l) {
        this.listeners.remove(l);
    }

    public void deregister() {
        AnimationProvider.deregisterAnimater(this);
    }

    private void fireAnimationEvent(boolean wasFadin) {
        for (AnimationListener l : (ArrayList)this.listeners.clone()) {
            l.animationFinished(wasFadin);
        }
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        AnimationProvider.deregisterAnimater(this);
        this.view = null;
        this.listeners.clear();
    }

    public void startAnimation() {
        if (AnimationProvider.isAnimationActiv) {
            this.isMoveAction = true;
            ((Component)this.view).setLocation(this.startX, this.startY);
            this.moveProgress = 0.0f;
            this.moveStartTime = System.currentTimeMillis();
            AnimationProvider.registerAnimater(this);
        } else {
            ((Component)this.view).setLocation(this.endX, this.endY);
            this.fireAnimationEvent(true);
        }
    }

    public void setLocationSmooth(int endX, int endY) {
        if (AnimationProvider.isAnimationActiv) {
            this.startX = ((Component)this.view).getX();
            this.startY = ((Component)this.view).getY();
            this.endX = endX;
            this.endY = endY;
            if (this.startX == endX && this.startY == endY) {
                return;
            }
            this.isMoveAction = true;
            this.moveProgress = 0.0f;
            this.moveStartTime = System.currentTimeMillis();
            AnimationProvider.registerAnimater(this);
        } else {
            this.endX = endX;
            this.endY = endY;
            ((Component)this.view).setLocation(endX, endY);
            this.fireAnimationEvent(true);
        }
    }

    public float getProgress() {
        return this.moveProgress;
    }

    public boolean isAnimating() {
        return this.isMoveAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isMoveAction) {
            AnimationProvider.deregisterAnimater(this);
            return;
        }
        this.moveProgress = (float)(System.currentTimeMillis() - this.moveStartTime) / this.animationDuration;
        float p = (float)Math.sin((double)this.moveProgress * 1.5707963267948966);
        if (this.moveProgress >= 1.0f) {
            AnimationProvider.deregisterAnimater(this);
            ((Component)this.view).setLocation(this.endX, this.endY);
            this.isMoveAction = false;
            this.fireAnimationEvent(true);
        } else {
            int dx = this.endX - this.startX;
            int dy = this.endY - this.startY;
            int cx = (int)((float)this.startX + (float)dx * p);
            int cy = (int)((float)this.startY + (float)dy * p);
            ((Component)this.view).setLocation(cx, cy);
            if (((Component)this.view).getParent() != null) {
                ((Component)this.view).getParent().repaint(32L);
            }
        }
    }
}

