/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ArticleInfoLoadingPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ProductInfoLoadingPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Date;

public class ArticleProductInfoButton
extends InfoButton {
    private static final long serialVersionUID = 1L;
    private Node articleNode;
    private Node<Date> validityNode;
    private int magicNo;
    private boolean useForProduct;
    private String additionalText;

    public ArticleProductInfoButton(Node node, Node<Date> validityNode, int type) {
        this(node, validityNode, type, "");
    }

    public ArticleProductInfoButton(Node node, Node<Date> validityNode, int type, String additionalText) {
        super(SizedSkin1Field.SkinSize.SMALL);
        this.setValidityNode(validityNode);
        this.additionalText = additionalText;
        this.articleNode = node;
        this.magicNo = type;
    }

    public void setValidityNode(Node<Date> validityNode) {
        this.validityNode = validityNode;
    }

    public void setType(int type) {
        this.magicNo = type;
    }

    public void setNode(Node node) {
        this.articleNode = node;
    }

    public boolean isUseForProduct() {
        return this.useForProduct;
    }

    public void setUseForProduct(boolean useForProduct) {
        this.useForProduct = useForProduct;
    }

    @Override
    public void buttonPressed(Button source, final int x, final int y) {
        if (this.articleNode == null || this.articleNode.getValue() == null) {
            return;
        }
        final InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        if (this.titleName == null) {
            this.titleName = Words.INFO;
        }
        pop.setAttributes(null, false, false, this.titleName);
        if (this.useForProduct) {
            pop.setView(new ProductInfoLoadingPopupInsert(this.articleNode, this.magicNo));
        } else if (this.articleNode.getValue() instanceof BasicArticleReference) {
            pop.setView(new ArticleInfoLoadingPopupInsert(this.articleNode, this.validityNode, this.magicNo, this.additionalText));
        } else if (this.articleNode.getValue() instanceof ArticleChargeComplete) {
            final ArticleChargeComplete charge = (ArticleChargeComplete)this.articleNode.getValue();
            final BasicArticleLight light = charge.getBasicArticle();
            final BasicArticleComplete complete = (BasicArticleComplete)this.articleNode.getChildNamed(ArticleChargeComplete_.basicArticle).getValue(BasicArticleComplete.class);
            if (complete == null) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(light.getId())).getValue();
                        ArticleProductInfoButton.this.articleNode.getChildNamed(ArticleChargeComplete_.basicArticle).setValue((Object)artC, 0L);
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                ArticleProductInfoButton.this.installStringViewer(ArticleToolkit.getArticleInfoPopupString(complete, charge.getCreationDate(), 435435, charge.getPackingQuantities()));
                                pop.setView(new StringPopUpInsert(ArticleProductInfoButton.this.getInstallString()));
                                ArticleProductInfoButton.this.doSow(x, y, pop);
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)ArticleProductInfoButton.this);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
                return;
            }
            this.installStringViewer(ArticleToolkit.getArticleInfoPopupString(complete, charge.getCreationDate(), 435435, charge.getPackingQuantities()));
            pop.setView(new StringPopUpInsert(this.getInstallString()));
        }
        this.doSow(x, y, pop);
    }

    private void doSow(int x, int y, InnerPopUp2 pop) {
        int w = (int)pop.getView().getPreferredSize().getWidth() + 150;
        int h = (int)pop.getView().getPreferredSize().getHeight() + 30;
        if (w < minWidth) {
            w = minWidth;
        }
        if (h < minHeight) {
            h = minHeight;
        }
        pop.showPopUp(x, y, w, h, null, this, PopupType.NORMAL);
    }
}

