/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.CheckBox2Skin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;

public class CheckBoxTriState
extends Button
implements ButtonListener,
NodeListener,
Stringable {
    private static final long serialVersionUID = 1L;
    private Object userObject;
    private TypedSkin1Field skin;
    private CheckBox2Skin.CheckBoxState isChecked = null;
    private boolean isUnDisable;
    private Node<Integer> node;

    public CheckBoxTriState() {
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(CheckBox2Skin.class);
        this.setToolTipText(Words.TOGGLE);
        this.addButtonListener(this);
        this.setSize(this.getPreferredSize());
    }

    public CheckBoxTriState(Node<Integer> node) {
        this();
        this.setNode(node);
    }

    public Node<Integer> getNode() {
        return this.node;
    }

    public void setNode(Node<Integer> n) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            if (this.node.getValue() == null) {
                this.node.setValue((Object)CheckBox2Skin.CheckBoxState.Unchecked.getValue(), 0L);
            }
            this.selectValue();
        }
    }

    public boolean isUnDisable() {
        return this.isUnDisable;
    }

    public void setUnDisable(boolean isUnDisable) {
        this.isUnDisable = isUnDisable;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private void selectValue() {
        if (this.node.getValue() != null) {
            this.setChecked(CheckBox2Skin.CheckBoxState.getType((Integer)this.node.getValue()));
        }
    }

    @Override
    public void kill() {
        super.kill();
        this.removeKeyListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.skin.getImage(this.state, this.isChecked).getWidth(), this.skin.getImage(this.state, this.isChecked).getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.state, this.isChecked);
        this.paintChildren(g2);
    }

    public CheckBox2Skin.CheckBoxState isChecked() {
        return this.isChecked;
    }

    public void setChecked(CheckBox2Skin.CheckBoxState isChecked) {
        this.isChecked = isChecked;
        if (this.node != null && ((Integer)this.node.getValue()).intValue() != isChecked.getValue()) {
            this.node.setValueSilent((Object)isChecked.getValue(), false, System.currentTimeMillis(), new NodeListener[]{this});
        }
        this.repaint(32L);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        switch (this.isChecked) {
            case Checked: {
                this.setCheckState(CheckBox2Skin.CheckBoxState.Unchecked);
                break;
            }
            case Unchecked: {
                this.setCheckState(CheckBox2Skin.CheckBoxState.Partial);
                break;
            }
            case Partial: {
                this.setCheckState(CheckBox2Skin.CheckBoxState.Checked);
            }
        }
    }

    private void setCheckState(CheckBox2Skin.CheckBoxState newState) {
        if (this.isChecked != newState) {
            if (this.node != null) {
                this.node.setValue((Object)newState.getValue(), System.currentTimeMillis());
            }
            this.isChecked = newState;
            this.repaint(32L);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (!this.isUnDisable) {
            super.setEnabled(isEnabled);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            this.fireEvent(0, 0);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        this.selectValue();
    }

    public static int getPreferredWidth() {
        CheckBox n = new CheckBox();
        int w = (int)n.getPreferredSize().getWidth();
        n.kill();
        n = null;
        return w;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public String getStringValue() {
        switch (this.isChecked) {
            case Checked: {
                return "checked";
            }
            case Partial: {
                return "partly";
            }
            case Unchecked: {
                return "unchecked";
            }
        }
        return null;
    }

    public boolean isSwingOnly() {
        return true;
    }
}

