/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TabbedBackButton;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class TabbedBackButtonContainer
extends JPanelKillable
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private ArrayList<TabbedBackButton> buttons = new ArrayList();
    private static BufferedImage backImage_3_up;
    private static BufferedImage backImage_3_over;
    private int buttonWidth = 34;

    public TabbedBackButtonContainer() {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.lafAttributeChanged("All attribues changed");
    }

    public void addButton(TabbedBackButton b) {
        this.buttons.add(b);
        this.add(b);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (Button button : this.buttons) {
            button.kill();
        }
        this.buttons.clear();
        this.buttons = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int count = 0;
        int currentX = 0;
        for (TabbedBackButton b : this.buttons) {
            if (count != this.buttons.size() - 1) {
                g2.drawImage(backImage_3_up, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX += b.getWidth(), 0.0f), null);
                currentX += backImage_3_up.getWidth();
            }
            ++count;
        }
        this.paintChildren(g2);
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void loadImages() {
        if (backImage_3_over == null) {
            backImage_3_up = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("smartscreen_backbutton_background_03_up"));
            backImage_3_over = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("smartscreen_backbutton_background_03_over"));
        }
    }

    @Override
    public void clearImages() {
        backImage_3_over = null;
        this.loadImages();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            for (TabbedBackButton b : TabbedBackButtonContainer.this.buttons) {
                b.setLocation(currentX, 0);
                b.setSize(TabbedBackButtonContainer.this.buttonWidth, (int)b.getPreferredSize().getHeight());
                currentX += b.getWidth() + 1;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentX = 0;
            int currentHeight = 0;
            for (TabbedBackButton b : TabbedBackButtonContainer.this.buttons) {
                currentHeight = (int)b.getPreferredSize().getHeight();
                currentX += TabbedBackButtonContainer.this.buttonWidth + 1;
            }
            return new Dimension(--currentX, currentHeight);
        }
    }
}

