/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons.prototypes;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class SkinButton<T extends Skin1Field>
extends Button {
    private static final long serialVersionUID = 1L;
    private T skin;
    protected int border = 0;

    public SkinButton(Class<T> clazz) {
        this(clazz, true);
    }

    public SkinButton(Class<T> clazz, boolean focus) {
        super(focus);
        this.setSkin((Skin1Field)SkinRegistry.getSkin(clazz));
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.skin = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getSkin() == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(((Skin1Field)this.getSkin()).getImage(Button.ButtonState.UP).getWidth() + 2 * this.border, ((Skin1Field)this.getSkin()).getImage(Button.ButtonState.UP).getHeight() + 2 * this.border);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.getSkin() != null) {
            this.paintSkin(this.getSkin(), g2, this.border);
        }
        this.paintChildren(g2);
    }

    public void paintSkin(T skin, Graphics2D g2, int border) {
        ((Skin1Field)skin).paint(g2, border, border, this.getState());
    }

    public T getSkin() {
        return this.skin;
    }

    public void setSkin(T skin) {
        this.skin = skin;
    }
}

