/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.calendar.ProductionTargetTable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanReference;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.ProductionTargetComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class JobsView
extends DefaultPanel {
    private final RDProvider provider;
    private Node<WeeklyPlanLight> node;
    private ProductionTargetTable productionTargetTable;
    private TextButton reloadFlights;
    private TextButton reloadMatDispo;

    public JobsView(RDProvider provider) {
        this.provider = provider;
        this.productionTargetTable = new ProductionTargetTable(provider);
        this.reloadFlights = new TextButton("Update Flights");
        this.reloadMatDispo = new TextButton("Update Targets");
        this.reloadFlights.addButtonListener((source, x, y) -> this.reloadFlights());
        this.reloadMatDispo.addButtonListener((source, x, y) -> this.reloadMatDispo());
        this.setLayout(new Layout());
        this.add(this.productionTargetTable);
        this.add(this.reloadFlights);
        this.add(this.reloadMatDispo);
    }

    public ProductionTargetTable getProductionTable() {
        return this.productionTargetTable;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void setNode(Node<WeeklyPlanLight> node) {
        this.node = node;
        Node<WeeklyPlanLight> n = node;
        this.productionTargetTable.setNode((Node<List<ProductionTargetComplete>>)n.getChildNamed(WeeklyPlanComplete_.productionTargets));
    }

    private void reloadFlights() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanComplete weeklyPlan = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).updateFlightsOnWeeklyPlan(new WeeklyPlanReference(((WeeklyPlanLight)JobsView.this.node.getValue()).getId())).getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)weeklyPlan, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessage("Weekly Plan Update", "Flights updated on Weekly Plan", null, JobsView.this);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)JobsView.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void reloadMatDispo() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanComplete weeklyPlan = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).calculateWeeklyPlanProductionTargets(new WeeklyPlanReference(((WeeklyPlanLight)JobsView.this.node.getValue()).getId())).getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)weeklyPlan, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessage("Weekly Plan Update", "Production Targets updated", null, JobsView.this);
                        JobsView.this.productionTargetTable.setNode((Node<List<ProductionTargetComplete>>)node.getChildNamed(WeeklyPlanComplete_.productionTargets));
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)JobsView.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            JobsView.this.productionTargetTable.setLocation(0, 0);
            JobsView.this.productionTargetTable.setSize(parent.getWidth(), (int)((double)parent.getHeight() - (JobsView.this.reloadMatDispo.getPreferredSize().getHeight() + (double)(2 * border))));
            JobsView.this.reloadFlights.setLocation(border, (int)((double)parent.getHeight() - (JobsView.this.reloadFlights.getPreferredSize().getHeight() + (double)border)));
            JobsView.this.reloadFlights.setSize((parent.getWidth() - 2 * border) / 2, (int)JobsView.this.reloadFlights.getPreferredSize().getHeight());
            JobsView.this.reloadMatDispo.setLocation(JobsView.this.reloadFlights.getX() + JobsView.this.reloadFlights.getWidth() + border, JobsView.this.reloadFlights.getY());
            JobsView.this.reloadMatDispo.setSize(JobsView.this.reloadFlights.getWidth(), (int)JobsView.this.reloadMatDispo.getPreferredSize().getHeight());
        }
    }
}

