/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar.agenda;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.DayView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.HighLightMatcher;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.StockPrediction;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TaskFilter;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.VerticalTimeContainer;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.stock.StockController;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents.SimpleTextTimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents.TaskTimeComponent;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CalendarView
extends DefaultPanel {
    private final RDProvider provider;
    private final WeeklyPlanSettingsComplete setting;
    private Node<WeeklyPlanComplete> node;
    private VerticalTimeContainer timeColumn;
    private List<DayView> days = new ArrayList<DayView>();
    private TimeComponent selectedComponent;
    private List<MouseListener> injectedMouseListeners = new ArrayList<MouseListener>();
    private boolean hideNotActiveTasks;
    private StockController stockController;

    public CalendarView(RDProvider provider) {
        this.provider = provider;
        this.setting = (WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue();
        this.setLayout(new Layout());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CalendarView.this.injectedMouseListeners.forEach(mouseListener -> mouseListener.mousePressed(e));
                CalendarView.this.setSelectedComponent(null);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CalendarView.this.injectedMouseListeners.forEach(mouseListener -> mouseListener.mouseClicked(e));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CalendarView.this.injectedMouseListeners.forEach(mouseListener -> mouseListener.mouseReleased(e));
            }
        });
    }

    public void setStockController(StockController stockController) {
        this.stockController = stockController;
    }

    public void setHideNotActiveTasks(boolean hideNotActiveTasks) {
        this.hideNotActiveTasks = hideNotActiveTasks;
    }

    public RDProvider getProvider() {
        return this.provider;
    }

    public void setSelectedComponent(TimeComponent t) {
        if (this.selectedComponent == t) {
            return;
        }
        if (this.selectedComponent != null) {
            this.selectedComponent.setSelected(false);
        }
        if (t != null) {
            t.setSelected(true);
        }
        this.selectedComponent = t;
        this.repaint(32L);
    }

    private void initCalendarView(Node<WeeklyPlanComplete> weeklyPlan, StockController stockController) {
        Date date = new Date(System.currentTimeMillis());
        this.timeColumn = new VerticalTimeContainer(this, "Time", this.setting, date);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        Time time = new Time(this.setting.getDayStart().getTime());
        while (time.getTime() <= this.setting.getDayEnd().getTime() + 1L) {
            SimpleTextTimeComponent component = new SimpleTextTimeComponent(format.format(time), DateUtil.getTimestamp((java.util.Date)date, (Time)time), new TimeDurationComplete(TimeUnitE.HOUR, Double.valueOf(1.0)));
            this.timeColumn.addTimeItem(component);
            time = new Time(time.getTime() + 3600000L);
        }
        Node period = weeklyPlan.getChildNamed(WeeklyPlanLight_.period);
        Timestamp ts = new Timestamp(((PeriodComplete)period.getValue()).getStartDate().getTime());
        while (ts.getTime() <= ((PeriodComplete)period.getValue()).getEndDate().getTime()) {
            DayView day = new DayView(this, this.provider, stockController, new Date(ts.getTime()));
            this.days.add(day);
            ts = (Timestamp)DateUtil.addDays((java.util.Date)ts, (int)1);
        }
        Iterator it = weeklyPlan.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node itemNode = (Node)it.next();
            TaskTimeComponent task = new TaskTimeComponent(this, (Node<JobComplete>)itemNode);
            task.setDefaultBackground(this.getDefaultTaskBackground((Node<JobComplete>)itemNode));
            task.setDefaultForeground(this.getDefaultTaskForeground((Node<JobComplete>)itemNode));
            task.setDefaultInActiveBackground(this.getDefaultTaskInActiveBackground((Node<JobComplete>)itemNode));
            task.setDefaultInActiveForeground(this.getDefaultTaskInActiveForeground((Node<JobComplete>)itemNode));
            this.addTask(task);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.timeColumn != null) {
            int headerHeight = SkinRegistry.getSkin(BackgroundFadeSkin.class).getImage(11).getHeight();
            int boxX = 0;
            int boxY = headerHeight;
            int boxWidth = 50;
            int boxHeight = this.getHeight() - headerHeight;
            this.timeColumn.paint(g2, boxX, boxY, boxWidth, boxHeight);
            int currentX = boxX + boxWidth;
            int dayWidth = (this.getWidth() - (boxX + boxWidth)) / this.days.size();
            for (DayView day : this.days) {
                day.paint(g2, currentX, 0, dayWidth, this.getHeight());
                currentX += dayWidth;
            }
        }
        this.paintChildren(g2);
    }

    private void addTask(TaskTimeComponent task) {
        for (DayView day : this.days) {
            PeriodComplete dayPeriod = new PeriodComplete(new Date(day.getDate().getTime()), new Date(day.getDate().getTime()));
            if (!dayPeriod.within(new Date(task.getTime().getTime())).booleanValue()) continue;
            day.addTask(task);
            return;
        }
    }

    private Color getDefaultTaskBackground(Node<JobComplete> itemNode) {
        if (itemNode.getValue() instanceof ProductionJobComplete) {
            if (itemNode.getValue() instanceof ProductProductionJobComplete) {
                return new Color(218, 188, 193);
            }
            return new Color(241, 227, 157);
        }
        return new Color(87, 192, 228);
    }

    private Color getDefaultTaskForeground(Node<JobComplete> itemNode) {
        return Color.WHITE;
    }

    private Color getDefaultTaskInActiveForeground(Node<JobComplete> itemNode) {
        return Color.LIGHT_GRAY;
    }

    private Color getDefaultTaskInActiveBackground(Node<JobComplete> itemNode) {
        return Color.DARK_GRAY;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void setNode(Node<WeeklyPlanComplete> node) {
        this.node = node;
        this.initCalendarView(node, this.stockController);
    }

    public DayView getDayForX(int x) {
        int currentX = Integer.MIN_VALUE;
        DayView lastDay = null;
        for (DayView day : this.days) {
            int cx = day.getX();
            if (x >= currentX && x <= cx) {
                if (lastDay == null) {
                    return day;
                }
                return lastDay;
            }
            lastDay = day;
            currentX = cx;
        }
        return this.days.get(this.days.size() - 1);
    }

    public void switchContainer(TaskTimeComponent taskTimeComponent, DayView newContainer) {
        boolean wasChange = false;
        for (DayView day : this.days) {
            if (day == newContainer || !day.containsTask(taskTimeComponent)) continue;
            day.switchComponentOut(taskTimeComponent);
            wasChange = true;
        }
        if (wasChange) {
            newContainer.switchComponentIn(taskTimeComponent);
        }
    }

    public void highLightTasks(HighLightMatcher matcher) {
        for (DayView day : this.days) {
            day.highLightTasks(matcher);
        }
        this.repaint(32L);
    }

    public void injectMouseListener(MouseListener mouseAdapter) {
        this.injectedMouseListeners.add(mouseAdapter);
    }

    public void updateStockEvent(StockPrediction stockPrediction) {
        for (DayView day : this.days) {
            day.updateStockEvent(stockPrediction);
        }
    }

    public boolean hideNotActiveTasks() {
        return this.hideNotActiveTasks;
    }

    public void updateFiltering(TaskFilter taskFilter) {
        this.days.forEach(day -> day.updateFiltering(taskFilter));
    }

    public void removeStockPrediction() {
        this.days.forEach(dayView -> dayView.removeStock());
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (CalendarView.this.timeColumn != null) {
                int headerHeight = SkinRegistry.getSkin(BackgroundFadeSkin.class).getImage(11).getHeight();
                int boxX = 0;
                int boxY = headerHeight;
                int boxWidth = 50;
                int boxHeight = parent.getHeight() - headerHeight;
                CalendarView.this.timeColumn.layoutContainer(boxX, boxY, boxWidth, boxHeight);
                int currentX = boxX + boxWidth;
                int dayWidth = (parent.getWidth() - (boxX + boxWidth)) / CalendarView.this.days.size();
                for (DayView day : CalendarView.this.days) {
                    day.layoutContainer(currentX, 0, dayWidth, parent.getHeight());
                    currentX += dayWidth;
                }
            }
        }
    }
}

