/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar.agenda;

import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.CalendarView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.ConsumeProduceCalculator;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.HighLightMatcher;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.StockPrediction;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TaskFilter;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimedComponentUtil;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents.TaskTimeComponent;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerticalTimeContainer {
    private final TextLabel title;
    private final CalendarView container;
    private final WeeklyPlanSettingsComplete setting;
    private final Date date;
    private Color inlineColor;
    private List<TimeComponent> timeComponents = new ArrayList<TimeComponent>();

    public VerticalTimeContainer(CalendarView container, String titleText, WeeklyPlanSettingsComplete setting, Date date) {
        this.container = container;
        this.setting = setting;
        this.date = date;
        this.title = new TextLabel(titleText);
        container.add(this.title);
    }

    public void paint(Graphics g, int boxX, int boxY, int boxWidth, int boxHeight) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.getInlineColor() != null) {
            g2.setColor(this.getInlineColor());
            g2.fillRect(boxX, boxY, boxWidth, boxHeight);
        }
    }

    public void addTimeItem(TimeComponent component) {
        this.timeComponents.add(component);
        this.container.add((Component)((Object)component));
    }

    public void removeTimeItem(TimeComponent component) {
        this.timeComponents.remove(component);
        this.container.remove((Component)((Object)component));
    }

    public Color getInlineColor() {
        return this.inlineColor;
    }

    public void setInlineColor(Color inlineColor) {
        this.inlineColor = inlineColor;
    }

    public void layoutContainer(int boxX, int boxY, int boxWidth, int boxHeight) {
        this.title.setLocation((int)(((double)boxWidth - this.title.getPreferredSize().getWidth()) / 2.0) + boxX, boxY);
        this.title.setSize(this.title.getPreferredSize());
        TimedComponentUtil timedComponentUtil = new TimedComponentUtil(this.setting);
        HashMap<Integer, ArrayList<TimeComponent>> index = new HashMap<Integer, ArrayList<TimeComponent>>();
        ArrayList<TimeComponent> shownComponents = new ArrayList<TimeComponent>();
        ArrayList<TimeComponent> hiddenComponents = new ArrayList<TimeComponent>();
        for (TimeComponent timeComponent : this.timeComponents) {
            if (!timeComponent.isFiltered()) {
                if (timeComponent.isActive()) {
                    shownComponents.add(timeComponent);
                    continue;
                }
                if (!this.container.hideNotActiveTasks()) {
                    shownComponents.add(timeComponent);
                    continue;
                }
                hiddenComponents.add(timeComponent);
                continue;
            }
            hiddenComponents.add(timeComponent);
        }
        for (TimeComponent timeComponent : shownComponents) {
            int y = timedComponentUtil.calculateYPositionForTime(DateUtil.getTime((Timestamp)timeComponent.getTime()), boxHeight);
            ArrayList<TimeComponent> timeComponents = (ArrayList<TimeComponent>)index.get(y);
            if (timeComponents == null) {
                timeComponents = new ArrayList<TimeComponent>();
                index.put(y, timeComponents);
            }
            timeComponents.add(timeComponent);
        }
        for (Map.Entry entry : index.entrySet()) {
            int entryWidth = boxWidth / ((List)entry.getValue()).size();
            int cx = 0;
            for (TimeComponent timeComponent : (List)entry.getValue()) {
                int h = timedComponentUtil.calculateHeightForDuration(timeComponent.getDurationInMillis(), boxHeight);
                timeComponent.layoutTimeComponent(boxX + cx, (Integer)entry.getKey() + boxY, entryWidth, h, boxHeight);
                cx += entryWidth;
            }
        }
        for (TimeComponent timeComponent : hiddenComponents) {
            timeComponent.layoutTimeComponent(0, 0, 0, 0, boxHeight);
        }
    }

    public boolean containsTask(TaskTimeComponent taskTimeComponent) {
        return this.timeComponents.contains(taskTimeComponent);
    }

    public void switchComponentOut(TimeComponent taskTimeComponent) {
        this.timeComponents.remove(taskTimeComponent);
    }

    public void switchComponentIn(TimeComponent taskTimeComponent) {
        this.timeComponents.add(taskTimeComponent);
    }

    public void highLightTasks(HighLightMatcher matcher) {
        this.timeComponents.forEach(timeComponent -> timeComponent.setActive(matcher.highLightItem((TimeComponent)timeComponent)));
    }

    public List<ConsumeProduceCalculator> getStockEvents(StockPrediction stockPrediction) {
        ArrayList<ConsumeProduceCalculator> events = new ArrayList<ConsumeProduceCalculator>();
        for (TimeComponent timeComponent : this.timeComponents) {
            ConsumeProduceCalculator calculator = stockPrediction.hasStockEvent(timeComponent);
            if (calculator == null) continue;
            events.add(calculator);
        }
        return events;
    }

    public void clearItems() {
        new ArrayList<TimeComponent>(this.timeComponents).forEach(component -> this.removeTimeItem((TimeComponent)component));
    }

    public void updateFiltering(TaskFilter taskFilter) {
        this.timeComponents.forEach(timeComponent -> timeComponent.setFiltered(taskFilter.filterItem((TimeComponent)timeComponent)));
    }

    public List<TimeComponent> getItemsForTime(Timestamp time) {
        ArrayList<TimeComponent> components = new ArrayList<TimeComponent>();
        for (TimeComponent timeComponent : this.timeComponents) {
            if (time.getTime() != timeComponent.getTime().getTime()) continue;
            components.add(timeComponent);
        }
        return components;
    }
}

