/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents;

import ch.icit.pegasus.client.gui.utils.calendar.agenda.CalendarView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.DayView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TaskPopupInsert;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimedComponentUtil;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeListenerAdaptor;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.DeliveryJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.DeliveryLoadToTruckJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.RecipeProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TaskTimeComponent
extends JPanelFadable
implements TimeComponent {
    private final WeeklyPlanSettingsComplete settings;
    private final CalendarView calendarView;
    private final Node<JobComplete> node;
    private boolean dragActive;
    private Point dragStartLocation;
    private double minDragDistance = 5.0;
    private int parentBoxHeight;
    private int coordinateSpaceOffset;
    private Skin1Field taskIcon;
    private String taskName;
    private String taskWorkName;
    private String taskTime;
    private boolean selected;
    private Dimension preferredPopupSize = new Dimension(200, 200);
    private Color defaultBackground;
    private Color defaultForeground;
    private boolean active = true;
    private boolean filtered = false;
    private Color defaultInActiveBackground;
    private Color defaultInActiveForeground;

    public TaskTimeComponent(final CalendarView calendarView, final Node<JobComplete> node) {
        this.calendarView = calendarView;
        this.node = node;
        this.settings = (WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue();
        this.updateView();
        node.getChildNamed(JobComplete_.jobSchedule).addNodeListener((NodeListener)new NodeListenerAdaptor(){

            public void valueChanged(Node<?> node) {
                TaskTimeComponent.this.updateView();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TaskTimeComponent.this.dragStartLocation = new Point(e.getX(), e.getY());
                calendarView.setSelectedComponent(TaskTimeComponent.this);
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TaskTimeComponent.this.dragActive = false;
                TaskTimeComponent.this.dragStartLocation = null;
                calendarView.revalidate();
                e.consume();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
                    pop.setAttributes(TaskTimeComponent.this, false, false, TaskTimeComponent.this.taskName);
                    pop.setView(new TaskPopupInsert(calendarView.getProvider(), (Node<JobComplete>)node));
                    pop.showPopUp(e.getX(), e.getY(), ((TaskTimeComponent)TaskTimeComponent.this).preferredPopupSize.width, ((TaskTimeComponent)TaskTimeComponent.this).preferredPopupSize.height, null, TaskTimeComponent.this);
                    e.consume();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TaskTimeComponent.this.dragStartLocation == null) {
                    return;
                }
                if (!TaskTimeComponent.this.dragActive && (Math.abs(TaskTimeComponent.this.dragStartLocation.getX() - (double)e.getX()) > TaskTimeComponent.this.minDragDistance || Math.abs(TaskTimeComponent.this.dragStartLocation.getY() - (double)e.getY()) > TaskTimeComponent.this.minDragDistance)) {
                    TaskTimeComponent.this.dragActive = true;
                } else if (TaskTimeComponent.this.dragActive) {
                    double dx = TaskTimeComponent.this.dragStartLocation.getX() - (double)e.getX();
                    double dy = TaskTimeComponent.this.dragStartLocation.getY() - (double)e.getY();
                    int newX = TaskTimeComponent.this.getX() - (int)dx;
                    int newY = TaskTimeComponent.this.getY() - (int)dy;
                    TimedComponentUtil timedComponentUtil = new TimedComponentUtil(TaskTimeComponent.this.settings);
                    Point point = timedComponentUtil.snapPosition(newX, newY -= TaskTimeComponent.this.coordinateSpaceOffset, TaskTimeComponent.this.parentBoxHeight);
                    newY = (int)point.getY();
                    Time newTime = timedComponentUtil.calculateTimeForYPosition(newY, TaskTimeComponent.this.parentBoxHeight);
                    newY += TaskTimeComponent.this.coordinateSpaceOffset;
                    DayView dayForX = calendarView.getDayForX(newX);
                    newX = dayForX.getTaskX();
                    calendarView.switchContainer(TaskTimeComponent.this, dayForX);
                    Timestamp newTimestamp = DateUtil.getTimestamp((Date)dayForX.getDate(), (Time)newTime);
                    node.getChildNamed(JobComplete_.jobSchedule).setValue((Object)newTimestamp, 0L);
                    calendarView.revalidate();
                    e.consume();
                }
            }
        });
    }

    public Node<JobComplete> getNode() {
        return this.node;
    }

    private void updateView() {
        JobComplete value = (JobComplete)this.node.getValue();
        this.taskTime = new SimpleDateFormat("HH:mm").format((Date)this.node.getChildNamed(JobComplete_.jobSchedule).getValue());
        if (value instanceof ProductionJobComplete) {
            this.taskName = value instanceof RecipeProductionJobComplete ? ((RecipeProductionJobComplete)value).getRecipe().getCurrentVariant().getName() : ((ProductionJobComplete)value).getProduct().getCurrentVariant().getName();
            this.taskWorkName = "produce";
        } else if (value instanceof DeliveryJobComplete) {
            this.taskWorkName = value instanceof DeliveryLoadToTruckJobComplete ? "deliver to " : "prepare for ";
            this.taskName = this.taskWorkName + ((DeliveryJobComplete)value).getFlight().getOutboundCode() + " " + new SimpleDateFormat("HH:mm").format(((DeliveryJobComplete)value).getFlight().getStd());
        }
    }

    @Override
    public Timestamp getTime() {
        if (this.node.getChildNamed(JobComplete_.jobSchedule).getValue() != null) {
            return (Timestamp)this.node.getChildNamed(JobComplete_.jobSchedule).getValue();
        }
        return DateUtil.getTimestamp((int)2020, (int)12, (int)18, (int)15, (int)0, (int)0);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float defaultComposite = DrawToolkit.setAlphaComposite(g2, this.getFader());
        float backgroundComposite = this.selected ? defaultComposite : defaultComposite * 0.5f;
        g2.setComposite(AlphaComposite.getInstance(3, backgroundComposite));
        g2.setColor(this.active ? this.defaultBackground : this.defaultInActiveBackground);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setComposite(AlphaComposite.getInstance(3, defaultComposite));
        g2.fillRect(0, 0, 2, this.getHeight());
        if (!StringUtil.isBlank((String)this.taskName)) {
            g2.setColor(this.active ? this.defaultForeground : this.defaultInActiveForeground);
            Font oldFont = g2.getFont();
            Font font = oldFont.deriveFont(11.0f);
            g2.setFont(font);
            g2.drawString(this.taskName, 4, font.getSize() + 3);
            g2.setFont(oldFont);
        }
        this.paintChildren(g2);
    }

    @Override
    public void layoutTimeComponent(int x, int y, int w, int h, int parentBoxHeight) {
        this.parentBoxHeight = parentBoxHeight;
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    @Override
    public long getDurationInMillis() {
        return new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(5.0)).getDurationInMillis();
    }

    @Override
    public void setCoordinateSpaceOffset(int coordinateSpaceOffset) {
        this.coordinateSpaceOffset = coordinateSpaceOffset;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
    }

    public void setDefaultForeground(Color defaultForeground) {
        this.defaultForeground = defaultForeground;
    }

    public void setDefaultInActiveBackground(Color defaultInActiveBackground) {
        this.defaultInActiveBackground = defaultInActiveBackground;
    }

    public void setDefaultInActiveForeground(Color defaultInActiveForeground) {
        this.defaultInActiveForeground = defaultInActiveForeground;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }
}

