/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.gui.utils.TextUtils;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxCellRenderer
extends JLabel
implements ListCellRenderer,
LafListener {
    private static final long serialVersionUID = 1L;
    private List<Object> usedItems = new ArrayList<Object>();

    public ComboBoxCellRenderer() {
        this.setOpaque(true);
    }

    public void setUsedItems(List<Object> usedItems) {
        this.usedItems = usedItems;
    }

    protected boolean isInList(Object o) {
        if (o instanceof Node) {
            Node m = (Node)o;
            for (Object i : this.usedItems) {
                Node n;
                if (!(i instanceof Node) || (n = (Node)i).getValue() == null || !n.getValue().equals(m.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean isUnabeld = this.isInList(value);
        if (isUnabeld) {
            this.setBackground(ComboBox.popUpBackgroundColor);
            this.setForeground(new Color(90, 90, 90));
        } else if (isSelected) {
            this.setBackground(ComboBox.popUpSelectedBackgroundColor);
            this.setForeground(ComboBox.popUpSelectedForegroundColor);
        } else {
            this.setBackground(ComboBox.popUpBackgroundColor);
            this.setForeground(ComboBox.popUpForegroundColor);
        }
        int w = list.getWidth();
        String g = "  ";
        int wm = this.getFontMetrics(ComboBox.popUpItemFont).stringWidth(g);
        String t = value != null ? this.getDisplayString(w - wm, g + value.toString(), ComboBox.popUpItemFont, list) : "";
        this.setFont(ComboBox.popUpItemFont);
        this.setText(t);
        return this;
    }

    private String getDisplayString(int maxWidth, String text, Font usedFont, Component invoker) {
        return TextUtils.cutString(text, maxWidth, usedFont, invoker);
    }

    @Override
    public void lafAttributeChanged(String att) {
    }
}

